/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.common.part.KintaiCompilePart;
import jp.mosp.kintai.payroll.dto.CompileAmendmentDto;
import jp.mosp.kintai.payroll.vo.CompileAmendmentListVo;

/**
 * @author yoshida
 *
 */
public class CompileAmendmentListAction extends AttendanceTotalAction {
	
	// R}h
	private static final String	CMD_AMENDMENT_LIST_SHOW			= "P1040";
	private static final String	CMD_AMENDMENT_LIST_SEARCH		= "P1041";
	/**
	 * 
	 */
	public static final String	CMD_AMENDMENT_LIST_RE_SEARCH	= "P1042";
	private static final String	CMD_AMENDMENT_LIST_SORT			= "P1043";
	

	/**
	 * RXgN^
	 */
	public CompileAmendmentListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_AMENDMENT_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_AMENDMENT_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_AMENDMENT_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_AMENDMENT_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new CompileAmendmentListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// RlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// [U[擾
		getInfo(user.getUserId());
		// v_E擾
		CompileAmendmentListVo vo = (CompileAmendmentListVo)getVo();
		// ΑӏF@\mF
		if (isAttendanceApprovalFunction()) {
			vo.setMode(CompileAmendmentListVo.MODE_POSSIBLE);
		} else {
			vo.setMode(CompileAmendmentListVo.MODE_IMPOSSIBLE);
		}
		// Xg̃Zbg
		if (hasCalculateAuth()) {
			vo.aryPltSection = StringUtil.addArrayFirstRowValue(getSectionArrayAll(),
					CommonConst.NAM_COMMON_STRING_INITIAL_VALUE, CommonConst.NAM_ALL_SECTION);
		} else {
			vo.aryPltSection = getSectionArrayForManager();
		}
		// NXg擾
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(getCalcMonth()), 1, 1);
		vo.aryPltMonth = StringUtil.getMonthArray();
		// FL
		if (isAttendanceApprovalFunction()) {
			vo.aryPltApprovalFlag = StringUtil.addArrayFirstRowSpace(StringUtil.getExistenceArray());
		} else {
			vo.aryPltApprovalFlag = StringUtil.getBlankArray();
		}
		// vZL
		vo.aryPltCompileFlag = StringUtil.addArrayFirstRowSpace(StringUtil.getExistenceArray());
		// ԊOxݒ
		setUseOver60Hour();
		vo.setUseOver60Hour(useOver60Hour);
	}
	
	@Override
	protected void show() throws Exception {
		CompileAmendmentListVo vo = (CompileAmendmentListVo)getVo();
		// WvN
		vo.setPltYear(String.valueOf(MospUtility.getYear(getCalcMonth())));
		// Wv
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(getCalcMonth())));
		// lɃZbg
		vo.setSearchmode(CompileAmendmentListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		CompileAmendmentListVo vo = (CompileAmendmentListVo)getVo();
		vo.setParams(request);
		serachEmployeeList();
		vo.setFormerKey(vo.KEY_K_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(CompileAmendmentListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		CompileAmendmentListVo vo = (CompileAmendmentListVo)getVo();
		removeSessionDto();
		if (vo.getSearchmode() == CompileAmendmentListVo.SEARCH_ON) {
			serachEmployeeList();
			vo.setPageButton();
			sortList();
		} else {
			// ΑӏWv
			setCompileInfo();
			serachEmployeeList();
			vo.setFormerKey(vo.KEY_K_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
			// ɃZbg
			vo.setSearchmode(CompileAmendmentListVo.SEARCH_ON);
			sortList();
		}
	}
	
	/**
	 * ЈXg
	 * @throws Exception  	Oꍇ
	 */
	private void serachEmployeeList() throws Exception {
		CompileAmendmentListVo vo = (CompileAmendmentListVo)getVo();
		// Wv擾
		Date targetMonth = DateUtil.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth());
		// IЈꗗ
		List<MKihonDto> humanList = part().human().getMKihonDao().findForCondition(vo.getTxtKCode(), vo.getTxtKName(),
				vo.getPltSection(), userBasis.getJCode(), userBasis.getKCode(), user.getDataLevel(),
				DateUtil.convDateToInteger(getStartDate(targetMonth)),
				DateUtil.convDateToInteger(getEndDate(targetMonth)));
		// ΑӏWv
		List<CompileAmendmentDto> compileList = new ArrayList<CompileAmendmentDto>();
		for (MKihonDto humanDto : humanList) {
			CompileAmendmentDto dto = compile().getCompileAmendmentInfo(humanDto.getKCode(), targetMonth,
					humanDto.getSCode());
			// Wvݒ
			if (VariousUtil.isNull(dto)) {
				dto = new CompileAmendmentDto();
				dto.setKCode(humanDto.getKCode());
				dto.setKName(humanDto.getSimei());
				dto.setSCode(humanDto.getSCode());
			} else {
				// Wv
				dto.setCompiledFlag(true);
			}
			// ̕ύXB
			dto.setSCode(getSectionName(dto.getSCode()));
			// Jgݒ擾
			setLaborAgreementInfo(humanDto.getKCode(), targetMonth);
			if (VariousUtil.isNotNull(agreement)) {
				dto.setCautionMonthly(agreement.getCautionMonth());
			}
			boolean addFlag = false;
			// ΑӏF@\mF
			if (vo.getMode() == CompileAmendmentListVo.MODE_POSSIBLE) {
				// FL
				dto.setApprovedFlag(KintaiCompilePart
					.checkApproval(getAttendanceList(humanDto.getKCode(), targetMonth)));
				if (StringUtil.isNull(vo.getPltCompile())) {
					// WvSȈꍇ
					if (vo.getPltApproval().equals(StringUtil.convTrueIsOff(dto.isApprovedFlag()))) {
						// FI
						addFlag = true;
					} else if (StringUtil.isNull(vo.getPltApproval())) {
						// SȈꍇ				
						addFlag = true;
					}
				} else {
					// WvI
					if (vo.getPltCompile().equals(StringUtil.convTrueIsOff(dto.isCompiledFlag()))) {
						if (vo.getPltApproval().equals(StringUtil.convTrueIsOff(dto.isApprovedFlag()))) {
							// FI
							addFlag = true;
						} else if (StringUtil.isNull(vo.getPltApproval())) {
							// SȈꍇ
							addFlag = true;
						}
					}
				}
			} else {
				// WvIASȈꍇ
				if (vo.getPltCompile().equals(StringUtil.convTrueIsOff(dto.isCompiledFlag()))
						|| StringUtil.isNull(vo.getPltCompile())) {
					addFlag = true;
				}
			}
			if (addFlag) {
				compileList.add(dto);
			}
		}
		// VOݒ
		vo.setFields(compileList);
		// IN
		vo.setHidSelectDate(DateUtil.convDateToStringYearMonthShort(targetMonth));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryCompile().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * ΑӏWṽZbg
	 * @throws Exception  	Oꍇ
	 */
	private void setCompileInfo() throws Exception {
		CompileAmendmentListVo vo = (CompileAmendmentListVo)getVo();
		// WvR[h
		vo.setPltSection((String)request.getAttribute(COMPILE_SECTION));
		// WvЈR[h
		vo.setTxtKCode((String)request.getAttribute(COMPILE_K_CODE));
		// WvN
		vo.setPltYear(String.valueOf(MospUtility.getYear(getCalcMonth())));
		// Wv
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(getCalcMonth())));
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		CompileAmendmentListVo vo = (CompileAmendmentListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		CompileAmendmentListVo vo = (CompileAmendmentListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		CompileAmendmentListVo vo = (CompileAmendmentListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 2785426316163131119L;
		

		public int compare(Object obj1, Object obj2) {
			CompileAmendmentDto dto1 = (CompileAmendmentDto)obj1;
			CompileAmendmentDto dto2 = (CompileAmendmentDto)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}
	
	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 6920023209991067840L;
		

		public int compare(Object obj1, Object obj2) {
			CompileAmendmentDto dto1 = (CompileAmendmentDto)obj1;
			CompileAmendmentDto dto2 = (CompileAmendmentDto)obj2;
			return dto1.getKName().compareTo(dto2.getKName());
		}
	}
	
	/**
	 * ɂrNX
	 */
	protected static class CompSection implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 8039660004898020825L;
		

		public int compare(Object obj1, Object obj2) {
			CompileAmendmentDto dto1 = (CompileAmendmentDto)obj1;
			CompileAmendmentDto dto2 = (CompileAmendmentDto)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}
	
}
