/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.action;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.kintai.vo.EmployeeAttendanceListVo;

/**
 * @author yoshida
 *
 */
public class EmployeeAttendanceListAction extends AttendanceTotalAction {
	
	// R}h
	private static final String	CMD_EMPLOYEE_LIST_SHOW		= "K2010";
	private static final String	CMD_EMPLOYEE_LIST_SEARCH	= "K2011";
	/**
	 * 
	 */
	public static final String	CMD_EMPLOYEE_LIST_RE_SEARCH	= "K2012";
	private static final String	CMD_EMPLOYEE_LIST_SORT		= "K2013";
	

	/**
	 * RXgN^
	 */
	public EmployeeAttendanceListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_EMPLOYEE_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_EMPLOYEE_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_EMPLOYEE_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_EMPLOYEE_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new EmployeeAttendanceListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// RlNV擾
		getConnection();
		// MANAGERmF
		confirmManagerAuth();
		EmployeeAttendanceListVo vo = (EmployeeAttendanceListVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// v_E擾
		vo.aryPltSectionAll = getSectionArrayAll();
		vo.aryPltSection = getSectionArrayForHuman();
		vo.aryPltPosition = getPositionArray();
	}
	
	@Override
	protected void show() throws Exception {
		EmployeeAttendanceListVo vo = (EmployeeAttendanceListVo)getVo();
		vo.setPltSection(userBasis.getSCode());
	}
	
	@Override
	protected void search() throws Exception {
		EmployeeAttendanceListVo vo = (EmployeeAttendanceListVo)getVo();
		vo.setParams(request);
		serachEmployeeList();
		vo.setFormerKey(vo.KEY_K_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
	}
	
	@Override
	protected void research() throws Exception {
		EmployeeAttendanceListVo vo = (EmployeeAttendanceListVo)getVo();
		removeSessionDto();
		if (StringUtil.isNotNull(vo.getPltSection())) {
			serachEmployeeList();
			vo.setPageButton();
			sortList();
		} else {
			vo.setPltSection(userBasis.getSCode());
		}
	}
	
	/**
	 * ЈXg
	 * @throws Exception 	Oꍇ
	 */
	private void serachEmployeeList() throws Exception {
		EmployeeAttendanceListVo vo = (EmployeeAttendanceListVo)getVo();
		// Wv擾
		Date current = DateUtil.getSystemDate();
		// ^S҂̏ꍇ͌vZ
		if (hasPayrollAuth()) {
			current = getCalcMonth();
		}
		// VOݒ
		vo.setFields(part().human().getMKihonDao().findForCondition(vo.getTxtKCode(), vo.getTxtKName(),
				vo.getPltSection(), userBasis.getJCode(), userBasis.getKCode(), user.getDataLevel(),
				DateUtil.convDateToInteger(getStartDate(current)), DateUtil.convDateToInteger(getEndDate(current))));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryKCode().length == 0) {
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		EmployeeAttendanceListVo vo = (EmployeeAttendanceListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else if (key.equals(vo.KEY_POSITION)) {
			comp = new CompPosition();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -6187177073497888259L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}
	
	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 6329744446685857068L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getSimei().compareTo(dto2.getSimei());
		}
	}
	
	/**
	 * ɂrNX
	 */
	protected static class CompSection implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -1783273816527143665L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}
	
	/**
	 * EʂɂrNX
	 */
	protected static class CompPosition implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -485908349343472522L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			//EꍇAŔr
			if (dto1.getYCode().equals(dto2.getYCode())) {
				return dto1.getTokyu().compareTo(dto2.getTokyu());
			} else {
				return dto1.getYCode().compareTo(dto2.getYCode());
			}
		}
	}
	
}
