/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.human.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.human.dto.MEmergencyDto;
import jp.mosp.kintai.human.dto.MKojinDto;

/**
 * @author yoshida
 *
 */
public class HumanPersonalCardVo extends HumanCardVo {
	
	private static final long	serialVersionUID				= 767129584113797363L;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_GENDER					= "pltGender";
	/**
	 * 
	 */
	public static final String	PRM_PLT_BIRTH_YEAR				= "pltBirthYear";
	/**
	 * 
	 */
	public static final String	PRM_PLT_BIRTH_MONTH				= "pltBirthMonth";
	/**
	 * 
	 */
	public static final String	PRM_PLT_BIRTH_DAY				= "pltBirthDay";
	/**
	 * 
	 */
	public static final String	PRM_TXT_POSTAL_CODE1			= "txtPostalCode1";
	/**
	 * 
	 */
	public static final String	PRM_TXT_POSTAL_CODE2			= "txtPostalCode2";
	/**
	 * 
	 */
	public static final String	PRM_PLT_PREFECTURE				= "pltPrefecture";
	/**
	 * 
	 */
	public static final String	PRM_TXT_ADRESS1					= "txtAdress1";
	/**
	 * 
	 */
	public static final String	PRM_TXT_ADRESS2					= "txtAdress2";
	/**
	 * 
	 */
	public static final String	PRM_TXT_ADRESS3					= "txtAdress3";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_CODE			= "txtEMCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_NAME			= "txtEmName";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_TEL1			= "txtEmTel1";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_TEL2			= "txtEmTel2";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_TEL3			= "txtEmTel3";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_PHONE1		= "txtEmPhone1";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_PHONE2		= "txtEmPhone2";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_PHONE3		= "txtEmPhone3";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_POSTAL_CODE1	= "txtEmPostalCode1";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_POSTAL_CODE2	= "txtEmPostalCode2";
	/**
	 * 
	 */
	public static final String	PRM_PLT_EMERGENCY_PREFECTURE	= "pltEmPrefecture";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_ADRESS1		= "txtEmAdress1";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_ADRESS2		= "txtEmAdress2";
	/**
	 * 
	 */
	public static final String	PRM_TXT_EMERGENCY_ADRESS3		= "txtEmAdress3";
	/**
	 * 
	 */
	public static final String	PRM_TXT_TEL1					= "txtTel1";
	/**
	 * 
	 */
	public static final String	PRM_TXT_TEL2					= "txtTel2";
	/**
	 * 
	 */
	public static final String	PRM_TXT_TEL3					= "txtTel3";
	/**
	 * 
	 */
	public static final String	PRM_TXT_FAX1					= "txtFax1";
	/**
	 * 
	 */
	public static final String	PRM_TXT_FAX2					= "txtFax2";
	/**
	 * 
	 */
	public static final String	PRM_TXT_FAX3					= "txtFax3";
	/**
	 * 
	 */
	public static final String	PRM_TXT_PHONE1					= "txtPhone1";
	/**
	 * 
	 */
	public static final String	PRM_TXT_PHONE2					= "txtPhone2";
	/**
	 * 
	 */
	public static final String	PRM_TXT_PHONE3					= "txtPhone3";
	/**
	 * 
	 */
	public static final String	PRM_PLT_BLOOD_TYPE				= "pltBloodType";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LICENSE					= "txtLicense";
	/**
	 * 
	 */
	public static final String	PRM_TXT_RECAPITULATION			= "txtRecapitulation";
	/**
	 * 
	 */
	public static final String	PRM_TXT_HEALTH					= "txtHealth";
	/**
	 * 
	 */
	public static final String	PRM_PLT_SALARY_KB				= "pltSalaryKb";
	/**
	 * 
	 */
	public static final String	PRM_PLT_TAX_KB					= "pltTaxKb";
	/**
	 * 
	 */
	public static final String	PRM_PLT_UNION_KB				= "pltUnionKb";
	/**
	 * 
	 */
	public static final String	PRM_PLT_PART_KB					= "pltPartKb";
	/**
	 * 
	 */
	public static final String	PRM_PLT_PAYMENT_KB				= "pltPaymentKb";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE					= "pltDelete";
	/**
	 * 
	 */
	public static final String	PRM_HID_GENDER					= "hidGender";
	/**
	 * 
	 */
	public static final String	PRM_HID_BIRTH_YEAR				= "hidBirthYear";
	/**
	 * 
	 */
	public static final String	PRM_HID_BIRTH_MONTH				= "hidBirthMonth";
	/**
	 * 
	 */
	public static final String	PRM_HID_BIRTH_DAY				= "hidBirthDay";
	/**
	 * 
	 */
	public static final String	PRM_HID_POSTAL_CODE1			= "hidPostalCode1";
	/**
	 * 
	 */
	public static final String	PRM_HID_POSTAL_CODE2			= "hidPostalCode2";
	/**
	 * 
	 */
	public static final String	PRM_HID_PREFECTURE				= "hidPrefecture";
	/**
	 * 
	 */
	public static final String	PRM_HID_ADRESS1					= "hidAdress1";
	/**
	 * 
	 */
	public static final String	PRM_HID_ADRESS2					= "hidAdress2";
	/**
	 * 
	 */
	public static final String	PRM_HID_ADRESS3					= "hidAdress3";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_CODE			= "hidEMCode";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_NAME			= "hidEmName";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_TEL1			= "hidEmTel1";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_TEL2			= "hidEmTel2";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_TEL3			= "hidEmTel3";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_PHONE1		= "hidEmPhone1";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_PHONE2		= "hidEmPhone2";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_PHONE3		= "hidEmPhone3";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_POSTAL_CODE1	= "hidEmPostalCode1";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_POSTAL_CODE2	= "hidEmPostalCode2";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_PREFECTURE	= "hidEmPrefecture";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_ADRESS1		= "hidEmAdress1";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_ADRESS2		= "hidEmAdress2";
	/**
	 * 
	 */
	public static final String	PRM_HID_EMERGENCY_ADRESS3		= "hidEmAdress3";
	/**
	 * 
	 */
	public static final String	PRM_HID_TEL1					= "hidTel1";
	/**
	 * 
	 */
	public static final String	PRM_HID_TEL2					= "hidTel2";
	/**
	 * 
	 */
	public static final String	PRM_HID_TEL3					= "hidTel3";
	/**
	 * 
	 */
	public static final String	PRM_HID_FAX1					= "hidFax1";
	/**
	 * 
	 */
	public static final String	PRM_HID_FAX2					= "hidFax2";
	/**
	 * 
	 */
	public static final String	PRM_HID_FAX3					= "hidFax3";
	/**
	 * 
	 */
	public static final String	PRM_HID_PHONE1					= "hidPhone1";
	/**
	 * 
	 */
	public static final String	PRM_HID_PHONE2					= "hidPhone2";
	/**
	 * 
	 */
	public static final String	PRM_HID_PHONE3					= "hidPhone3";
	/**
	 * 
	 */
	public static final String	PRM_HID_BLOOD_TYPE				= "hidBloodType";
	/**
	 * 
	 */
	public static final String	PRM_HID_LICENSE					= "hidLicense";
	/**
	 * 
	 */
	public static final String	PRM_HID_RECAPITULATION			= "hidRecapitulation";
	/**
	 * 
	 */
	public static final String	PRM_HID_HEALTH					= "hidHealth";
	/**
	 * 
	 */
	public static final String	PRM_HID_SALARY_KB				= "hidSalaryKb";
	/**
	 * 
	 */
	public static final String	PRM_HID_TAX_KB					= "hidTaxKb";
	/**
	 * 
	 */
	public static final String	PRM_HID_UNION_KB				= "hidUnionKb";
	/**
	 * 
	 */
	public static final String	PRM_HID_PART_KB					= "hidPartKb";
	/**
	 * 
	 */
	public static final String	PRM_HID_PAYMENT_KB				= "hidPaymentKb";
	/**
	 * 
	 */
	public static final String	PRM_HID_DELETE					= "hidDelete";
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_K_KANA;
	/**
	 * 
	 */
	public String				NAM_GENDER;
	/**
	 * 
	 */
	public String				NAM_BIRTH_DATE;
	/**
	 * 
	 */
	public String				NAM_POSTAL1;
	/**
	 * 
	 */
	public String				NAM_POSTAL2;
	/**
	 * 
	 */
	public String				NAM_ADDRESS;
	/**
	 * 
	 */
	public String				NAM_POSTAL_CODE;
	/**
	 * 
	 */
	public String				NAM_PREFECTURE;
	/**
	 * 
	 */
	public String				NAM_ADRESS1;
	/**
	 * 
	 */
	public String				NAM_ADRESS2;
	/**
	 * 
	 */
	public String				NAM_ADRESS3;
	/**
	 * 
	 */
	public String				NAM_TEL;
	/**
	 * 
	 */
	public String				NAM_TEL1;
	/**
	 * 
	 */
	public String				NAM_TEL2;
	/**
	 * 
	 */
	public String				NAM_TEL3;
	/**
	 * 
	 */
	public String				NAM_FAX;
	/**
	 * 
	 */
	public String				NAM_FAX1;
	/**
	 * 
	 */
	public String				NAM_FAX2;
	/**
	 * 
	 */
	public String				NAM_FAX3;
	/**
	 * 
	 */
	public String				NAM_PHONE;
	/**
	 * 
	 */
	public String				NAM_PHONE1;
	/**
	 * 
	 */
	public String				NAM_PHONE2;
	/**
	 * 
	 */
	public String				NAM_PHONE3;
	/**
	 * 
	 */
	public String				NAM_BLOOD_TYPE;
	/**
	 * 
	 */
	public String				NAM_SALARY_KB;
	/**
	 * 
	 */
	public String				NAM_TAX_KB;
	/**
	 * 
	 */
	public String				NAM_UNION_KB;
	/**
	 * 
	 */
	public String				NAM_PART_KB;
	/**
	 * 
	 */
	public String				NAM_PAYMENT_KB;
	/**
	 * 
	 */
	public String				NAM_LICENSE;
	/**
	 * 
	 */
	public String				NAM_RECAPITULATION;
	/**
	 * 
	 */
	public String				NAM_HEALTH;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_ADRESS;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_NAME;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_POSTAL1;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_POSTAL2;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_TEL;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_TEL1;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_TEL2;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_TEL3;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_PHONE;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_PHONE1;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_PHONE2;
	/**
	 * 
	 */
	public String				NAM_EMERGENCY_PHONE3;
	/**
	 * 
	 */
	public int					LEN_K_CODE;
	/**
	 * 
	 */
	public int					LEN_NAME;
	/**
	 * 
	 */
	public int					LEN_POSTAL_CODE1;
	/**
	 * 
	 */
	public int					LEN_POSTAL_CODE2;
	/**
	 * 
	 */
	public int					LEN_PHONE_NUMBER;
	/**
	 * 
	 */
	public int					LEN_ADDRESS;
	/**
	 * 
	 */
	public int					LEN_LICENSE;
	/**
	 * 
	 */
	public int					LEN_RECAPITULATION;
	/**
	 * 
	 */
	public int					LEN_HEALTH;
	/**
	 * 
	 */
	public String				REG_DELETE;
	
	// ҏW[htO
	/**
	 * 
	 */
	public static final int		MODE_INSERT						= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE						= 1;
	
	// ҏW[h
	/**
	 * 
	 */
	public static final String	NAM_MODE_INSERT					= CommonConst.NAM_HU_MODE_INSERT;
	/**
	 * 
	 */
	public static final String	NAM_MODE_UPDATE					= CommonConst.NAM_HU_MODE_UPDATE;
	
	// tB[h
	private String				eMCode;
	private String				pltGender;
	private String				pltBirthYear;
	private String				pltBirthMonth;
	private String				pltBirthDay;
	private String				txtPostalCode1;
	private String				txtPostalCode2;
	private String				pltPrefecture;
	private String				txtAdress1;
	private String				txtAdress2;
	private String				txtAdress3;
	private String				txtEmName;
	private String				txtEmTel1;
	private String				txtEmTel2;
	private String				txtEmTel3;
	private String				txtEmPhone1;
	private String				txtEmPhone2;
	private String				txtEmPhone3;
	private String				txtEmPostalCode1;
	private String				txtEmPostalCode2;
	private String				pltEmPrefecture;
	private String				txtEmAdress1;
	private String				txtEmAdress2;
	private String				txtEmAdress3;
	private String				txtTel1;
	private String				txtTel2;
	private String				txtTel3;
	private String				txtFax1;
	private String				txtFax2;
	private String				txtFax3;
	private String				txtPhone1;
	private String				txtPhone2;
	private String				txtPhone3;
	private String				pltBloodType;
	private String				txtLicense;
	private String				txtRecapitulation;
	private String				txtHealth;
	private String				pltSalaryKb;
	private String				pltTaxKb;
	private String				pltUnionKb;
	private String				pltPartKb;
	private String				pltPaymentKb;
	
	// tB[h(\̂)
	private String				lblGender;
	private String				lblBirthYear;
	private String				lblBirthMonth;
	private String				lblBirthDay;
	private String				lblPostalCode1;
	private String				lblPostalCode2;
	private String				lblPrefecture;
	private String				lblAdress1;
	private String				lblAdress2;
	private String				lblAdress3;
	private String				lblEmName;
	private String				lblEmTel;
	private String				lblEmPhone;
	private String				lblEmPostalCode1;
	private String				lblEmPostalCode2;
	private String				lblEmPrefecture;
	private String				lblEmAdress1;
	private String				lblEmAdress2;
	private String				lblEmAdress3;
	private String				lblTel;
	private String				lblFax;
	private String				lblPhone;
	private String				lblBloodType;
	private String				lblLicense;
	private String				lblRecapitulation;
	private String				lblHealth;
	private String				lblSalaryKb;
	private String				lblTaxKb;
	private String				lblUnionKb;
	private String				lblPartKb;
	private String				lblPaymentKb;
	
	// tB[h(ύXmFp)
	private String				hidGender;
	private String				hidBirthYear;
	private String				hidBirthMonth;
	private String				hidBirthDay;
	private String				hidPostalCode1;
	private String				hidPostalCode2;
	private String				hidPrefecture;
	private String				hidAdress1;
	private String				hidAdress2;
	private String				hidAdress3;
	private String				hidEmName;
	private String				hidEmTel1;
	private String				hidEmTel2;
	private String				hidEmTel3;
	private String				hidEmPhone1;
	private String				hidEmPhone2;
	private String				hidEmPhone3;
	private String				hidEmPostalCode1;
	private String				hidEmPostalCode2;
	private String				hidEmPrefecture;
	private String				hidEmAdress1;
	private String				hidEmAdress2;
	private String				hidEmAdress3;
	private String				hidTel1;
	private String				hidTel2;
	private String				hidTel3;
	private String				hidFax1;
	private String				hidFax2;
	private String				hidFax3;
	private String				hidPhone1;
	private String				hidPhone2;
	private String				hidPhone3;
	private String				hidBloodType;
	private String				hidLicense;
	private String				hidRecapitulation;
	private String				hidHealth;
	private String				hidSalaryKb;
	private String				hidTaxKb;
	private String				hidUnionKb;
	private String				hidPartKb;
	private String				hidPaymentKb;
	
	// ҏW[h(0FVKo^A1FXV)
	private int					mode;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltGender;
	/**
	 * 
	 */
	public String[][]			aryPltBirthYear;
	/**
	 * 
	 */
	public String[][]			aryPltBirthMonth;
	/**
	 * 
	 */
	public String[][]			aryPltBirthDay;
	/**
	 * 
	 */
	public String[][]			aryPltPrefecture;
	/**
	 * 
	 */
	public String[][]			aryPltBloodType;
	/**
	 * 
	 */
	public String[][]			aryPltSalaryKb;
	/**
	 * 
	 */
	public String[][]			aryPltTaxKb;
	/**
	 * 
	 */
	public String[][]			aryPltUnionKb;
	/**
	 * 
	 */
	public String[][]			aryPltPartKb;
	/**
	 * 
	 */
	public String[][]			aryPltPaymentKb;
	

	/**
	 * RXgN^
	 */
	public HumanPersonalCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_HUMAN_KOJIN;
		aryMenu = new String[][]{ { CMD_MENU_HUMAN, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_K_KANA = CommonConst.NAM_K_KANA;
		NAM_GENDER = CommonConst.NAM_GENDER;
		NAM_BIRTH_DATE = CommonConst.NAM_BIRTH_DATE;
		NAM_POSTAL_CODE = CommonConst.NAM_POSTAL_CODE;
		NAM_POSTAL1 = NAM_POSTAL_CODE + CommonConst.NAM_POSTAL_FRONT;
		NAM_POSTAL2 = NAM_POSTAL_CODE + CommonConst.NAM_POSTAL_BACK;
		NAM_ADDRESS = CommonConst.NAM_ADDRESS;
		NAM_PREFECTURE = CommonConst.NAM_PREFECTURE;
		NAM_ADRESS1 = CommonConst.NAM_CITIES;
		NAM_ADRESS2 = CommonConst.NAM_HOUSE_NUMBER;
		NAM_ADRESS3 = CommonConst.NAM_HOUSE_NAME;
		NAM_TEL = CommonConst.NAM_PHONE_NUMBER;
		NAM_TEL1 = NAM_TEL + CommonConst.NAM_AREA_NUMBER;
		NAM_TEL2 = NAM_TEL + CommonConst.NAM_LOCAL_AREA_NUMBER;
		NAM_TEL3 = NAM_TEL + CommonConst.NAM_SUBSCRIBER_NUMBER;
		NAM_FAX = CommonConst.NAM_FAX;
		NAM_FAX1 = NAM_FAX + CommonConst.NAM_AREA_NUMBER;
		NAM_FAX2 = NAM_FAX + CommonConst.NAM_LOCAL_AREA_NUMBER;
		NAM_FAX3 = NAM_FAX + CommonConst.NAM_SUBSCRIBER_NUMBER;
		NAM_PHONE = CommonConst.NAM_CELLPHONE_NUMBER;
		NAM_PHONE1 = NAM_PHONE + CommonConst.NAM_AREA_NUMBER;
		NAM_PHONE2 = NAM_PHONE + CommonConst.NAM_LOCAL_AREA_NUMBER;
		NAM_PHONE3 = NAM_PHONE + CommonConst.NAM_SUBSCRIBER_NUMBER;
		NAM_BLOOD_TYPE = CommonConst.NAM_BLOOD_TYPE;
		NAM_SALARY_KB = CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_COMMON_TYPE;
		NAM_TAX_KB = CommonConst.NAM_INCOME_TAX_TYPE;
		NAM_UNION_KB = CommonConst.NAM_UNION + CommonConst.NAM_COMMON_TYPE;
		NAM_PART_KB = CommonConst.NAM_PARTTIME_TYPE;
		NAM_PAYMENT_KB = CommonConst.NAM_PAYMENT_TYPE;
		NAM_LICENSE = CommonConst.NAM_LICENSE;
		NAM_RECAPITULATION = CommonConst.NAM_RECAPITULATION;
		NAM_HEALTH = CommonConst.NAM_HEALTH;
		
		NAM_EMERGENCY_ADRESS = CommonConst.NAM_EMERGENCY;
		NAM_EMERGENCY_NAME = CommonConst.NAM_FAMILY_NAME;
		NAM_EMERGENCY_POSTAL1 = CommonConst.NAM_EMERGENCY + CommonConst.NAM_POSTAL_CODE + CommonConst.NAM_POSTAL_FRONT;
		NAM_EMERGENCY_POSTAL2 = CommonConst.NAM_EMERGENCY + CommonConst.NAM_POSTAL_CODE + CommonConst.NAM_POSTAL_BACK;
		NAM_EMERGENCY_TEL = CommonConst.NAM_EMERGENCY + CommonConst.NAM_PHONE_NUMBER;
		NAM_EMERGENCY_TEL1 = NAM_EMERGENCY_TEL + CommonConst.NAM_AREA_NUMBER;
		NAM_EMERGENCY_TEL2 = NAM_EMERGENCY_TEL + CommonConst.NAM_LOCAL_AREA_NUMBER;
		NAM_EMERGENCY_TEL3 = NAM_EMERGENCY_TEL + CommonConst.NAM_SUBSCRIBER_NUMBER;
		NAM_EMERGENCY_PHONE = CommonConst.NAM_EMERGENCY + CommonConst.NAM_CELLPHONE_NUMBER;
		NAM_EMERGENCY_PHONE1 = NAM_EMERGENCY_PHONE + CommonConst.NAM_AREA_NUMBER;
		NAM_EMERGENCY_PHONE2 = NAM_EMERGENCY_PHONE + CommonConst.NAM_LOCAL_AREA_NUMBER;
		NAM_EMERGENCY_PHONE3 = NAM_EMERGENCY_PHONE + CommonConst.NAM_SUBSCRIBER_NUMBER;
		
		LEN_K_CODE = CommonConst.LEN_K_CODE;
		LEN_NAME = CommonConst.LEN_K_NAME;
		LEN_POSTAL_CODE1 = 3;
		LEN_POSTAL_CODE2 = 4;
		LEN_PHONE_NUMBER = 4;
		LEN_ADDRESS = 50;
		LEN_LICENSE = 230;
		LEN_RECAPITULATION = 230;
		LEN_HEALTH = 230;
		REG_DELETE = CommonConst.REG_DELETE;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		pltGender = request.getParameter(PRM_PLT_GENDER);
		pltBirthYear = request.getParameter(PRM_PLT_BIRTH_YEAR);
		pltBirthMonth = request.getParameter(PRM_PLT_BIRTH_MONTH);
		pltBirthDay = request.getParameter(PRM_PLT_BIRTH_DAY);
		txtPostalCode1 = request.getParameter(PRM_TXT_POSTAL_CODE1);
		txtPostalCode2 = request.getParameter(PRM_TXT_POSTAL_CODE2);
		pltPrefecture = request.getParameter(PRM_PLT_PREFECTURE);
		txtAdress1 = request.getParameter(PRM_TXT_ADRESS1);
		txtAdress2 = request.getParameter(PRM_TXT_ADRESS2);
		txtAdress3 = request.getParameter(PRM_TXT_ADRESS3);
		txtEmName = request.getParameter(PRM_TXT_EMERGENCY_NAME);
		txtEmTel1 = request.getParameter(PRM_TXT_EMERGENCY_TEL1);
		txtEmTel2 = request.getParameter(PRM_TXT_EMERGENCY_TEL2);
		txtEmTel3 = request.getParameter(PRM_TXT_EMERGENCY_TEL3);
		txtEmPhone1 = request.getParameter(PRM_TXT_EMERGENCY_PHONE1);
		txtEmPhone2 = request.getParameter(PRM_TXT_EMERGENCY_PHONE2);
		txtEmPhone3 = request.getParameter(PRM_TXT_EMERGENCY_PHONE3);
		txtEmPostalCode1 = request.getParameter(PRM_TXT_EMERGENCY_POSTAL_CODE1);
		txtEmPostalCode2 = request.getParameter(PRM_TXT_EMERGENCY_POSTAL_CODE2);
		pltEmPrefecture = request.getParameter(PRM_PLT_EMERGENCY_PREFECTURE);
		txtEmAdress1 = request.getParameter(PRM_TXT_EMERGENCY_ADRESS1);
		txtEmAdress2 = request.getParameter(PRM_TXT_EMERGENCY_ADRESS2);
		txtEmAdress3 = request.getParameter(PRM_TXT_EMERGENCY_ADRESS3);
		txtTel1 = request.getParameter(PRM_TXT_TEL1);
		txtTel2 = request.getParameter(PRM_TXT_TEL2);
		txtTel3 = request.getParameter(PRM_TXT_TEL3);
		txtFax1 = request.getParameter(PRM_TXT_FAX1);
		txtFax2 = request.getParameter(PRM_TXT_FAX2);
		txtFax3 = request.getParameter(PRM_TXT_FAX3);
		txtPhone1 = request.getParameter(PRM_TXT_PHONE1);
		txtPhone2 = request.getParameter(PRM_TXT_PHONE2);
		txtPhone3 = request.getParameter(PRM_TXT_PHONE3);
		pltBloodType = request.getParameter(PRM_PLT_BLOOD_TYPE);
		txtLicense = request.getParameter(PRM_TXT_LICENSE);
		txtRecapitulation = request.getParameter(PRM_TXT_RECAPITULATION);
		txtHealth = request.getParameter(PRM_TXT_HEALTH);
		pltSalaryKb = request.getParameter(PRM_PLT_SALARY_KB);
		pltTaxKb = request.getParameter(PRM_PLT_TAX_KB);
		pltUnionKb = request.getParameter(PRM_PLT_UNION_KB);
		pltPartKb = request.getParameter(PRM_PLT_PART_KB);
		pltPaymentKb = request.getParameter(PRM_PLT_PAYMENT_KB);
		eMCode = request.getParameter(PRM_TXT_EMERGENCY_CODE);
		if (StringUtil.isNull(eMCode)) {
			eMCode = "0";
		}
	}
	
	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 */
	public void setFields(MKihonDto dto) {
		// f[^̐ݒ
		pltSalaryKb = dto.getKyKubun();
		pltTaxKb = dto.getTxKubun();
		pltUnionKb = dto.getKmKubun();
		pltPartKb = dto.getPtKubun();
		pltPaymentKb = dto.getShKubun();
		
		hidSalaryKb = pltSalaryKb;
		hidTaxKb = pltTaxKb;
		hidUnionKb = pltUnionKb;
		hidPartKb = pltPartKb;
		hidPaymentKb = pltPaymentKb;
		setLblKName(dto.getSimei());
		lblKKana = dto.getFurigana();
		lblSalaryKb = getCodeName(pltSalaryKb, aryPltSalaryKb);
		lblTaxKb = getCodeName(pltTaxKb, aryPltTaxKb);
		lblUnionKb = getCodeName(pltUnionKb, aryPltUnionKb);
		lblPartKb = getCodeName(pltPartKb, aryPltPartKb);
		lblPaymentKb = getCodeName(pltPaymentKb, aryPltPaymentKb);
	}
	
	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 */
	public void setFields(MKojinDto dto) {
		// f[^̐ݒ
		pltGender = dto.getSeibetu();
		pltBirthYear = DateUtil.convIntegerDateToArray(dto.getSeinenbi())[0];
		pltBirthMonth = DateUtil.convIntegerDateToArray(dto.getSeinenbi())[1];
		pltBirthDay = DateUtil.convIntegerDateToArray(dto.getSeinenbi())[2];
		txtPostalCode1 = StringUtil.divideYubinCodeForward(dto.getYubinban());
		txtPostalCode2 = StringUtil.divideYubinCodeBackward(dto.getYubinban());
		pltPrefecture = String.valueOf(dto.getPrefectures());
		txtAdress1 = dto.getJyuusyo1();
		txtAdress2 = dto.getJyuusyo2();
		txtAdress3 = dto.getJyuusyo3();
		txtTel1 = StringUtil.divideByHyphen(dto.getTel(), 2)[0];
		txtTel2 = StringUtil.divideByHyphen(dto.getTel(), 2)[1];
		txtTel3 = StringUtil.divideByHyphen(dto.getTel(), 2)[2];
		txtFax1 = StringUtil.divideByHyphen(dto.getFax(), 2)[0];
		txtFax2 = StringUtil.divideByHyphen(dto.getFax(), 2)[1];
		txtFax3 = StringUtil.divideByHyphen(dto.getFax(), 2)[2];
		txtPhone1 = StringUtil.divideByHyphen(dto.getKeitai(), 2)[0];
		txtPhone2 = StringUtil.divideByHyphen(dto.getKeitai(), 2)[1];
		txtPhone3 = StringUtil.divideByHyphen(dto.getKeitai(), 2)[2];
		pltBloodType = dto.getKetueki();
		txtLicense = dto.getSikaku();
		txtRecapitulation = dto.getTekiyou();
		txtHealth = dto.getKenkou();
		
		hidGender = dto.getSeibetu();
		hidBirthYear = DateUtil.convIntegerDateToArray(dto.getSeinenbi())[0];
		hidBirthMonth = DateUtil.convIntegerDateToArray(dto.getSeinenbi())[1];
		hidBirthDay = DateUtil.convIntegerDateToArray(dto.getSeinenbi())[2];
		hidPostalCode1 = StringUtil.divideYubinCodeForward(dto.getYubinban());
		hidPostalCode2 = StringUtil.divideYubinCodeBackward(dto.getYubinban());
		hidPrefecture = String.valueOf(dto.getPrefectures());
		hidAdress1 = dto.getJyuusyo1();
		hidAdress2 = dto.getJyuusyo2();
		hidAdress3 = dto.getJyuusyo3();
		hidTel1 = StringUtil.divideByHyphen(dto.getTel(), 2)[0];
		hidTel2 = StringUtil.divideByHyphen(dto.getTel(), 2)[1];
		hidTel3 = StringUtil.divideByHyphen(dto.getTel(), 2)[2];
		hidFax1 = StringUtil.divideByHyphen(dto.getFax(), 2)[0];
		hidFax2 = StringUtil.divideByHyphen(dto.getFax(), 2)[1];
		hidFax3 = StringUtil.divideByHyphen(dto.getFax(), 2)[2];
		hidPhone1 = StringUtil.divideByHyphen(dto.getKeitai(), 2)[0];
		hidPhone2 = StringUtil.divideByHyphen(dto.getKeitai(), 2)[1];
		hidPhone3 = StringUtil.divideByHyphen(dto.getKeitai(), 2)[2];
		hidBloodType = dto.getKetueki();
		hidLicense = dto.getSikaku();
		hidRecapitulation = dto.getTekiyou();
		hidHealth = dto.getKenkou();
		
		lblGender = getCodeName(dto.getSeibetu(), aryPltGender);
		lblBirthYear = DateUtil.convIntegerDateToArray(dto.getSeinenbi())[0];
		lblBirthMonth = DateUtil.convIntegerDateToArray(dto.getSeinenbi())[1];
		lblBirthDay = DateUtil.convIntegerDateToArray(dto.getSeinenbi())[2];
		lblPostalCode1 = StringUtil.divideYubinCodeForward(dto.getYubinban());
		lblPostalCode2 = StringUtil.divideYubinCodeBackward(dto.getYubinban());
		lblPrefecture = getCodeName(String.valueOf(dto.getPrefectures()), aryPltPrefecture);
		lblAdress1 = dto.getJyuusyo1();
		lblAdress2 = dto.getJyuusyo2();
		lblAdress3 = dto.getJyuusyo3();
		lblTel = txtTel1 + "-" + txtTel2 + "-" + txtTel3;
		lblFax = txtFax1 + "-" + txtFax2 + "-" + txtFax3;
		lblPhone = txtPhone1 + "-" + txtPhone2 + "-" + txtPhone3;
		lblBloodType = getCodeName(dto.getKetueki(), aryPltBloodType);
		lblLicense = dto.getSikaku();
		lblRecapitulation = dto.getTekiyou();
		lblHealth = dto.getKenkou();
	}
	
	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 */
	public void setFields(MEmergencyDto dto) {
		// f[^̐ݒ
		txtEmName = dto.getName();
		txtEmTel1 = StringUtil.divideByHyphen(dto.getPhone(), 2)[0];
		txtEmTel2 = StringUtil.divideByHyphen(dto.getPhone(), 2)[1];
		txtEmTel3 = StringUtil.divideByHyphen(dto.getPhone(), 2)[2];
		txtEmPhone1 = StringUtil.divideByHyphen(dto.getCell(), 2)[0];
		txtEmPhone2 = StringUtil.divideByHyphen(dto.getCell(), 2)[1];
		txtEmPhone3 = StringUtil.divideByHyphen(dto.getCell(), 2)[2];
		txtEmPostalCode1 = StringUtil.divideYubinCodeForward(dto.getPostalCode());
		txtEmPostalCode2 = StringUtil.divideYubinCodeBackward(dto.getPostalCode());
		pltEmPrefecture = String.valueOf(dto.getPrefectures());
		txtEmAdress1 = dto.getJyuusyo1();
		txtEmAdress2 = dto.getJyuusyo2();
		txtEmAdress3 = dto.getJyuusyo3();
		
		hidEmName = dto.getName();
		hidEmTel1 = StringUtil.divideByHyphen(dto.getPhone(), 2)[0];
		hidEmTel2 = StringUtil.divideByHyphen(dto.getPhone(), 2)[1];
		hidEmTel3 = StringUtil.divideByHyphen(dto.getPhone(), 2)[2];
		hidEmPhone1 = StringUtil.divideByHyphen(dto.getCell(), 2)[0];
		hidEmPhone2 = StringUtil.divideByHyphen(dto.getCell(), 2)[1];
		hidEmPhone3 = StringUtil.divideByHyphen(dto.getCell(), 2)[2];
		hidEmPostalCode1 = StringUtil.divideYubinCodeForward(dto.getPostalCode());
		hidEmPostalCode2 = StringUtil.divideYubinCodeBackward(dto.getPostalCode());
		hidEmPrefecture = String.valueOf(dto.getPrefectures());
		hidEmAdress1 = dto.getJyuusyo1();
		hidEmAdress2 = dto.getJyuusyo2();
		hidEmAdress3 = dto.getJyuusyo3();
		
		lblEmName = dto.getName();
		lblEmTel = txtEmTel1 + "-" + txtEmTel2 + "-" + txtEmTel3;
		lblEmPhone = txtEmPhone1 + "-" + txtEmPhone2 + "-" + txtEmPhone3;
		lblEmPostalCode1 = StringUtil.divideYubinCodeForward(dto.getPostalCode());
		lblEmPostalCode2 = StringUtil.divideYubinCodeBackward(dto.getPostalCode());
		lblEmPrefecture = getCodeName(pltEmPrefecture, aryPltPrefecture);
		lblEmAdress1 = dto.getJyuusyo1();
		lblEmAdress2 = dto.getJyuusyo2();
		lblEmAdress3 = dto.getJyuusyo3();
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto	ΏDTO
	 */
	public void setDtoFields(MKihonDto dto) {
		dto.setKCode(txtChangeKCode);
		dto.setKyKubun(pltSalaryKb);
		dto.setTxKubun(pltTaxKb);
		dto.setKmKubun(pltUnionKb);
		dto.setPtKubun(pltPartKb);
		dto.setShKubun(pltPaymentKb);
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param  dto	ΏDTO
	 */
	public void setDtoFields(MKojinDto dto) {
		dto.setSeibetu(pltGender);
		dto.setSeinenbi(DateUtil.convStringDateToInteger(pltBirthYear, pltBirthMonth, pltBirthDay));
		dto.setYubinban(txtPostalCode1 + CommonConst.NAM_POSTAL_SEPARATOR + txtPostalCode2);
		dto.setPrefectures(Integer.parseInt(pltPrefecture));
		dto.setJyuusyo1(txtAdress1);
		dto.setJyuusyo2(txtAdress2);
		dto.setJyuusyo3(txtAdress3);
		dto.setTel(txtTel1 + "-" + txtTel2 + "-" + txtTel3);
		dto.setFax(txtFax1 + "-" + txtFax2 + "-" + txtFax3);
		dto.setKeitai(txtPhone1 + "-" + txtPhone2 + "-" + txtPhone3);
		dto.setKetueki(pltBloodType);
		dto.setSikaku(txtLicense);
		dto.setTekiyou(txtRecapitulation);
		dto.setKenkou(txtHealth);
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param  dto	ΏDTO
	 */
	public void setDtoFields(MEmergencyDto dto) {
		dto.setKCode(txtChangeKCode);
		dto.setName(txtEmName);
		dto.setPhone(txtEmTel1 + "-" + txtEmTel2 + "-" + txtEmTel3);
		dto.setCell(txtEmPhone1 + "-" + txtEmPhone2 + "-" + txtEmPhone3);
		dto.setPostalCode(txtEmPostalCode1 + CommonConst.NAM_POSTAL_SEPARATOR + txtEmPostalCode2);
		dto.setPrefectures(Integer.parseInt(pltEmPrefecture));
		dto.setJyuusyo1(txtEmAdress1);
		dto.setJyuusyo2(txtEmAdress2);
		dto.setJyuusyo3(txtEmAdress3);
	}
	
	@Override
	public void initFields() {
		super.initFields();
		pltGender = "";
		pltBirthYear = "";
		pltBirthMonth = "";
		pltBirthDay = "";
		txtPostalCode1 = "";
		txtPostalCode2 = "";
		pltPrefecture = "";
		txtAdress1 = "";
		txtAdress2 = "";
		txtAdress3 = "";
		txtEmName = "";
		txtEmTel1 = "";
		txtEmTel2 = "";
		txtEmTel3 = "";
		txtEmPhone1 = "";
		txtEmPhone2 = "";
		txtEmPhone3 = "";
		txtEmPostalCode1 = "";
		txtEmPostalCode2 = "";
		pltEmPrefecture = "";
		txtEmAdress1 = "";
		txtEmAdress2 = "";
		txtEmAdress3 = "";
		txtTel1 = "";
		txtTel2 = "";
		txtTel3 = "";
		txtFax1 = "";
		txtFax2 = "";
		txtFax3 = "";
		lblKKana = "";
		txtPhone1 = "";
		txtPhone2 = "";
		txtPhone3 = "";
		pltBloodType = "";
		txtLicense = "";
		txtRecapitulation = "";
		txtHealth = "";
		pltSalaryKb = "";
		pltTaxKb = "";
		pltUnionKb = "";
		pltPartKb = "";
		pltPaymentKb = "";
		
		hidGender = "";
		hidBirthYear = "";
		hidBirthMonth = "";
		hidBirthDay = "";
		hidPostalCode1 = "";
		hidPostalCode2 = "";
		hidPrefecture = "";
		hidAdress1 = "";
		hidAdress2 = "";
		hidAdress3 = "";
		hidEmName = "";
		hidEmTel1 = "";
		hidEmTel2 = "";
		hidEmTel3 = "";
		hidEmPhone1 = "";
		hidEmPhone2 = "";
		hidEmPhone3 = "";
		hidEmPostalCode1 = "";
		hidEmPostalCode2 = "";
		hidEmPrefecture = "";
		hidEmAdress1 = "";
		hidEmAdress2 = "";
		hidEmAdress3 = "";
		hidTel1 = "";
		hidTel2 = "";
		hidTel3 = "";
		hidFax1 = "";
		hidFax2 = "";
		hidFax3 = "";
		lblKKana = "";
		hidPhone1 = "";
		hidPhone2 = "";
		hidPhone3 = "";
		hidBloodType = "";
		hidLicense = "";
		hidRecapitulation = "";
		hidHealth = "";
		hidSalaryKb = "";
		hidTaxKb = "";
		hidUnionKb = "";
		hidPartKb = "";
		hidPaymentKb = "";
		
		lblGender = "";
		lblBirthYear = "";
		lblBirthMonth = "";
		lblBirthDay = "";
		lblPostalCode1 = "";
		lblPostalCode2 = "";
		lblPrefecture = "";
		lblAdress1 = "";
		lblAdress2 = "";
		lblAdress3 = "";
		lblEmName = "";
		lblEmTel = "";
		lblEmPhone = "";
		lblEmPostalCode1 = "";
		lblEmPostalCode2 = "";
		lblEmPrefecture = "";
		lblEmAdress1 = "";
		lblEmAdress2 = "";
		lblEmAdress3 = "";
		lblTel = "";
		lblFax = "";
		lblKKana = "";
		lblPhone = "";
		lblBloodType = "";
		lblLicense = "";
		lblRecapitulation = "";
		lblHealth = "";
		lblSalaryKb = "";
		lblTaxKb = "";
		lblUnionKb = "";
		lblPartKb = "";
		lblPaymentKb = "";
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException  	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtChangeKCode, NAM_K_CODE, PRM_TXT_CHANGE_K_CODE);
		// mF
		checkLength(txtChangeKCode, LEN_K_CODE, NAM_K_CODE, PRM_TXT_CHANGE_K_CODE);
		//lmF
		checkNumber(txtTel1, NAM_TEL1, PRM_TXT_TEL1);
		checkNumber(txtTel2, NAM_TEL2, PRM_TXT_TEL2);
		checkNumber(txtTel3, NAM_TEL3, PRM_TXT_TEL3);
		checkNumber(txtFax1, NAM_FAX1, PRM_TXT_FAX1);
		checkNumber(txtFax2, NAM_FAX2, PRM_TXT_FAX2);
		checkNumber(txtFax3, NAM_FAX3, PRM_TXT_FAX3);
		checkNumber(txtPhone1, NAM_PHONE1, PRM_TXT_PHONE1);
		checkNumber(txtPhone2, NAM_PHONE2, PRM_TXT_PHONE2);
		checkNumber(txtPhone3, NAM_PHONE3, PRM_TXT_PHONE3);
		checkNumber(txtEmTel1, NAM_EMERGENCY_TEL1, PRM_TXT_EMERGENCY_TEL1);
		checkNumber(txtEmTel2, NAM_EMERGENCY_TEL2, PRM_TXT_EMERGENCY_TEL2);
		checkNumber(txtEmTel3, NAM_EMERGENCY_TEL3, PRM_TXT_EMERGENCY_TEL3);
		checkNumber(txtEmPhone1, NAM_EMERGENCY_PHONE1, PRM_TXT_EMERGENCY_PHONE1);
		checkNumber(txtEmPhone2, NAM_EMERGENCY_PHONE2, PRM_TXT_EMERGENCY_PHONE2);
		checkNumber(txtEmPhone3, NAM_EMERGENCY_PHONE3, PRM_TXT_EMERGENCY_PHONE3);
		// tmF
		checkDate(getIntParam(pltBirthYear), getIntParam(pltBirthMonth), getIntParam(pltBirthDay), NAM_BIRTH_DATE,
				PRM_PLT_BIRTH_YEAR + PRM_PLT_BIRTH_MONTH + PRM_PLT_BIRTH_DAY);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	/**
	 * @return eMCode
	 */
	public String geteMCode() {
		return eMCode;
	}
	
	/**
	 * @return pltGender
	 */
	public String getPltGender() {
		return pltGender;
	}
	
	/**
	 * @return pltBirthYear
	 */
	public String getPltBirthYear() {
		return pltBirthYear;
	}
	
	/**
	 * @return pltBirthMonth
	 */
	public String getPltBirthMonth() {
		return pltBirthMonth;
	}
	
	/**
	 * @return pltBirthDay
	 */
	public String getPltBirthDay() {
		return pltBirthDay;
	}
	
	/**
	 * @return txtPostalCode1
	 */
	public String getTxtPostalCode1() {
		return txtPostalCode1;
	}
	
	/**
	 * @return txtPostalCode2
	 */
	public String getTxtPostalCode2() {
		return txtPostalCode2;
	}
	
	/**
	 * @return pltPrefecture
	 */
	public String getPltPrefecture() {
		return pltPrefecture;
	}
	
	/**
	 * @return txtAdress1
	 */
	public String getTxtAdress1() {
		return txtAdress1;
	}
	
	/**
	 * @return txtAdress2
	 */
	public String getTxtAdress2() {
		return txtAdress2;
	}
	
	/**
	 * @return txtAdress3
	 */
	public String getTxtAdress3() {
		return txtAdress3;
	}
	
	/**
	 * @return txtEmName
	 */
	public String getTxtEmName() {
		return txtEmName;
	}
	
	/**
	 * @return txtEmTel1
	 */
	public String getTxtEmTel1() {
		return txtEmTel1;
	}
	
	/**
	 * @return txtEmTel2
	 */
	public String getTxtEmTel2() {
		return txtEmTel2;
	}
	
	/**
	 * @return txtEmTel3
	 */
	public String getTxtEmTel3() {
		return txtEmTel3;
	}
	
	/**
	 * @return txtEmPhone1
	 */
	public String getTxtEmPhone1() {
		return txtEmPhone1;
	}
	
	/**
	 * @return txtEmPhone2
	 */
	public String getTxtEmPhone2() {
		return txtEmPhone2;
	}
	
	/**
	 * @return txtEmPhone3
	 */
	public String getTxtEmPhone3() {
		return txtEmPhone3;
	}
	
	/**
	 * @return txtEmPostalCode1
	 */
	public String getTxtEmPostalCode1() {
		return txtEmPostalCode1;
	}
	
	/**
	 * @return txtEmPostalCode2
	 */
	public String getTxtEmPostalCode2() {
		return txtEmPostalCode2;
	}
	
	/**
	 * @return pltEmPrefecture
	 */
	public String getPltEmPrefecture() {
		return pltEmPrefecture;
	}
	
	/**
	 * @return txtEmAdress1
	 */
	public String getTxtEmAdress1() {
		return txtEmAdress1;
	}
	
	/**
	 * @return txtEmAdress2
	 */
	public String getTxtEmAdress2() {
		return txtEmAdress2;
	}
	
	/**
	 * @return txtEmAdress3
	 */
	public String getTxtEmAdress3() {
		return txtEmAdress3;
	}
	
	/**
	 * @return txtTel1
	 */
	public String getTxtTel1() {
		return txtTel1;
	}
	
	/**
	 * @return txtTel2
	 */
	public String getTxtTel2() {
		return txtTel2;
	}
	
	/**
	 * @return txtTel3
	 */
	public String getTxtTel3() {
		return txtTel3;
	}
	
	/**
	 * @return txtFax1
	 */
	public String getTxtFax1() {
		return txtFax1;
	}
	
	/**
	 * @return txtFax2
	 */
	public String getTxtFax2() {
		return txtFax2;
	}
	
	/**
	 * @return txtFax3
	 */
	public String getTxtFax3() {
		return txtFax3;
	}
	
	/**
	 * @return txtPhone1
	 */
	public String getTxtPhone1() {
		return txtPhone1;
	}
	
	/**
	 * @return txtPhone2
	 */
	public String getTxtPhone2() {
		return txtPhone2;
	}
	
	/**
	 * @return txtPhone3
	 */
	public String getTxtPhone3() {
		return txtPhone3;
	}
	
	/**
	 * @return pltBloodType
	 */
	public String getPltBloodType() {
		return pltBloodType;
	}
	
	/**
	 * @return txtLicense
	 */
	public String getTxtLicense() {
		return txtLicense;
	}
	
	/**
	 * @return txtRecapitulation
	 */
	public String getTxtRecapitulation() {
		return txtRecapitulation;
	}
	
	/**
	 * @return txtHealth
	 */
	public String getTxtHealth() {
		return txtHealth;
	}
	
	/**
	 * @return pltSalaryKb
	 */
	public String getPltSalaryKb() {
		return pltSalaryKb;
	}
	
	/**
	 * @return pltTaxKb
	 */
	public String getPltTaxKb() {
		return pltTaxKb;
	}
	
	/**
	 * @return pltUnionKb
	 */
	public String getPltUnionKb() {
		return pltUnionKb;
	}
	
	/**
	 * @return pltPartKb
	 */
	public String getPltPartKb() {
		return pltPartKb;
	}
	
	/**
	 * @return pltPaymentKb
	 */
	public String getPltPaymentKb() {
		return pltPaymentKb;
	}
	
	/**
	 * @return lblGender
	 */
	public String getLblGender() {
		return lblGender;
	}
	
	/**
	 * @return lblBirthYear
	 */
	public String getLblBirthYear() {
		return lblBirthYear;
	}
	
	/**
	 * @return lblBirthMonth
	 */
	public String getLblBirthMonth() {
		return lblBirthMonth;
	}
	
	/**
	 * @return lblBirthDay
	 */
	public String getLblBirthDay() {
		return lblBirthDay;
	}
	
	/**
	 * @return lblPostalCode1
	 */
	public String getLblPostalCode1() {
		return lblPostalCode1;
	}
	
	/**
	 * @return lblPostalCode2
	 */
	public String getLblPostalCode2() {
		return lblPostalCode2;
	}
	
	/**
	 * @return lblPrefecture
	 */
	public String getLblPrefecture() {
		return lblPrefecture;
	}
	
	/**
	 * @return lblAdress1
	 */
	public String getLblAdress1() {
		return lblAdress1;
	}
	
	/**
	 * @return lblAdress2
	 */
	public String getLblAdress2() {
		return lblAdress2;
	}
	
	/**
	 * @return lblAdress3
	 */
	public String getLblAdress3() {
		return lblAdress3;
	}
	
	/**
	 * @return lblEmName
	 */
	public String getLblEmName() {
		return lblEmName;
	}
	
	/**
	 * @return lblEmTel
	 */
	public String getLblEmTel() {
		return lblEmTel;
	}
	
	/**
	 * @return lblEmPhone
	 */
	public String getLblEmPhone() {
		return lblEmPhone;
	}
	
	/**
	 * @return lblEmPostalCode1
	 */
	public String getLblEmPostalCode1() {
		return lblEmPostalCode1;
	}
	
	/**
	 * @return lblEmPostalCode2
	 */
	public String getLblEmPostalCode2() {
		return lblEmPostalCode2;
	}
	
	/**
	 * @return lblEmPrefecture
	 */
	public String getLblEmPrefecture() {
		return lblEmPrefecture;
	}
	
	/**
	 * @return lblEmAdress1
	 */
	public String getLblEmAdress1() {
		return lblEmAdress1;
	}
	
	/**
	 * @return lblEmAdress2
	 */
	public String getLblEmAdress2() {
		return lblEmAdress2;
	}
	
	/**
	 * @return lblEmAdress3
	 */
	public String getLblEmAdress3() {
		return lblEmAdress3;
	}
	
	/**
	 * @return lblTel
	 */
	public String getLblTel() {
		return lblTel;
	}
	
	/**
	 * @return lblFax
	 */
	public String getLblFax() {
		return lblFax;
	}
	
	/**
	 * @return lblPhone
	 */
	public String getLblPhone() {
		return lblPhone;
	}
	
	/**
	 * @return lblBloodType
	 */
	public String getLblBloodType() {
		return lblBloodType;
	}
	
	/**
	 * @return lblLicense
	 */
	public String getLblLicense() {
		return lblLicense;
	}
	
	/**
	 * @return lblRecapitulation
	 */
	public String getLblRecapitulation() {
		return lblRecapitulation;
	}
	
	/**
	 * @return lblHealth
	 */
	public String getLblHealth() {
		return lblHealth;
	}
	
	/**
	 * @return lblSalaryKb
	 */
	public String getLblSalaryKb() {
		return lblSalaryKb;
	}
	
	/**
	 * @return lblTaxKb
	 */
	public String getLblTaxKb() {
		return lblTaxKb;
	}
	
	/**
	 * @return lblUnionKb
	 */
	public String getLblUnionKb() {
		return lblUnionKb;
	}
	
	/**
	 * @return lblPartKb
	 */
	public String getLblPartKb() {
		return lblPartKb;
	}
	
	/**
	 * @return lblPaymentKb
	 */
	public String getLblPaymentKb() {
		return lblPaymentKb;
	}
	
	/**
	 * @return hidGender
	 */
	public String getHidGender() {
		return hidGender;
	}
	
	/**
	 * @return hidBirthYear
	 */
	public String getHidBirthYear() {
		return hidBirthYear;
	}
	
	/**
	 * @return hidBirthMonth
	 */
	public String getHidBirthMonth() {
		return hidBirthMonth;
	}
	
	/**
	 * @return hidBirthDay
	 */
	public String getHidBirthDay() {
		return hidBirthDay;
	}
	
	/**
	 * @return hidPostalCode1
	 */
	public String getHidPostalCode1() {
		return hidPostalCode1;
	}
	
	/**
	 * @return hidPostalCode2
	 */
	public String getHidPostalCode2() {
		return hidPostalCode2;
	}
	
	/**
	 * @return hidPrefecture
	 */
	public String getHidPrefecture() {
		return hidPrefecture;
	}
	
	/**
	 * @return hidAdress1
	 */
	public String getHidAdress1() {
		return hidAdress1;
	}
	
	/**
	 * @return hidAdress2
	 */
	public String getHidAdress2() {
		return hidAdress2;
	}
	
	/**
	 * @return hidAdress3
	 */
	public String getHidAdress3() {
		return hidAdress3;
	}
	
	/**
	 * @return hidEmName
	 */
	public String getHidEmName() {
		return hidEmName;
	}
	
	/**
	 * @return hidEmTel1
	 */
	public String getHidEmTel1() {
		return hidEmTel1;
	}
	
	/**
	 * @return hidEmTel2
	 */
	public String getHidEmTel2() {
		return hidEmTel2;
	}
	
	/**
	 * @return hidEmTel3
	 */
	public String getHidEmTel3() {
		return hidEmTel3;
	}
	
	/**
	 * @return hidEmPhone1
	 */
	public String getHidEmPhone1() {
		return hidEmPhone1;
	}
	
	/**
	 * @return hidEmPhone2
	 */
	public String getHidEmPhone2() {
		return hidEmPhone2;
	}
	
	/**
	 * @return hidEmPhone3
	 */
	public String getHidEmPhone3() {
		return hidEmPhone3;
	}
	
	/**
	 * @return hidEmPostalCode1
	 */
	public String getHidEmPostalCode1() {
		return hidEmPostalCode1;
	}
	
	/**
	 * @return hidEmPostalCode2
	 */
	public String getHidEmPostalCode2() {
		return hidEmPostalCode2;
	}
	
	/**
	 * @return hidEmPrefecture
	 */
	public String getHidEmPrefecture() {
		return hidEmPrefecture;
	}
	
	/**
	 * @return hidEmAdress1
	 */
	public String getHidEmAdress1() {
		return hidEmAdress1;
	}
	
	/**
	 * @return hidEmAdress2
	 */
	public String getHidEmAdress2() {
		return hidEmAdress2;
	}
	
	/**
	 * @return hidEmAdress3
	 */
	public String getHidEmAdress3() {
		return hidEmAdress3;
	}
	
	/**
	 * @return hidTel1
	 */
	public String getHidTel1() {
		return hidTel1;
	}
	
	/**
	 * @return hidTel2
	 */
	public String getHidTel2() {
		return hidTel2;
	}
	
	/**
	 * @return hidTel3
	 */
	public String getHidTel3() {
		return hidTel3;
	}
	
	/**
	 * @return hidFax1
	 */
	public String getHidFax1() {
		return hidFax1;
	}
	
	/**
	 * @return hidFax2
	 */
	public String getHidFax2() {
		return hidFax2;
	}
	
	/**
	 * @return hidFax3
	 */
	public String getHidFax3() {
		return hidFax3;
	}
	
	/**
	 * @return hidPhone1
	 */
	public String getHidPhone1() {
		return hidPhone1;
	}
	
	/**
	 * @return hidPhone2
	 */
	public String getHidPhone2() {
		return hidPhone2;
	}
	
	/**
	 * @return hidPhone3
	 */
	public String getHidPhone3() {
		return hidPhone3;
	}
	
	/**
	 * @return hidBloodType
	 */
	public String getHidBloodType() {
		return hidBloodType;
	}
	
	/**
	 * @return hidLicense
	 */
	public String getHidLicense() {
		return hidLicense;
	}
	
	/**
	 * @return hidRecapitulation
	 */
	public String getHidRecapitulation() {
		return hidRecapitulation;
	}
	
	/**
	 * @return hidHealth
	 */
	public String getHidHealth() {
		return hidHealth;
	}
	
	/**
	 * @return hidSalaryKb
	 */
	public String getHidSalaryKb() {
		return hidSalaryKb;
	}
	
	/**
	 * @return hidTaxKb
	 */
	public String getHidTaxKb() {
		return hidTaxKb;
	}
	
	/**
	 * @return hidUnionKb
	 */
	public String getHidUnionKb() {
		return hidUnionKb;
	}
	
	/**
	 * @return hidPartKb
	 */
	public String getHidPartKb() {
		return hidPartKb;
	}
	
	/**
	 * @return hidPaymentKb
	 */
	public String getHidPaymentKb() {
		return hidPaymentKb;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param eMCode Zbg eMCode
	 */
	public void seteMCode(String eMCode) {
		this.eMCode = eMCode;
	}
	
	/**
	 * @param pltGender Zbg pltGender
	 */
	public void setPltGender(String pltGender) {
		this.pltGender = pltGender;
	}
	
	/**
	 * @param pltBirthYear Zbg pltBirthYear
	 */
	public void setPltBirthYear(String pltBirthYear) {
		this.pltBirthYear = pltBirthYear;
	}
	
	/**
	 * @param pltBirthMonth Zbg pltBirthMonth
	 */
	public void setPltBirthMonth(String pltBirthMonth) {
		this.pltBirthMonth = pltBirthMonth;
	}
	
	/**
	 * @param pltBirthDay Zbg pltBirthDay
	 */
	public void setPltBirthDay(String pltBirthDay) {
		this.pltBirthDay = pltBirthDay;
	}
	
	/**
	 * @param txtPostalCode1 Zbg txtPostalCode1
	 */
	public void setTxtPostalCode1(String txtPostalCode1) {
		this.txtPostalCode1 = txtPostalCode1;
	}
	
	/**
	 * @param txtPostalCode2 Zbg txtPostalCode2
	 */
	public void setTxtPostalCode2(String txtPostalCode2) {
		this.txtPostalCode2 = txtPostalCode2;
	}
	
	/**
	 * @param pltPrefecture Zbg pltPrefecture
	 */
	public void setPltPrefecture(String pltPrefecture) {
		this.pltPrefecture = pltPrefecture;
	}
	
	/**
	 * @param txtAdress1 Zbg txtAdress1
	 */
	public void setTxtAdress1(String txtAdress1) {
		this.txtAdress1 = txtAdress1;
	}
	
	/**
	 * @param txtAdress2 Zbg txtAdress2
	 */
	public void setTxtAdress2(String txtAdress2) {
		this.txtAdress2 = txtAdress2;
	}
	
	/**
	 * @param txtAdress3 Zbg txtAdress3
	 */
	public void setTxtAdress3(String txtAdress3) {
		this.txtAdress3 = txtAdress3;
	}
	
	/**
	 * @param txtEmName Zbg txtEmName
	 */
	public void setTxtEmName(String txtEmName) {
		this.txtEmName = txtEmName;
	}
	
	/**
	 * @param txtEmTel1 Zbg txtEmTel1
	 */
	public void setTxtEmTel1(String txtEmTel1) {
		this.txtEmTel1 = txtEmTel1;
	}
	
	/**
	 * @param txtEmTel2 Zbg txtEmTel2
	 */
	public void setTxtEmTel2(String txtEmTel2) {
		this.txtEmTel2 = txtEmTel2;
	}
	
	/**
	 * @param txtEmTel3 Zbg txtEmTel3
	 */
	public void setTxtEmTel3(String txtEmTel3) {
		this.txtEmTel3 = txtEmTel3;
	}
	
	/**
	 * @param txtEmPhone1 Zbg txtEmPhone1
	 */
	public void setTxtEmPhone1(String txtEmPhone1) {
		this.txtEmPhone1 = txtEmPhone1;
	}
	
	/**
	 * @param txtEmPhone2 Zbg txtEmPhone2
	 */
	public void setTxtEmPhone2(String txtEmPhone2) {
		this.txtEmPhone2 = txtEmPhone2;
	}
	
	/**
	 * @param txtEmPhone3 Zbg txtEmPhone3
	 */
	public void setTxtEmPhone3(String txtEmPhone3) {
		this.txtEmPhone3 = txtEmPhone3;
	}
	
	/**
	 * @param txtEmPostalCode1 Zbg txtEmPostalCode1
	 */
	public void setTxtEmPostalCode1(String txtEmPostalCode1) {
		this.txtEmPostalCode1 = txtEmPostalCode1;
	}
	
	/**
	 * @param txtEmPostalCode2 Zbg txtEmPostalCode2
	 */
	public void setTxtEmPostalCode2(String txtEmPostalCode2) {
		this.txtEmPostalCode2 = txtEmPostalCode2;
	}
	
	/**
	 * @param pltEmPrefecture Zbg pltEmPrefecture
	 */
	public void setPltEmPrefecture(String pltEmPrefecture) {
		this.pltEmPrefecture = pltEmPrefecture;
	}
	
	/**
	 * @param txtEmAdress1 Zbg txtEmAdress1
	 */
	public void setTxtEmAdress1(String txtEmAdress1) {
		this.txtEmAdress1 = txtEmAdress1;
	}
	
	/**
	 * @param txtEmAdress2 Zbg txtEmAdress2
	 */
	public void setTxtEmAdress2(String txtEmAdress2) {
		this.txtEmAdress2 = txtEmAdress2;
	}
	
	/**
	 * @param txtEmAdress3 Zbg txtEmAdress3
	 */
	public void setTxtEmAdress3(String txtEmAdress3) {
		this.txtEmAdress3 = txtEmAdress3;
	}
	
	/**
	 * @param txtTel1 Zbg txtTel1
	 */
	public void setTxtTel1(String txtTel1) {
		this.txtTel1 = txtTel1;
	}
	
	/**
	 * @param txtTel2 Zbg txtTel2
	 */
	public void setTxtTel2(String txtTel2) {
		this.txtTel2 = txtTel2;
	}
	
	/**
	 * @param txtTel3 Zbg txtTel3
	 */
	public void setTxtTel3(String txtTel3) {
		this.txtTel3 = txtTel3;
	}
	
	/**
	 * @param txtFax1 Zbg txtFax1
	 */
	public void setTxtFax1(String txtFax1) {
		this.txtFax1 = txtFax1;
	}
	
	/**
	 * @param txtFax2 Zbg txtFax2
	 */
	public void setTxtFax2(String txtFax2) {
		this.txtFax2 = txtFax2;
	}
	
	/**
	 * @param txtFax3 Zbg txtFax3
	 */
	public void setTxtFax3(String txtFax3) {
		this.txtFax3 = txtFax3;
	}
	
	/**
	 * @param txtPhone1 Zbg txtPhone1
	 */
	public void setTxtPhone1(String txtPhone1) {
		this.txtPhone1 = txtPhone1;
	}
	
	/**
	 * @param txtPhone2 Zbg txtPhone2
	 */
	public void setTxtPhone2(String txtPhone2) {
		this.txtPhone2 = txtPhone2;
	}
	
	/**
	 * @param txtPhone3 Zbg txtPhone3
	 */
	public void setTxtPhone3(String txtPhone3) {
		this.txtPhone3 = txtPhone3;
	}
	
	/**
	 * @param pltBloodType Zbg pltBloodType
	 */
	public void setPltBloodType(String pltBloodType) {
		this.pltBloodType = pltBloodType;
	}
	
	/**
	 * @param txtLicense Zbg txtLicense
	 */
	public void setTxtLicense(String txtLicense) {
		this.txtLicense = txtLicense;
	}
	
	/**
	 * @param txtRecapitulation Zbg txtRecapitulation
	 */
	public void setTxtRecapitulation(String txtRecapitulation) {
		this.txtRecapitulation = txtRecapitulation;
	}
	
	/**
	 * @param txtHealth Zbg txtHealth
	 */
	public void setTxtHealth(String txtHealth) {
		this.txtHealth = txtHealth;
	}
	
	/**
	 * @param pltSalaryKb Zbg pltSalaryKb
	 */
	public void setPltSalaryKb(String pltSalaryKb) {
		this.pltSalaryKb = pltSalaryKb;
	}
	
	/**
	 * @param pltTaxKb Zbg pltTaxKb
	 */
	public void setPltTaxKb(String pltTaxKb) {
		this.pltTaxKb = pltTaxKb;
	}
	
	/**
	 * @param pltUnionKb Zbg pltUnionKb
	 */
	public void setPltUnionKb(String pltUnionKb) {
		this.pltUnionKb = pltUnionKb;
	}
	
	/**
	 * @param pltPartKb Zbg pltPartKb
	 */
	public void setPltPartKb(String pltPartKb) {
		this.pltPartKb = pltPartKb;
	}
	
	/**
	 * @param pltPaymentKb Zbg pltPaymentKb
	 */
	public void setPltPaymentKb(String pltPaymentKb) {
		this.pltPaymentKb = pltPaymentKb;
	}
	
	/**
	 * @param lblGender Zbg lblGender
	 */
	public void setLblGender(String lblGender) {
		this.lblGender = lblGender;
	}
	
	/**
	 * @param lblBirthYear Zbg lblBirthYear
	 */
	public void setLblBirthYear(String lblBirthYear) {
		this.lblBirthYear = lblBirthYear;
	}
	
	/**
	 * @param lblBirthMonth Zbg lblBirthMonth
	 */
	public void setLblBirthMonth(String lblBirthMonth) {
		this.lblBirthMonth = lblBirthMonth;
	}
	
	/**
	 * @param lblBirthDay Zbg lblBirthDay
	 */
	public void setLblBirthDay(String lblBirthDay) {
		this.lblBirthDay = lblBirthDay;
	}
	
	/**
	 * @param lblPostalCode1 Zbg lblPostalCode1
	 */
	public void setLblPostalCode1(String lblPostalCode1) {
		this.lblPostalCode1 = lblPostalCode1;
	}
	
	/**
	 * @param lblPostalCode2 Zbg lblPostalCode2
	 */
	public void setLblPostalCode2(String lblPostalCode2) {
		this.lblPostalCode2 = lblPostalCode2;
	}
	
	/**
	 * @param lblPrefecture Zbg lblPrefecture
	 */
	public void setLblPrefecture(String lblPrefecture) {
		this.lblPrefecture = lblPrefecture;
	}
	
	/**
	 * @param lblAdress1 Zbg lblAdress1
	 */
	public void setLblAdress1(String lblAdress1) {
		this.lblAdress1 = lblAdress1;
	}
	
	/**
	 * @param lblAdress2 Zbg lblAdress2
	 */
	public void setLblAdress2(String lblAdress2) {
		this.lblAdress2 = lblAdress2;
	}
	
	/**
	 * @param lblAdress3 Zbg lblAdress3
	 */
	public void setLblAdress3(String lblAdress3) {
		this.lblAdress3 = lblAdress3;
	}
	
	/**
	 * @param lblEmName Zbg lblEmName
	 */
	public void setLblEmName(String lblEmName) {
		this.lblEmName = lblEmName;
	}
	
	/**
	 * @param lblEmTel Zbg lblEmTel
	 */
	public void setLblEmTel(String lblEmTel) {
		this.lblEmTel = lblEmTel;
	}
	
	/**
	 * @param lblEmPhone Zbg lblEmPhone
	 */
	public void setLblEmPhone(String lblEmPhone) {
		this.lblEmPhone = lblEmPhone;
	}
	
	/**
	 * @param lblEmPostalCode1 Zbg lblEmPostalCode1
	 */
	public void setLblEmPostalCode1(String lblEmPostalCode1) {
		this.lblEmPostalCode1 = lblEmPostalCode1;
	}
	
	/**
	 * @param lblEmPostalCode2 Zbg lblEmPostalCode2
	 */
	public void setLblEmPostalCode2(String lblEmPostalCode2) {
		this.lblEmPostalCode2 = lblEmPostalCode2;
	}
	
	/**
	 * @param lblEmPrefecture Zbg lblEmPrefecture
	 */
	public void setLblEmPrefecture(String lblEmPrefecture) {
		this.lblEmPrefecture = lblEmPrefecture;
	}
	
	/**
	 * @param lblEmAdress1 Zbg lblEmAdress1
	 */
	public void setLblEmAdress1(String lblEmAdress1) {
		this.lblEmAdress1 = lblEmAdress1;
	}
	
	/**
	 * @param lblEmAdress2 Zbg lblEmAdress2
	 */
	public void setLblEmAdress2(String lblEmAdress2) {
		this.lblEmAdress2 = lblEmAdress2;
	}
	
	/**
	 * @param lblEmAdress3 Zbg lblEmAdress3
	 */
	public void setLblEmAdress3(String lblEmAdress3) {
		this.lblEmAdress3 = lblEmAdress3;
	}
	
	/**
	 * @param lblTel Zbg lblTel
	 */
	public void setLblTel(String lblTel) {
		this.lblTel = lblTel;
	}
	
	/**
	 * @param lblFax Zbg lblFax
	 */
	public void setLblFax(String lblFax) {
		this.lblFax = lblFax;
	}
	
	/**
	 * @param lblPhone Zbg lblPhone
	 */
	public void setLblPhone(String lblPhone) {
		this.lblPhone = lblPhone;
	}
	
	/**
	 * @param lblBloodType Zbg lblBloodType
	 */
	public void setLblBloodType(String lblBloodType) {
		this.lblBloodType = lblBloodType;
	}
	
	/**
	 * @param lblLicense Zbg lblLicense
	 */
	public void setLblLicense(String lblLicense) {
		this.lblLicense = lblLicense;
	}
	
	/**
	 * @param lblRecapitulation Zbg lblRecapitulation
	 */
	public void setLblRecapitulation(String lblRecapitulation) {
		this.lblRecapitulation = lblRecapitulation;
	}
	
	/**
	 * @param lblHealth Zbg lblHealth
	 */
	public void setLblHealth(String lblHealth) {
		this.lblHealth = lblHealth;
	}
	
	/**
	 * @param lblSalaryKb Zbg lblSalaryKb
	 */
	public void setLblSalaryKb(String lblSalaryKb) {
		this.lblSalaryKb = lblSalaryKb;
	}
	
	/**
	 * @param lblTaxKb Zbg lblTaxKb
	 */
	public void setLblTaxKb(String lblTaxKb) {
		this.lblTaxKb = lblTaxKb;
	}
	
	/**
	 * @param lblUnionKb Zbg lblUnionKb
	 */
	public void setLblUnionKb(String lblUnionKb) {
		this.lblUnionKb = lblUnionKb;
	}
	
	/**
	 * @param lblPartKb Zbg lblPartKb
	 */
	public void setLblPartKb(String lblPartKb) {
		this.lblPartKb = lblPartKb;
	}
	
	/**
	 * @param lblPaymentKb Zbg lblPaymentKb
	 */
	public void setLblPaymentKb(String lblPaymentKb) {
		this.lblPaymentKb = lblPaymentKb;
	}
	
	/**
	 * @param hidGender Zbg hidGender
	 */
	public void setHidGender(String hidGender) {
		this.hidGender = hidGender;
	}
	
	/**
	 * @param hidBirthYear Zbg hidBirthYear
	 */
	public void setHidBirthYear(String hidBirthYear) {
		this.hidBirthYear = hidBirthYear;
	}
	
	/**
	 * @param hidBirthMonth Zbg hidBirthMonth
	 */
	public void setHidBirthMonth(String hidBirthMonth) {
		this.hidBirthMonth = hidBirthMonth;
	}
	
	/**
	 * @param hidBirthDay Zbg hidBirthDay
	 */
	public void setHidBirthDay(String hidBirthDay) {
		this.hidBirthDay = hidBirthDay;
	}
	
	/**
	 * @param hidPostalCode1 Zbg hidPostalCode1
	 */
	public void setHidPostalCode1(String hidPostalCode1) {
		this.hidPostalCode1 = hidPostalCode1;
	}
	
	/**
	 * @param hidPostalCode2 Zbg hidPostalCode2
	 */
	public void setHidPostalCode2(String hidPostalCode2) {
		this.hidPostalCode2 = hidPostalCode2;
	}
	
	/**
	 * @param hidPrefecture Zbg hidPrefecture
	 */
	public void setHidPrefecture(String hidPrefecture) {
		this.hidPrefecture = hidPrefecture;
	}
	
	/**
	 * @param hidAdress1 Zbg hidAdress1
	 */
	public void setHidAdress1(String hidAdress1) {
		this.hidAdress1 = hidAdress1;
	}
	
	/**
	 * @param hidAdress2 Zbg hidAdress2
	 */
	public void setHidAdress2(String hidAdress2) {
		this.hidAdress2 = hidAdress2;
	}
	
	/**
	 * @param hidAdress3 Zbg hidAdress3
	 */
	public void setHidAdress3(String hidAdress3) {
		this.hidAdress3 = hidAdress3;
	}
	
	/**
	 * @param hidEmName Zbg hidEmName
	 */
	public void setHidEmName(String hidEmName) {
		this.hidEmName = hidEmName;
	}
	
	/**
	 * @param hidEmTel1 Zbg hidEmTel1
	 */
	public void setHidEmTel1(String hidEmTel1) {
		this.hidEmTel1 = hidEmTel1;
	}
	
	/**
	 * @param hidEmTel2 Zbg hidEmTel2
	 */
	public void setHidEmTel2(String hidEmTel2) {
		this.hidEmTel2 = hidEmTel2;
	}
	
	/**
	 * @param hidEmTel3 Zbg hidEmTel3
	 */
	public void setHidEmTel3(String hidEmTel3) {
		this.hidEmTel3 = hidEmTel3;
	}
	
	/**
	 * @param hidEmPhone1 Zbg hidEmPhone1
	 */
	public void setHidEmPhone1(String hidEmPhone1) {
		this.hidEmPhone1 = hidEmPhone1;
	}
	
	/**
	 * @param hidEmPhone2 Zbg hidEmPhone2
	 */
	public void setHidEmPhone2(String hidEmPhone2) {
		this.hidEmPhone2 = hidEmPhone2;
	}
	
	/**
	 * @param hidEmPhone3 Zbg hidEmPhone3
	 */
	public void setHidEmPhone3(String hidEmPhone3) {
		this.hidEmPhone3 = hidEmPhone3;
	}
	
	/**
	 * @param hidEmPostalCode1 Zbg hidEmPostalCode1
	 */
	public void setHidEmPostalCode1(String hidEmPostalCode1) {
		this.hidEmPostalCode1 = hidEmPostalCode1;
	}
	
	/**
	 * @param hidEmPostalCode2 Zbg hidEmPostalCode2
	 */
	public void setHidEmPostalCode2(String hidEmPostalCode2) {
		this.hidEmPostalCode2 = hidEmPostalCode2;
	}
	
	/**
	 * @param hidEmPrefecture Zbg hidEmPrefecture
	 */
	public void setHidEmPrefecture(String hidEmPrefecture) {
		this.hidEmPrefecture = hidEmPrefecture;
	}
	
	/**
	 * @param hidEmAdress1 Zbg hidEmAdress1
	 */
	public void setHidEmAdress1(String hidEmAdress1) {
		this.hidEmAdress1 = hidEmAdress1;
	}
	
	/**
	 * @param hidEmAdress2 Zbg hidEmAdress2
	 */
	public void setHidEmAdress2(String hidEmAdress2) {
		this.hidEmAdress2 = hidEmAdress2;
	}
	
	/**
	 * @param hidEmAdress3 Zbg hidEmAdress3
	 */
	public void setHidEmAdress3(String hidEmAdress3) {
		this.hidEmAdress3 = hidEmAdress3;
	}
	
	/**
	 * @param hidTel1 Zbg hidTel1
	 */
	public void setHidTel1(String hidTel1) {
		this.hidTel1 = hidTel1;
	}
	
	/**
	 * @param hidTel2 Zbg hidTel2
	 */
	public void setHidTel2(String hidTel2) {
		this.hidTel2 = hidTel2;
	}
	
	/**
	 * @param hidTel3 Zbg hidTel3
	 */
	public void setHidTel3(String hidTel3) {
		this.hidTel3 = hidTel3;
	}
	
	/**
	 * @param hidFax1 Zbg hidFax1
	 */
	public void setHidFax1(String hidFax1) {
		this.hidFax1 = hidFax1;
	}
	
	/**
	 * @param hidFax2 Zbg hidFax2
	 */
	public void setHidFax2(String hidFax2) {
		this.hidFax2 = hidFax2;
	}
	
	/**
	 * @param hidFax3 Zbg hidFax3
	 */
	public void setHidFax3(String hidFax3) {
		this.hidFax3 = hidFax3;
	}
	
	/**
	 * @param hidPhone1 Zbg hidPhone1
	 */
	public void setHidPhone1(String hidPhone1) {
		this.hidPhone1 = hidPhone1;
	}
	
	/**
	 * @param hidPhone2 Zbg hidPhone2
	 */
	public void setHidPhone2(String hidPhone2) {
		this.hidPhone2 = hidPhone2;
	}
	
	/**
	 * @param hidPhone3 Zbg hidPhone3
	 */
	public void setHidPhone3(String hidPhone3) {
		this.hidPhone3 = hidPhone3;
	}
	
	/**
	 * @param hidBloodType Zbg hidBloodType
	 */
	public void setHidBloodType(String hidBloodType) {
		this.hidBloodType = hidBloodType;
	}
	
	/**
	 * @param hidLicense Zbg hidLicense
	 */
	public void setHidLicense(String hidLicense) {
		this.hidLicense = hidLicense;
	}
	
	/**
	 * @param hidRecapitulation Zbg hidRecapitulation
	 */
	public void setHidRecapitulation(String hidRecapitulation) {
		this.hidRecapitulation = hidRecapitulation;
	}
	
	/**
	 * @param hidHealth Zbg hidHealth
	 */
	public void setHidHealth(String hidHealth) {
		this.hidHealth = hidHealth;
	}
	
	/**
	 * @param hidSalaryKb Zbg hidSalaryKb
	 */
	public void setHidSalaryKb(String hidSalaryKb) {
		this.hidSalaryKb = hidSalaryKb;
	}
	
	/**
	 * @param hidTaxKb Zbg hidTaxKb
	 */
	public void setHidTaxKb(String hidTaxKb) {
		this.hidTaxKb = hidTaxKb;
	}
	
	/**
	 * @param hidUnionKb Zbg hidUnionKb
	 */
	public void setHidUnionKb(String hidUnionKb) {
		this.hidUnionKb = hidUnionKb;
	}
	
	/**
	 * @param hidPartKb Zbg hidPartKb
	 */
	public void setHidPartKb(String hidPartKb) {
		this.hidPartKb = hidPartKb;
	}
	
	/**
	 * @param hidPaymentKb Zbg hidPaymentKb
	 */
	public void setHidPaymentKb(String hidPaymentKb) {
		this.hidPaymentKb = hidPaymentKb;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
