/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.vo;

import java.security.NoSuchAlgorithmException;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

/**
 * @author yoshida
 *
 */
public class MosPPasswordVo extends MosPVo {
	
	private static final long	serialVersionUID		= -7284219341360162310L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_SHOW				= 0;
	/**
	 * 
	 */
	public static final int		MODE_FORCE_UPDATE		= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_OLD_PASSWORD	= "txtOldPassword";
	/**
	 * 
	 */
	public static final String	PRM_TXT_NEW_PASSWORD	= "txtNewPassword";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CONFIRM_PASS	= "txtConfirmPass";
	/**
	 * 
	 */
	public static final String	PRM_HDN_OLD_PASSWORD	= "hdnOldPassword";
	/**
	 * 
	 */
	public static final String	PRM_HDN_NEW_PASSWORD	= "hdnNewPassword";
	/**
	 * 
	 */
	public static final String	PRM_HDN_CONFIRM_PASS	= "hdnConfirmPass";
	/**
	 * 
	 */
	public static final String	PRM_HID_USER_ID			= "hidUserId";
	
	// tB[h
	private String				hdnOldPassword;
	private String				hdnNewPassword;
	private String				hdnConfirmPass;
	
	// [h
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_PASSWORD;
	/**
	 * 
	 */
	public String				NAM_OLD_PASSWORD;
	/**
	 * 
	 */
	public String				NAM_NEW_PASSWORD;
	/**
	 * 
	 */
	public String				NAM_CONFIRM_PASS;
	/**
	 * 
	 */
	public String				NAM_CHECK_PASS_ID;
	/**
	 * 
	 */
	public int					LEN_PASSWORD;
	/**
	 * 
	 */
	public int					LEN_MIN_PASSWORD;
	

	/**
	 * RXgN^
	 */
	public MosPPasswordVo() {
		super();
		setViewPath(getClassName());
		mode = MODE_SHOW;
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_CHANGE_PASSWORD;
	}
	
	@Override
	protected void setFieldsName() {
		NAM_PASSWORD = CommonConst.NAM_PASSWORD;
		NAM_OLD_PASSWORD = CommonConst.NAM_OLD_PASSWORD;
		NAM_NEW_PASSWORD = CommonConst.NAM_NEW_PASSWORD;
		NAM_CONFIRM_PASS = CommonConst.NAM_CONFIRM_PASS;
		NAM_CHECK_PASS_ID = CommonConst.MSG_CHECK_PASS_ID;
		LEN_PASSWORD = CommonConst.LEN_PASSWORD;
		LEN_MIN_PASSWORD = CommonConst.LEN_MIN_PASSWORD;
	}
	
	/**
	 * j[R}hݒ
	 * @param menuCmd	Ώۃj[R}h
	 */
	public void setAryMenu(String menuCmd) {
		aryMenu = new String[][]{ { menuCmd, CommonConst.NAM_TO_MENU } };
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		hdnOldPassword = request.getParameter(PRM_HDN_OLD_PASSWORD);
		hdnNewPassword = request.getParameter(PRM_HDN_NEW_PASSWORD);
		hdnConfirmPass = request.getParameter(PRM_HDN_CONFIRM_PASS);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @param currentPassword ݂̃pX[h
	 * @throws NoSuchAlgorithmException  	NoSuchAlgorithmExceptionOꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public void validate(String currentPassword) throws NoSuchAlgorithmException, MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(hdnOldPassword, NAM_OLD_PASSWORD, PRM_TXT_OLD_PASSWORD);
		checkRequired(hdnNewPassword, NAM_NEW_PASSWORD, PRM_TXT_NEW_PASSWORD);
		checkRequired(hdnConfirmPass, NAM_CONFIRM_PASS, PRM_TXT_CONFIRM_PASS);
		// 񒷊mF
		checkLength(hdnOldPassword, LEN_PASSWORD, NAM_OLD_PASSWORD, PRM_TXT_OLD_PASSWORD);
		checkLength(hdnNewPassword, LEN_PASSWORD, NAM_NEW_PASSWORD, PRM_TXT_NEW_PASSWORD);
		checkLength(hdnConfirmPass, LEN_PASSWORD, NAM_CONFIRM_PASS, PRM_TXT_CONFIRM_PASS);
		// pX[hmF
		checkPassword(MospUtility.getDigest(hdnOldPassword), currentPassword, PRM_TXT_OLD_PASSWORD);
		// ύXpX[hmF
		checkCompare(hdnNewPassword, hdnConfirmPass, 0, NAM_PASSWORD, PRM_TXT_NEW_PASSWORD, PRM_TXT_CONFIRM_PASS);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return hdnOldPassword
	 */
	public String getHdnOldPassword() {
		return hdnOldPassword;
	}
	
	/**
	 * @return hdnNewPassword
	 */
	public String getHdnNewPassword() {
		return hdnNewPassword;
	}
	
	/**
	 * @return hdnConfirmPass
	 */
	public String getHdnConfirmPass() {
		return hdnConfirmPass;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param hdnOldPassword Zbg hdnOldPassword
	 */
	public void setHdnOldPassword(String hdnOldPassword) {
		this.hdnOldPassword = hdnOldPassword;
	}
	
	/**
	 * @param hdnNewPassword Zbg hdnNewPassword
	 */
	public void setHdnNewPassword(String hdnNewPassword) {
		this.hdnNewPassword = hdnNewPassword;
	}
	
	/**
	 * @param hdnConfirmPass Zbg hdnConfirmPass
	 */
	public void setHdnConfirmPass(String hdnConfirmPass) {
		this.hdnConfirmPass = hdnConfirmPass;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
