/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmComponentDto;
import jp.mosp.common.utils.StringUtil;

/**
 * @author yoshida
 *
 */
public abstract class MosPMenuArrangeVo extends MosPVo {
	
	static final long			serialVersionUID	= 1L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	/**
	 * 
	 */
	public static final int		MODE_INSERT			= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE			= 1;
	
	// p[^[
	/**
	 * txtCompCode
	 */
	public static final String	PRM_TXT_COMP_CODE	= "txtCompCode";
	/**
	 * txtCompName
	 */
	public static final String	PRM_TXT_COMP_NAME	= "txtCompName";
	/**
	 * pltManage
	 */
	public static final String	PRM_PLT_MANAGE		= "pltManage";
	/**
	 * pltSelected
	 */
	public static final String	PRM_PLT_SELECTED	= "pltSelected";
	/**
	 * pltDelete
	 */
	public static final String	PRM_PLT_DELETE		= "pltDelete";
	
	// tB[h
	private String				txtCompCode;
	private String				txtCompName;
	private String				hidDivision;
	private String				pltManage;
	private String[]			pltSelected;
	private String				pltDelete;
	
	private String[]			aryCompCode;
	private String[]			aryCompName;
	private String[]			aryManage;
	private String[]			aryComponent;
	private String[]			aryDelete;
	
	// [h(0FVKo^A1FXV)
	private int					mode;
	
	// [h(0FȂA1F)
	private int					searchmode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_COMP_CODE;
	/**
	 * 
	 */
	public String				NAM_COMP_NAME;
	/**
	 * 
	 */
	public String				NAM_MANAGE;
	/**
	 * 
	 */
	public String				NAM_COMPONENT;
	/**
	 * 
	 */
	public String				NAM_PLT_SELECTED;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	
	/**
	 * 
	 */
	public String				NAM_EMPLOYEE_CMD;
	/**
	 * 
	 */
	public String				NAM_MANAGER_CMD;
	/**
	 * 
	 */
	public String				NAM_PAYROLL_CMD;
	/**
	 * 
	 */
	public String				NAM_HUMAN_CMD;
	
	/**
	 * 
	 */
	public static final int		LEN_CODE			= 10;
	/**
	 * 
	 */
	public static final int		LEN_NAME			= 10;
	/**
	 * 
	 */
	public static final String	REG_DELETE			= CommonConst.REG_DELETE;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltManage;
	/**
	 * 
	 */
	public String[][]			aryPltCmdItem;
	/**
	 * 
	 */
	public String[][]			arySelectedCmdItem;
	
	// \[gL[
	/**
	 * keyCompCode
	 */
	public final String			KEY_COMP_CODE		= "keyCompCode";
	/**
	 * keyCompName
	 */
	public final String			KEY_COMP_NAME		= "keyCompName";
	/**
	 * keyManage
	 */
	public final String			KEY_MANAGE			= "keyManage";
	/**
	 * keyComponent
	 */
	public final String			KEY_COMPONENT		= "keyComponent";
	/**
	 * keyDelete
	 */
	public final String			KEY_DELETE			= "keyDelete";
	

	/**
	 * RXgN^
	 */
	public MosPMenuArrangeVo() {
		super();
		txtCompCode = "";
		txtCompName = "";
		hidDivision = "";
		pltManage = "";
		pltSelected = new String[0];
		pltDelete = "";
		aryCompCode = new String[0];
		aryCompName = new String[0];
		aryManage = new String[0];
		aryComponent = new String[0];
		aryDelete = new String[0];
		mode = MODE_INSERT;
		searchmode = SEARCH_OFF;
	}
	
	@Override
	protected void setFieldsName() {
		NAM_COMP_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_COMP_NAME = CommonConst.NAM_COMMON_MEISYO;
		NAM_MANAGE = CommonConst.NAM_MANAGE;
		NAM_COMPONENT = CommonConst.NAM_COMPONENT;
		NAM_PLT_SELECTED = CommonConst.NAM_PLT_SELECTED;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		NAM_EMPLOYEE_CMD = CommonConst.NAM_EMPLOYEE_CMD;
		NAM_MANAGER_CMD = CommonConst.NAM_MANAGER_CMD;
		NAM_PAYROLL_CMD = CommonConst.NAM_PAYROLL_CMD;
		NAM_HUMAN_CMD = CommonConst.NAM_HUMAN_CMD;
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setCardParams(HttpServletRequest request) {
		txtCompCode = request.getParameter(PRM_TXT_COMP_CODE);
		txtCompName = request.getParameter(PRM_TXT_COMP_NAME);
		pltManage = request.getParameter(PRM_PLT_MANAGE);
		pltSelected = request.getParameterValues(PRM_PLT_SELECTED);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setListParams(HttpServletRequest request) {
		txtCompCode = request.getParameter(PRM_TXT_COMP_CODE);
		txtCompName = request.getParameter(PRM_TXT_COMP_NAME);
		pltManage = request.getParameter(PRM_PLT_MANAGE);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(CmComponentDto dto) {
		txtCompCode = dto.getCompCode();
		txtCompName = dto.getCompName();
		pltManage = String.valueOf(dto.getManage());
		pltSelected = StringUtil.divideByComma(dto.getComponent());
		pltDelete = String.valueOf(dto.getDeleteFlag());
	}
	
	@Override
	public void setFields(List<?> list) {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		aryCompCode = new String[count];
		aryCompName = new String[count];
		aryManage = new String[count];
		aryComponent = new String[count];
		aryDelete = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = list.iterator();
		while (it.hasNext()) {
			CmComponentDto dto = (CmComponentDto)it.next();
			aryCompCode[i] = escapeHTML(dto.getCompCode());
			aryCompName[i] = escapeHTML(dto.getCompName());
			aryManage[i] = escapeHTML(getCodeName(String.valueOf(dto.getManage()), aryPltManage));
			aryComponent[i] = escapeHTML(getCmdNameList(dto.getComponent(), aryPltCmdItem));
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			}
			i++;
		}
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmComponentDto dto) {
		dto.setDivision(hidDivision);
		dto.setCompCode(txtCompCode);
		dto.setCompName(txtCompName);
		dto.setManage(Integer.parseInt(pltManage));
		dto.setComponent(StringUtil.combineByComma(pltSelected));
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException 	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtCompCode, NAM_COMP_CODE, PRM_TXT_COMP_CODE);
		checkRequired(txtCompName, NAM_COMP_NAME, PRM_TXT_COMP_NAME);
		// 񒷊mF
		checkLength(txtCompCode, LEN_CODE, NAM_COMP_CODE, PRM_TXT_COMP_CODE);
		checkLength(txtCompName, LEN_NAME, NAM_COMP_NAME, PRM_TXT_COMP_NAME);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append("var DEFAULT_CODE = \"");
		sb.append(hidDivision);
		sb.append("\";");
		if (mode == MODE_UPDATE) {
			sb.append(getArrayJs("ARY_SELECTED", arySelectedCmdItem));
		}
		return sb.toString();
	}
	
	/**
	 * R}ḧꗗ
	 * @param component			ΏۃR}hꗗ
	 * @param aryPltCmdItem		ΏۃR}hz
	 * @return R}ḧꗗ
	 */
	protected String getCmdNameList(String component, String[][] aryPltCmdItem) {
		String[] aryCmd = StringUtil.divideByComma(component);
		StringBuffer sb = new StringBuffer();
		for (int j = 0; j < aryCmd.length; j++) {
			sb.append(getCodeName(aryCmd[j], aryPltCmdItem));
			if (j != aryCmd.length - 1) {
				sb.append(CommonConst.STR_UNDER_SEPARATOR);
			}
		}
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return pltSelected
	 */
	public String[] getPltSelected() {
		return pltSelected == null ? new String[0] : pltSelected.clone();
	}
	
	/**
	 * @return txtCompCode
	 */
	public String getEscTxtCompCode() {
		return escapeHTML(txtCompCode);
	}
	
	/**
	 * @return txtCompName
	 */
	public String getEscTxtCompName() {
		return escapeHTML(txtCompName);
	}
	
	/**
	 * @return txtCompCode
	 */
	public String getTxtCompCode() {
		return txtCompCode;
	}
	
	/**
	 * @return txtCompName
	 */
	public String getTxtCompName() {
		return txtCompName;
	}
	
	/**
	 * @return hidDivision
	 */
	public String getHidDivision() {
		return hidDivision;
	}
	
	/**
	 * @return pltManage
	 */
	public String getPltManage() {
		return pltManage;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @return aryCompCode
	 */
	public String[] getAryCompCode() {
		return aryCompCode.clone();
	}
	
	/**
	 * @return aryCompName
	 */
	public String[] getAryCompName() {
		return aryCompName.clone();
	}
	
	/**
	 * @return aryManage
	 */
	public String[] getAryManage() {
		return aryManage.clone();
	}
	
	/**
	 * @return aryComponent
	 */
	public String[] getAryComponent() {
		return aryComponent.clone();
	}
	
	/**
	 * @return aryDelete
	 */
	public String[] getAryDelete() {
		return aryDelete.clone();
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param txtCompCode Zbg txtCompCode
	 */
	public void setTxtCompCode(String txtCompCode) {
		this.txtCompCode = txtCompCode;
	}
	
	/**
	 * @param txtCompName Zbg txtCompName
	 */
	public void setTxtCompName(String txtCompName) {
		this.txtCompName = txtCompName;
	}
	
	/**
	 * @param hidDivision Zbg hidDivision
	 */
	public void setHidDivision(String hidDivision) {
		this.hidDivision = hidDivision;
	}
	
	/**
	 * @param pltManage Zbg pltManage
	 */
	public void setPltManage(String pltManage) {
		this.pltManage = pltManage;
	}
	
	/**
	 * @param pltSelected Zbg pltSelected
	 */
	public void setPltSelected(String[] pltSelected) {
		this.pltSelected = pltSelected.clone();
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}
	
	/**
	 * @param aryCompCode Zbg aryCompCode
	 */
	public void setAryCompCode(String[] aryCompCode) {
		this.aryCompCode = aryCompCode.clone();
	}
	
	/**
	 * @param aryCompName Zbg aryCompName
	 */
	public void setAryCompName(String[] aryCompName) {
		this.aryCompName = aryCompName.clone();
	}
	
	/**
	 * @param aryManage Zbg aryManage
	 */
	public void setAryManage(String[] aryManage) {
		this.aryManage = aryManage.clone();
	}
	
	/**
	 * @param aryComponent Zbg aryComponent
	 */
	public void setAryComponent(String[] aryComponent) {
		this.aryComponent = aryComponent.clone();
	}
	
	/**
	 * @param aryDelete Zbg aryDelete
	 */
	public void setAryDelete(String[] aryDelete) {
		this.aryDelete = aryDelete.clone();
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
