/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.dto.KintaiCommonDtoInterface;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.dto.CmWorkTypeDto;
import jp.mosp.kintai.kintai.dao.MSyukkinboDao;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.schedule.dao.MScheduleDao;
import jp.mosp.kintai.schedule.dto.MScheduleDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.mospcommon.system.AgreementBaseInfo;

/**
 * ΑӂɊւPartNX
 * @author yoshida
 * 	@version	0.0.17
 */
public class KintaiCommonPart extends KintaiBasePart {
	
	/**
	 * M_SYUKKINBO
	 */
	public static final String	SYUKKINBO_TABLE	= MSyukkinboDao.TABLE;
	

	/**
	 * RXgN^
	 */
	public KintaiCommonPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public KintaiCommonPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * MScheduleDaoCX^X
	 */
	private MScheduleDao	scheduleDao;
	

	/**
	 * ςݗ\pDAO擾
	 * @return	ςMScheduleDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public MScheduleDao getMScheduleDao() throws Exception {
		if (VariousUtil.isNull(scheduleDao)) {
			scheduleDao = (MScheduleDao)getPreparedDao(MScheduleDao.class.getCanonicalName());
		}
		return scheduleDao;
	}
	

	/**
	 * MSyukkinboDaoCX^X
	 */
	private MSyukkinboDao	syukkinboDao;
	

	/**
	 * ςݏoΕpDAO擾
	 * @return	ςMSyukkinboDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public MSyukkinboDao getMSyukkinboDao() throws Exception {
		if (VariousUtil.isNull(syukkinboDao)) {
			syukkinboDao = (MSyukkinboDao)getPreparedDao(MSyukkinboDao.class.getCanonicalName());
		}
		return syukkinboDao;
	}
	
	/**
	 * xof
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param code		Ώې\
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isWorkOnHoliday(String code) {
		return CommonConst.NUM_WORK_ON_HOLIDAY_FLAG_ON.equals(code);
	}
	
	/**
	 * Oxf
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param code		Ώې\
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isStartHalfHoliday(String code) {
		return CommonConst.NUM_START_HALF_HOLIDAY_FLAG_ON.equals(code);
	}
	
	/**
	 * 㔼xf
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param code		Ώې\
	 * @return
	 * <p>
	 * xΖȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isQuitHalfHoliday(String code) {
		return CommonConst.NUM_QUIT_HALF_HOLIDAY_FLAG_ON.equals(code);
	}
	
	/**
	 * xɁALxftO
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param kinmu			ΏۋΖ`ԃR[h
	 * @return
	 * <p>
	 * xɁALxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isHoliday(String kinmu) {
		return CommonConst.ATTENDANCE_TYPE_HOLIDAY.equals(kinmu);
	}
	
	/**
	 * TxftO
	 * <p>	2009/06/24	m.yoshida	ǉ	</p>
	 * @param kinmu			ΏۋΖ`ԃR[h
	 * @return
	 * <p>
	 * TxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isWeekHoliday(String kinmu) {
		return CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY.equals(kinmu);
	}
	
	/**
	 * xof
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * xo΂ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isWorkOnHoliday(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isWorkOnHoliday(dto.getKyusyuKb());
		}
		return false;
	}
	
	/**
	 * Oxf
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * OxȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isStartHalfHoliday(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isStartHalfHoliday(dto.getSHankyuKb());
		}
		return false;
	}
	
	/**
	 * 㔼xf
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * 㔼xȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isQuitHalfHoliday(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isQuitHalfHoliday(dto.getTHankyuKb());
		}
		return false;
	}
	
	/**
	 * xɁALxftO
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * o΁E\낪xɁALxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isHoliday(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isHoliday(dto.getKinmu());
		}
		return false;
	}
	
	/**
	 * TxftO
	 * <p>	2009/06/24	m.yoshida	ǉ		</p>
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * o΁E\낪TxꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isWeekHoliday(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isWeekHoliday(dto.getKinmu());
		}
		return false;
	}
	
	/**
	 * Ζ\ftO
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param dto			ΏDTO
	 * @return
	 * <p>
	 * Ζ\ȋΖ`Ԃ̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAvailableWorkType(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return !isHoliday(dto) && !isWeekHoliday(dto) && !isOfficialHoliday(dto);
		}
		return false;
	}
	
	/**
	 * [鎞ԊJn
	 * @return	[鎞ԊJnij
	 * @throws Exception	Oꍇ
	 */
	public int getLateNightStart() throws Exception {
		// M_CODEl擾
		String conf = part().mospcode().findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_LATE_NIGHT);
		return TimeUtil.convStringTimeToIntegerTime(conf.split(CommonConst.STR_SLASH_SEPARATOR)[0]);
	}
	
	/**
	 * [鎞ԏI
	 * @return	[鎞ԏIij
	 * @throws Exception	Oꍇ
	 */
	public int getLateNightEnd() throws Exception {
		// M_CODEl擾
		String conf = part().mospcode().findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_LATE_NIGHT);
		return TimeUtil.convStringTimeToIntegerTime(conf.split(CommonConst.STR_SLASH_SEPARATOR)[1]);
	}
	
	/**
	 * xɎԎ擾
	 * @return	xɎԁij
	 * @throws Exception	Oꍇ
	 */
	public int getAllHolidayTimes() throws Exception {
		String conf = part().mospcode().findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_HOLIDAY_HOURS);
		return TimeUtil.convStringTimeToIntegerTime(conf.split(CommonConst.STR_SLASH_SEPARATOR)[0]);
	}
	
	/**
	 * xɎԎ擾
	 * @return	xɎԁij
	 * @throws Exception	Oꍇ
	 */
	public int getHalfHolidayTimes() throws Exception {
		String conf = part().mospcode().findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_HOLIDAY_HOURS);
		return TimeUtil.convStringTimeToIntegerTime(conf.split(CommonConst.STR_SLASH_SEPARATOR)[1]);
	}
	
	/**
	 * o^PʎԎ擾
	 * @return	o^Pʎԁij
	 * @throws Exception	Oꍇ
	 */
	public int getInputUnitTimes() throws Exception {
		return NumberUtil.getIntParam(part().mospcode().findTchange(CommonConst.TID_INPUT_UNIT_TIMES,
				CommonConst.TCD_MINUTES));
	}
	
	/**
	 * vZtO擾
	 * @return	vZtO
	 * @throws Exception	Oꍇ
	 */
	public boolean isAutoCalc() throws Exception {
		String autoCalc = part().mospcode().findTchange(CommonConst.TID_WORK_SYSTEM,
				CommonConst.TCD_AUTOMATIC_CALCULATION);
		if (String.valueOf(MospConst.DELETE_FLAG_OFF).equals(autoCalc)) {
			return true;
		}
		return false;
	}
	
	/**
	 * Αӓ͎vZtO擾B
	 * @since 0.0.16
	 * @return Αӓ͎vZtO
	 * @throws Exception	Oꍇ
	 */
	public boolean isDailyAutoCalc() throws Exception {
		return isAutoCalc()
				&& StringUtil.isFlagOff(part().mospcode().findTchange(CommonConst.TID_WORK_SYSTEM,
						CommonConst.TCD_CALCULATION_PROCESS));
	}
	
	/**
	 * ΑӏWvvZtO擾B
	 * @return ΑӏWvvZtO
	 * @throws Exception 	Oꍇ
	 */
	public boolean isMonthlyAutoCalc() throws Exception {
		return isAutoCalc()
				&& StringUtil.isFlagOn(part().mospcode().findTchange(CommonConst.TID_WORK_SYSTEM,
						CommonConst.TCD_CALCULATION_PROCESS));
	}
	
	/**
	 * ֋xftO
	 * @since	0.0.2
	 * @param kinmu				ΏۋΖ`ԃR[h
	 * @param kkRiyuu			ΏۋxɗRR[h
	 * @return
	 * <p>
	 * Ζ`ԃR[hƋxɗRR[h֋xꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isCompensationHoliday(String kinmu, String kkRiyuu) {
		if (isHoliday(kinmu) && CommonConst.CODE_HOLIDAY_REASON_COMPENSATION.equals(kkRiyuu)) {
			return true;
		}
		return false;
	}
	
	/**
	 * ֋xftO
	 * @since	0.0.2
	 * @param dto				ΏDTO
	 * @return
	 * <p>
	 * Ζ`ԃR[hƋxɗRR[h֋xꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isCompensationHoliday(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isCompensationHoliday(dto.getKinmu(), dto.getKKRiyuu());
		}
		return false;
	}
	
	/**
	 * ԊOx(S)f
	 * @param dto	ΏDTO
	 * @return
	 * <p>
	 * Ζ`ԃR[hƋxɗRR[hԊOx(S)ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isSubstituteAll(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto) && isHoliday(dto)) {
			return CommonConst.CODE_SUB_HOLIDAY_REQUEST.equals(dto.getKKRiyuu());
		}
		return false;
	}
	
	/**
	 * LxftO
	 * @since	0.0.2
	 * @param kinmu					ΏۋΖ`ԃR[h
	 * @param kkRiyuu				ΏۋxɗRR[h
	 * @return
	 * <p>
	 * Ζ`ԃR[hƋxɗRR[hLxxɂꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAllHoliday(String kinmu, String kkRiyuu) {
		if (isHoliday(kinmu) && PaidHolidayPart.isPaidHoliday(kkRiyuu)) {
			return true;
		}
		return false;
	}
	
	/**
	 * LxftO
	 * @since	0.0.2
	 * @param dto				ΏDTO
	 * @return
	 * <p>
	 * Ζ`ԃR[hƋxɗRR[hLxxɂꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAllHoliday(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isAllHoliday(dto.getKinmu(), dto.getKKRiyuu());
		}
		return false;
	}
	
	/**
	 * oΕp̃Rs[ݒ
	 * <p>	2009/07/01	m.yoshida	ǉ	</p>
	 * @since	0.0.2
	 * @param dto Ώۗ\AoΕDTO
	 * @return mSyukkinboDto MSyukkinboDto
	 */
	public static MSyukkinboDto copyToSyukkinbo(KintaiCommonDtoInterface dto) {
		MSyukkinboDto mSyukkinboDto = new MSyukkinboDto();
		mSyukkinboDto.setKCode(dto.getKCode());
		mSyukkinboDto.setHizuke(dto.getHizuke());
		mSyukkinboDto.setNen(dto.getNen());
		mSyukkinboDto.setTuki(dto.getTuki());
		mSyukkinboDto.setHi(dto.getHi());
		mSyukkinboDto.setSyozoku(dto.getSyozoku());
		mSyukkinboDto.setNinsyo(dto.getNinsyo());
		mSyukkinboDto.setSyJikoku(dto.getSyJikoku());
		mSyukkinboDto.setKinmu(dto.getKinmu());
		mSyukkinboDto.setSHankyuKb(dto.getSHankyuKb());
		mSyukkinboDto.setKyusyuKb(dto.getKyusyuKb());
		mSyukkinboDto.setTiRiyuu(dto.getTiRiyuu());
		mSyukkinboDto.setTiComent(dto.getTiComent());
		mSyukkinboDto.setTiSyoumei(dto.getTiSyoumei());
		mSyukkinboDto.setTiJikan(dto.getTiJikan());
		mSyukkinboDto.setSyTimes(dto.getSyTimes());
		mSyukkinboDto.setTaJikoku(dto.getTaJikoku());
		mSyukkinboDto.setKinmuJi(dto.getKinmuJi());
		mSyukkinboDto.setKyukeiJi(dto.getKyukeiJi());
		mSyukkinboDto.setTHankyuKb(dto.getTHankyuKb());
		mSyukkinboDto.setSoRiyuu(dto.getSoRiyuu());
		mSyukkinboDto.setSoComent(dto.getSoComent());
		mSyukkinboDto.setSoSyoumei(dto.getSoSyoumei());
		mSyukkinboDto.setSoJikan(dto.getSoJikan());
		mSyukkinboDto.setZaJikan(dto.getZaJikan());
		mSyukkinboDto.setKsJikan(dto.getKsJikan());
		mSyukkinboDto.setSnJikan(dto.getSnJikan());
		mSyukkinboDto.setSyokuji(dto.getSyokuji());
		mSyukkinboDto.setCyoku1(dto.getCyoku1());
		mSyukkinboDto.setCyoku2(dto.getCyoku2());
		mSyukkinboDto.setCyoku3(dto.getCyoku3());
		mSyukkinboDto.setHoka1(dto.getHoka1());
		mSyukkinboDto.setHoka2(dto.getHoka2());
		mSyukkinboDto.setHoka3(dto.getHoka3());
		mSyukkinboDto.setHoka4(dto.getHoka4());
		mSyukkinboDto.setHoka5(dto.getHoka5());
		mSyukkinboDto.setTaTimes(dto.getTaTimes());
		mSyukkinboDto.setKKRiyuu(dto.getKKRiyuu());
		mSyukkinboDto.setDaiKyuJyu(dto.getDaiKyuJyu());
		mSyukkinboDto.setKKComent(dto.getKKComent());
		mSyukkinboDto.setKKSyoumei(dto.getKKSyoumei());
		mSyukkinboDto.setKKJikan(dto.getKKJikan());
		mSyukkinboDto.setKKTimes(dto.getKKTimes());
		mSyukkinboDto.setSnRiyuu(dto.getSnRiyuu());
		mSyukkinboDto.setSnComent(dto.getSnComent());
		mSyukkinboDto.setSnTimes(dto.getSnTimes());
		mSyukkinboDto.setUpdtTimes(dto.getUpdtTimes());
		mSyukkinboDto.setNijiKyu(dto.getNijiKyu());
		mSyukkinboDto.setWarimasi1(dto.getWarimasi1());
		mSyukkinboDto.setZKinmu(dto.getZKinmu());
		return mSyukkinboDto;
	}
	
	/**
	 * ȅ
	 * @since	0.0.15
	 * @param dto	ΏDTO
	 */
	public static void initKintaiInfo(KintaiCommonDtoInterface dto) {
		dto.setNinsyo("");
		dto.setSyJikoku("");
		dto.setKinmu("");
		dto.setSHankyuKb("");
		dto.setKyusyuKb("");
		dto.setTiRiyuu("");
		dto.setTiComent("");
		dto.setTiSyoumei("");
		dto.setTiJikan(0);
		dto.setSyTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
		dto.setTaJikoku("");
		dto.setKinmuJi(0);
		dto.setKyukeiJi(0);
		dto.setTHankyuKb("");
		dto.setSoRiyuu("");
		dto.setSoComent("");
		dto.setSoSyoumei("");
		dto.setSoJikan(0);
		dto.setZaJikan(0);
		dto.setKsJikan(0);
		dto.setSnJikan(0);
		dto.setSyokuji(0);
		dto.setCyoku1(0);
		dto.setCyoku2(0);
		dto.setCyoku3(0);
		dto.setHoka1(0);
		dto.setHoka2(0);
		dto.setHoka3(0);
		dto.setHoka4(0);
		dto.setHoka5(0);
		dto.setTaTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
		dto.setKKRiyuu("");
		dto.setDaiKyuJyu("");
		dto.setKKComent("");
		dto.setKKSyoumei("");
		dto.setKKJikan(0);
		dto.setKKTimes("");
		dto.setSnRiyuu("");
		dto.setSnComent("");
		dto.setSnTimes("");
		dto.setUpdtTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
		dto.setNijiKyu(0);
		dto.setWarimasi1(0);
		dto.setZKinmu("");
	}
	
	/**
	 * oΕꗗ
	 * @since	0.0.3
	 * @param kCode			ΏێЈR[h
	 * @param startDate		ΏۊJn(yyyy/MM/dd)
	 * @param endDate		ΏۏI(yyyy/MM/dd)
	 * @return List (DTOList)
	 * @throws Exception	Oꍇ
	 */
	public List<MSyukkinboDto> getAttendanceList(String kCode, String startDate, String endDate) throws Exception {
		return getMSyukkinboDao().findForAttendanceList(kCode, startDate, endDate);
	}
	
	/**
	 * oΕꗗ
	 * @since	0.0.17
	 * @param kCode			ΏێЈR[h
	 * @param startDate		ΏۊJn
	 * @param endDate		ΏۏI
	 * @return List (DTOList)
	 * @throws Exception	Oꍇ
	 */
	public List<MSyukkinboDto> getAttendanceList(String kCode, Date startDate, Date endDate) throws Exception {
		return getAttendanceList(kCode, DateUtil.convDateFormatted(startDate), DateUtil.convDateFormatted(endDate));
	}
	
	/**
	 * \ꗗ
	 * @since	0.0.3
	 * @param kCode			ΏێЈR[h
	 * @param startDate		ΏۊJn(yyyy/MM/dd)
	 * @param endDate		ΏۏI(yyyy/MM/dd)
	 * @return List (DTOList)
	 * @throws Exception	Oꍇ
	 */
	public List<MScheduleDto> getScheduleList(String kCode, String startDate, String endDate) throws Exception {
		return getMScheduleDao().findForScheduleList(kCode, startDate, endDate);
	}
	
	/**
	 * \ꗗ
	 * @since	0.0.17
	 * @param kCode			ΏێЈR[h
	 * @param startDate		ΏۊJn
	 * @param endDate		ΏۏI
	 * @return List (DTOList)
	 * @throws Exception	Oꍇ
	 */
	public List<MScheduleDto> getScheduleList(String kCode, Date startDate, Date endDate) throws Exception {
		return getScheduleList(kCode, DateUtil.convDateFormatted(startDate), DateUtil.convDateFormatted(endDate));
	}
	
	/**
	 * ΖJn擾
	 * @since	0.0.4
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * ΖJni0̌oߕjB<br>
	 * ĂȂꍇ́A0:00
	 * <p>
	 */
	public static int getWorkStartTime(KintaiCommonDtoInterface dto) {
		return TimeUtil.convStringTimeToIntegerTime(dto.getSyJikoku());
	}
	
	/**
	 * ΖI擾
	 * @since	0.0.4
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * ΖIi0̌oߕjB<br>
	 * ĂȂꍇ́A0:00
	 * <p>
	 */
	public static int getWorkQuitTime(KintaiCommonDtoInterface dto) {
		return TimeUtil.convStringTimeToIntegerTime(dto.getTaJikoku());
	}
	
	/**
	 * xf
	 * @since	0.0.5
	 * @param dto	ΏDTO
	 * @return
	 * <p>
	 * Ox܂͌㔼xȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isHalfHoliday(KintaiCommonDtoInterface dto) {
		return isStartHalfHoliday(dto) || isQuitHalfHoliday(dto);
	}
	
	/**
	 * ΑӌvZ@Ăяo
	 * @since	0.0.6
	 * @param shiftCode		ΏۋΖ`ԃR[h
	 * @return	ΑӌvZ@CX^X
	 * @throws Exception 	O
	 */
	public KintaiCalcPart getCalculator(String shiftCode) throws Exception {
		CmWorkTypeDto dto = part().worktype().getWorkTypeInfo(shiftCode);
		if (VariousUtil.isNull(dto)) {
			throw new NullPointerException();
		}
		// ΑӌvZ
		KintaiCalcPart calc = new KintaiCalcPart();
		// ΏۋΖ`ԏݒ
		calc.setWorkTypeInfo(dto.getStartTime(), dto.getQuitTime(), dto.getWorkTime(), dto.getBreakTime());
		// [鎞ԏݒ
		calc.setLateNightInfo(getLateNightStart(), getLateNightStart() + getLateNightEnd());
		// x
		calc.setHalfHoliday(getHalfHolidayTimes());
		// @Jԁi8ԁj
		calc.setLegalHours(LegalConst.LEGAL_HOURS_PER_DAY * CommonConst.NUM_1HOUR_MIN);
		// ͒P
		calc.setInputUnit(getInputUnitTimes());
		// cƋxeݒ
		calc.setOverTimeIntervalInfo(getBeforeOverTimeInterval(), getOverTimeUnitTime(), getOverTimeInterval());
		// Αӓ͎ۂߏ
		calc.setUseRoundNumber(isRoundNumberDaily());
		return calc;
	}
	
	/**
	 * o΍ڌvZ
	 * @since	0.0.6
	 * @param dto			ΏۏoΕDTO
	 * @throws Exception	Oꍇ
	 */
	public void runStartCalculate(KintaiCommonDtoInterface dto) throws Exception {
		// ΑӌvZ@擾
		KintaiCalcPart calc = getCalculator(dto.getKinmu());
		// o΍ڂ̌vZ
		calc.runCalcStartTime(getWorkStartTime(dto), isStartHalfHoliday(dto), isWorkOnHoliday(dto));
		// xԃZbg
		dto.setTiJikan(calc.getLateTime());
	}
	
	/**
	 * ΑӍڌvZ
	 * @since	0.0.6
	 * @param dto		ΏDTO
	 * @throws Exception	Oꍇ
	 */
	public void runCalculatedInfo(KintaiCommonDtoInterface dto) throws Exception {
		// ΑӌvZ@擾
		KintaiCalcPart calc = getCalculator(dto.getKinmu());
		Date targetDate = DateUtil.convStringDateToDate(dto.getHizuke());
		// eڂ̌vZ
		calc.runCalculate(
		// oΎZo
				getWorkStartTime(dto),
				// ދΎZo
				getWorkQuitTime(dto),
				// oΔx
				isStartHalfHoliday(dto) || isOverTimeSubHolidayStart(dto),
				// ދΔx
				isQuitHalfHoliday(dto) || isOverTimeSubHolidayQuit(dto),
				// xof
				isWorkOnHoliday(dto));
		// x
		dto.setTiJikan(calc.getLateTime());
		// Ζ
		dto.setKinmuJi(calc.getWorkTime());
		// ގ
		dto.setSoJikan(calc.getLeaveTime());
		// xe
		dto.setKyukeiJi(calc.getIntervalTime());
		// [鎞
		dto.setSnJikan(calc.getLateNightTime());
		// xo
		int workOnHolidayTime = 0;
		// cƎ
		int overTime = calc.getOverTime();
		// xΖ̏ꍇ
		if (isWorkOnHoliday(dto)) {
			// Jg擾
			AgreementBaseInfo agreement = part().laborAgreement().getUserLaborAgreement(dto.getKCode(), targetDate);
			if (VariousUtil.isNotNull(agreement)) {
				// x̏ꍇAׂĎcƎԂƂĈ
				if (part().laborAgreement().isStandardHoliday(targetDate, agreement)) {
					overTime = calc.getHolidayWorkTime();
				}
				// @x̏ꍇAׂċxoԂƂĈ
				if (LaborAgreementPart.isOfficialHoliday(targetDate, agreement)) {
					workOnHolidayTime = calc.getHolidayWorkTime();
				}
			} else {
				// Jg肪ꍇA]ʂ
				workOnHolidayTime = calc.getHolidayWorkTime();
			}
		}
		// cƎ
		dto.setZaJikan(overTime);
		// xo
		dto.setKsJikan(workOnHolidayTime);
	}
	
	/**
	 * cƊJnOxe
	 * @since	0.0.7
	 * @return	cƊJnOxeԁij
	 * @throws Exception	Oꍇ
	 */
	public int getBeforeOverTimeInterval() throws Exception {
		return NumberUtil.getIntParam(part().mospcode().findTchange(CommonConst.TID_OVER_TIME_INTERVAL,
				CommonConst.TCD_BEFORE_OVER_TIME_INTERVAL_TIME));
	}
	
	/**
	 * cƋxexΏےPʎ
	 * @since	0.0.7
	 * @return	cƋxexΏےPʎԁij
	 * @throws Exception	Oꍇ
	 */
	public int getOverTimeUnitTime() throws Exception {
		return NumberUtil.getIntParam(part().mospcode().findTchange(CommonConst.TID_OVER_TIME_INTERVAL,
				CommonConst.TCD_OVER_TIME_UNIT_TIME));
	}
	
	/**
	 * cƋxe
	 * @since	0.0.7
	 * @return	cƋxexΏےPʎԖɎxcƋxeԁij
	 * @throws Exception	Oꍇ
	 */
	public int getOverTimeInterval() throws Exception {
		return NumberUtil.getIntParam(part().mospcode().findTchange(CommonConst.TID_OVER_TIME_INTERVAL,
				CommonConst.TCD_OVER_TIME_INTERVAL_TIME));
	}
	
	/**
	 * boΕ񐶐
	 * @since	0.0.8
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return	boΕDTO
	 * <p>
	 * ЈR[hAtANAÂ݃Zbg
	 * </p>
	 */
	public static MSyukkinboDto createBaseSyukkinboInfo(String kCode, Date targetDate) {
		MSyukkinboDto dto = new MSyukkinboDto();
		dto.setKCode(kCode);
		dto.setHizuke(DateUtil.convDateFormatted(targetDate));
		dto.setNen(MospUtility.getYear(targetDate));
		dto.setTuki(MospUtility.getMonth(targetDate));
		dto.setHi(MospUtility.getDay(targetDate));
		return dto;
	}
	
	/**
	 * oΕΏۓ擾
	 * @since	0.0.9
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @return dto ΏDTO
	 * @throws Exception	Oꍇ
	 */
	public MSyukkinboDto getSyukkinboInfo(String kCode, String targetDate) throws Exception {
		return getMSyukkinboDao().findForKey(kCode, targetDate);
	}
	
	/**
	 * oΕΏۓ擾
	 * @since	0.0.9
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return dto ΏDTO
	 * @throws Exception	Oꍇ
	 */
	public MSyukkinboDto getSyukkinboInfo(String kCode, Date targetDate) throws Exception {
		return getSyukkinboInfo(kCode, DateUtil.convDateFormatted(targetDate));
	}
	
	/**
	 * oΕΏۓsbN
	 * @since	0.0.9
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @return 				ΏDTO(sbNς)
	 * @throws Exception	Oꍇ
	 */
	public MSyukkinboDto lockSyukkinboInfo(String kCode, String targetDate) throws Exception {
		return getMSyukkinboDao().findForUpdate(kCode, targetDate);
	}
	
	/**
	 * oΕΏۓsbN
	 * @since	0.0.9
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return 				ΏDTO(sbNς)
	 * @throws Exception	Oꍇ
	 */
	public MSyukkinboDto lockSyukkinboInfo(String kCode, Date targetDate) throws Exception {
		return lockSyukkinboInfo(kCode, DateUtil.convDateFormatted(targetDate));
	}
	
	/**
	 * ΏۓoΕ擾
	 * @since	0.0.9
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @param isUpdate		sbNtO
	 * @return	ΏDTO
	 * @throws Exception	Oꍇ
	 */
	public MSyukkinboDto getSyukkinboInfo(String kCode, String targetDate, boolean isUpdate) throws Exception {
		if (isUpdate) {
			return lockSyukkinboInfo(kCode, targetDate);
		}
		return getSyukkinboInfo(kCode, targetDate);
	}
	
	/**
	 * ΏۓoΕ擾
	 * @since	0.0.9
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @param isUpdate		sbNtO
	 * @return	ΏDTO
	 * @throws Exception	Oꍇ
	 */
	public MSyukkinboDto getSyukkinboInfo(String kCode, Date targetDate, boolean isUpdate) throws Exception {
		return getSyukkinboInfo(kCode, DateUtil.convDateFormatted(targetDate), isUpdate);
	}
	
	/**
	 * \Ώۓ擾
	 * @since	0.0.9
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @return dto ΏDTO
	 * @throws Exception	Oꍇ
	 */
	public MScheduleDto getScheduleInfo(String kCode, String targetDate) throws Exception {
		return getMScheduleDao().findForKey(kCode, targetDate);
	}
	
	/**
	 * \Ώۓ擾
	 * @since	0.0.9
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return dto ΏDTO
	 * @throws Exception	Oꍇ
	 */
	public MScheduleDto getScheduleInfo(String kCode, Date targetDate) throws Exception {
		return getScheduleInfo(kCode, DateUtil.convDateFormatted(targetDate));
	}
	
	/**
	 * \ΏۓsbN
	 * @since	0.0.9
	 * <p>	2009/04/21	m.yoshida	ǉ	</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @return				ΏDTO
	 * @throws Exception	Oꍇ
	 */
	public MScheduleDto lockScheduleInfo(String kCode, String targetDate) throws Exception {
		return getMScheduleDao().findForUpdate(kCode, targetDate);
	}
	
	/**
	 * \Ώۓ擾
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @param isUpdate 		sbNtO
	 * @return				ΏDTO
	 * @throws Exception	Oꍇ
	 */
	public MScheduleDto getScheduleInfo(String kCode, String targetDate, boolean isUpdate) throws Exception {
		if (isUpdate) {
			return lockScheduleInfo(kCode, targetDate);
		}
		return getScheduleInfo(kCode, targetDate);
	}
	
	/**
	 * \Ώۓ擾
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @param isUpdate 		sbNtO
	 * @return				ΏDTO
	 * @throws Exception	Oꍇ
	 */
	public MScheduleDto getScheduleInfo(String kCode, Date targetDate, boolean isUpdate) throws Exception {
		if (isUpdate) {
			return lockScheduleInfo(kCode, DateUtil.convDateFormatted(targetDate));
		}
		return getScheduleInfo(kCode, targetDate);
	}
	
	/**
	 * oΕ񐶐
	 * @since	0.0.10
	 * @param kCode				ΏێЈR[h
	 * @param targetDate		Ώ۔N
	 * @param startTime			Jn(HH:mm)
	 * @param quitTime			I(HH:mm)
	 * @param kinmu				Ζ`
	 * @param isStartHalf		oΔx敪
	 * @param isQuitHalf		ދΔx敪
	 * @param isWorkOnHoliday	xof
	 * @return	oΕ
	 */
	public static MSyukkinboDto createPreSyukkinboInfo(String kCode, Date targetDate, String startTime,
			String quitTime, String kinmu, boolean isStartHalf, boolean isQuitHalf, boolean isWorkOnHoliday) {
		// boΕ񐶐
		MSyukkinboDto dto = createBaseSyukkinboInfo(kCode, targetDate);
		// Ζ`
		dto.setKinmu(kinmu);
		// oΎ
		if (StringUtil.isNotNull(startTime)) {
			dto.setSyJikoku(startTime);
			dto.setSyTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
		}
		// ދΎ
		if (StringUtil.isNotNull(quitTime)) {
			dto.setTaJikoku(quitTime);
			dto.setTaTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
		}
		// oΔx
		if (isStartHalf) {
			dto.setSHankyuKb(CommonConst.NUM_START_HALF_HOLIDAY_FLAG_ON);
		}
		// ދΔx
		if (isQuitHalf) {
			dto.setTHankyuKb(CommonConst.NUM_QUIT_HALF_HOLIDAY_FLAG_ON);
		}
		// xof
		if (isWorkOnHoliday) {
			dto.setKyusyuKb(CommonConst.NUM_WORK_ON_HOLIDAY_FLAG_ON);
		}
		dto.setUpdtTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
		return dto;
	}
	
	/**
	 * \̐
	 * @since	0.0.11
	 * @param userBasis		ΏێЈ{
	 * @param targetDate	Ώ۔N
	 * @param shiftCode		ΏۋΖ`ԃR[h
	 * @return	\
	 * @throws Exception	Oꍇ
	 */
	public MScheduleDto createScheduleInfo(HumanBasisDtoInterface userBasis, Date targetDate, String shiftCode)
			throws Exception {
		MScheduleDto dto = new MScheduleDto();
		addWorkTypeInfo(dto, userBasis, targetDate, shiftCode);
		return dto;
	}
	
	/**
	 * Ζgяݒ
	 * @param dto ΏDTO
	 * @param userBasis		ΏێЈ{
	 * @param targetDate	Ώ۔N
	 * @param shiftCode		ΏۋΖ`ԃR[h
	 * @throws Exception 	Oꍇ
	 */
	public void addWorkTypeInfo(KintaiCommonDtoInterface dto, HumanBasisDtoInterface userBasis, Date targetDate,
			String shiftCode) throws Exception {
		if (VariousUtil.isNotNull(dto)) {
			dto.setKCode(userBasis.getKCode());
			dto.setHizuke(DateUtil.convDateFormatted(targetDate));
			dto.setNen(MospUtility.getYear(targetDate));
			dto.setTuki(MospUtility.getMonth(targetDate));
			dto.setHi(MospUtility.getDay(targetDate));
			dto.setSyozoku(userBasis.getSCode());
			dto.setUpdtTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
			dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
			if (StringUtil.isNotNull(shiftCode)) {
				// xɂ̏ꍇ
				if (isHoliday(shiftCode)) {
					dto.setKinmu(CommonConst.ATTENDANCE_TYPE_HOLIDAY);
				} else if (isWeekHoliday(shiftCode)) {
					// Tx̏ꍇ
					dto.setKinmu(CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
				} else if (isOfficialHoliday(shiftCode)) {
					// @xΉ
					dto.setKinmu(CommonConst.ATTENDANCE_TYPE_OFFICIAL_HOLIDAY);
				} else {
					CmWorkTypeDto workTypeDto = part().worktype().getWorkTypeInfo(shiftCode);
					dto.setKinmu(workTypeDto.getShiftCode());
					dto.setSyJikoku(TimeUtil.convIntegerTimeToStringTime(workTypeDto.getStartTime()));
					dto.setSyTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
					dto.setTaJikoku(TimeUtil.convIntegerTimeToStringTime(workTypeDto.getQuitTime()));
					dto.setKinmuJi(workTypeDto.getWorkTime());
					dto.setKyukeiJi(workTypeDto.getBreakTime());
					dto.setTaTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
				}
			}
		}
	}
	
	/**
	 * Ζ`Ԗ̎擾iTxAxɗR܂ށj
	 * @since	0.0.12
	 * @param dto	ΏDTO
	 * @param addTime	Ζ`Ԏ\f
	 * @return	Ζ`Ԗ
	 * @throws Exception	Oꍇ
	 */
	public String getWorkTypeNameForKinmu(KintaiCommonDtoInterface dto, boolean addTime) throws Exception {
		return getWorkTypeNameForKinmu(dto.getKinmu(), dto.getKKRiyuu(), addTime);
	}
	
	/**
	 * Ζ`Ԗ̎擾iTxAxɗR܂ށj
	 * @since	0.0.12
	 * @param kinmu		ΏۋΖ`ԃR[h
	 * @param kkRiyuu	ΏۋxɗRR[h
	 * @param addTime	Ζ`Ԏ\f
	 * @return	Ζ`Ԗ
	 * @throws Exception	Oꍇ
	 */
	public String getWorkTypeNameForKinmu(String kinmu, String kkRiyuu, boolean addTime) throws Exception {
		if (StringUtil.isNotNull(kinmu)) {
			// xɂ̏ꍇ
			if (isHoliday(kinmu)) {
				return part().mospcode().getHolidayName(kkRiyuu);
			}
			// Ζ`ԁAxA@x
			return part().worktype().getWorkTypeName(kinmu, addTime);
		}
		return kinmu;
	}
	
	/**
	 * R[h𖼏̂ɕϊ(Ζ`ԁAxo敪AxRAxؖAޗRAޏؖ)
	 * @since	0.0.13
	 * @param dto			ΏDTO
	 * @throws Exception	Oꍇ
	 */
	public void replaceCodeToName(KintaiCommonDtoInterface dto) throws Exception {
		// Ζ`
		dto.setKinmu(getWorkTypeNameForKinmu(dto, true));
		// xo敪
		dto.setKyusyuKb(part().mospcode().getTName(CommonConst.TID_WORK_ON_HOLIDAY_TYPE, dto.getKyusyuKb()));
		// xR
		dto.setTiRiyuu(part().mospcode().getTName(CommonConst.TID_LATE_REASON, dto.getTiRiyuu()));
		// xؖ
		dto.setTiSyoumei(part().mospcode().getTName(CommonConst.TID_LATE_CERTIFICATE, dto.getTiSyoumei()));
		// ޗR
		dto.setSoRiyuu(part().mospcode().getTName(CommonConst.TID_LEAVE_EARLY_REASON, dto.getSoRiyuu()));
		// ޏؖ
		dto.setSoSyoumei(part().mospcode().getTName(CommonConst.TID_LEAVE_EARLY_CERTIFICATE, dto.getSoSyoumei()));
	}
	
	/**
	 * jtHgFݒ
	 * @since	0.0.14
	 * @param targetDate	Ώ۔N
	 * @return	tHgF̃NX
	 * @throws Exception	Oꍇ
	 */
	public String getDayOfWeekColorClass(Date targetDate) throws Exception {
		String className = CommonConst.CSS_CLASS_NORMAL_SPAN;
		if (DateUtil.isDayOfWeek(targetDate, Calendar.SATURDAY)) {
			className = CommonConst.CSS_CLASS_BLUE_SPAN;
		}
		if (DateUtil.isDayOfWeek(targetDate, Calendar.SUNDAY) || part().jpholiday().isPublicHoliday(targetDate)) {
			className = CommonConst.CSS_CLASS_RED_SPAN;
		}
		return className;
	}
	
	/**
	 * Αӓ͊ۂߏf
	 * @return
	 * <p>
	 * ۂߏΑӓ͎ɍsꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception @Oꍇ
	 */
	public boolean isRoundNumberDaily() throws Exception {
		return StringUtil.isFlagOff(part().mospcode().getRoundNumberProcess());
	}
	
	/**
	 * ΑӏWvۂߏf
	 * @return
	 * <p>
	 * ۂߏΑӏWvɍsꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception@Oꍇ
	 */
	public boolean isRoundNumberMonthly() throws Exception {
		return StringUtil.isFlagOn(part().mospcode().getRoundNumberProcess());
	}
	
	/**
	 * @xf
	 * @param code ΏۃR[h
	 * @return
	 * <p>
	 * @x̃R[hłꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isOfficialHoliday(String code) {
		return CommonConst.ATTENDANCE_TYPE_OFFICIAL_HOLIDAY.equals(code);
	}
	
	/**
	 * @xf
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * @x̃R[hłꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isOfficialHoliday(KintaiCommonDtoInterface dto) {
		return isOfficialHoliday(dto.getKinmu());
	}
	
	/**
	 * 60ԎԊOɂxiSxj̔f
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * 60ԎԊOɂxiSxj̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isOverTimeSubHolidayAll(KintaiCommonDtoInterface dto) {
		if (isHoliday(dto)) {
			return HolidayRequestPart.isSubHoliday(dto.getKKRiyuu());
		}
		return false;
	}
	
	/**
	 * 60ԎԊOɂxiOxj̔f
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * 60ԎԊOɂxiOxj̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isOverTimeSubHolidayStart(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return CommonConst.CODE_SUB_HOLIDAY_HALF_FLAG.equals(dto.getSHankyuKb());
		}
		return false;
	}
	
	/**
	 * 60ԎԊOɂxi㔼xj̔f
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * 60ԎԊOɂxi㔼xj̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isOverTimeSubHolidayQuit(KintaiCommonDtoInterface dto) {
		if (VariousUtil.isNotNull(dto)) {
			return CommonConst.CODE_SUB_HOLIDAY_HALF_FLAG.equals(dto.getTHankyuKb());
		}
		return false;
	}
	
	/**
	 * 60ԎԊOɂxixj̔f
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * 60ԎԊOɂxixj̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isOverTimeSubHolidayHalf(KintaiCommonDtoInterface dto) {
		return isOverTimeSubHolidayStart(dto) || isOverTimeSubHolidayQuit(dto);
	}
	
	/**
	 * xɗR1f
	 * @param kkRiyuu ΏۋxɗRR[h
	 * @return
	 * <p>
	 * xɗRR[hu1v̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isParticularHoliday(String kkRiyuu) {
		return CommonConst.CODE_HOLIDAY_REASON_PARTICULAR.equals(kkRiyuu);
	}
	
	/**
	 * xɗR2f
	 * @param kkRiyuu ΏۋxɗRR[h
	 * @return
	 * <p>
	 * xɗRR[hu2v̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isAbsence(String kkRiyuu) {
		return CommonConst.CODE_HOLIDAY_REASON_ABSENCE.equals(kkRiyuu);
	}
	
	/**
	 * xɗR3f
	 * @param kkRiyuu ΏۋxɗRR[h
	 * @return
	 * <p>
	 * xɗRR[hu3v̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isMedical(String kkRiyuu) {
		return CommonConst.CODE_HOLIDAY_REASON_MEDICAL.equals(kkRiyuu);
	}
	
	/**
	 * xɗR4f
	 * @param kkRiyuu ΏۋxɗRR[h
	 * @return
	 * <p>
	 * xɗRR[hu4v̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isCompensation(String kkRiyuu) {
		return CommonConst.CODE_HOLIDAY_REASON_COMPENSATION.equals(kkRiyuu);
	}
	
	/**
	 * xɗR5f
	 * @param kkRiyuu ΏۋxɗRR[h
	 * @return
	 * <p>
	 * xɗRR[hu5v̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isTransfer(String kkRiyuu) {
		return CommonConst.CODE_HOLIDAY_REASON_TRANSFER.equals(kkRiyuu);
	}
	
	/**
	 * xɗR6f
	 * @param kkRiyuu ΏۋxɗRR[h
	 * @return
	 * <p>
	 * xɗRR[hu6v̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isHolidayReason6(String kkRiyuu) {
		return CommonConst.CODE_HOLIDAY_REASON_6.equals(kkRiyuu);
	}
	
	/**
	 * xɗR7f
	 * @param kkRiyuu ΏۋxɗRR[h
	 * @return
	 * <p>
	 * xɗRR[hu7v̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isHolidayReason7(String kkRiyuu) {
		return CommonConst.CODE_HOLIDAY_REASON_7.equals(kkRiyuu);
	}
	
	/**
	 * xɗR8f
	 * @param kkRiyuu ΏۋxɗRR[h
	 * @return
	 * <p>
	 * xɗRR[hu8v̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isHolidayReason8(String kkRiyuu) {
		return CommonConst.CODE_HOLIDAY_REASON_8.equals(kkRiyuu);
	}
	
	/**
	 * xɗR9f
	 * @param kkRiyuu ΏۋxɗRR[h
	 * @return
	 * <p>
	 * xɗRR[hu9v̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isHolidayReason9(String kkRiyuu) {
		return CommonConst.CODE_HOLIDAY_REASON_9.equals(kkRiyuu);
	}
	
	/**
	 * ΏۊԂ̎cƎԍv
	 * @param kCode ΏێЈR[h
	 * @param startDate JnN
	 * @param endDate IN
	 * @return ΏۊԂ̎cƎԍv()
	 * @throws Exception @Oꍇ
	 */
	public int getOverTimeForPeriod(String kCode, Date startDate, Date endDate) throws Exception {
		return getMSyukkinboDao().findForOverTimeSum(kCode, DateUtil.convDateFormatted(startDate),
				DateUtil.convDateFormatted(endDate));
	}
	
	/**
	 * @param kCode ΏێЈR[h
	 * @param startDate Jn
	 * @param endDate I
	 * @return ΏێЈ̓tꗗɂ\̃}bv
	 * @throws Exception Oꍇ
	 */
	public Map<Date, MScheduleDto> getScheduleMap(String kCode, Date startDate, Date endDate) throws Exception {
		Map<Date, MScheduleDto> map = new TreeMap<Date, MScheduleDto>();
		Calendar cal = Calendar.getInstance();
		cal.setTime(startDate);
		while (cal.getTime().compareTo(endDate) <= 0) {
			map.put(cal.getTime(), null);
			cal.add(Calendar.DATE, 1);
		}
		List<MScheduleDto> list = getScheduleList(kCode, startDate, endDate);
		for (MScheduleDto dto : list) {
			map.put(DateUtil.convStringDateToDate(dto.getHizuke()), dto);
		}
		return map;
	}
	
	/**
	 * @param kCode ΏێЈR[h
	 * @param startDate Jn
	 * @param endDate I
	 * @return ΏێЈ̓tꗗɂ\̃}bv
	 * @throws Exception Oꍇ
	 */
	public Map<Date, MSyukkinboDto> getAttendanceMap(String kCode, Date startDate, Date endDate) throws Exception {
		Map<Date, MSyukkinboDto> map = new TreeMap<Date, MSyukkinboDto>();
		Calendar cal = Calendar.getInstance();
		cal.setTime(startDate);
		while (cal.getTime().compareTo(endDate) <= 0) {
			map.put(cal.getTime(), null);
			cal.add(Calendar.DATE, 1);
		}
		List<MSyukkinboDto> list = getAttendanceList(kCode, startDate, endDate);
		for (MSyukkinboDto dto : list) {
			map.put(DateUtil.convStringDateToDate(dto.getHizuke()), dto);
		}
		return map;
	}
	
}
