/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.dto.KintaiCommonDtoInterface;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.workflow.dao.KtHolidayRequestDao;
import jp.mosp.kintai.workflow.dto.KtHolidayRequestDto;

/**
 * xɐ\ɊւPart
 * @author yoshida
 *	@version	0.0.1
 */
public class HolidayRequestPart extends KintaiBasePart {
	
	/**
	 * RXgN^
	 */
	public HolidayRequestPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public HolidayRequestPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * KtHolidayRequestDaoCX^X
	 */
	private KtHolidayRequestDao	holidayRequestDao;
	

	/**
	 * xɐ\e[uDAO̎擾
	 * @return	ςKtHolidayRequestDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public KtHolidayRequestDao getKtHolidayRequestDao() throws Exception {
		if (VariousUtil.isNull(holidayRequestDao)) {
			holidayRequestDao = (KtHolidayRequestDao)getPreparedDao(KtHolidayRequestDao.class.getCanonicalName());
		}
		return holidayRequestDao;
	}
	
	/**
	 * xɐ\擾
	 * @param voucher	Ώۓ`[ԍ
	 * @return	(DTO)
	 * @throws Exception	Oꍇ
	 */
	public KtHolidayRequestDto getHolidayRequest(int voucher) throws Exception {
		return getKtHolidayRequestDao().findForKey(voucher);
	}
	
	/**
	 * xɐ\擾
	 * @param kCode				ΏێЈR[h
	 * @param targetDate		Ώ۔N
	 * @return	(DTO)
	 * @throws Exception	Oꍇ
	 */
	public KtHolidayRequestDto getHolidayRequest(String kCode, Date targetDate) throws Exception {
		return getKtHolidayRequestDao().findForHolidayDate(kCode, targetDate);
	}
	
	/**
	 * xɐ\Lf
	 * @param kCode				ΏێЈR[h
	 * @param targetDate		Ώ۔N
	 * @return	xɐ\ꍇtrueAłȂꍇfalse
	 * @throws Exception	Oꍇ
	 */
	public boolean existHolidayRequest(String kCode, Date targetDate) throws Exception {
		return VariousUtil.isNotNull(getHolidayRequest(kCode, targetDate));
	}
	
	/**
	 * LxɁiSxj敪z擾
	 * @return	LxɁiSxj敪z
	 */
	public static String[] getPaidHolidayAllArray() {
		return new String[]{ CommonConst.CODE_HOLIDAY_ALL, CommonConst.NAM_VACATION_LEAVE_ALL };
	}
	
	/**
	 * LxɁiOxj敪z擾
	 * @return	LxɁiOxj敪z
	 */
	public static String[] getPaidHolidayStartArray() {
		return new String[]{ CommonConst.CODE_HOLIDAY_HALF_START, CommonConst.NAM_HOLIDAY_HALF_START };
	}
	
	/**
	 * LxɁi㔼xj敪z擾
	 * @return	LxɁi㔼xj敪z
	 */
	public static String[] getPaidHolidayQuitArray() {
		return new String[]{ CommonConst.CODE_HOLIDAY_HALF_QUIT, CommonConst.NAM_HOLIDAY_HALF_QUIT };
	}
	
	/**
	 * LxɁiԋxj敪z擾
	 * @return	LxɁiԋxj敪z
	 */
	public static String[] getPaidHolidayTimeArray() {
		return new String[]{ CommonConst.CODE_PAID_HOLIDAY_TIME, CommonConst.NAM_PAID_HOLIDAY_TIME };
	}
	
	/**
	 * LxɑS敪z擾
	 * @return	Lxɋ敪z
	 */
	public static String[][] getHolidayRequestTypeArrayAll() {
		return new String[][]{ getPaidHolidayAllArray(), getPaidHolidayStartArray(), getPaidHolidayQuitArray(),
			getPaidHolidayTimeArray(), };
	}
	
	/**
	 * Lxɋ敪z擾
	 * @return	Lxɋ敪z
	 * @throws Exception 	Oꍇ
	 */
	public String[][] getHolidayRequestTypeArray() throws Exception {
		String[][] aryType = new String[][]{ getPaidHolidayAllArray(), getPaidHolidayStartArray(),
			getPaidHolidayQuitArray() };
		if (part().mospcode().useHourPaidHolidayFunction()) {
			return getHolidayRequestTypeArrayAll();
		}
		return aryType;
	}
	
	/**
	 * xɗR̎擾iLxɋ敪܂ށj
	 * @param dto	ΏDTO
	 * @param addTime		ԑѕ\f
	 * @return	xɗR
	 * @throws Exception	Oꍇ
	 */
	public String getReasonNameWithType(KtHolidayRequestDto dto, boolean addTime) throws Exception {
		StringBuffer sb = new StringBuffer();
		if (VariousUtil.isNotNull(dto)) {
			// xɗR
			sb.append(part().mospcode().getHolidayName(dto.getReason()));
			// Lxɂ̏ꍇ
			if (isPaidHoliday(dto)) {
				// ԋx̏ꍇ
				if (isPaidHolidayTime(dto.getHolidayType()) && addTime) {
					sb.append(StringUtil.surroundRoundBracket(new StringBuffer().append(
							TimeUtil.convIntegerTimeToStringTime(dto.getStartTime())).append(CommonConst.STR_TERM)
						.append(TimeUtil.convIntegerTimeToStringTime(dto.getEndTime())).toString()));
				} else {
					sb.append(StringUtil.surroundRoundBracket(getHolidayTypeName(dto.getHolidayType())));
				}
			} else if (isSubHoliday(dto)) {
				sb.append(StringUtil.surroundRoundBracket(getHolidayTypeName(dto.getHolidayType())));
			}
		}
		return sb.toString();
	}
	
	/**
	 * xɎޖ̎擾
	 * @param holidayType ΏۋxɎރR[h
	 * @return xɎޖ
	 */
	public static String getHolidayTypeName(String holidayType) {
		String typeName = "";
		if (isAllHolidayType(holidayType)) {
			typeName = CommonConst.NAM_VACATION_LEAVE_ALL;
		} else if (isStartHalfHolidayType(holidayType)) {
			typeName = CommonConst.NAM_HOLIDAY_HALF_START;
		} else if (isQuitHalfHolidayType(holidayType)) {
			typeName = CommonConst.NAM_HOLIDAY_HALF_QUIT;
		} else if (isPaidHolidayTime(holidayType)) {
			typeName = CommonConst.NAM_PAID_HOLIDAY_TIME;
		}
		return typeName;
	}
	
	/**
	 * Lxɐ\f
	 * @param reason	ΏۋxɗRR[h
	 * @return
	 * <p>
	 * Lxɂ̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isPaidHoliday(String reason) {
		return PaidHolidayPart.isPaidHoliday(reason);
	}
	
	/**
	 * SxfB
	 * @param holidayType 	ΏۋxɎރR[h
	 * @return
	 * <p>
	 * Sx\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAllHolidayType(String holidayType) {
		return CommonConst.CODE_HOLIDAY_ALL.equals(holidayType);
	}
	
	/**
	 * SxfB
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * Sx\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAllHolidayType(KtHolidayRequestDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isAllHolidayType(dto.getHolidayType());
		}
		return false;
	}
	
	/**
	 * OxfB
	 * @param holidayType 	ΏۋxɎރR[h
	 * @return
	 * <p>
	 * Ox\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isStartHalfHolidayType(String holidayType) {
		return CommonConst.CODE_HOLIDAY_HALF_START.equals(holidayType);
	}
	
	/**
	 * OxfB
	 * @param dto  ΏDTO
	 * @return
	 * <p>
	 * Ox\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isStartHalfHolidayType(KtHolidayRequestDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isStartHalfHolidayType(dto.getHolidayType());
		}
		return false;
	}
	
	/**
	 * 㔼xfB
	 * @param holidayType 	ΏۋxɎރR[h
	 * @return
	 * <p>
	 * 㔼x\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isQuitHalfHolidayType(String holidayType) {
		return CommonConst.CODE_HOLIDAY_HALF_QUIT.equals(holidayType);
	}
	
	/**
	 * 㔼xfB
	 * @param dto  ΏDTO
	 * @return
	 * <p>
	 * 㔼x\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isQuitHalfHolidayType(KtHolidayRequestDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isQuitHalfHolidayType(dto.getHolidayType());
		}
		return false;
	}
	
	/**
	 * xfB
	 * @param holidayType 	ΏۋxɎރR[h
	 * @return
	 * <p>
	 * OxA㔼x\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isHalfHolidayType(String holidayType) {
		return isStartHalfHolidayType(holidayType) || isQuitHalfHolidayType(holidayType);
	}
	
	/**
	 * xfB
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * OxA㔼x\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isHalfHolidayType(KtHolidayRequestDto dto) {
		return isStartHalfHolidayType(dto) || isQuitHalfHolidayType(dto);
	}
	
	/**
	 * Lxɐ\f
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * Lxɂ̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isPaidHoliday(KtHolidayRequestDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isPaidHoliday(dto.getReason());
		}
		return false;
	}
	
	/**
	 * LxɁiSxj\f
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * LxɁiSxj\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isPaidHolidayAll(KtHolidayRequestDto dto) {
		return isPaidHoliday(dto) && isAllHolidayType(dto);
	}
	
	/**
	 * LxɁiOxj\f
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * LxɁiOxj\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isPaidHolidayStart(KtHolidayRequestDto dto) {
		return isPaidHoliday(dto) && isStartHalfHolidayType(dto);
	}
	
	/**
	 * LxɁi㔼xj\f
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * LxɁi㔼xj\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isPaidHolidayQuit(KtHolidayRequestDto dto) {
		return isPaidHoliday(dto) && isQuitHalfHolidayType(dto);
	}
	
	/**
	 * Lxɔx\f
	 * @param dto 	ΏDTO
	 * @return
	 * <p>
	 * Lxɐ\Ox܂͌㔼x̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isPaidHolidayHalf(KtHolidayRequestDto dto) {
		return isPaidHolidayStart(dto) || isPaidHolidayQuit(dto);
	}
	
	/**
	 * LxɁiԋxj\f
	 * @param holidayType		ΏۋxɎރR[h
	 * @return
	 * <p>
	 * LxɁiԋxj\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isPaidHolidayTime(String holidayType) {
		return CommonConst.CODE_PAID_HOLIDAY_TIME.equals(holidayType);
	}
	
	/**
	 * LxɁiԋxj\f
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * LxɁiԋxj\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isPaidHolidayTime(KtHolidayRequestDto dto) {
		return isPaidHoliday(dto) && isPaidHolidayTime(dto.getHolidayType());
	}
	
	/**
	 * LxɎԎ擾
	 * @param dto		ΏDTO
	 * @return	LxɎ()
	 */
	public static int getHolidayTime(KtHolidayRequestDto dto) {
		if (isPaidHolidayTime(dto)) {
			return Double.valueOf(TimeUtil.convMinutesToDoubleHour(dto.getEndTime() - dto.getStartTime())).intValue();
		}
		return 0;
	}
	
	/**
	 * 񎟏Fςݔf
	 * @param dto	ΏDTO
	 * @return	xɐ\񎟏Fς݂̏ꍇtrueAłȂꍇfalse
	 * @throws Exception 	Oꍇ
	 */
	public boolean isStatus2ndApproved(KtHolidayRequestDto dto) throws Exception {
		return part().workflow().isStatusLastApproved(dto.getWorkflow());
	}
	
	/**
	 * wԒ̋xɐ\ꗗ
	 * @param kCode ЈR[h
	 * @param startDate JnN
	 * @param endDate IN
	 * @return xɐ\Xg
	 * @throws Exception 	Oꍇ
	 */
	public List<KtHolidayRequestDto> getHolidayRequestList(String kCode, Date startDate, Date endDate) throws Exception {
		return getKtHolidayRequestDao().findForCondition(kCode, startDate, endDate);
	}
	
	/**
	 * wԒ̏Fς݋xɐ\ꗗ
	 * @param kCode ЈR[h
	 * @param startDate JnN
	 * @param endDate IN
	 * @return  xɐ\Xg
	 * @throws Exception 	Oꍇ
	 * 
	 */
	public List<KtHolidayRequestDto> getApprovedHolidayRequestList(String kCode, Date startDate, Date endDate)
			throws Exception {
		return getKtHolidayRequestDao().findForCondition(kCode, startDate, endDate, CommonConst.NUM_LAST_LAYER,
				WorkflowPart.getStatusCodeArray()[1]);
	}
	
	/**
	 * wԒ̏Fς݂̗Lxɐ\ꗗ
	 * @param kCode ЈR[h
	 * @param startDate JnN
	 * @param endDate IN
	 * @return xɐ\Xg
	 * @throws Exception 	Oꍇ
	 */
	public List<KtHolidayRequestDto> getApprovedPaidHolidayRequestList(String kCode, Date startDate, Date endDate)
			throws Exception {
		return getKtHolidayRequestDao().findForCondition(kCode, CommonConst.CODE_HOLIDAY_REASON_PAID, startDate,
				endDate, CommonConst.NUM_LAST_LAYER, WorkflowPart.getStatusCodeArray()[1]);
	}
	
	/**
	 * 60Ԃ̎ԊOɂx\f
	 * @param reason 	ΏۋxɗRR[h
	 * @return
	 * <p>
	 * 60Ԃ̎ԊOɂx\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isSubHoliday(String reason) {
		return CommonConst.CODE_SUB_HOLIDAY_REQUEST.equals(reason);
	}
	
	/**
	 * 60Ԃ̎ԊOɂx\f
	 * @param dto 	ΏDTO
	 * @return
	 * <p>
	 * 60Ԃ̎ԊOɂx\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isSubHoliday(KtHolidayRequestDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isSubHoliday(dto.getReason());
		}
		return false;
	}
	
	/**
	 * 60ԎԊOɂxiSxj\fB
	 * @param dto ΏDTO
	 * @return 
	 * <p>
	 * 60Ԃ̎ԊOɂxiSxj\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isSubHolidayAll(KtHolidayRequestDto dto) {
		return isSubHoliday(dto) && isAllHolidayType(dto);
	}
	
	/**
	 * 60ԎԊOɂxiOxj\fB
	 * @param dto ΏDTO
	 * @return 
	 * <p>
	 * 60Ԃ̎ԊOɂxiOxj\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isSubHolidayStartHalf(KtHolidayRequestDto dto) {
		return isSubHoliday(dto) && isStartHalfHolidayType(dto);
	}
	
	/**
	 * 60ԎԊOɂxi㔼xj\fB
	 * @param dto ΏDTO
	 * @return 
	 * <p>
	 * 60Ԃ̎ԊOɂxi㔼xj\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isSubHolidayQuitHalf(KtHolidayRequestDto dto) {
		return isSubHoliday(dto) && isQuitHalfHolidayType(dto);
	}
	
	/**
	 * 60ԎԊOɂxixj\fB
	 * @param dto ΏDTO
	 * @return 
	 * <p>
	 * 60Ԃ̎ԊOɂxixj\̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isSubHolidayHalf(KtHolidayRequestDto dto) {
		return isSubHoliday(dto) && isHalfHolidayType(dto);
	}
	
	/**
	 * ЈΏ۔N̋xɐ\ꗗ擾B
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return Ώ۔N̋xɐ\ꗗ
	 * @throws Exception 	Oꍇ
	 */
	public List<KtHolidayRequestDto> getDateRequestList(String kCode, Date targetDate) throws Exception {
		return getDateRequestListForReason(kCode, targetDate, "");
	}
	
	/**
	 * ЈΏ۔N̑ΏۋxɗRxɐ\ꗗ擾B
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @param reason ΏۋxɗRR[h
	 * @return Ώ۔N̑ΏۋxɗRxɐ\ꗗ
	 * @throws Exception  	Oꍇ
	 */
	public List<KtHolidayRequestDto> getDateRequestListForReason(String kCode, Date targetDate, String reason)
			throws Exception {
		return getDateRequestListForReasonType(kCode, targetDate, reason, "");
	}
	
	/**
	 * ЈΏ۔N̑ΏۋxɗRAxɎދxɐ\ꗗ擾B
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @param reason ΏۋxɗR
	 * @param holidayType ΏۋxɎރR[h
	 * @return Ώ۔N̑ΏۋxɗRAxɎދxɐ\ꗗ
	 * @throws Exception  	Oꍇ
	 */
	public List<KtHolidayRequestDto> getDateRequestListForReasonType(String kCode, Date targetDate, String reason,
			String holidayType) throws Exception {
		return getKtHolidayRequestDao().findForCondition(kCode, reason, holidayType, targetDate);
	}
	
	/**
	 * ЈΏ۔N̑ΏۋxɗRAxɎށAF󋵋xɐ\ꗗ擾B
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @param reason ΏۋxɗR
	 * @param holidayType ΏۋxɎރR[h
	 * @param layer FKw
	 * @param status F
	 * @return 	ЈΏ۔N̑ΏۋxɗRAxɎށAF󋵋xɐ\ꗗ
	 * @throws Exception  	Oꍇ
	 */
	public List<KtHolidayRequestDto> getDateRequestList(String kCode, Date targetDate, String reason,
			String holidayType, int layer, String status) throws Exception {
		return getKtHolidayRequestDao().findForCondition(kCode, targetDate, targetDate, reason, holidayType, layer,
				status);
	}
	
	/**
	 * xɐ\̓e𔽉fB
	 * @param dto ΏDTO
	 * @throws Exception  	Oꍇ
	 */
	public void margeHolidayRequest(KintaiCommonDtoInterface dto) throws Exception {
		if (VariousUtil.isNotNull(dto)) {
			// xɐ\擾
			List<KtHolidayRequestDto> list = getDateRequestList(dto.getKCode(), DateUtil.convStringDateToDate(dto
				.getHizuke()));
			// 60ԎԊOԋ@\
			boolean useSubHolidayFunction = part().mospcode().useSubstituteHolidayFunction();
			// xɎ
			int totalHolidayTime = 0;
			// ԒPʔNx
			int unitHourHoliday = 0;
			for (KtHolidayRequestDto requestDto : list) {
				// 񎟏Fς݂̂
				if (part().holidayRequest().isStatus2ndApproved(requestDto)) {
					// Ζ\
					if (KintaiCommonPart.isAvailableWorkType(dto)) {
						int holidayTime = 0;
						int workTime = dto.getKinmuJi();
						// ߑOx
						if (isPaidHolidayStart(requestDto)) {
							dto.setSHankyuKb(CommonConst.NUM_START_HALF_HOLIDAY_FLAG_ON);
						}
						// ߌ㔼x
						if (isPaidHolidayQuit(requestDto)) {
							dto.setTHankyuKb(CommonConst.NUM_QUIT_HALF_HOLIDAY_FLAG_ON);
						}
						// 60ԎԊOɂxiOxj
						if (isSubHolidayStartHalf(requestDto) && useSubHolidayFunction) {
							dto.setSHankyuKb(CommonConst.CODE_SUB_HOLIDAY_HALF_FLAG);
						}
						// 60ԎԊOɂxi㔼xj
						if (isSubHolidayQuitHalf(requestDto) && useSubHolidayFunction) {
							dto.setTHankyuKb(CommonConst.CODE_SUB_HOLIDAY_HALF_FLAG);
						}
						// }[W
						if (StringUtil.isNotNull(dto.getTaJikoku())) {
							part().kintai().runCalculatedInfo(dto);
						} else {
							part().kintai().runStartCalculate(dto);
						}
						// ԒPʔNxΉ
						if (HolidayRequestPart.isPaidHolidayTime(requestDto)) {
							holidayTime = TimeUtil.convHourToMinutes(HolidayRequestPart.getHolidayTime(requestDto));
							totalHolidayTime += holidayTime;
							workTime -= holidayTime;
							// ԒPʔNxZ
							unitHourHoliday++;
							dto.setNijiKyu(unitHourHoliday);
						}
						if (workTime < 0) {
							workTime = 0;
						}
						dto.setKinmuJi(workTime);
						dto.setKKJikan(totalHolidayTime);
						// \󋵂֕ύX
						if (StringUtil.isNotNull(dto.getTaJikoku())) {
							dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
						}
					} else {
						// Sx
						// e
						KintaiCommonPart.initKintaiInfo(dto);
						// Lx\
						if (isPaidHolidayAll(requestDto)) {
							dto.setKinmu(CommonConst.ATTENDANCE_TYPE_HOLIDAY);
							dto.setKKRiyuu(CommonConst.CODE_HOLIDAY_REASON_PAID);
						} else if (isSubHolidayAll(requestDto) && useSubHolidayFunction) {
							// 60ԎԊOɂx
							dto.setKinmu(CommonConst.ATTENDANCE_TYPE_HOLIDAY);
							dto.setKKRiyuu(CommonConst.CODE_SUB_HOLIDAY_REQUEST);
						} else {
							dto.setKinmu(CommonConst.ATTENDANCE_TYPE_HOLIDAY);
							dto.setKKRiyuu(requestDto.getReason());
						}
						// \󋵂֕ύX
						dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
					}
				}
			}
		}
	}
	
	/**
	 * \pΏۋxɈꗗiF󋵒ǉj
	 * @param holidayList ΏۋxɗRꗗ
	 * @return
	 * \pΏۋxɈꗗiF󋵒ǉjz
	 * @throws Exception 	Oꍇ
	 */
	public String[] getLabelHolidayRequestStatusArray(List<KtHolidayRequestDto> holidayList) throws Exception {
		List<String> labelList = new ArrayList<String>();
		for (KtHolidayRequestDto dto : holidayList) {
			StringBuffer sb = new StringBuffer();
			String statusCode = part().workflow().toKintaiApprovalStatus(dto.getWorkflow());
			// ȊO
			if (!KintaiApprovalPart.isDraft(statusCode)) {
				// xɗR
				sb.append(part().holidayRequest().getReasonNameWithType(dto, true));
				// F
				sb.append(StringUtil.surroundBracket(part().kintaiApproval().getApprovalName(statusCode)));
			}
			if (sb.length() != 0) {
				labelList.add(sb.toString());
			}
		}
		return StringUtil.listToArray(labelList);
	}
	
	/**
	 * Ώ۔N̏FςݎԊOxxɐ\ꗗ擾
	 * @param kCode ΏێЈR[h
	 * @param occurYear N
	 * @param occurMonth 
	 * @return Ώ۔N̏FςݎԊOxxɐ\ꗗ
	 * @throws Exception 	Oꍇ
	 */
	public List<KtHolidayRequestDto> getOccurYearMonthList(String kCode, int occurYear, int occurMonth)
			throws Exception {
		return getKtHolidayRequestDao().findForOccur(kCode, CommonConst.CODE_SUB_HOLIDAY_REQUEST,
				StringUtil.combineByHyphen(String.valueOf(occurYear), String.valueOf(occurMonth)),
				CommonConst.NUM_LAST_LAYER, WorkflowPart.getStatusCodeArray()[1]);
	}
	
	/**
	 * NpԎ擾
	 * @param dto ΏDTO
	 * @param occurYear N
	 * @param occurMonth 
	 * @return Np
	 */
	public static int getOccurUseTime(KtHolidayRequestDto dto, int occurYear, int occurMonth) {
		if (isSubHoliday(dto)) {
			String occurYearMonth = StringUtil.combineByHyphen(String.valueOf(occurYear), String.valueOf(occurMonth));
			if (dto.getOccurDate1().equals(occurYearMonth)) {
				return dto.getUseTime1();
			} else if (dto.getOccurDate2().equals(occurYearMonth)) {
				return dto.getUseTime2();
			}
		}
		return 0;
	}
	
	/**
	 * Ώۂ̋xɐ\܂ޏꍇXg폜B
	 * @param dto ΏDTO
	 * @param list ΏۃXg
	 */
	public static void removeSameRequest(KtHolidayRequestDto dto, List<KtHolidayRequestDto> list) {
		if (VariousUtil.isNotNull(dto) && VariousUtil.isNotNull(list)) {
			KtHolidayRequestDto targetDto = null;
			for (KtHolidayRequestDto requestDto : list) {
				if (requestDto.getVoucher() == dto.getVoucher()) {
					targetDto = requestDto;
				}
			}
			if (VariousUtil.isNotNull(targetDto)) {
				list.remove(targetDto);
			}
		}
	}
	
	/**
	 * Lxɐ\Fϔf(Sx)
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * Ώ۔N̗Lxɐ\(Sx)񎟏Fς̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public boolean isApprovedPaidHolidayRequestAll(KintaiCommonDtoInterface dto) throws Exception {
		boolean approved = false;
		if (VariousUtil.isNotNull(dto)) {
			// xɐ\擾
			List<KtHolidayRequestDto> list = getDateRequestList(dto.getKCode(), DateUtil.convStringDateToDate(dto
				.getHizuke()));
			for (KtHolidayRequestDto requestDto : list) {
				// 񎟏F
				if (isStatus2ndApproved(requestDto)) {
					if (KintaiCommonPart.isAllHoliday(dto) && isPaidHolidayAll(requestDto)) {
						// Lx
						approved = true;
					}
					break;
				}
			}
		}
		return approved;
	}
	
	/**
	 * Lxɐ\Fϔf(ߑOx)
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * Ώ۔N̗Lxɐ\(ߑOx)񎟏Fς̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public boolean isApprovedPaidHolidayRequestStartHalf(KintaiCommonDtoInterface dto) throws Exception {
		boolean approved = false;
		if (VariousUtil.isNotNull(dto)) {
			// xɐ\擾
			List<KtHolidayRequestDto> list = getDateRequestList(dto.getKCode(), DateUtil.convStringDateToDate(dto
				.getHizuke()));
			for (KtHolidayRequestDto requestDto : list) {
				// 񎟏F
				if (isStatus2ndApproved(requestDto)) {
					if (KintaiCommonPart.isStartHalfHoliday(dto) && isPaidHolidayStart(requestDto)) {
						// Lx(ߑOx)
						approved = true;
					}
					break;
				}
			}
		}
		return approved;
	}
	
	/**
	 * Lxɐ\Fϔf(ߌ㔼x)
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * Ώ۔N̗Lxɐ\(ߌ㔼x)񎟏Fς̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public boolean isApprovedPaidHolidayRequestQuitHalf(KintaiCommonDtoInterface dto) throws Exception {
		boolean approved = false;
		if (VariousUtil.isNotNull(dto)) {
			// xɐ\擾
			List<KtHolidayRequestDto> list = getDateRequestList(dto.getKCode(), DateUtil.convStringDateToDate(dto
				.getHizuke()));
			for (KtHolidayRequestDto requestDto : list) {
				// 񎟏F
				if (isStatus2ndApproved(requestDto)) {
					if (KintaiCommonPart.isQuitHalfHoliday(dto) && isPaidHolidayQuit(requestDto)) {
						// Lx(ߌ㔼x)
						approved = true;
					}
					break;
				}
			}
		}
		return approved;
	}
	
	/**
	 * ֋xɐ\Fϔf(Sx)
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * Ώ۔N̑֋xɐ\(Sx)񎟏Fς̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public boolean isApprovedSubstituteHolidayRequestAll(KintaiCommonDtoInterface dto) throws Exception {
		boolean approved = false;
		if (VariousUtil.isNotNull(dto)) {
			// xɐ\擾
			List<KtHolidayRequestDto> list = getDateRequestList(dto.getKCode(), DateUtil.convStringDateToDate(dto
				.getHizuke()));
			for (KtHolidayRequestDto requestDto : list) {
				// 񎟏F
				if (isStatus2ndApproved(requestDto)) {
					if (part().mospcode().useSubstituteHolidayFunction() && KintaiCommonPart.isSubstituteAll(dto)
							&& isSubHolidayAll(requestDto)) {
						// 60ԎԊOɂx
						approved = true;
					}
					break;
				}
			}
		}
		return approved;
	}
	
	/**
	 * ֋xɐ\Fϔf(ߑOx)
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * Ώ۔N̑֋xɐ\(ߑOx)񎟏Fς̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public boolean isApprovedSubstituteHolidayRequestStartHalf(KintaiCommonDtoInterface dto) throws Exception {
		boolean approved = false;
		if (VariousUtil.isNotNull(dto)) {
			// xɐ\擾
			List<KtHolidayRequestDto> list = getDateRequestList(dto.getKCode(), DateUtil.convStringDateToDate(dto
				.getHizuke()));
			for (KtHolidayRequestDto requestDto : list) {
				// 񎟏F
				if (isStatus2ndApproved(requestDto)) {
					if (part().mospcode().useSubstituteHolidayFunction()
							&& KintaiCommonPart.isOverTimeSubHolidayStart(dto) && isSubHolidayStartHalf(requestDto)) {
						// 60ԎԊOɂx(ߑOx)
						approved = true;
					}
					break;
				}
			}
		}
		return approved;
	}
	
	/**
	 * ֋xɐ\Fϔf(ߌ㔼x)
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * Ώ۔N̑֋xɐ\(ߌ㔼x)񎟏Fς̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public boolean isApprovedSubstituteHolidayRequestQuitHalf(KintaiCommonDtoInterface dto) throws Exception {
		boolean approved = false;
		if (VariousUtil.isNotNull(dto)) {
			// xɐ\擾
			List<KtHolidayRequestDto> list = getDateRequestList(dto.getKCode(), DateUtil.convStringDateToDate(dto
				.getHizuke()));
			for (KtHolidayRequestDto requestDto : list) {
				// 񎟏F
				if (isStatus2ndApproved(requestDto)) {
					if (part().mospcode().useSubstituteHolidayFunction()
							&& KintaiCommonPart.isOverTimeSubHolidayQuit(dto) && isSubHolidayQuitHalf(requestDto)) {
						// 60ԎԊOɂx(ߌ㔼x)
						approved = true;
					}
					break;
				}
			}
		}
		return approved;
	}
	
}
