/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.action;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.kintai.common.vo.MosPLoginVo;

/**
 * @author yoshida
 *
 */
public class MosPIndexAction extends MosPAction {
	
	/**
	 * RXgN^
	 */
	public MosPIndexAction() {
		super();
		// ʏݒ
		setNeedSession(false);
		setNeedAspUser(false);
		setNeedUser(false);
		setCheckProcSeq(false);
		setCheckAuth(false);
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// ZbV̎擾
		session = request.getSession(true);
		// y[W̎擾
		getIndexUrl();
		// ZbVɏZbg
		session.setAttribute(MospConst.ATT_ASPUSER, aspUser);
	}
	
	/**
	 * Jڐ擾
	 * @throws Exception	Oꍇ
	 */
	protected void getIndexUrl() throws Exception {
		// ݒt@CASPݒɂď𕪊
		createAspUser();
		// St@C̐ݒ
		setUseLogo();
		switch (MospUtility.getAspFlag(cfg)) {
			case 0:
				// 0FASP(x[U[:1Av)
				// ASP̃ANVNXɏϏ邢͂̂܂JSP֔΂Ă܂B
				//break;
			case 1:
				// 1FASP(1[U[:1Av)
				// ASPOCy[W֑J
				break;
			case 2:
				// 2FASP
				initNonAspUser();
				break;
			default:
				throw new MospException(MospConst.EX_ASP_PROPERTIES);
		}
	}
	
	/**
	 * ASP
	 */
	protected void initNonAspUser() {
		MosPLoginVo vo = new MosPLoginVo(cfg, msg, nam, cmd, aspUser, user);
		vo.setUserId("");
		vo.setPass("");
		// VOyёJڐZbg
		setVo(vo);
		setUrl(vo.getRetUrl());
	}
	
}
