/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.common.action;

import java.sql.SQLException;
import java.util.Date;

import jp.mosp.common.MosPAction;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.utils.TableLockUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.common.part.KintaiPartStore;
import jp.mosp.mospcommon.system.AgreementBaseInfo;

/**
 * MosPΑӊǗ̋ActionNX
 * @author yoshida
 *	@version 0.1
 */
public abstract class KintaiCommonAction extends MosPAction {
	
	/**
	 * RXgN^
	 */
	public KintaiCommonAction() {
		super();
	}
	
	/**
	 * KintaiPartStoreCX^X擾
	 * @return	KintaiPartStoreCX^X
	 * @throws SQLException   SQLOꍇ
	 * @throws ClassNotFoundException  NXȂꍇ
	 * @throws MospException  MosPOꍇ
	 */
	@Override
	protected KintaiPartStore part() throws MospException, ClassNotFoundException, SQLException {
		return (KintaiPartStore)getBaseStore(KintaiPartStore.class);
	}
	
	/* ΑӌvZ֘A */

	/**
	 * ΑӒ擾
	 * @return	Date	Ώ۔N
	 * @throws Exception Oꍇ
	 */
	protected Date getCalcMonth() throws Exception {
		return part().calculate().getCalcMonth();
	}
	
	/**
	 * ΑӌvZ擾
	 * @return yyyymm vZN
	 * @throws Exception Oꍇ
	 */
	protected Date getCalcAttendance() throws Exception {
		return part().calculate().getCalcAttendance();
	}
	
	/**
	 * WvJn擾
	 * @param targetMonth Ώی
	 * @return WvJn
	 * @throws Exception Oꍇ
	 */
	protected Date getStartDate(Date targetMonth) throws Exception {
		return part().calculate().getStartDate(targetMonth);
	}
	
	/**
	 * WvI擾
	 * @param targetMonth Ώی
	 * @return WvI
	 * @throws Exception Oꍇ
	 */
	protected Date getEndDate(Date targetMonth) throws Exception {
		return part().calculate().getEndDate(targetMonth);
	}
	
	/**
	 * Wv擾
	 * @param targetDate Ώۓ
	 * @return Wv
	 * @throws Exception Oꍇ
	 */
	protected Date getCalcAttendanceMonth(Date targetDate) throws Exception {
		return part().calculate().getCalcAttendanceMonth(targetDate);
	}
	
	/**
	 * ^xΏ۔N擾
	 * @param targetDate Ώۓ
	 * @return	iΑӏWvji^xj
	 * @throws Exception Oꍇ
	 */
	protected Date getCalcPayment(Date targetDate) throws Exception {
		return part().calculate().getCalcPayment(targetDate);
	}
	
	/**
	 * ^x擾
	 * @return	Date	Ώ۔N
	 * @throws Exception Oꍇ
	 */
	protected Date getCalcPayment() throws Exception {
		return part().calculate().getCalcPayment();
	}
	
	/**
	 * \pJnN
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param targetDate	Ώ۔N	
	 * @return \pJnN
	 * @throws Exception Oꍇ
	 */
	protected Date getStartDateForList(Date targetDate) throws Exception {
		return part().calculate().getStartDateForList(targetDate);
	}
	
	/**
	 * \pIN
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param targetDate	Ώ۔N
	 * @return \pJnN
	 * @throws Exception Oꍇ
	 */
	protected Date getEndDateForList(Date targetDate) throws Exception {
		return part().calculate().getEndDateForList(targetDate);
	}
	
	/* Ə֘A */

	/**
	 * ƏR[h擾(M_KAISYA)
	 * @return ƏR[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getOfficeArrayAll() throws Exception {
		return part().office().getOfficeArrayAll();
	}
	
	/**
	 * ƏR[h擾(p\̂)(M_KAISYA)
	 * @return ƏR[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getOfficeArray() throws Exception {
		return part().office().getOfficeArray();
	}
	
	/**
	 * ƏR[h擾î݁j(M_KAISYA)
	 * @param kCode 擾ΏێЈR[h
	 * @return ƏR[h
	 * @throws Exception Oꍇ
	 */
	protected String getBelongOfficeCode(String kCode) throws Exception {
		return part().office().getBelongOfficeCode(kCode);
	}
	
	/* ֘A */

	/**
	 * 擾(M_SYOZOKU)
	 * @param sCode 擾ΏۏR[h
	 * @return 
	 * @throws Exception Oꍇ
	 */
	protected String getSectionName(String sCode) throws Exception {
		return part().section().getSectionName(sCode);
	}
	
	/**
	 * R[h擾
	 * @param kCode 擾ΏێЈR[h
	 * @return R[h
	 * @throws Exception Oꍇ
	 */
	protected String getBelongSectionCode(String kCode) throws Exception {
		return part().section().getBelongSectionCode(kCode);
	}
	
	/**
	 * R[h擾(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getSectionArrayAll() throws Exception {
		return part().section().getSectionArrayAll();
	}
	
	/**
	 * R[h擾(p\ĉ)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getSectionArrayForManager() throws Exception {
		return part().section().getSectionArrayForManager();
	}
	
	/**
	 * R[h擾(p\cɂω)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getSectionArrayForHuman() throws Exception {
		return part().section().getSectionArrayForHuman();
	}
	
	/**
	 * R[h擾(͈͂ɂω)(M_SYOZOKU)
	 * @return R[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getSectionScopeArrayForPayroll() throws Exception {
		return part().section().getSectionScopeArrayForPayroll();
	}
	
	/* E֘A */

	/**
	 * ER[h擾(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getPositionArrayAll() throws Exception {
		return part().position().getPositionArrayAll();
	}
	
	/**
	 * ER[h擾(L̂)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getPositionArray() throws Exception {
		return part().position().getPositionArray();
	}
	
	/**
	 * ER[h擾(̂)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getPositionTitleArray() throws Exception {
		return part().position().getPositionTitleArray();
	}
	
	/**
	 * ER[h擾(v_Ep)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getPositionPltArray() throws Exception {
		return part().position().getPositionPltArray();
	}
	
	/**
	 * E̎擾(t)
	 * @param kCode		ΏێЈR[h
	 * @return	ΏێЈE
	 * @throws Exception Oꍇ
	 */
	protected String getPositionName(String kCode) throws Exception {
		return part().position().getPositionName(kCode);
	}
	
	/* l֘A */

	/**
	 * [U[擾
	 * @param userId Ώۃ[U[ID
	 * @throws Exception Oꍇ
	 */
	protected void getInfo(String userId) throws Exception {
		userBasis = getBasisInfo(part().mospuser().getUserKCode(userId));
	}
	
	/**
	 * @param kCode ΏێЈR[h
	 * @return ΏێЈ{
	 * @throws Exception Oꍇ
	 */
	protected MKihonDto getBasisInfo(String kCode) throws Exception {
		return part().human().getBasisInfo(kCode);
	}
	
	/**
	 * Ј擾(M_KIHON)
	 * @param kCode 擾ΏێЈR[h
	 * @return Ј
	 * @throws Exception Oꍇ
	 */
	protected String getKName(String kCode) throws Exception {
		return part().human().getKName(kCode);
	}
	
	/**
	 * {\ݒ
	 * @param dto		ΏDTO
	 * @throws Exception Oꍇ
	 */
	protected void setLabelBasisInfo(HumanBasisDtoInterface dto) throws Exception {
		MosPVo vo = (MosPVo)getVo();
		if (VariousUtil.isNotNull(dto)) {
			vo.setLblKCode(dto.getKCode());
			vo.setLblKName(dto.getSimei());
			vo.setLblSectionName(getSectionName(dto.getSCode()));
		} else {
			vo.setLblKCode("");
			vo.setLblKName("");
			vo.setLblSectionName("");
		}
	}
	
	/**
	 * {\ݒ
	 * @param kCode ΏێЈR[h
	 * @throws Exception Oꍇ
	 */
	protected void setLabelBasisInfo(String kCode) throws Exception {
		setLabelBasisInfo(getBasisInfo(kCode));
	}
	
	/* Ζ`Ԋ֘A */

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getWorkTypeArrayNotDeleted() throws Exception {
		return part().worktype().getWorkTypeArrayNotDeleted();
	}
	
	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)iTxtj
	 * @return Ζ`ԃR[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getWorkTypeArrayWithWeekHoliday() throws Exception {
		return part().worktype().getWorkTypeArrayWithWeekHoliday();
	}
	
	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getWorkTypeArrayAll() throws Exception {
		return part().worktype().getWorkTypeArrayAll();
	}
	
	/**
	 * Ζ`ԏ擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception Oꍇ
	 */
	protected String[][] getWorkTypeDataArray() throws Exception {
		return part().worktype().getWorkTypeDataArray();
	}
	

	/**
	 * Jg
	 */
	protected AgreementBaseInfo	agreement;
	

	/**
	 * ΏێЈJg擾
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @throws Exception @Oꍇ
	 */
	protected void setLaborAgreementInfo(String kCode, Date targetDate) throws Exception {
		agreement = part().laborAgreement().getUserLaborAgreement(kCode, targetDate);
		/*
		if (VariousUtil.isNull(agreement)) {
			// G[bZ[W
			addErrMessage(getKName(kCode) + "̘Jg񂪂܂B");
		}
		*/
	}
	
	/**
	 * Αӓ͊ۂߏf
	 * @return
	 * <p>
	 * ۂߏΑӓ͎ɍsꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception@Oꍇ
	 */
	protected boolean isRoundNumberDaily() throws Exception {
		return part().kintai().isRoundNumberDaily();
	}
	
	/**
	 * ΑӏWvۂߏf
	 * @return
	 * <p>
	 * ۂߏΑӏWvɍsꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception@Oꍇ
	 */
	protected boolean isRoundNumberMonthly() throws Exception {
		return part().kintai().isRoundNumberMonthly();
	}
	

	/*e[ubN*/

	/**
	 * e[ubNp[eBeB
	 */
	private TableLockUtil	tableLock	= null;
	

	/**
	 * e[ubNJn
	 * @throws Exception	Oꍇ
	 */
	protected void prepareTableLock() throws Exception {
		tableLock = new TableLockUtil(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * e[ubNΏDAOǉ
	 * @param dao		Ώۃe[uDAO
	 * @param isWrite	WRITȄꍇtrueAREAD̏ꍇfalse
	 */
	protected void addTargetTable(BaseDao dao, boolean isWrite) {
		tableLock.addTargetTable(dao, isWrite);
	}
	
	/**
	 * e[ubNΏDAOǉ
	 * @param tablename		Ώۃe[u
	 * @param isWrite	WRITȄꍇtrueAREAD̏ꍇfalse
	 */
	protected void addTargetTable(String tablename, boolean isWrite) {
		tableLock.addTargetTable(tablename, isWrite);
	}
	
	/**
	 * e[ubN
	 * @throws Exception	Oꍇ
	 */
	protected void lockTables() throws Exception {
		tableLock.lockTables();
	}
	
	/**
	 * e[ubN
	 * @throws Exception	Oꍇ
	 */
	protected void unLockTables() throws Exception {
		tableLock.unLockTables();
	}
	
}
