/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.utils;

import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.BaseDto;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.BasePart;

/**
 * e탁\bhɊւPartNX
 * @author yoshida
 *	@version	0.0.3
 */
public class VariousUtil {
	
	/**
	 * 
	 */
	private VariousUtil() {
		// NXɂCX^Xh~
	}
	
	/**
	 * 폜tOXg擾
	 * @return 폜tOXg
	 */
	public static String[][] getDeleteArray() {
		String[][] array = new String[2][2];
		array[0][0] = String.valueOf(MospConst.DELETE_FLAG_OFF);
		array[0][1] = MospConst.DELETE_FLAG_OFF_NAME;
		array[1][0] = String.valueOf(MospConst.DELETE_FLAG_ON);
		array[1][1] = MospConst.DELETE_FLAG_ON_NAME;
		return array;
	}
	
	/**
	 * KptOXg擾
	 * @return 폜tOXg
	 */
	public static String[][] getApplicableFlagArray() {
		String[][] array = new String[2][2];
		array[0][0] = String.valueOf(CommonConst.APPLICABLE_FLAG_OFF);
		array[0][1] = CommonConst.NAM_APPLICABLE_FLAG_OFF;
		array[1][0] = String.valueOf(CommonConst.APPLICABLE_FLAG_ON);
		array[1][1] = CommonConst.NAM_APPLICABLE_FLAG_ON;
		return array;
	}
	
	/**
	 * f[^݊mF
	 * @param dto mFΏDTO
	 * @return boolean	ΏDTOݗL
	 */
	public static boolean chkExistDto(BaseDto dto) {
		if (dto == null) {
			return false;
		}
		return true;
	}
	
	/**
	 * DTO݊mF
	 * @since	0.0.3
	 * @param dto mFΏDTO
	 * @return	ΏDTOݗL
	 */
	public static boolean isNull(BaseDto dto) {
		if (dto == null) {
			return true;
		}
		return false;
	}
	
	/**
	 * DTO݊mF
	 * @since	0.0.3
	 * @param dto mFΏDTO
	 * @return	ΏDTOݗL
	 */
	public static boolean isNotNull(BaseDto dto) {
		return !isNull(dto);
	}
	
	/**
	 * f[^݊mF
	 * @param obj mFΏObject
	 * @return boolean	ΏObjectݗL
	 */
	public static boolean chkExistObject(Object obj) {
		if (obj == null) {
			return false;
		}
		return true;
	}
	
	/**
	 * f[^݊mF
	 * @since	0.0.3
	 * @param obj mFΏObject
	 * @return boolean	ΏObjectݗL
	 */
	public static boolean isNull(Object obj) {
		if (obj == null) {
			return true;
		}
		return false;
	}
	
	/**
	 * f[^݊mF
	 * @since	0.0.3
	 * @param obj mFΏObject
	 * @return boolean	ΏObjectݗL
	 */
	public static boolean isNotNull(Object obj) {
		return !isNull(obj);
	}
	
	/**
	 * Part݊mF
	 * @since	0.0.3
	 * @param part mFΏPart
	 * @return boolean	ΏPartݗL
	 */
	public static boolean isNull(BasePart part) {
		return isNull((Object)part);
	}
	
	/**
	 * Part݊mF
	 * @since	0.0.3
	 * @param part mFΏPart
	 * @return boolean	ΏPartݗL
	 */
	public static boolean isNotNull(BasePart part) {
		return !isNull(part);
	}
	
	/**
	 * DAO݊mF
	 * @since	0.0.3
	 * @param dao mFΏDAO
	 * @return boolean	ΏDAOݗL
	 */
	public static boolean isNull(BaseDao dao) {
		return isNull((Object)dao);
	}
	
	/**
	 * DAO݊mF
	 * @since	0.0.3
	 * @param dao mFΏDAO
	 * @return boolean	ΏDAOݗL
	 */
	public static boolean isNotNull(BaseDao dao) {
		return !isNull(dao);
	}
	
	/**
	 * {R[hz擾
	 * @return	{R[hz
	 * <p>
	 * [0]c
	 * [1]cI𕔏
	 * [2]cS
	 * </p>
	 */
	public static int[] getManageCode() {
		int[] aryCode = new int[3];
		aryCode[0] = Integer.parseInt(CommonConst.NUM_BELONGING_SECTION);
		aryCode[1] = Integer.parseInt(CommonConst.NUM_SELECT_SECTION);
		aryCode[2] = Integer.parseInt(CommonConst.NUM_ALL_SECTION);
		return aryCode;
	}
	
	/**
	 * L[l擾(L[)
	 * @param key		ΏۃL[
	 * @param keyIndex L[CfbNX
	 * @return L[l
	 */
	public static String getKeyValue(String key, int keyIndex) {
		String[] aryKey = key.split(CommonConst.KEY_SEPARATOR);
		return aryKey[keyIndex];
	}
	
	/**
	 * jݒ
	 * @param dayOfWeek j
	 * @return j
	 */
	public static String getDayOfWeek(int dayOfWeek) {
		switch (dayOfWeek) {
			case Calendar.SUNDAY:
				return CommonConst.NAM_SUNDAY;
			case Calendar.MONDAY:
				return CommonConst.NAM_MONDAY;
			case Calendar.TUESDAY:
				return CommonConst.NAM_TUESDAY;
			case Calendar.WEDNESDAY:
				return CommonConst.NAM_WEDNESDAY;
			case Calendar.THURSDAY:
				return CommonConst.NAM_THURSDAY;
			case Calendar.FRIDAY:
				return CommonConst.NAM_FRIDAY;
			case Calendar.SATURDAY:
				return CommonConst.NAM_SATURDAY;
			default:
				return "";
		}
	}
	
	/**
	 * o͔͈̓v_EXg
	 * @return	String[][]	o͔͈͔z
	 */
	public static String[][] getOutputScopeArray() {
		// ͈̓v_EXg쐬
		String[][] aryScope = new String[3][2];
		aryScope[0][0] = CommonConst.CODE_SCOPE_PERSONAL;
		aryScope[0][1] = CommonConst.NAM_SCOPE_PERSONAL;
		aryScope[1][0] = CommonConst.CODE_SCOPE_SECTION;
		aryScope[1][1] = CommonConst.NAM_SCOPE_SECTION;
		aryScope[2][0] = CommonConst.CODE_SCOPE_ALL;
		aryScope[2][1] = CommonConst.NAM_SCOPE_ALL;
		return aryScope;
	}
	
	/**
	 * FXe[^XR[hXg擾
	 * @return FXe[^XR[hXgz
	 * <p>
	 * [0]cFi\j
	 * [1]cꎟF
	 * [2]cꎟ
	 * [3]c񎟏F
	 * [4]c񎟍
	 * [5]c
	 * </p>
	 */
	public static String[] getApprovalStatusCodeArray() {
		// z̍쐬
		String[] aryStatus = new String[6];
		aryStatus[0] = CommonConst.NUM_ATTENDANCE_REQUEST;
		aryStatus[1] = CommonConst.NUM_ATTENDANCE_1ST_APPROVED;
		aryStatus[2] = CommonConst.NUM_ATTENDANCE_1ST_RETURNED;
		aryStatus[3] = CommonConst.NUM_ATTENDANCE_2ND_APPROVED;
		aryStatus[4] = CommonConst.NUM_ATTENDANCE_2ND_RETURNED;
		aryStatus[5] = CommonConst.CODE_DRAFT;
		return aryStatus;
	}
	
	/**
	 * {v_EXg
	 * @return	String[][]	o͔͈͔z
	 */
	public static String[][] getManageArray() {
		// ͈̓v_EXg쐬
		String[][] aryScope = new String[3][2];
		aryScope[0][0] = String.valueOf(getManageCode()[0]);
		aryScope[0][1] = CommonConst.NAM_BELONGING_SECTION;
		aryScope[1][0] = String.valueOf(getManageCode()[1]);
		aryScope[1][1] = CommonConst.NAM_SELECT_SECTION;
		aryScope[2][0] = String.valueOf(getManageCode()[2]);
		aryScope[2][1] = CommonConst.NAM_ALL_SECTION;
		return aryScope;
	}
	
	/**
	 * DTOꐫ`FbN
	 * @param formerDto		ΏDTO
	 * @param currentDto	ΏDTO
	 * @return
	 * <p>
	 * XV̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean chkIdentityDto(BaseDto formerDto, BaseDto currentDto) {
		if (chkExistDto(currentDto)) {
			if (formerDto.getUpdateDate().compareTo(currentDto.getUpdateDate()) == 0) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * E蓖敪v_EXgiL{^Pj
	 * @return E蓖敪z
	 */
	public static String[][] getPositionAllowanceType1() {
		String[][] array = { { CommonConst.CODE_ALLOWANCE_NONE, CommonConst.NAME_ALLOWANCE_NONE },
			{ CommonConst.CODE_ALLOWANCE_STATE_1, CommonConst.NAME_ALLOWANCE_SALARY } };
		return array.clone();
	}
	
	/**
	 * E蓖敪v_EXgiL{ŒPj
	 * @return E蓖敪z
	 */
	public static String[][] getPositionAllowanceType2() {
		String[][] array = { { CommonConst.CODE_ALLOWANCE_NONE, CommonConst.NAME_ALLOWANCE_NONE },
			{ CommonConst.CODE_ALLOWANCE_STATE_1, CommonConst.NAME_ALLOWANCE_FIXED } };
		return array.clone();
	}
	
	/**
	 * E蓖敪v_EXgiL{^P{ŒPj
	 * @return E蓖敪z
	 */
	public static String[][] getPositionAllowanceType3() {
		String[][] array = { { CommonConst.CODE_ALLOWANCE_NONE, CommonConst.NAME_ALLOWANCE_NONE },
			{ CommonConst.CODE_ALLOWANCE_STATE_1, CommonConst.NAME_ALLOWANCE_SALARY },
			{ CommonConst.CODE_ALLOWANCE_STATE_2, CommonConst.NAME_ALLOWANCE_FIXED } };
		return array.clone();
	}
	
	/**
	 * YtOz
	 * @return YtOz
	 */
	public static String[][] getCorrespondFlagArray() {
		return StringUtil.getFlagArray(CommonConst.NAM_DEFAULT_FLAG_OFF, CommonConst.NAM_DEFAULT_FLAG_ON);
	}
	
	/**
	 * tB[h̓̃f[^擾
	 * <p>
	 * CfbNXԍ
	 * </p>
	 * <ol start="0">
	 * 		<li>t@CID</li>
	 * 		<li>Ǘԍ</li>
	 * 		<li>tB[hID</li>
	 * 		<li>tB[h</li>
	 * </ol>
	 * @param csvString Ώە
	 * @param i CfbNX
	 * @return ΏۃCfbNX
	 */
	public static String getCsvSplitInfo(String csvString, int i) {
		//@Ǘԍ擾
		if (StringUtil.isNotNull(csvString)) {
			String[] arl = csvString.split(CommonConst.STR_CSV_SEPARATOR);
			return arl[i];
		}
		return "";
	}
	
	/**
	 * ԃtH[}bg
	 * @param hour 
	 * @return ()
	 */
	public static String getHourString(double hour) {
		NumberFormat nf = NumberFormat.getNumberInstance();
		nf.setMaximumFractionDigits(2);
		nf.setMinimumFractionDigits(2);
		return nf.format(hour);
	}
	
	/**
	 * ԍ擾()
	 * @param date1 It
	 * @param date2 Jnt
	 * @return ԍ(date1 - date2)
	 */
	public static long getTimeRemainder(Date date1, Date date2) {
		final int thousand = 1000;
		long timeRemainder = date1.getTime() - date2.getTime();
		final int min = 60;
		long result = timeRemainder / (thousand * min);
		return result;
	}
	
	/**
	 * Ώ۔NΏ۔Nx擾
	 * @param year		Ώ۔N
	 * @param month		Ώی
	 * @param startmonth	NxJn
	 * @return	Ώ۔Nx
	 */
	public static int getTargetFiscalYear(int year, int month, int startmonth) {
		// NxJnȌꍇΏ۔N̑ONgpB
		// NxJň̏ꍇ͑Ώ۔Ngp
		int fiscalyear = year;
		if (month < startmonth) {
			fiscalyear--;
		}
		return fiscalyear;
	}
	
	/**
	 * Ώ۔NxΏ۔N擾
	 * @param fiscalyear		Ώ۔Nx
	 * @param month				Ώی
	 * @param startmonth		NxJn
	 * @return	Ώ۔N
	 */
	public static int getTargetYear(int fiscalyear, int month, int startmonth) {
		// NxJn̑O͑Ώ۔Nx̗N𗘗p
		// NxJň̌͑Ώ۔Nxgp
		int year = fiscalyear;
		if (month < startmonth) {
			year++;
		}
		return year;
	}
	
	/**
	 * ̑݃`FbN
	 * @since	0.0.2
	 * @param value			ΏۃR[h
	 * @param aryTarget		Ώۖ̂܂ޔz
	 * @return
	 * <p>
	 * ݂̂ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean checkNameExist(String value, String[][] aryTarget) {
		String target = StringUtil.getCodeName(value, aryTarget);
		if (target.equals(value)) {
			return false;
		}
		return true;
	}
	
	/**
	 * Xg̃\[g
	 * @since	0.0.2
	 * @param list		ΏۃXg
	 * @param comp		ΏComparator
	 */
	public static void sortList(List<?> list, Comparator<Object> comp) {
		Collections.sort(list, comp);
	}
	
	/**
	 * Xg̃\[g
	 * @since	0.0.2
	 * @param list			ΏۃXg
	 * @param comp			ΏComparator
	 * @param isAscending	true...Afalse...~
	 */
	public static void sortList(List<?> list, Comparator<Object> comp, boolean isAscending) {
		if (isAscending) {
			sortList(list, comp);
		} else {
			sortList(list, Collections.reverseOrder(comp));
		}
	}
	
	/**
	 * ftHgpX[h`FbN
	 * @param userid			Ώۃ[UID
	 * @param inputPassWord		Ώۓ̓pX[h
	 * @return
	 * <p>
	 * ftHgpX[h̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	public static boolean isDefaultPassWord(String userid, String inputPassWord) throws Exception {
		if (MospUtility.getDigest(MospUtility.getDigest(userid)).equals(MospUtility.getDigest(inputPassWord))) {
			return true;
		}
		return false;
	}
	
	/**
	 * R[h̑݃`FbNB
	 * @param code ΏۃR[h
	 * @param aryTarget Ώ۔z
	 * @return
	 * <p>
	 * ΏۃR[hΏ۔zɊ܂܂ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean checkCodeExist(String code, String[][] aryTarget) {
		for (String[] target : aryTarget) {
			if (code.equals(target[0])) {
				return true;
			}
		}
		return false;
	}
	
}
