<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.mospcommon.system.vo.WorkOnHolidayAgreementListVo"
%><%
WorkOnHolidayAgreementListVo vo = (WorkOnHolidayAgreementListVo)request.getAttribute(MospConst.ATT_VO);
String[] aryWorkOnId		= vo.getEscAryWorkOnId();
String[] aryWorkOnCode		= vo.getEscAryWorkOnCode();
String[] aryWorkTypeName	= vo.getEscAryWorkTypeName();
String[] aryStartDate		= vo.getEscAryStartDate();
String[] aryDelete			= vo.getEscAryDelete();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="agreementList">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Search">
		<table>
			<tr>
				<td id="tdWorkOnCode">
					<span><%= vo.NAM_WORK_ON_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="CodeTextBox" id="<%= WorkOnHolidayAgreementListVo.PRM_TXT_WORK_ON_CODE %>" name="<%= WorkOnHolidayAgreementListVo.PRM_TXT_WORK_ON_CODE %>" value="<%= vo.getEscTxtWorkOnCode() %>" />
				</td>
				<td id="tdWorkTypeName">
					<span><%= vo.NAM_WORK_TYPE_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="TextBox" id="<%= WorkOnHolidayAgreementListVo.PRM_TXT_WORK_TYPE_NAME %>" name="<%= WorkOnHolidayAgreementListVo.PRM_TXT_WORK_TYPE_NAME %>" value="<%= vo.getEscTxtWorkTypeName() %>" />
				</td>
				<td id="tdDelete">
					<span><%= vo.NAM_DELETE %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="DeleteFlagSelect" id="<%= WorkOnHolidayAgreementListVo.PRM_PLT_DELETE %>" name="<%= WorkOnHolidayAgreementListVo.PRM_PLT_DELETE %>">
						<option value=""></option>
						<%= HtmlUtility.getDeleteFlagSelectOption(vo.getPltDelete()) %>
					</select>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'S2531')"><%= CommonConst.NAM_SEARCH %></button>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfo(vo) %>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thWorkOnCode" onclick="doSubmitKey(document.form, 'S2533', '<%= vo.KEY_WORK_ON_CODE %>', '')">&nbsp;<%= vo.NAM_WORK_ON_CODE %>&nbsp;<%= vo.getSortMark(vo.KEY_WORK_ON_CODE) %></th>
					<th id="thWorkTypeName" onclick="doSubmitKey(document.form, 'S2533', '<%= vo.KEY_WORK_TYPE_NAME %>', '')">&nbsp;<%= vo.NAM_WORK_TYPE_NAME %>&nbsp;<%= vo.getSortMark(vo.KEY_WORK_TYPE_NAME) %></th>
					<th id="thStartDate" onclick="doSubmitKey(document.form, 'S2533', '<%= vo.KEY_START_DATE %>', '')">&nbsp;<%= vo.NAM_START_DATE %>&nbsp;<%= vo.getSortMark(vo.KEY_START_DATE) %></th>
					<th id="thDelete" onclick="doSubmitKey(document.form, 'S2533', '<%= vo.KEY_DELETE %>', '')">&nbsp;<%= vo.NAM_DELETE %>&nbsp;<%= vo.getSortMark(vo.KEY_DELETE) %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'S2536', '<%= aryWorkOnId[i] %>' ,  '')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td><%= aryWorkOnCode[i] %></td>
					<td><%= aryWorkTypeName[i] %></td>
					<td><%= aryStartDate[i] %></td>
					<td class="tdDelete"><%= aryDelete[i] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
	<div class="ButtonDiv">
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'S2535')"><%= CommonConst.NAM_MAKE_NEW_DATA %></button>
		<button type="button" class="MenuButton" onclick="doSubmit(document.form, 'S2500')"><%= CommonConst.TTL_LABOR_AGREEMENT_MANAGEMENT %></button>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
