<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.kintai.workflow.vo.OverTimeRequestCardVo"
%><%
OverTimeRequestCardVo vo = (OverTimeRequestCardVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="overTimeRequestList">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Select">
		<table>
			<tr>
				<td id="tdKCode">
					<%= CommonConst.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKCode() %>
				</td>
				<td id="tdKName">
					<%= CommonConst.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKName() %>
				</td>
				<td id="tdStation">
					<%= CommonConst.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblSectionName() %>
				</td>
			</tr>
		</table>
	</div>
	<div class="Card">
		<table>
			<tr>
				<td class="TitleTd">
					<%= HtmlUtility.getRequiredMark() %><%= vo.NAM_WORK_DATE %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<select id="<%= OverTimeRequestCardVo.PRM_PLT_REQUEST_YEAR%>" name="<%= OverTimeRequestCardVo.PRM_PLT_REQUEST_YEAR %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltYear , vo.getPltRequestYear())%>
					</select><%=CommonConst.NAM_YEAR%>
					<select id="<%= OverTimeRequestCardVo.PRM_PLT_REQUEST_MONTH%>" name="<%= OverTimeRequestCardVo.PRM_PLT_REQUEST_MONTH %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltMonth , vo.getPltRequestMonth())%>
					</select><%=CommonConst.NAM_MONTH%>
					<select id="<%= OverTimeRequestCardVo.PRM_PLT_REQUEST_DAY%>" name="<%= OverTimeRequestCardVo.PRM_PLT_REQUEST_DAY %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltDay , vo.getPltRequestDay())%>
					</select><%=CommonConst.NAM_DAY%>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= HtmlUtility.getRequiredMark() %><%=vo.NAM_REQUEST_TIME %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<select id="<%= OverTimeRequestCardVo.PRM_PLT_REQUEST_HOUR %>" name="<%= OverTimeRequestCardVo.PRM_PLT_REQUEST_HOUR %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltHour , vo.getPltRequestHour())%>
					</select><%= CommonConst.NAM_COMMON_TIME %>
					<select id="<%= OverTimeRequestCardVo.PRM_PLT_REQUEST_MIN %>" name="<%= OverTimeRequestCardVo.PRM_PLT_REQUEST_MIN %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltMin , vo.getPltRequestMin())%>
					</select><%= CommonConst.NAM_MINUTES %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= HtmlUtility.getRequiredMark() %><%= vo.NAM_REASON %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<input type="text" id="<%= OverTimeRequestCardVo.PRM_TXT_REASON %>" name="<%= OverTimeRequestCardVo.PRM_TXT_REASON %>" value="<%= vo.getEscTxtReason() %>">
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_STATUS %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<%= vo.getEscLblStatus() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_APPROVER %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<%= vo.getEscLblApprover() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_AUTHOR_COMMENT %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<%= vo.getEscLblComment() %>
				</td>
			</tr>
		</table>		
		<input type="hidden" id="<%= OverTimeRequestCardVo.PRM_HID_VOUCHER %>" name="<%= OverTimeRequestCardVo.PRM_HID_VOUCHER %>" value="<%= vo.getHidVoucher() %>">
	</div>
	<div class="Footer">
		<button id="btnDraft" type="button" class="ExecuteButton" onclick="submitForm(document.form, '<%= CommonConst.CODE_DRAFT %>')"><%= CommonConst.NAME_DRAFT %></button>
		<button id="btnRequest" type="button" class="ExecuteButton" onclick="submitForm(document.form, '')"><%= CommonConst.NAM_APPLICATION %></button>
		<button id="btnCancel" type="button" class="ExecuteButton" onclick="doSubmitMessage(document.form, 'K1419', 'WF0037', '')"><%= CommonConst.NAM_CANCEL %></button>
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form,'K1412')"><%=CommonConst.NAM_TO_LIST %></button>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
