<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.common.common.BaseVo"
import = "jp.mosp.kintai.workflow.vo.OverTimeApprovalCardVo"
%><%
OverTimeApprovalCardVo vo = (OverTimeApprovalCardVo)request.getAttribute(MospConst.ATT_VO);
String[][] aryComments = vo.getEscAryComments();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="overTimeRequestList">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Card">
		<table id="tblRequest">
			<thead>
				<tr>
					<th colspan="2">
						<%= CommonConst.NAM_APPLICATION %><%= CommonConst.NAM_COMMON_ITEM %>
					</th>
				</tr>
			</thead>
			<tr>
				<td class="TitleTd">
					<%= CommonConst.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<%= vo.getEscLblKCode() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= CommonConst.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<%= vo.getEscLblKName() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= CommonConst.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<%= vo.getEscLblSectionName() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_WORK_DATE %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<%= vo.getEscLblWorkDate() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%=vo.NAM_OVER_TIME %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<%= vo.getEscLblOverTime() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_OVER_TIME_MONTHLY %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<span id="spnMonthly"><%= BaseVo.escapeHTML(vo.getLblOverTimeMonthly()) %></span>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_REASON %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<%= vo.getEscLblReason() %>
				</td>
			</tr>
		</table>
		<table id="tblApproval">
			<thead>
				<tr>
					<th colspan="2">
						<%= CommonConst.NAM_APPROVED %><%= CommonConst.NAM_COMMON_ITEM %>
					</th>
				</tr>
			</thead>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_STATUS %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<%= vo.getEscLblApprovalStatus() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_REQUEST_DATE %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<%= vo.getEscLblReqestDate() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_COMMENT %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<input id="<%= OverTimeApprovalCardVo.PRM_TXT_COMMENT %>" name="<%= OverTimeApprovalCardVo.PRM_TXT_COMMENT %>" value="<%= vo.getEscTxtComment() %>">
				</td>
			</tr>
		</table>
		<input type="hidden" id="<%= OverTimeApprovalCardVo.PRM_HID_VOUCHER %>" name="<%= OverTimeApprovalCardVo.PRM_HID_VOUCHER %>" value="<%= vo.getHidVoucher() %>">
	</div>
	<div class="Footer">
		<button id="btnApprove" type="button" class="ExecuteButton" onclick="submitForm(document.form, 'K2137')"><%= CommonConst.NAM_APPROVED %></button>
		<button id="btnReturn" type="button" class="ExecuteButton" onclick="submitForm(document.form, 'K2138')"><%= CommonConst.NAM_APPROVAL_DENY %></button>
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form,'K2132')"><%=CommonConst.NAM_TO_LIST %></button>
	</div>
</div>
<div id="comment">
	<div class="List">
		<table>
			<thead>
				<tr>
					<th id="thAuthor"><%= CommonConst.NAM_APPROVER %></th>
					<th id="thComment"><%= vo.NAM_AUTHOR_COMMENT %></th>
				</tr>
			</thead>
			<tbody>
				
<%
for (int i = 0 ; i < aryComments.length; i++) {
%>
				<tr>
					<td class="AuthorTd"><%= aryComments[i][0] %></td>
					<td class="CommentTd"><%= aryComments[i][1] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
