<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "128kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.common.common.BaseVo"
import = "jp.mosp.kintai.workflow.vo.ApprovalCardVo"
%><%
ApprovalCardVo vo = (ApprovalCardVo) request.getAttribute(MospConst.ATT_VO);
String[][] aryAllowance = vo.getAryAllowance();
String[] aryRequest = vo.getAryLblHolidayRequest();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="approvalCard">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Select">
		<table>
			<tr>
				<td id="tdKCode">
					<%= CommonConst.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKCode() %>
				</td>
				<td id="tdKName">
					<%= CommonConst.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKName() %>
				</td>
				<td id="tdStation">
					<%= CommonConst.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblSectionName() %>
				</td>
				<td id="tdDate">
					<%= CommonConst.NAM_DATE %><%= CommonConst.STR_TITLE_SEPARATOR %><%= BaseVo.escapeHTML(vo.getLblDate()) %>
					<input type="hidden" id="<%= ApprovalCardVo.PRM_PLT_YEAR %>" name="<%= ApprovalCardVo.PRM_PLT_YEAR %>" value="<%= BaseVo.escapeHTML(vo.getPltYear()) %>">
					<input type="hidden" id="<%= ApprovalCardVo.PRM_PLT_MONTH %>" name="<%= ApprovalCardVo.PRM_PLT_MONTH %>" value="<%= BaseVo.escapeHTML(vo.getPltMonth()) %>">
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'K2122')"><%=CommonConst.TTL_APPROVAL_LIST%></button>
				</td>
			</tr>
		</table>
	</div>
<!--	ԍ	-->
	<div class="Card">
		<table id="tblTime">
			<tr>
				<th >
					<%= CommonConst.NAM_APPLICATION %><%= CommonConst.NAM_COMMON_ITEM %>
				</th>
			</tr>
			<tr>
				<td>
					<div>
						<%= vo.NAM_WORKING_TYPE %><%= CommonConst.STR_TITLE_SEPARATOR %><%= BaseVo.escapeHTML(vo.getLblWorkType()) %>
					</div>
				</td>
			</tr>
			<tr>
				<td>
					<div>
						<%= CommonConst.NAM_WORKING_TABLE_INFO %><%= CommonConst.STR_TITLE_SEPARATOR %>
						<%= BaseVo.escapeHTML(vo.getLblStartQuitTime()) %>
					</div>
					<div>
						<%= vo.NAM_HALF_HOLIDAY %><%= CommonConst.STR_TITLE_SEPARATOR %><%= BaseVo.escapeHTML(vo.getLblHalfHoliday()) %>
					</div>
				</td>
			</tr>
			<tr>
				<td>
					<div>
						<%= vo.NAM_WORKING_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %><span><%= BaseVo.escapeHTML(vo.getLblWorkTime()) %></span>
					</div>
					<div>
						<%= vo.NAM_LATE_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %><span><%= BaseVo.escapeHTML(vo.getLblLateTime()) %></span>
					</div>
					<div>
						<%= vo.NAM_LEAVE_EARLY_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %><span><%= BaseVo.escapeHTML(vo.getLblLeaveEarlyTime()) %></span>
					</div>
				</td>
			</tr>
			<tr>
				<td >
					<div id="divOverTime">
						<%= vo.NAM_OVER_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %><span><%= BaseVo.escapeHTML(vo.getLblOverTime()) %></span>
					</div>
					<div>
						<%= vo.NAM_OVER_TIME_REQUEST %><%= CommonConst.STR_TITLE_SEPARATOR %><%= BaseVo.escapeHTML(vo.getLblOverTimeRequest()) %>
					</div>
				</td>
			</tr>
			<tr>
				<td >
					<div>
						<%= vo.NAM_INTERVAL_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %><span><%= BaseVo.escapeHTML(vo.getLblBreakTime()) %></span>
					</div>
					<div>
						<%= vo.NAM_LATE_NIGHT %><%= CommonConst.STR_TITLE_SEPARATOR %><span><%= BaseVo.escapeHTML(vo.getLblLateNightTime()) %></span>
					</div>
				</td>
			</tr>
			<tr>
				<td >
					<div>
						<%= vo.NAM_WORK_ON_HOLIDAY_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %><span><%= BaseVo.escapeHTML(vo.getLblWorkOnHolidayTime()) %></span>
					</div>
					<div>
						<%= vo.NAM_WORK_ON_HOLIDAY %><%= CommonConst.STR_TITLE_SEPARATOR %><%= BaseVo.escapeHTML(vo.getLblWorkOnHoliday()) %>
					</div>
					<div>
						<%= vo.NAM_ACTUAL_WORK_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %><span><%= BaseVo.escapeHTML(vo.getLblActualTime()) %></span>
					</div>
				</td>
			</tr>
			<tr>
				<th>
					<%= vo.NAM_HOLIDAY_REQUEST %>
				</th>
			</tr>
			<tr>
				<td>
<%
for (int i = 0; i < aryRequest.length; i++) {
%>
					<div>
						<%= BaseVo.escapeHTML(aryRequest[i]) %>
					</div>
<% 
} 
%>
				</td>
			</tr>
		</table>
<!--	xލ	-->
		<table id="tblLateLeave">
			<tr>
				<th colspan="6">
					<%= CommonConst.NAM_ARRIVE_LATE %><%= CommonConst.NAM_LEAVE_EARLY %><%= CommonConst.NAM_COMMON_ITEM %>
				</th>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_LATE_REASON %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<%= BaseVo.escapeHTML(vo.getLblLateReason()) %>
				</td>
				<td class="TitleTd">
					<%= vo.NAM_LATE_CERTIFICATE %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<%= BaseVo.escapeHTML(vo.getLblLateCertificate()) %>
				</td>
				<td class="TitleTd">
					<%= vo.NAM_LATE_COMMENT %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<%= BaseVo.escapeHTML(vo.getLblLateComment()) %>
				</td>
			</tr>			
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_LEAVE_EARLY_REASON %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<%= BaseVo.escapeHTML(vo.getLblLeaveEarlyReason()) %>
				</td>
				<td class="TitleTd">
					<%= vo.NAM_LEAVE_EARLY_CERTIFICATE %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<%= BaseVo.escapeHTML(vo.getLblLeaveEarlyCertificate()) %>
				</td>
				<td class="TitleTd">
					<%= vo.NAM_LEAVE_EARLY_COMMENT %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<%= BaseVo.escapeHTML(vo.getLblLeaveEarlyComment()) %>
				</td>
			</tr>
		</table>
		<table>
			<tr>
				<th colspan="2">
					<%= CommonConst.NAM_ALLOWANCE %><%= CommonConst.NAM_COMMON_ITEM %>
				</th>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_ALLOWANCE %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<div class="AllowanceDiv">
						<ul>
							<li>
								<%= aryAllowance[8][1] %><%= CommonConst.STR_TITLE_SEPARATOR %>
								<%= BaseVo.escapeHTML(vo.getLblSyokuji()) %>					
							</li>
							<li>
								<%= aryAllowance[9][1] %><%= CommonConst.STR_TITLE_SEPARATOR %>
								<%= BaseVo.escapeHTML(vo.getLblCyoku1()) %>					
							</li>
							<li>
								<%= aryAllowance[10][1] %><%= CommonConst.STR_TITLE_SEPARATOR %>
								<%= BaseVo.escapeHTML(vo.getLblCyoku2()) %>					
							</li>
							<li>
								<%= aryAllowance[11][1] %><%= CommonConst.STR_TITLE_SEPARATOR %>
								<%= BaseVo.escapeHTML(vo.getLblCyoku3()) %>							
							</li>
						</ul>
					</div>
					<div class="AllowanceDiv">
						<ul>
							<li>
								<%= aryAllowance[12][1] %><%= CommonConst.STR_TITLE_SEPARATOR %>
								<%= BaseVo.escapeHTML(vo.getLblHoka1()) %>
							</li>
							<li>
								<%= aryAllowance[13][1] %><%= CommonConst.STR_TITLE_SEPARATOR %>
								<%= BaseVo.escapeHTML(vo.getLblHoka2()) %>
							</li>
							<li>
								<%= aryAllowance[14][1] %><%= CommonConst.STR_TITLE_SEPARATOR %>
								<%= BaseVo.escapeHTML(vo.getLblHoka3()) %>
							</li>
							<li>
								<%= aryAllowance[15][1] %><%= CommonConst.STR_TITLE_SEPARATOR %>
								<%= BaseVo.escapeHTML(vo.getLblHoka4()) %>
							</li>
							<li>
								<%= aryAllowance[16][1] %><%= CommonConst.STR_TITLE_SEPARATOR %>
								<%= BaseVo.escapeHTML(vo.getLblHoka5()) %>
							</li>
						</ul>
					</div>
				</td>
			</tr>
		</table>
		<table id="tblApproval">
			<tr>
				<th colspan="2">
					<%= CommonConst.NAM_APPROVED %><%= CommonConst.NAM_COMMON_ITEM %>
				</th>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_STATUS %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<%= BaseVo.escapeHTML(vo.getLblStatus()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_COMMENT %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td >
					<input type="text" id="<%= ApprovalCardVo.PRM_TXT_COMMENT %>" name="<%= ApprovalCardVo.PRM_TXT_COMMENT %>" value="<%= BaseVo.escapeHTML(vo.getTxtComment()) %>">
				</td>
			</tr>
		</table>
	</div>
	<div class="Footer">
		<button type="button" class="ExecuteButton" id="btnApprove" onclick="submitForm(document.form, 'K2127')"><%= CommonConst.NAM_APPROVED %></button>
		<button type="button" class="ExecuteButton" id="btnReturn" onclick="submitForm(document.form, 'K2129')"><%= CommonConst.NAM_APPROVAL_DENY %></button>
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form,'K2122')"><%= CommonConst.NAM_TO_LIST %></button>
	</div>
</div>
<%=HtmlUtility.getFooter(vo)%>
