<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "16kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.kintai.payroll.vo.SubHolidayAttitudeCardVo"
%><%
SubHolidayAttitudeCardVo vo = (SubHolidayAttitudeCardVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="subHolidayAttitudeCard">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Card">
		<table>
			<tr>
				<td class="TitleTd"><%= vo.NAM_OCCUR_MONTH %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td colspan="2" class="InputTd">
					<%= vo.getEscLblOccurYear() %>
					<%= CommonConst.NAM_YEAR %>
					<%= vo.getEscLblOccurMonth() %>
					<%= CommonConst.NAM_MONTH %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_CLOSE_DATE %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td colspan="2" class="InputTd">
					<%= vo.getEscLblCloseDate() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= HtmlUtility.getRequiredMark() %><%= vo.NAM_ATTITUDE_STATUS %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td colspan="2" class="InputTd">
					<select id="<%= SubHolidayAttitudeCardVo.PRM_PLT_ATTITUDE_STATUS %>" name="<%= SubHolidayAttitudeCardVo.PRM_PLT_ATTITUDE_STATUS %>" onchange="changeAttitudeView()">
						<%= HtmlUtility.getSelectOption(vo.aryPltAttitudeStatus, vo.getPltAttitudeStatus()) %>
					</select>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"></td>
				<td class="InputTd"><%= vo.NAM_WEEKDAY %></td>
				<td class="InputTd"><%= vo.NAM_STANDARD_WEEK_HOLIDAY %></td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_RATE %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="InputTd">
					<%= vo.getEscHidRate() %>
				</td>
				<td class="InputTd">
					<%= vo.getEscHidHolidayRate() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_CONVERTED_MONTHLY_OVER_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="InputTd">
					<%= vo.getEscHidConvertedMonthlyOverTimeHour() %>
					<%= CommonConst.NAM_COMMON_TIME %>
					<%= vo.getEscHidConvertedMonthlyOverTimeMin() %>
					<%= CommonConst.NAM_MINUTES %>
					<input type="hidden" id="<%= SubHolidayAttitudeCardVo.PRM_HID_CONVERTED_MONTHLY_OVER_TIME_HOUR %>" value="<%= vo.getEscHidConvertedMonthlyOverTimeHour() %>" />
					<input type="hidden" id="<%= SubHolidayAttitudeCardVo.PRM_HID_CONVERTED_MONTHLY_OVER_TIME_MIN %>" value="<%= vo.getEscHidConvertedMonthlyOverTimeMin() %>" />
				</td>
				<td class="InputTd">
					<%= vo.getEscHidConvertedMonthlyWeekHolidayHour() %>
					<%= CommonConst.NAM_COMMON_TIME %>
					<%= vo.getEscHidConvertedMonthlyWeekHolidayMin() %>
					<%=CommonConst.NAM_MINUTES%>
					<input type="hidden" id="<%= SubHolidayAttitudeCardVo.PRM_HID_CONVERTED_MONTHLY_WEEK_HOLIDAY_HOUR %>" value="<%= vo.getEscHidConvertedMonthlyWeekHolidayHour() %>" />
					<input type="hidden" id="<%= SubHolidayAttitudeCardVo.PRM_HID_CONVERTED_MONTHLY_WEEK_HOLIDAY_MIN %>" value="<%= vo.getEscHidConvertedMonthlyWeekHolidayMin() %>" />
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= HtmlUtility.getRequiredMark() %><%= vo.NAM_PAYMENT_ACQUIRE_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="InputTd">
					<input type="text" class="NumberTextBox" id="<%= SubHolidayAttitudeCardVo.PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR %>" name="<%= SubHolidayAttitudeCardVo.PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR %>" value="<%=vo.getEscTxtPaymentAcquireTimeHour()%>" />
					<%= CommonConst.NAM_COMMON_TIME %>
					<input type="text" class="NumberTextBox" id="<%= SubHolidayAttitudeCardVo.PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN %>" name="<%= SubHolidayAttitudeCardVo.PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN %>" value="<%=vo.getEscTxtPaymentAcquireTimeMin()%>" />
					<%= CommonConst.NAM_MINUTES %>
				</td>
				<td class="InputTd">
					<input type="text" class="NumberTextBox" id="<%= SubHolidayAttitudeCardVo.PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR %>" name="<%= SubHolidayAttitudeCardVo.PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR %>" value="<%= vo.getEscTxtPaymentAcquireHolidayHour() %>" />
					<%= CommonConst.NAM_COMMON_TIME %>
					<input type="text" class="NumberTextBox" id="<%= SubHolidayAttitudeCardVo.PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN %>" name="<%= SubHolidayAttitudeCardVo.PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN %>" value="<%= vo.getEscTxtPaymentAcquireHolidayMin() %>" />
					<%= CommonConst.NAM_MINUTES %>
					<input type="hidden" id="<%= SubHolidayAttitudeCardVo.PRM_HID_PAYMENT_QUIT_TIME %>" name="<%= SubHolidayAttitudeCardVo.PRM_HID_PAYMENT_QUIT_TIME %>" value="<%= vo.getEscHidPaymentQuitTime() %>" />
				</td>
			</tr>
		</table>
	</div>
</div>
<div class="Footer">
	<button type="button" class="ExecuteButton" id="btnDraft" onclick="submitForm(document.form, 'K1152')"><%= CommonConst.NAME_DRAFT %></button>
	<button type="button" class="ExecuteButton" id="btnRegist" onclick="submitForm(document.form, 'K1153')"><%= CommonConst.NAM_REGIST %></button>
	<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'K1150')"><%= CommonConst.NAM_RE_SEARCH %></button>
</div>
<%= HtmlUtility.getFooter(vo) %>
