<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "128kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.common.common.BaseVo"
import = "jp.mosp.kintai.kintai.vo.AttendanceQuitCardVo"
%><%
AttendanceQuitCardVo vo = (AttendanceQuitCardVo) request.getAttribute(MospConst.ATT_VO);
String[][] aryAllowance = vo.getAryAllowance();
String[] aryHolidayStatus = vo.getAryHolidayRequestStatus();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="quitCard">
	<%=HtmlUtility.getMessages(vo)%>
	<jsp:include page="attendanceMenu.jsp" />
	<div class="changeDiv">
		<button type="button" id="btnReflect" onclick="doSubmit(document.form, 'K1115')">
			<%= CommonConst.NAM_REFLECT_SCHEDULE %>
		</button>
		<button type="button" id="btnReset" onclick="doSubmitKey(document.form, 'K1110', '<%= vo.getEscHidKCode() %>', '<%= vo.getEscHidDate() %>')">
			<%= CommonConst.NAM_RE_SEARCH %>
		</button>
		<button type="button" id="btnCalc" onclick="doSubmitKey(document.form, 'K1116', '<%= vo.getEscHidKCode() %>', '<%= vo.getEscHidDate() %>')">
			<%= CommonConst.NAM_CALCULATE %>
		</button>
	</div>
	<div class="Card">
		<table id="tblQuit">
			<thead>
				<tr>
					<th id="thTime" colspan="3">
						<%= CommonConst.NAM_QUIT_TIME %><%= CommonConst.NAM_COMMON_ITEM %>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td class="TitleTd">
						<%= HtmlUtility.getRequiredMark() %><%= vo.NAM_QUIT_TIME %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_QUIT_HOUR %>" name="<%= AttendanceQuitCardVo.PRM_TXT_QUIT_HOUR %>" value="<%= BaseVo.escapeHTML(vo.getTxtQuitHour()) %>" />
						<%=CommonConst.STR_TIME_SEPARATOR%>
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_QUIT_MIN %>" name="<%= AttendanceQuitCardVo.PRM_TXT_QUIT_MIN %>" value="<%= BaseVo.escapeHTML(vo.getTxtQuitMin()) %>" />
					</td>
					<td>
						<%= CommonConst.MSG_QUIT_TIME_NEXT_DAY %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%=vo.NAM_WORKING_TYPE%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<%= BaseVo.escapeHTML(vo.getLblWorkType()) %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%=vo.NAM_HALF_HOLIDAY%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<select id="<%= AttendanceQuitCardVo.PRM_PLT_HALF_HOLIDAY %>" name="<%= AttendanceQuitCardVo.PRM_PLT_HALF_HOLIDAY %>">
							<option value=""></option>
							<%=HtmlUtility.getSelectOption(vo.aryPltHalfHoliday, vo.getPltHalfHoliday())%>
						</select>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_WORKING_TIME %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_WORK_HOUR %>" name="<%= AttendanceQuitCardVo.PRM_TXT_WORK_HOUR %>" value="<%= BaseVo.escapeHTML(vo.getTxtWorkHour()) %>" />
						<%=CommonConst.NAM_COMMON_TIME %>
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_WORK_MIN %>" name="<%= AttendanceQuitCardVo.PRM_TXT_WORK_MIN %>" value="<%= BaseVo.escapeHTML(vo.getTxtWorkMin()) %>" />
						<%=CommonConst.NAM_MINUTES %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_INTERVAL_TIME %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_BREAK_HOUR %>" name="<%= AttendanceQuitCardVo.PRM_TXT_BREAK_HOUR %>" value="<%= BaseVo.escapeHTML(vo.getTxtBreakHour()) %>" />
						<%=CommonConst.NAM_COMMON_TIME %>
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_BREAK_MIN %>" name="<%= AttendanceQuitCardVo.PRM_TXT_BREAK_MIN %>" value="<%= BaseVo.escapeHTML(vo.getTxtBreakMin()) %>" />
						<%=CommonConst.NAM_MINUTES %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_ACTUAL_WORK_TIME %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<%= BaseVo.escapeHTML(vo.getLblActualHour()) %>
						<%=CommonConst.NAM_COMMON_TIME %>
						<%= BaseVo.escapeHTML(vo.getLblActualMin()) %>
						<%=CommonConst.NAM_MINUTES %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_LEAVE_EARLY_REASON %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<select class="SectionSelect" id="<%= AttendanceQuitCardVo.PRM_PLT_LEAVE_EARLY_REASON %>" name="<%= AttendanceQuitCardVo.PRM_PLT_LEAVE_EARLY_REASON %>">
							<option value=""></option>
							<%=HtmlUtility.getSelectOption(vo.aryPltLeaveEarlyReason, vo.getPltLeaveEarlyReason())%>
						</select>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_LEAVE_EARLY_TIME %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_LEAVE_EARLY_HOUR %>" name="<%= AttendanceQuitCardVo.PRM_TXT_LEAVE_EARLY_HOUR %>" value="<%= BaseVo.escapeHTML(vo.getTxtLeaveEarlyHour()) %>" />
						<%=CommonConst.NAM_COMMON_TIME %>
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_LEAVE_EARLY_MIN %>" name="<%= AttendanceQuitCardVo.PRM_TXT_LEAVE_EARLY_MIN %>" value="<%= BaseVo.escapeHTML(vo.getTxtLeaveEarlyMin()) %>" />
						<%=CommonConst.NAM_MINUTES %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_LEAVE_EARLY_CERTIFICATE %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<select id="<%= AttendanceQuitCardVo.PRM_PLT_LEAVE_EARLY_CERTIFICATE %>" name="<%= AttendanceQuitCardVo.PRM_PLT_LEAVE_EARLY_CERTIFICATE %>">
							<option value=""></option>
							<%=HtmlUtility.getSelectOption(vo.aryPltLeaveEarlyCertificate, vo.getPltLeaveEarlyCertificate())%>
						</select>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_LEAVE_EARLY_COMMENT %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<input type="text" class="TextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_LEAVE_EARLY_COMMENT %>" name="<%= AttendanceQuitCardVo.PRM_TXT_LEAVE_EARLY_COMMENT %>" value="<%= BaseVo.escapeHTML(vo.getTxtLeaveEarlyComment()) %>" />
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_OVER_TIME %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_OVER_HOUR %>" name="<%= AttendanceQuitCardVo.PRM_TXT_OVER_HOUR %>" value="<%= BaseVo.escapeHTML(vo.getTxtOverHour()) %>" />
						<%=CommonConst.NAM_COMMON_TIME %>
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_OVER_MIN %>" name="<%= AttendanceQuitCardVo.PRM_TXT_OVER_MIN %>" value="<%= BaseVo.escapeHTML(vo.getTxtOverMin()) %>" />
						<%=CommonConst.NAM_MINUTES %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_WORK_ON_HOLIDAY %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_WORK_ON_HOLIDAY_HOUR %>" name="<%= AttendanceQuitCardVo.PRM_TXT_WORK_ON_HOLIDAY_HOUR %>" value="<%= BaseVo.escapeHTML(vo.getTxtWorkOnHolidayHour()) %>" />
						<%=CommonConst.NAM_COMMON_TIME %>
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_WORK_ON_HOLIDAY_MIN %>" name="<%= AttendanceQuitCardVo.PRM_TXT_WORK_ON_HOLIDAY_MIN %>" value="<%= BaseVo.escapeHTML(vo.getTxtWorkOnHolidayMin()) %>" />
						<%=CommonConst.NAM_MINUTES %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_LATE_NIGHT %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="2">
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_LATE_NIGHT_HOUR %>" name="<%= AttendanceQuitCardVo.PRM_TXT_LATE_NIGHT_HOUR %>" value="<%= BaseVo.escapeHTML(vo.getTxtLateNightHour()) %>" />
						<%=CommonConst.NAM_COMMON_TIME %>
						<input type="text" class="NumberTextBox" id="<%= AttendanceQuitCardVo.PRM_TXT_LATE_NIGHT_MIN %>" name="<%= AttendanceQuitCardVo.PRM_TXT_LATE_NIGHT_MIN %>" value="<%= BaseVo.escapeHTML(vo.getTxtLateNightMin()) %>" />
						<%=CommonConst.NAM_MINUTES %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_ALLOWANCE %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="checkTd">
						<div>
							<%= aryAllowance[8][1] %><%=CommonConst.STR_TITLE_SEPARATOR%>
							<%= AttendanceQuitCardVo.getCheckBox(AttendanceQuitCardVo.PRM_CKB_SYOKUJI, AttendanceQuitCardVo.PRM_CKB_SYOKUJI, vo.getCheckBoxChecked(vo.getCkbSyokuji())) %>					
						</div>
						<div>
							<%= aryAllowance[9][1] %><%=CommonConst.STR_TITLE_SEPARATOR%>
							<%= AttendanceQuitCardVo.getCheckBox(AttendanceQuitCardVo.PRM_CKB_CYOKU1, AttendanceQuitCardVo.PRM_CKB_CYOKU1, vo.getCheckBoxChecked(vo.getCkbCyoku1())) %>					
						</div>
						<div>
							<%= aryAllowance[10][1] %><%=CommonConst.STR_TITLE_SEPARATOR%>
							<%= AttendanceQuitCardVo.getCheckBox(AttendanceQuitCardVo.PRM_CKB_CYOKU2, AttendanceQuitCardVo.PRM_CKB_CYOKU2, vo.getCheckBoxChecked(vo.getCkbCyoku2())) %>					
						</div>
						<div>
							<%= aryAllowance[11][1] %><%=CommonConst.STR_TITLE_SEPARATOR%>
							<%= AttendanceQuitCardVo.getCheckBox(AttendanceQuitCardVo.PRM_CKB_CYOKU3, AttendanceQuitCardVo.PRM_CKB_CYOKU3, vo.getCheckBoxChecked(vo.getCkbCyoku3())) %>					
						</div>
					</td>	
					<td class="checkTd">	
						<div>
							<%= aryAllowance[12][1] %><%=CommonConst.STR_TITLE_SEPARATOR%>
							<%= AttendanceQuitCardVo.getCheckBox(AttendanceQuitCardVo.PRM_CKB_HOKA1, AttendanceQuitCardVo.PRM_CKB_HOKA1, vo.getCheckBoxChecked(vo.getCkbHoka1())) %>					
						</div>
						<div>
							<%= aryAllowance[13][1] %><%=CommonConst.STR_TITLE_SEPARATOR%>
							<%= AttendanceQuitCardVo.getCheckBox(AttendanceQuitCardVo.PRM_CKB_HOKA2, AttendanceQuitCardVo.PRM_CKB_HOKA2, vo.getCheckBoxChecked(vo.getCkbHoka2())) %>					
						</div>
						<div>
							<%= aryAllowance[14][1] %><%=CommonConst.STR_TITLE_SEPARATOR%>
							<%= AttendanceQuitCardVo.getCheckBox(AttendanceQuitCardVo.PRM_CKB_HOKA3, AttendanceQuitCardVo.PRM_CKB_HOKA3, vo.getCheckBoxChecked(vo.getCkbHoka3())) %>					
						</div>
						<div>
							<%= aryAllowance[15][1] %><%=CommonConst.STR_TITLE_SEPARATOR%>
							<%= AttendanceQuitCardVo.getCheckBox(AttendanceQuitCardVo.PRM_CKB_HOKA4, AttendanceQuitCardVo.PRM_CKB_HOKA4, vo.getCheckBoxChecked(vo.getCkbHoka4())) %>					
						</div>
						<div>
							<%= aryAllowance[16][1] %><%=CommonConst.STR_TITLE_SEPARATOR%>
							<%= AttendanceQuitCardVo.getCheckBox(AttendanceQuitCardVo.PRM_CKB_HOKA5, AttendanceQuitCardVo.PRM_CKB_HOKA5, vo.getCheckBoxChecked(vo.getCkbHoka5())) %>					
						</div>
					</td>
				</tr>
			</tbody>
		</table>
<!--	2009/12/01	m.yoshida	e\	-->
		<table id="tblRequest">
			<thead>
				<tr>
					<th colspan="4">
						<%= CommonConst.NAM_APPLICATION %><%= CommonConst.NAM_COMMON_ITEM %>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_OVER_TIME_REQUEST %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<%= BaseVo.escapeHTML(vo.getLblOverTimeRequest()) %>
					</td>
					<td class="TitleTd">
						<%= vo.NAM_REQUEST_STATUS %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<%= BaseVo.escapeHTML(vo.getLblOverTimeRequestStatus()) %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= vo.NAM_HOLIDAY_REQUEST %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd" colspan="3">
						<ol>
<%
for (int i = 0; i < aryHolidayStatus.length; i++) {
%>
							<li>
								<%= BaseVo.escapeHTML(aryHolidayStatus[i]) %>
							</li>
<%
}
%>
						</ol>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
	<div class="Footer">
		<button type="button" class="ExecuteButton" id="btnDraft" onclick="submitForm(document.form, 'K1114')"><%=CommonConst.NAME_DRAFT%></button>
		<button type="button" class="ExecuteButton" id="btnRegist" onclick="submitForm(document.form, 'K1112')"><%=CommonConst.NAM_REGIST%></button>
		<button type="button" class="ExecuteButton" id="btnDelete" onclick="doSubmitMessage(document.form, 'K1113','QC0002' ,'')"><%= CommonConst.NAM_DELETE %></button>
	</div>
</div>
<%=HtmlUtility.getFooter(vo)%>
