/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.util.List;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.ListVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.VoInterface;

public class HtmlUtility {
    public static String getHeader(VoInterface vo) throws IllegalAccessException {
        int i;
        List<String> extraCss = vo.getExtraCss();
        List<String> extraJs = vo.getExtraJs();
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"Shift_JIS\" ?>");
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ja\">");
        sb.append("<head>");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=Shift_JIS\">");
        sb.append("<meta http-equiv=\"Content-Script-Type\" content=\"text/javascript\">");
        sb.append("<meta name=\"robots\" content=\"noindex,nofollow,noarchive\" />");
        sb.append("<title>");
        sb.append(vo.getEscTitle());
        sb.append("&nbsp;");
        sb.append(vo.getEscVersion());
        sb.append("</title>");
        sb.append("<link href=\"..");
        sb.append(vo.getEscCommonCss());
        sb.append("\" rel=\"stylesheet\" type=\"text/css\" />");
        if (extraCss != null) {
            for (i = 0; i < extraCss.size(); ++i) {
                sb.append("<link href=\"..");
                sb.append(HtmlUtility.escapeHTML(extraCss.get(i)));
                sb.append("\" rel=\"stylesheet\" type=\"text/css\" />");
            }
        }
        sb.append("<script type=\"text/javascript\" src=\"..");
        sb.append("/pub/common/js/mosp.js");
        sb.append("\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"..");
        sb.append("/pub/common/js/message.js");
        sb.append("\"></script>");
        if (extraJs != null) {
            for (i = 0; i < extraJs.size(); ++i) {
                sb.append("<script type=\"text/javascript\" src=\"..");
                sb.append(HtmlUtility.escapeHTML(extraJs.get(i)));
                sb.append("\"></script>");
            }
        }
        sb.append("<script type=\"text/javascript\">");
        try {
            sb.append(vo.getDirectJs(vo.getClass()));
        }
        catch (NullPointerException e) {
            sb.append(vo.getDirectJs(vo.getClass(), vo));
        }
        if (vo.getIsDialog()) {
            sb.append("isDialog = true;");
        }
        sb.append("</script>");
        sb.append("</head>");
        sb.append("<body id=\"base\" onLoad=\"onLoad()\" onUnload=\"onUnload()\">");
        sb.append("<form name=\"form\">");
        return sb.toString();
    }

    public static String getFooter(VoInterface vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("<input type=\"hidden\" name=\"");
        sb.append("cmd");
        sb.append("\" value=\"\" />");
        sb.append("<input type=\"hidden\" name=\"");
        sb.append("key1");
        sb.append("\" value=\"\" />");
        sb.append("<input type=\"hidden\" name=\"");
        sb.append("key2");
        sb.append("\" value=\"\" />");
        sb.append("<input type=\"hidden\" name=\"");
        sb.append("procSeq");
        sb.append("\" id=\"");
        sb.append("procSeq");
        sb.append("\" value=\"");
        sb.append(vo.getEscProcSeq());
        sb.append("\" />");
        sb.append("<input type=\"hidden\" name=\"");
        sb.append("resType");
        sb.append("\" value=\"\" />");
        sb.append("</form>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    public static String getMessages(VoInterface vo) {
        StringBuffer sb = new StringBuffer();
        List<String> errMessage = vo.getErrMessage();
        if (vo.getEscMessage() != null && !vo.getEscMessage().equals("")) {
            sb.append("<div class=\"MessageLabel\" id=\"lblMessage\">");
            sb.append(vo.getEscMessage());
            sb.append("</div>");
        }
        if (errMessage != null && errMessage.size() > 0) {
            sb.append("<div class=\"ErrorMessageLabel\" id=\"lblErrorMessage\">");
            for (int i = 0; i < errMessage.size(); ++i) {
                sb.append(errMessage.get(i));
                sb.append("<br />");
            }
            sb.append("</div>");
        }
        return sb.toString();
    }

    public static String getListInfo(ListVo vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("<div class=\"ListInfo\">");
        sb.append("<table>");
        sb.append("<tr>");
        sb.append("<td>");
        if (vo.getNeedFormer()) {
            sb.append("<button type=\"button\" onclick=\"doSubmit(document.form, '");
            sb.append("C1041");
            sb.append("')\">");
        } else {
            sb.append("<button type=\"button\" disabled=\"disabled\">");
        }
        sb.append("\u524d\u9801</button>");
        sb.append("</td>");
        if (vo.getCount() != 0) {
            sb.append("<td>");
            sb.append(vo.getStart() + 1);
            sb.append("&nbsp;\uff5e&nbsp;");
            sb.append(vo.getEnd() + 1);
            sb.append("&nbsp;/&nbsp;");
            sb.append(vo.getCount());
            sb.append("&nbsp\u4ef6");
            sb.append("</td>");
        }
        sb.append("<td>");
        if (vo.getNeedNext()) {
            sb.append("<button type=\"button\" onclick=\"doSubmit(document.form, '");
            sb.append("C1042");
            sb.append("')\">");
        } else {
            sb.append("<button type=\"button\" disabled=\"disabled\">");
        }
        sb.append("\u6b21\u9801</button>");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</div>");
        return sb.toString();
    }

    public static String getListInfoFlex(ListVo vo) {
        StringBuffer sb = new StringBuffer();
        String command = vo.getPageCommand();
        int select = vo.getSelectIndex();
        int full = vo.getCountAllData() / vo.getDataPerPage();
        int end = vo.getOffset() + vo.getDataPerPage();
        if (vo.getCountAllData() % vo.getDataPerPage() != 0) {
            ++full;
        }
        end = end > vo.getCountAllData() ? vo.getCountAllData() : end;
        sb.append("<div class=\"ListPageInfo\">");
        sb.append("<div>");
        sb.append(vo.getCountAllData() == 0 ? 0 : vo.getOffset() + 1);
        sb.append("&nbsp;\uff5e&nbsp;");
        sb.append(end);
        sb.append("&nbsp;/&nbsp;");
        sb.append(vo.getCountAllData());
        sb.append("&nbsp\u4ef6");
        sb.append("</div>");
        if (vo.getCountAllData() <= vo.getDataPerPage()) {
            sb.append("</div>");
            return sb.toString();
        }
        sb.append("<table>");
        sb.append("<tr>");
        sb.append("<td>");
        if (select - 1 > 0) {
            sb.append("<button type=\"button\" onclick=\"doSubmitKey(document.form, '");
            sb.append(command);
            sb.append("', '");
            sb.append(select - 1);
            sb.append("', '')\">");
        } else {
            sb.append("<button type=\"button\" disabled=\"disabled\">");
        }
        sb.append("\u524d\u9801</button>");
        sb.append("</td>");
        if (full != 0) {
            int pageNum = select / 10 * 10;
            for (int i = -1; i < 11; ++i) {
                if (pageNum + i <= 0 || pageNum + i > full) continue;
                if (select != pageNum + i) {
                    sb.append("<td><button type=\"button\" class=\"ButtonListPage\" ");
                    sb.append("onclick=\"doSubmitKey(document.form, '");
                    sb.append(command);
                    sb.append("', '");
                    sb.append(pageNum + i);
                    sb.append("', '')\">");
                    sb.append(pageNum + i);
                    sb.append("</button></td>");
                    continue;
                }
                if (select != pageNum + i) continue;
                sb.append("<td>");
                sb.append(pageNum + i);
                sb.append("\u9801</td>");
            }
        }
        sb.append("<td>");
        if (select + 1 <= full) {
            sb.append("<button type=\"button\" onclick=\"doSubmitKey(document.form, '");
            sb.append(command);
            sb.append("', '");
            sb.append(select + 1);
            sb.append("', '')\">");
        } else {
            sb.append("<button type=\"button\" disabled=\"disabled\">");
        }
        sb.append("\u6b21\u9801</button>");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</div>");
        return sb.toString();
    }

    public static String getMospAuthSelectOption(String mospAuthority) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < MospConst.AUTH_MOSP_VALUE.length; ++i) {
            String selected = "";
            if (mospAuthority != null && mospAuthority.equals(MospConst.AUTH_MOSP_VALUE[i])) {
                selected = "selected=\"selected\"";
            }
            sb.append("<option value=\"");
            sb.append(MospConst.AUTH_MOSP_VALUE[i]);
            sb.append("\"");
            sb.append(selected);
            sb.append(">");
            sb.append(MospConst.AUTH_MOSP_TITLE[i]);
            sb.append("</option>");
        }
        return sb.toString();
    }

    public static String getDeleteFlagSelectOption(String deleteFlag) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < MospConst.DELETE_FLAG_VALUE.length; ++i) {
            String selected = "";
            if (deleteFlag != null && deleteFlag.equals(MospConst.DELETE_FLAG_VALUE[i])) {
                selected = "selected=\"selected\"";
            }
            sb.append("<option value=\"");
            sb.append(MospConst.DELETE_FLAG_VALUE[i]);
            sb.append("\"");
            sb.append(selected);
            sb.append(">");
            sb.append(MospConst.DELETE_FLAG_TITLE[i]);
            sb.append("</option>");
        }
        return sb.toString();
    }

    public static String getSelectOption(String[][] array, String value) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            String selected = "";
            if (array[i][0].equals(value)) {
                selected = "selected=\"selected\"";
            }
            sb.append("<option value=\"");
            sb.append(HtmlUtility.escapeHTML(array[i][0]));
            sb.append("\"");
            sb.append(selected);
            sb.append(">");
            sb.append(HtmlUtility.escapeHTML(array[i][1]));
            sb.append("</option>");
        }
        return sb.toString();
    }

    public static String getRequiredMark() {
        return "<span class=\"RequiredLabel\">*&nbsp;</span>";
    }

    public static String getPulldownList(String[][] aryPulldown) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aryPulldown.length; ++i) {
            sb.append("<option value=\"");
            sb.append(aryPulldown[i][0]);
            sb.append("\">");
            sb.append(aryPulldown[i][1]);
            sb.append("</option>");
        }
        return sb.toString();
    }

    public static String escapeHTML(String aStr) {
        String strTarget = aStr != null ? aStr : "";
        StringBuffer returnStr = new StringBuffer();
        int length = strTarget.length();
        for (int i = 0; i < length; ++i) {
            char c = strTarget.charAt(i);
            returnStr = c == '<' ? returnStr.append("&lt;") : (c == '>' ? returnStr.append("&gt;") : (c == '&' ? returnStr.append("&amp;") : (c == '\"' ? returnStr.append("&quot;") : (c == '\'' ? returnStr.append("&#39;") : returnStr.append(c)))));
        }
        return new String(returnStr);
    }

    public static String getMainTitle(BaseVo vo, String extraTitle, String guideCommand, String guideTitle, boolean needLogout) {
        StringBuffer sb = new StringBuffer();
        sb.append("<div class=\"Header\">");
        sb.append("<div class=\"LogoBar\">");
        sb.append(HtmlUtility.getTagLogoImage(vo.getLogoPath(), vo.getName("C_LOGO")));
        sb.append("</div>");
        sb.append("<div class=\"MenuButtonBar\">");
        if (guideCommand != null) {
            sb.append(HtmlUtility.getButtonTag("btnGuide", guideCommand, guideTitle));
        }
        if (needLogout) {
            sb.append(HtmlUtility.getButtonTag("btnLogout", "C1030", vo.getName("C_LOGOUT")));
        }
        sb.append("</div>");
        sb.append("<div class=\"TitleBar\">");
        sb.append("<span id=\"lblTitle\">");
        sb.append(vo.getEscTitle() + "&nbsp;");
        if (extraTitle != null) {
            sb.append(extraTitle + "&nbsp;");
        }
        sb.append("</span>");
        sb.append("<span id=\"lblVersion\">" + vo.getEscVersion() + "</span>");
        if (vo.getEscUserName() != null && !vo.getEscUserName().equals("")) {
            sb.append("<span id=\"lblUserName\">");
            sb.append(vo.getName("C_USER") + vo.getName("C_NAME") + vo.getName("C_SEPARATOR"));
            sb.append(vo.getEscUserName() + "</span>");
        }
        sb.append("</div>");
        sb.append("</div>");
        return sb.toString();
    }

    public static String getSubTitle(BaseVo vo) {
        String[][] aryMenu = vo.getAryMenu();
        StringBuffer sb = new StringBuffer();
        sb.append("<div class=\"Header\">");
        sb.append("<div class=\"LogoBar\">");
        sb.append(HtmlUtility.getTagLogoImage(vo.getLogoPath(), vo.getName("C_LOGO")));
        sb.append("</div>");
        sb.append("<div class=\"MenuButtonBar\">");
        if (aryMenu != null) {
            for (int i = 1; i < aryMenu.length; ++i) {
                sb.append(HtmlUtility.getButtonTag("btnMenu" + i, aryMenu[i][0], aryMenu[i][1]));
            }
            sb.append(HtmlUtility.getButtonTag("btnMenu", aryMenu[0][0], aryMenu[0][1]));
        }
        sb.append(HtmlUtility.getButtonTag("btnLogout", "C1030", vo.getName("C_LOGOUT")));
        sb.append("</div>");
        sb.append("<div class=\"SubTitleBar\">");
        sb.append(vo.getSubTitle());
        sb.append("</div>");
        sb.append("</div>");
        return sb.toString();
    }

    public static String getButtonTag(String id, String cmd, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("<button type=\"button\" ");
        if (id.length() != 0) {
            sb.append("id=\"");
            sb.append(id);
            sb.append("\"");
        }
        sb.append(" onclick=\"doSubmit(document.form, '");
        sb.append(cmd);
        sb.append("')\">");
        sb.append(name);
        sb.append("</button>");
        return sb.toString();
    }

    public static String getTagLogoImage(String logoPath, String namLogo) {
        StringBuffer sb = new StringBuffer();
        if (logoPath != null) {
            sb.append("<img class=\"Logo\" id=\"logo\" src=\"");
            sb.append("../pub/" + logoPath);
            sb.append("\" alt=\"" + namLogo + "\">");
        }
        return sb.toString();
    }
}

