/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.express;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressUtility {
    public static String getMospExpressJarVersion() {
        return "1.0.0";
    }

    public static float calculate(String expression, Map<String, String> params, Map<String, String[][]> tables) throws MospException {
        StringBuffer sb = new StringBuffer(expression);
        ExpressUtility.setParams(sb, params);
        ExpressUtility.operateBrackets(sb);
        ExpressUtility.operateFour(sb);
        try {
            return Float.parseFloat(sb.toString());
        }
        catch (NumberFormatException e) {
            throw new MospException(1401, MospUtility.replace((String)"\u8a08\u7b97\u306e\u9014\u4e2d\u3067\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(%1%)", (String)sb.toString()));
        }
    }

    public static String checkExpression(String expression) throws MospException {
        StringBuffer sb = new StringBuffer();
        try {
            sb = new StringBuffer(expression);
            ExpressUtility.setDummyParams(sb);
            ExpressUtility.operateBrackets(sb);
            ExpressUtility.operateFour(sb);
            Float.parseFloat(sb.toString());
            return null;
        }
        catch (NumberFormatException e) {
            return MospUtility.replace((String)"\u8a08\u7b97\u306e\u9014\u4e2d\u3067\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(%1%)", (String)sb.toString());
        }
        catch (MospException e) {
            if (e.getExMessage() == null) {
                return "";
            }
            return e.getExMessage();
        }
    }

    private static void operateFour(StringBuffer sb) throws MospException {
        while (sb.indexOf(String.valueOf('%')) >= 0) {
            ExpressUtility.calcUnit(sb, sb.indexOf(String.valueOf('%')));
        }
        while (sb.indexOf(String.valueOf('/')) >= 0) {
            ExpressUtility.calcUnit(sb, sb.indexOf(String.valueOf('/')));
        }
        while (sb.indexOf(String.valueOf('*')) >= 0) {
            ExpressUtility.calcUnit(sb, sb.indexOf(String.valueOf('*')));
        }
        while (sb.indexOf(String.valueOf('#')) >= 0) {
            ExpressUtility.calcUnit(sb, sb.indexOf(String.valueOf('#')));
        }
        while (sb.indexOf(String.valueOf('+')) >= 0) {
            ExpressUtility.calcUnit(sb, sb.indexOf(String.valueOf('+')));
        }
    }

    private static void calcUnit(StringBuffer sb, int idx) throws MospException {
        ExpressUtility.checkBlank(sb, idx, 1, 1);
        if (sb.charAt(sb.length() - 1) != ' ') {
            throw new MospException(1402, "\u8a08\u7b97\u5f0f\u306e\u524d\u5f8c\u306f\u534a\u89d2\u30b9\u30da\u30fc\u30b9\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
        }
        int idxFront = idx - 2;
        int idxBack = idx + 2;
        if (idxFront < 0 || idxBack >= sb.length()) {
            throw new MospException(1401, "\u6f14\u7b97\u5b50\u306e\u524d\u5f8c\u306b\u6f14\u7b97\u5bfe\u8c61\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        while (sb.charAt(idxFront) != ' ' && --idxFront >= 0) {
        }
        ++idxFront;
        while (sb.charAt(idxBack) != ' ') {
            ++idxBack;
        }
        float valFront = 0.0f;
        float valBack = 0.0f;
        try {
            valFront = Float.parseFloat(sb.substring(idxFront, idx - 1));
        }
        catch (NumberFormatException e) {
            throw new MospException(1401, MospUtility.replace((String)"\u8a08\u7b97\u306e\u9014\u4e2d\u3067\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(%1%)", (String)sb.substring(idxFront, idx - 1)));
        }
        try {
            valBack = Float.parseFloat(sb.substring(idx + 2, idxBack));
        }
        catch (NumberFormatException e) {
            throw new MospException(1401, MospUtility.replace((String)"\u8a08\u7b97\u306e\u9014\u4e2d\u3067\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(%1%)", (String)sb.substring(idx + 2, idxBack)));
        }
        switch (sb.charAt(idx)) {
            case '%': 
            case '/': {
                if (valBack != 0.0f) break;
                throw new MospException(1405, "0\u306b\u3088\u308b\u9664\u7b97\u3092\u8a66\u307f\u307e\u3057\u305f\u3002");
            }
        }
        float ans = 0.0f;
        switch (sb.charAt(idx)) {
            case '*': {
                ans = valFront * valBack;
                break;
            }
            case '/': {
                BigDecimal bdFront = new BigDecimal(valFront);
                BigDecimal bdBack = new BigDecimal(valBack);
                BigDecimal bdAns = bdFront.divide(bdBack, 2, 4);
                ans = bdAns.floatValue();
                break;
            }
            case '%': {
                ans = valFront % valBack;
                break;
            }
            case '+': {
                ans = valFront + valBack;
                break;
            }
            case '#': {
                ans = valFront - valBack;
                break;
            }
            default: {
                throw new MospException(1401, MospUtility.replace((String)"\u6f14\u7b97\u5b50\u304c\u4e0d\u6b63\u3067\u3059\u3002(%1%)", (String)String.valueOf(sb.charAt(idx))));
            }
        }
        sb.replace(idxFront, idxBack, String.valueOf(ans));
    }

    private static void operateBrackets(StringBuffer sb) throws MospException {
        block7: while (sb.lastIndexOf(String.valueOf('(')) >= 0) {
            int idx = sb.lastIndexOf(String.valueOf('('));
            switch (sb.charAt(idx + 1)) {
                case ' ': {
                    ExpressUtility.operateBracket(sb, idx);
                    continue block7;
                }
                case 'R': {
                    ExpressUtility.operateRound(sb, idx);
                    continue block7;
                }
                case 'Z': {
                    ExpressUtility.operateToZero(sb, idx);
                    continue block7;
                }
                case 'C': {
                    continue block7;
                }
                case 'T': {
                    continue block7;
                }
            }
            throw new MospException(1401, MospUtility.replace((String)"\u6f14\u7b97\u5b50\u304c\u4e0d\u6b63\u3067\u3059\u3002(%1%)", (String)String.valueOf(sb.charAt(idx + 1))));
        }
    }

    private static void operateBracket(StringBuffer sb, int idx) throws MospException {
        int idxEnd = ExpressUtility.getRightBracket(sb, idx, ')');
        ExpressUtility.checkBlank(sb, idx, 1, 1);
        ExpressUtility.checkBlank(sb, idxEnd, 1, 1);
        StringBuffer innerExp = new StringBuffer(sb.substring(idx + 1, idxEnd));
        ExpressUtility.operateFour(innerExp);
        sb.replace(idx - 1, idxEnd + 2, innerExp.toString());
    }

    private static void operateRound(StringBuffer sb, int idx) throws MospException {
        float value;
        int mode;
        int idxEnd = ExpressUtility.getRightBracket(sb, idx, ')');
        ExpressUtility.checkBlank(sb, idx, 1, 2);
        ExpressUtility.checkBlank(sb, idxEnd, 1, 1);
        if (idx + 3 >= idxEnd) {
            throw new MospException(1408, "\u7279\u6b8a\u51e6\u7406\u306e\u5185\u90e8\u304c\u4e0d\u6b63\u3067\u3059\u3002");
        }
        String contents = sb.substring(idx + 3, idxEnd);
        String[] aryContents = contents.split(String.valueOf(','));
        if (aryContents == null || aryContents.length != 3) {
            throw new MospException(1408, "\u7279\u6b8a\u51e6\u7406\u306e\u5185\u90e8\u304c\u4e0d\u6b63\u3067\u3059\u3002");
        }
        if (aryContents[0] == null || aryContents[0].length() != 1) {
            throw new MospException(1408, "\u7279\u6b8a\u51e6\u7406\u306e\u5185\u90e8\u304c\u4e0d\u6b63\u3067\u3059\u3002");
        }
        switch (aryContents[0].charAt(0)) {
            case 'L': {
                mode = 2;
                break;
            }
            case 'D': {
                mode = 1;
                break;
            }
            case 'F': {
                mode = 3;
                break;
            }
            case 'G': {
                mode = 5;
                break;
            }
            case 'E': {
                mode = 6;
                break;
            }
            case 'S': {
                mode = 4;
                break;
            }
            case 'U': {
                mode = 0;
                break;
            }
            default: {
                throw new MospException(1408, "\u7279\u6b8a\u51e6\u7406\u306e\u5185\u90e8\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            }
        }
        int scale = 0;
        try {
            scale = Integer.parseInt(aryContents[1]);
        }
        catch (NumberFormatException e) {
            throw new MospException(1408, "\u7279\u6b8a\u51e6\u7406\u306e\u5185\u90e8\u304c\u4e0d\u6b63\u3067\u3059\u3002");
        }
        StringBuffer innerExp = new StringBuffer(aryContents[2]);
        ExpressUtility.operateFour(innerExp);
        try {
            value = Float.parseFloat(innerExp.toString());
        }
        catch (NumberFormatException e) {
            throw new MospException(1401, MospUtility.replace((String)"\u8a08\u7b97\u306e\u9014\u4e2d\u3067\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(%1%)", (String)innerExp.toString()));
        }
        value = (float)MospUtility.round((double)value, (int)scale, (int)mode);
        sb.replace(idx, idxEnd + 1, String.valueOf(value));
    }

    private static void operateToZero(StringBuffer sb, int idx) throws MospException {
        float value;
        int idxEnd = ExpressUtility.getRightBracket(sb, idx, ')');
        ExpressUtility.checkBlank(sb, idx, 1, 2);
        ExpressUtility.checkBlank(sb, idxEnd, 1, 1);
        StringBuffer innerExp = new StringBuffer(sb.substring(idx + 2, idxEnd));
        ExpressUtility.operateFour(innerExp);
        try {
            value = Float.parseFloat(innerExp.toString());
        }
        catch (NumberFormatException e) {
            throw new MospException(1401, MospUtility.replace((String)"\u8a08\u7b97\u306e\u9014\u4e2d\u3067\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(%1%)", (String)innerExp.toString()));
        }
        value = value > 0.0f ? value : 0.0f;
        sb.replace(idx, idxEnd + 1, String.valueOf(value));
    }

    private static void setParams(StringBuffer sb, Map<String, String> params) throws MospException {
        while (sb.indexOf(String.valueOf('[')) >= 0) {
            ExpressUtility.setParam(sb, params, sb.indexOf(String.valueOf('[')));
        }
    }

    private static void setDummyParams(StringBuffer sb) throws MospException {
        int i = 0;
        while (sb.indexOf(String.valueOf('[')) >= 0) {
            int idx = sb.indexOf(String.valueOf('['));
            int idxEnd = ExpressUtility.getRightBracket(sb, idx, ']');
            ExpressUtility.checkBlank(sb, idx, 1, 1);
            ExpressUtility.checkBlank(sb, idxEnd, 1, 1);
            sb.replace(idx, idxEnd + 1, String.valueOf(++i));
        }
    }

    private static void setParam(StringBuffer sb, Map<String, String> params, int idx) throws MospException {
        int idxEnd = ExpressUtility.getRightBracket(sb, idx, ']');
        ExpressUtility.checkBlank(sb, idx, 1, 1);
        ExpressUtility.checkBlank(sb, idxEnd, 1, 1);
        String paramId = sb.substring(idx + 2, idxEnd - 1);
        String strValue = params.get(paramId);
        float value = 0.0f;
        try {
            if (strValue != null && !strValue.equals("")) {
                value = Float.parseFloat(strValue);
            }
        }
        catch (NumberFormatException e) {
            throw new MospException(1401, MospUtility.replace((String)"\u8a08\u7b97\u306e\u9014\u4e2d\u3067\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(%1%)", (String)sb.toString()));
        }
        sb.replace(idx, idxEnd + 1, String.valueOf(value));
    }

    private static void checkBlank(StringBuffer sb, int idx, int front, int back) throws MospException {
        try {
            if (sb.charAt(idx - front) != ' ') {
                throw new MospException(1403, "\u6f14\u7b97\u5b50\u306e\u524d\u5f8c\u306f\u534a\u89d2\u30b9\u30da\u30fc\u30b9\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
            }
            if (sb.charAt(idx + back) != ' ') {
                throw new MospException(1403, "\u6f14\u7b97\u5b50\u306e\u524d\u5f8c\u306f\u534a\u89d2\u30b9\u30da\u30fc\u30b9\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MospException(1402, "\u8a08\u7b97\u5f0f\u306e\u524d\u5f8c\u306f\u534a\u89d2\u30b9\u30da\u30fc\u30b9\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
        }
    }

    private static int getRightBracket(StringBuffer sb, int idx, char braket) throws MospException {
        int idxEnd = sb.indexOf(String.valueOf(braket), idx);
        if (idxEnd < 0) {
            throw new MospException(1406, "\u62ec\u5f27\u304c\u9589\u3058\u3089\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        return idxEnd;
    }

    public static void main(String[] arg) throws MospException {
        String exp = " 21 / 3 # 0.5 + 4 ";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "100");
        params.put("test2", "200");
        HashMap<String, String[][]> tables = new HashMap<String, String[][]>();
        float ans = ExpressUtility.calculate(exp, params, tables);
        System.out.println(ans);
    }
}

