/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.MCodeDao;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.system.vo.CodeMasterCardVo;
import jp.mosp.system.vo.HolidayMasterCardVo;

/**
 * @author yoshida
 *
 */
public class HolidayMasterCardAction extends MosPAction {
	
	// R}h
	private static final String	CMD_HOLIDAY_MASTER_CARD_SHOW	= "S2715";	// \(ǉ)
	private static final String	CMD_HOLIDAY_MASTER_CARD_SELECT	= "S2716";	// \(I)
	private static final String	CMD_HOLIDAY_MASTER_CARD_INSERT	= "S2717";	// o^
	private static final String	CMD_HOLIDAY_MASTER_CARD_UPDATE	= "S2718";	// XV
	private static final String	CMD_HOLIDAY_MASTER_CARD_DELETE	= "S2719";	// 폜
																			
	
	/**
	 * RXgN^
	 */
	public HolidayMasterCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_HOLIDAY_MASTER_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_CARD_UPDATE)) {
			// XV
			update();
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_CARD_DELETE)) {
			// 폜
			delete();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new HolidayMasterCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		HolidayMasterCardVo vo = (HolidayMasterCardVo)getVo();
		// v_E̐ݒ
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltDay = StringUtil.getDayArray();
	}
	
	@Override
	protected void show() {
		HolidayMasterCardVo vo = (HolidayMasterCardVo)getVo();
		Date todayDate = DateUtil.getSystemDate();
		// lݒ
		vo.setTxtHolidayYear(String.valueOf(MospUtility.getYear(todayDate)));
		vo.setPltHolidayMonth(String.valueOf(MospUtility.getMonth(todayDate)));
		vo.setPltHolidayDay(String.valueOf(MospUtility.getDay(todayDate)));
		vo.setTxtHolidayName("");
		// [hݒ
		vo.setMode(CodeMasterCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		HolidayMasterCardVo vo = (HolidayMasterCardVo)getVo();
		// f[^̎擾
		MCodeDto dto = part().mospcode().findForKey(CommonConst.NAM_HOLIDAY, key1);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		// [hݒ
		setMode();
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		HolidayMasterCardVo vo = (HolidayMasterCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		MCodeDto dto = new MCodeDto();
		vo.setDtoFields(dto);
		// DAȌ
		MCodeDao dao = part().mospcode().getMCodeDao();
		// ݃`FbN
		chkDuplicate(dao.findForKey(dto.getTId(), dto.getTCode()));
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		MCodeDto retDto = dao.findForKey(dto.getTId(), dto.getTCode());
		chkInsert(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		MCodeDto dto = (MCodeDto)getSessionDto();
		HolidayMasterCardVo vo = (HolidayMasterCardVo)getVo();
		vo.setParams(request);
		String holiday = dto.getTCode();
		if (holiday.startsWith("0") || holiday.startsWith("1")) {
			vo.setTxtHolidayYear("");
			vo.setPltHolidayMonth(StringUtil.removeZero(holiday.split(CommonConst.SEPARATOR_DATE)[0]));
			vo.setPltHolidayDay(StringUtil.removeZero(holiday.split(CommonConst.SEPARATOR_DATE)[1]));
		} else {
			vo.setTxtHolidayYear(String.valueOf(MospUtility.getYear(DateUtil.convStringDateToDate(holiday))));
			vo.setPltHolidayMonth(String.valueOf(MospUtility.getMonth(DateUtil.convStringDateToDate(holiday))));
			vo.setPltHolidayDay(String.valueOf(MospUtility.getDay(DateUtil.convStringDateToDate(holiday))));
		}
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto);
		// DAȌ
		MCodeDao dao = part().mospcode().getMCodeDao();
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getTId(), dto.getTCode()));
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MCodeDto retDto = dao.findForKey(dto.getTId(), dto.getTCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * f[^폜
	 * @throws Exception 	Oꍇ
	 */
	private void delete() throws Exception {
		// DTO̎擾
		MCodeDto dto = (MCodeDto)getSessionDto();
		HolidayMasterCardVo vo = (HolidayMasterCardVo)getVo();
		// f[^̍폜
		part().mospcode().getMCodeDao().delete(dto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(CodeMasterCardVo.MODE_INSERT);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_DELETE, ""));
	}
	
	/**
	 * [hݒ
	 * @throws Exception 	Oꍇ
	 */
	private void setMode() throws Exception {
		HolidayMasterCardVo vo = (HolidayMasterCardVo)getVo();
		// [hݒ
		if (hasSystemAuth()) {
			vo.setMode(HolidayMasterCardVo.MODE_SYSTEM);
		} else {
			vo.setMode(HolidayMasterCardVo.MODE_UPDATE);
		}
	}
	
}
