package jp.mosp.payroll.report.dto;

import jp.mosp.common.common.BaseDto;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dto.CdAdjustmentDto;

public class WithholdingVoteDto extends BaseDto {
	
	private static final long	serialVersionUID	= 2613587750422757053L;
	// tB[h
	protected String			incExpectedDate;							// a
	protected String			address;									// Z
	protected String			entranceYear;								// Г(N)
	protected String			entranceMonth;								// Г()
	protected String			entranceDay;								// Г()
	protected String			kCode;										// ЈR[h
	protected String			kKana;										// Јض
	protected String			kName;										// Ј
	protected String			positionName;								// E
																			
	protected String			withHoldType;								// 
	protected Integer			paymentAllowance;							// xz
	protected Integer			afterDeductIncome;							// ^T̋^̋z
	protected Integer			calcTaxedIncome;							// Tz̍vz
	protected Integer			withholdTax;								// 򒥐Ŋz
	/* TΏ۔z҂̗L */
	protected String			isDeductionSpouse;							// L
	protected String			noDeductionSpouse;							// 
	protected String			isSubDeducSpouse;							// ]L
	protected String			noSubDeducSpouse;							// ]
	protected String			elderlySpouse;								// Vl
	protected Integer			spouseSpDeduction;							// zғʍTz
	/* }{e̐(z҂) */
	protected String			spDependent;								// 
	protected String			spSubDependent;							// ]l
	protected String			spElDependent;								// Vl
	protected String			spElItemDepend;							// Vl
	protected String			spSubElDepend;								// ]l
	protected String			otherDepend;								// ̑
	protected String			otherSubDepend;							// ̑]l
	/* Q҂̐ */
	protected String			spHandicap;								// 
	protected String			spItemHandicap;							// ʓ
	protected String			spHandicapOther;							// ̑
	protected Integer			socialInsDeduction;						// ЉیTz
	protected Integer			lifeInsDeduction;							// یTz
	protected Integer			earthquakeIns;								// nkی
	protected Integer			houseLoanDeduction;						// ZؓʍTz
	protected String			withholdSlipNotes;							// 򒥎[Ev
	protected Integer			spouseSumIncome;							// z҂̖{N̍vžϊz
	protected Integer			privatePension;							// lNی
	protected Integer			longTermDamageIns;							// Qی
	/* }{T{l */
	protected String			selfMinority;								// N
	protected String			selfOtu;									// 
	protected String			selfSpHandicap;							// ʏQ
	protected String			selfGeHandicap;							// ʏQ
	protected String			selfGeWidow;								// ʉǕw
	protected String			selfSpWidow;								// ʉǕw
	protected String			widow;										// Ǖv
	protected String			studentGeneral;							// ΘJw
	protected String			deadRetirement;							// SސE
	protected String			selfDisaster;								// ЊQ
	protected String			foreigner;									// Ol
																			
	protected String			employment;								// AE
	protected String			retirement;								// ސE
	protected String			retirementYaer;							// ގГ(N)
	protected String			retirementMonth;							// ގГ()
	protected String			retirementDay;								// ގГ()
	protected String			birthYear;									// N(N)
	protected String			birthMonth;								// N()
	protected String			birthDay;									// N()
	protected String			birthHeisei;								// Na()
	protected String			birthMeiji;								// Na()
	protected String			birthTaisyou;								// Na(吳)
	protected String			birthSyouwa;								// Na(a)
																			
	protected String			companyName;								// Ж
	protected String			companyAddress;							// ЏZ
	protected String			companyPhone;								// Гdbԍ
																			
	protected String			stationNo01;								// ԍ_01
	protected String			stationNo02;								// ԍ_02
	protected String			stationNo03;								// ԍ_03
	protected String			stationNo04;								// ԍ_04
	protected String			stationNo05;								// ԍ_05
																			
	protected String			disposeNo01;								// ԍ_01
	protected String			disposeNo02;								// ԍ_02
	protected String			disposeNo03;								// ԍ_03
	protected String			disposeNo04;								// ԍ_04
	protected String			disposeNo05;								// ԍ_05
	protected String			disposeNo06;								// ԍ_06
	protected String			disposeNo07;								// ԍ_07
	protected String			disposeNo08;								// ԍ_08
																			
	
	/**
	 * RXgN^
	 */
	public WithholdingVoteDto(CdAdjustmentDto dto) {
		super();
		// 
		setIncExpectedDate("");
		setAddress("");
		setEntranceYear("");
		setEntranceMonth("");
		setEntranceDay("");
		setKCode("");
		setKKana("");
		setKName("");
		setPositionName("");
		setWithHoldType("");
		setPaymentAllowance(null);
		setAfterDeductIncome(null);
		setCalcTaxedIncome(null);
		setWithholdTax(null);
		setIsDeductionSpouse("");
		setNoDeductionSpouse("");
		setIsSubDeducSpouse("");
		setNoSubDeducSpouse("");
		setElderlySpouse("");
		setSpouseSpDeduction(null);
		setSpDependent("");
		setSpSubDependent("");
		setSpElDependent("");
		setSpElItemDepend("");
		setSpSubElDepend("");
		setOtherDepend("");
		setOtherSubDepend("");
		setSpHandicap("");
		setSpItemHandicap("");
		setSpHandicapOther("");
		setSocialInsDeduction(null);
		setLifeInsDeduction(null);
		setEarthquakeIns(null);
		setHouseLoanDeduction(null);
		setWithholdSlipNotes("");
		setSpouseSumIncome(null);
		setPrivatePension(null);
		setLongTermDamageIns(null);
		setSelfMinority("");
		setSelfOtu("");
		setSelfSpHandicap("");
		setSelfGeHandicap("");
		setSelfGeWidow("");
		setSelfSpWidow("");
		setWidow("");
		setStudentGeneral("");
		setDeadRetirement("");
		setSelfDisaster("");
		setForeigner("");
		setEmployment("");
		setRetirement("");
		setRetirementYear("");
		setRetirementMonth("");
		setRetirementDay("");
		setBirthYear("");
		setBirthMonth("");
		setBirthDay("");
		setBirthHeisei("");
		setBirthMeiji("");
		setBirthTaisyou("");
		setBirthSyouwa("");
		setCompanyName("");
		setCompanyAddress("");
		setCompanyPhone("");
		stationNo01 = "";
		stationNo02 = "";
		stationNo03 = "";
		stationNo04 = "";
		stationNo05 = "";
		disposeNo01 = "";
		disposeNo02 = "";
		disposeNo03 = "";
		disposeNo04 = "";
		disposeNo05 = "";
		disposeNo06 = "";
		disposeNo07 = "";
		disposeNo08 = "";
		if (dto != null) {
			incExpectedDate = String.valueOf(dto.getAdjustYear()); // a
			kCode = dto.getKCode(); // ЈR[h
			withHoldType = PayrollConst.NAM_PAY_BONUS; // 
			paymentAllowance = new Integer(dto.getTaxedPaymentSum()); // xz
			afterDeductIncome = new Integer(dto.getAfterDeductIncome()); // ^T̋^̋z
			calcTaxedIncome = new Integer(dto.getIncomeDeductSum()); // Tz̍vz
			withholdTax = new Integer(dto.getFinalIncomeTax()); // 򒥎Ŋz
			spouseSpDeduction = new Integer(dto.getSpouseSpDeduction()); // zғʍTz
			socialInsDeduction = new Integer(dto.getSocialInsDeduction()); // ЉیTz
			lifeInsDeduction = new Integer(dto.getLifeInsDeduction()); // یTz
			earthquakeIns = new Integer(dto.getEarthquakeIns()); // nkی
			houseLoanDeduction = new Integer(dto.getHouseLoanDeduction()); // ZؓʍTz
			withholdSlipNotes = setSpaceItem(dto.getWithholdSlipNotes()); // 򒥎[Ev
			spouseSumIncome = new Integer(dto.getSpouseSumIncome()); // z҂̖{N̍vžςz
			privatePension = new Integer(dto.getPrivatePension()); // lNی
			longTermDamageIns = new Integer(dto.getLongTermDamageIns()); // Qی
			// NULLΉ
			if (setSpaceItem(dto.getDeadRetirement()).equals(String.valueOf(PayrollConst.CHECKBOX_ON))) {
				deadRetirement = PayrollConst.ADJ_APPLICABLE; // SސE
			}
			// NULLΉ
			if (setSpaceItem(dto.getSelfDisaster()).equals(String.valueOf(PayrollConst.CHECKBOX_ON))) {
				selfDisaster = PayrollConst.ADJ_APPLICABLE; // ЊQ
			}
			// NULLΉ
			if (setSpaceItem(dto.getForeigner()).equals(String.valueOf(PayrollConst.CHECKBOX_ON))) {
				foreigner = PayrollConst.ADJ_APPLICABLE; // Ol
			}
		}
	}
	
	/**
	 * 񍀖NULL󔒐ݒ
	 * @param strTarget
	 * @return
	 */
	private String setSpaceItem(String strTarget) {
		if (strTarget == null) {
			return "";
		}
		return strTarget;
		
	}
	
	// ANZT\bh
	public void setIncExpectedDate(String incExpectedDate) {
		this.incExpectedDate = incExpectedDate;
	}
	
	public void setAddress(String address) {
		this.address = address;
	}
	
	public void setEntranceYear(String entranceYear) {
		this.entranceYear = entranceYear;
	}
	
	public void setEntranceMonth(String entranceMonth) {
		this.entranceMonth = entranceMonth;
	}
	
	public void setEntranceDay(String entranceDay) {
		this.entranceDay = entranceDay;
	}
	
	public void setKCode(String kCode) {
		this.kCode = kCode;
	}
	
	public void setKKana(String kKana) {
		this.kKana = kKana;
	}
	
	public void setKName(String kName) {
		this.kName = kName;
	}
	
	public void setPositionName(String positionName) {
		this.positionName = positionName;
	}
	
	public void setWithHoldType(String withHoldType) {
		this.withHoldType = withHoldType;
	}
	
	public void setPaymentAllowance(Integer paymentAllowance) {
		this.paymentAllowance = paymentAllowance;
	}
	
	public void setAfterDeductIncome(Integer afterDeductIncome) {
		this.afterDeductIncome = afterDeductIncome;
	}
	
	public void setCalcTaxedIncome(Integer calcTaxedIncome) {
		this.calcTaxedIncome = calcTaxedIncome;
	}
	
	public void setWithholdTax(Integer withholdTax) {
		this.withholdTax = withholdTax;
	}
	
	public void setIsDeductionSpouse(String isDeductionSpouse) {
		this.isDeductionSpouse = isDeductionSpouse;
	}
	
	public void setNoDeductionSpouse(String noDeductionSpouse) {
		this.noDeductionSpouse = noDeductionSpouse;
	}
	
	public void setIsSubDeducSpouse(String isSubDeducSpouse) {
		this.isSubDeducSpouse = isSubDeducSpouse;
	}
	
	public void setNoSubDeducSpouse(String noSubDeducSpouse) {
		this.noSubDeducSpouse = noSubDeducSpouse;
	}
	
	public void setElderlySpouse(String elderlySpouse) {
		this.elderlySpouse = elderlySpouse;
	}
	
	public void setSpouseSpDeduction(Integer spouseSpDeduction) {
		this.spouseSpDeduction = spouseSpDeduction;
	}
	
	public void setSpDependent(String spDependent) {
		this.spDependent = spDependent;
	}
	
	public void setSpSubDependent(String spSubDependent) {
		this.spSubDependent = spSubDependent;
	}
	
	public void setSpElDependent(String spElDependent) {
		this.spElDependent = spElDependent;
	}
	
	public void setSpElItemDepend(String spElItemDepend) {
		this.spElItemDepend = spElItemDepend;
	}
	
	public void setSpSubElDepend(String spSubElDepend) {
		this.spSubElDepend = spSubElDepend;
	}
	
	public void setOtherDepend(String otherDepend) {
		this.otherDepend = otherDepend;
	}
	
	public void setOtherSubDepend(String otherSubDepend) {
		this.otherSubDepend = otherSubDepend;
	}
	
	public void setSpHandicap(String spHandicap) {
		this.spHandicap = spHandicap;
	}
	
	public void setSpItemHandicap(String spItemHandicap) {
		this.spItemHandicap = spItemHandicap;
	}
	
	public void setSpHandicapOther(String spHandicapOther) {
		this.spHandicapOther = spHandicapOther;
	}
	
	public void setSocialInsDeduction(Integer socialInsDeduction) {
		this.socialInsDeduction = socialInsDeduction;
	}
	
	public void setLifeInsDeduction(Integer lifeInsDeduction) {
		this.lifeInsDeduction = lifeInsDeduction;
	}
	
	public void setEarthquakeIns(Integer earthquakeIns) {
		this.earthquakeIns = earthquakeIns;
	}
	
	public void setHouseLoanDeduction(Integer houseLoanDeduction) {
		this.houseLoanDeduction = houseLoanDeduction;
	}
	
	public void setWithholdSlipNotes(String withholdSlipNotes) {
		this.withholdSlipNotes = withholdSlipNotes;
	}
	
	public void setSpouseSumIncome(Integer spouseSumIncome) {
		this.spouseSumIncome = spouseSumIncome;
	}
	
	public void setPrivatePension(Integer privatePension) {
		this.privatePension = privatePension;
	}
	
	public void setLongTermDamageIns(Integer longTermDamageIns) {
		this.longTermDamageIns = longTermDamageIns;
	}
	
	public void setSelfMinority(String selfMinority) {
		this.selfMinority = selfMinority;
	}
	
	public void setSelfOtu(String selfOtu) {
		this.selfOtu = selfOtu;
	}
	
	public void setSelfSpHandicap(String selfSpHandicap) {
		this.selfSpHandicap = selfSpHandicap;
	}
	
	public void setSelfGeHandicap(String selfGeHandicap) {
		this.selfGeHandicap = selfGeHandicap;
	}
	
	public void setSelfGeWidow(String selfGeWidow) {
		this.selfGeWidow = selfGeWidow;
	}
	
	public void setSelfSpWidow(String selfSpWidow) {
		this.selfSpWidow = selfSpWidow;
	}
	
	public void setWidow(String widow) {
		this.widow = widow;
	}
	
	public void setStudentGeneral(String studentGeneral) {
		this.studentGeneral = studentGeneral;
	}
	
	public void setDeadRetirement(String deadRetirement) {
		this.deadRetirement = deadRetirement;
	}
	
	public void setSelfDisaster(String selfDisaster) {
		this.selfDisaster = selfDisaster;
	}
	
	public void setForeigner(String foreigner) {
		this.foreigner = foreigner;
	}
	
	public void setEmployment(String employment) {
		this.employment = employment;
	}
	
	public void setRetirement(String retirement) {
		this.retirement = retirement;
	}
	
	public void setRetirementYear(String retirementYaer) {
		this.retirementYaer = retirementYaer;
	}
	
	public void setRetirementMonth(String retirementMonth) {
		this.retirementMonth = retirementMonth;
	}
	
	public void setRetirementDay(String retirementDay) {
		this.retirementDay = retirementDay;
	}
	
	public void setBirthYear(String birthYear) {
		this.birthYear = birthYear;
	}
	
	public void setBirthMonth(String birthMonth) {
		this.birthMonth = birthMonth;
	}
	
	public void setBirthDay(String birthDay) {
		this.birthDay = birthDay;
	}
	
	public void setBirthHeisei(String birthHeisei) {
		this.birthHeisei = birthHeisei;
	}
	
	public void setBirthMeiji(String birthMeiji) {
		this.birthMeiji = birthMeiji;
	}
	
	public void setBirthTaisyou(String birthTaisyou) {
		this.birthTaisyou = birthTaisyou;
	}
	
	public void setBirthSyouwa(String birthSyouwa) {
		this.birthSyouwa = birthSyouwa;
	}
	
	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}
	
	public void setCompanyAddress(String companyAddress) {
		this.companyAddress = companyAddress;
	}
	
	public void setCompanyPhone(String companyPhone) {
		this.companyPhone = companyPhone;
	}
	
	public void setStationNo01(String stationNo01) {
		this.stationNo01 = stationNo01;
	} // ԍ01
	
	public void setStationNo02(String stationNo02) {
		this.stationNo02 = stationNo02;
	} // ԍ02
	
	public void setStationNo03(String stationNo03) {
		this.stationNo03 = stationNo03;
	} // ԍ03
	
	public void setStationNo04(String stationNo04) {
		this.stationNo04 = stationNo04;
	} // ԍ04
	
	public void setStationNo05(String stationNo05) {
		this.stationNo05 = stationNo05;
	} // ԍ05
	
	public void setDisposeNo01(String disposeNo01) {
		this.disposeNo01 = disposeNo01;
	} // ԍ01
	
	public void setDisposeNo02(String disposeNo02) {
		this.disposeNo02 = disposeNo02;
	} // ԍ02
	
	public void setDisposeNo03(String disposeNo03) {
		this.disposeNo03 = disposeNo03;
	} // ԍ03
	
	public void setDisposeNo04(String disposeNo04) {
		this.disposeNo04 = disposeNo04;
	} // ԍ04
	
	public void setDisposeNo05(String disposeNo05) {
		this.disposeNo05 = disposeNo05;
	} // ԍ_05
	
	public void setDisposeNo06(String disposeNo06) {
		this.disposeNo06 = disposeNo06;
	} // ԍ_06
	
	public void setDisposeNo07(String disposeNo07) {
		this.disposeNo07 = disposeNo07;
	} // ԍ_07
	
	public void setDisposeNo08(String disposeNo08) {
		this.disposeNo08 = disposeNo08;
	} // ԍ_08
	
	public String getIncExpectedDate() {
		return incExpectedDate;
	}
	
	public String getAddress() {
		return address;
	}
	
	public String getEntranceYear() {
		return entranceYear;
	}
	
	public String getEntranceMonth() {
		return entranceMonth;
	}
	
	public String getEntranceDay() {
		return entranceDay;
	}
	
	public String getKCode() {
		return kCode;
	}
	
	public String getKKana() {
		return kKana;
	}
	
	public String getKName() {
		return kName;
	}
	
	public String getPositionName() {
		return positionName;
	}
	
	public String getWithHoldType() {
		return withHoldType;
	}
	
	public Integer getPaymentAllowance() {
		return paymentAllowance;
	}
	
	public Integer getAfterDeductIncome() {
		return afterDeductIncome;
	}
	
	public Integer getCalcTaxedIncome() {
		return calcTaxedIncome;
	}
	
	public Integer getWithholdTax() {
		return withholdTax;
	}
	
	public String getIsDeductionSpouse() {
		return isDeductionSpouse;
	}
	
	public String getNoDeductionSpouse() {
		return noDeductionSpouse;
	}
	
	public String getIsSubDeducSpouse() {
		return isSubDeducSpouse;
	}
	
	public String getNoSubDeducSpouse() {
		return noSubDeducSpouse;
	}
	
	public String getElderlySpouse() {
		return elderlySpouse;
	}
	
	public Integer getSpouseSpDeduction() {
		return spouseSpDeduction;
	}
	
	public String getSpDependent() {
		return spDependent;
	}
	
	public String getSpSubDependent() {
		return spSubDependent;
	}
	
	public String getSpElDependent() {
		return spElDependent;
	}
	
	public String getSpElItemDepend() {
		return spElItemDepend;
	}
	
	public String getSpSubElDepend() {
		return spSubElDepend;
	}
	
	public String getOtherDepend() {
		return otherDepend;
	}
	
	public String getOtherSubDepend() {
		return otherSubDepend;
	}
	
	public String getSpHandicap() {
		return spHandicap;
	}
	
	public String getSpItemHandicap() {
		return spItemHandicap;
	}
	
	public String getSpHandicapOther() {
		return spHandicapOther;
	}
	
	public Integer getSocialInsDeduction() {
		return socialInsDeduction;
	}
	
	public Integer getLifeInsDeduction() {
		return lifeInsDeduction;
	}
	
	public Integer getEarthquakeIns() {
		return earthquakeIns;
	}
	
	public Integer getHouseLoanDeduction() {
		return houseLoanDeduction;
	}
	
	public String getWithholdSlipNotes() {
		return withholdSlipNotes;
	}
	
	public Integer getSpouseSumIncome() {
		return spouseSumIncome;
	}
	
	public Integer getPrivatePension() {
		return privatePension;
	}
	
	public Integer getLongTermDamageIns() {
		return longTermDamageIns;
	}
	
	public String getSelfMinority() {
		return selfMinority;
	}
	
	public String getSelfOtu() {
		return selfOtu;
	}
	
	public String getSelfSpHandicap() {
		return selfSpHandicap;
	}
	
	public String getSelfGeHandicap() {
		return selfGeHandicap;
	}
	
	public String getSelfGeWidow() {
		return selfGeWidow;
	}
	
	public String getSelfSpWidow() {
		return selfSpWidow;
	}
	
	public String getWidow() {
		return widow;
	}
	
	public String getStudentGeneral() {
		return studentGeneral;
	}
	
	public String getDeadRetirement() {
		return deadRetirement;
	}
	
	public String getSelfDisaster() {
		return selfDisaster;
	}
	
	public String getForeigner() {
		return foreigner;
	}
	
	public String getEmployment() {
		return employment;
	}
	
	public String getRetirement() {
		return retirement;
	}
	
	public String getRetirementYaer() {
		return retirementYaer;
	}
	
	public String getRetirementMonth() {
		return retirementMonth;
	}
	
	public String getRetirementDay() {
		return retirementDay;
	}
	
	public String getBirthYear() {
		return birthYear;
	}
	
	public String getBirthMonth() {
		return birthMonth;
	}
	
	public String getBirthDay() {
		return birthDay;
	}
	
	public String getBirthHeisei() {
		return birthHeisei;
	}
	
	public String getBirthMeiji() {
		return birthMeiji;
	}
	
	public String getBirthTaisyou() {
		return birthTaisyou;
	}
	
	public String getBirthSyouwa() {
		return birthSyouwa;
	}
	
	public String getCompanyName() {
		return companyName;
	}
	
	public String getCompanyAddress() {
		return companyAddress;
	}
	
	public String getCompanyPhone() {
		return companyPhone;
	}
	
	public String getStationNo01() {
		return stationNo01;
	} // ԍ01
	
	public String getStationNo02() {
		return stationNo02;
	} // ԍ02
	
	public String getStationNo03() {
		return stationNo03;
	} // ԍ03
	
	public String getStationNo04() {
		return stationNo04;
	} // ԍ04
	
	public String getStationNo05() {
		return stationNo05;
	} // ԍ05
	
	public String getDisposeNo01() {
		return disposeNo01;
	} // ԍ01
	
	public String getDisposeNo02() {
		return disposeNo02;
	} // ԍ02
	
	public String getDisposeNo03() {
		return disposeNo03;
	} // ԍ03
	
	public String getDisposeNo04() {
		return disposeNo04;
	} // ԍ04
	
	public String getDisposeNo05() {
		return disposeNo05;
	} // ԍ05
	
	public String getDisposeNo06() {
		return disposeNo06;
	} // ԍ06
	
	public String getDisposeNo07() {
		return disposeNo07;
	} // ԍ07
	
	public String getDisposeNo08() {
		return disposeNo08;
	} // ԍ08
	
}
