package jp.mosp.payroll.payment.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.dto.CmCoBankDto;

public class CompanyCoBankVo extends PayrollVo {
	
	private static final long	serialVersionUID		= 1048045114292237926L;
	
	public static final int		MODE_INSERT				= 0;
	public static final int		MODE_UPDATE				= 1;
	
	// p[^
	public static final String	PRM_TXT_CO_BANK_CODE	= "txtCoBankCode";
	public static final String	PRM_TXT_BANK_CODE		= "txtBankCode";
	public static final String	PRM_TXT_BRANCH_CODE		= "txtBranchCode";
	public static final String	PRM_TXT_ACCOUNT_NO		= "txtAccountNo";
	public static final String	PRM_PLT_ACCOUNT_TYPE	= "pltAccountType";
	public static final String	PRM_PLT_DELETE			= "pltDelete";
	public static final String	PRM_TXT_BANK_NAME		= "txtBankName";
	public static final String	PRM_TXT_BRANCH_NAME		= "txtBranchName";
	public static final String	PRM_LBL_BANK_NAME		= "lblBankName";
	public static final String	PRM_LBL_BRANCH_NAME		= "lblBranchName";
	
	// tB[h
	private String[]			aryCoBankCode;
	private String[]			aryBankCode;
	private String[]			aryBranchCode;
	private String[]			aryAccountType;
	private String[]			aryAccountNo;
	private String[]			aryDelete;
	private String[]			aryBankName;
	private String[]			aryBranchName;
	
	private String				txtCoBankCode;
	private String				txtBankCode;
	private String				txtBranchCode;
	private String				txtAccountNo;
	private String				pltAccountType;
	private String				pltDelete;
	private String				txtBankName;
	private String				txtBranchName;
	private String				lblBankName;
	private String				lblBranchName;
	
	// tB[hyѐ
	public static final String	NAM_CO_BANK_CODE		= "ЋsR[h";
	public static final String	NAM_BANK_CODE			= "sR[h";
	public static final String	NAM_BRANCH_CODE			= "xXR[h";
	public static final String	TNM_ACCOUNT_TYPE		= "a敪";
	public static final String	NAM_ACCOUNT_NO			= "ԍ";
	public static final String	NAM_DELETE				= "L/";
	public static final String	NAM_BANK_NAME			= "s";
	public static final String	NAM_BRANCH_NAME			= "xX";
	
	public static final int		LEN_CO_BANK_CODE		= 2;
	public static final int		LEN_BANK_CODE			= 4;
	public static final int		LEN_BRANCH_CODE			= 3;
	public static final int		LEN_ACCOUNT_NO			= 7;
	
	// \[gL[
	public final String			KEY_CO_BANK_CODE		= "keyCoBankCode";
	public final String			KEY_BANK_CODE			= "keyBankCode";
	public final String			KEY_BRANCH_CODE			= "keyBranchCode";
	public final String			KEY_ACCOUNT_TYPE		= "keyAccountType";
	public final String			KEY_ACCOUNT_NO			= "keyAccountNo";
	public final String			KEY_DELETE				= "keydelete";
	public final String			KEY_BANK_NAME			= "keyBankName";
	public final String			KEY_BRANCH_NAME			= "keyBranchName";
	
	// v_EXg
	public String[][]			aryPltAccountType;
	
	// [h(0Fo^A1FXV)
	private int					mode;
	
	// sXg
	public String[][]			aryPltPaidBankName;
	public String[][]			aryPltPaidBranchName;
	

	/**
	 * RXgN^
	 */
	public CompanyCoBankVo() {
		super();
		txtCoBankCode = "";
		txtBankCode = "";
		txtBranchCode = "";
		txtAccountNo = "";
		pltAccountType = "";
		pltDelete = "";
		txtBankName = "";
		txtBranchName = "";
		
		lblBankName = "";
		lblBranchName = "";
		
		aryCoBankCode = new String[0];
		aryBankCode = new String[0];
		aryBranchCode = new String[0];
		aryAccountType = new String[0];
		aryAccountNo = new String[0];
		aryDelete = new String[0];
		aryBankName = new String[0];
		aryBranchName = new String[0];
		setFormerKey(KEY_CO_BANK_CODE);
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_COMPANY") + getName("P_BANK") + getName("P_MAINTENANCE");
		addAryMenu("U5248", getName("P_COMPANY") + getName("P_INFORMATION") + getName("P_MAINTENANCE")
				+ getName("C_TO"));
		addAryMenu("P1002", getName("P_PAYROLL") + getName("C_MASTER") + getName("C_MENU") + getName("C_TO"));
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtCoBankCode = request.getParameter(PRM_TXT_CO_BANK_CODE);
		txtBankCode = request.getParameter(PRM_TXT_BANK_CODE);
		txtBranchCode = request.getParameter(PRM_TXT_BRANCH_CODE);
		txtAccountNo = request.getParameter(PRM_TXT_ACCOUNT_NO);
		pltAccountType = request.getParameter(PRM_PLT_ACCOUNT_TYPE);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
		txtBankName = request.getParameter(PRM_TXT_BANK_NAME);
		txtBranchName = request.getParameter(PRM_TXT_BRANCH_NAME);
		
	}
	
	/**
	 * tB[hݒ
	 * @param dto 
	 */
	public void setFields(CmCoBankDto dto) {
		txtCoBankCode = dto.getCoBankCode();
		txtBankCode = dto.getBankCode();
		txtBranchCode = dto.getBranchCode();
		txtAccountNo = dto.getAccountNo();
		pltAccountType = String.valueOf(dto.getAccountType());
		pltDelete = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * tB[hݒ
	 * @param listCmCoBank Ћso^Xg
	 * @throws MospException
	 */
	public void setFields(List listCmCoBank) throws MospException {
		// Xg̐ݒ
		list = listCmCoBank;
		// f[^̎擾
		count = listCmCoBank.size();
		// z̏
		aryCoBankCode = new String[count];
		aryBankCode = new String[count];
		aryBranchCode = new String[count];
		aryAccountType = new String[count];
		aryAccountNo = new String[count];
		aryDelete = new String[count];
		aryBankName = new String[count];
		aryBranchName = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listCmCoBank.iterator();
		
		while (it.hasNext()) {
			CmCoBankDto dto = (CmCoBankDto)it.next();
			aryCoBankCode[i] = escapeHTML(dto.getCoBankCode());
			aryBankCode[i] = escapeHTML(dto.getBankCode());
			aryBranchCode[i] = escapeHTML(dto.getBranchCode());
			aryAccountType[i] = dto.getAccountType();
			aryAccountNo[i] = escapeHTML(dto.getAccountNo());
			aryDelete[i] = String.valueOf(dto.getDeleteFlag());
			
			aryAccountType[i] = "";
			for (String[] element : aryPltAccountType) {
				if (dto.getAccountType().equals(element[0])) {
					aryAccountType[i] = escapeHTML(element[1]);
					break;
				}
			}
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			} else {
				throw new MospException(MospConst.EX_CM_USER_ILLEGAL);
			}
			i++;
		}
	}
	
	/**
	 * sݒ肷B<br>
	 * s̔zɋsZbgB<br>
	 * Ћso^ꗗŁAsR[hƈvsݒ肷B
	 * @param index
	 * @param bankName
	 */
	public void setBankName(int index, String bankName) {
		aryBankName[index] = escapeHTML(bankName);
	}
	
	/**
	 * xXݒ肷B<br>
	 * xX̔zɎxXZbgB<br>
	 * Ћso^ꗗŁAsR[hExXR[hƈvxXݒ肷B
	 * @param index
	 * @param branchName
	 */
	public void setBranchName(int index, String branchName) {
		aryBranchName[index] = escapeHTML(branchName);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtCoBankCode, NAM_CO_BANK_CODE, PRM_TXT_CO_BANK_CODE);
		checkRequired(txtBankCode, NAM_BANK_CODE, PRM_TXT_BANK_CODE);
		checkRequired(txtBranchCode, NAM_BRANCH_CODE, PRM_TXT_BRANCH_CODE);
		checkRequired(pltAccountType, TNM_ACCOUNT_TYPE, PRM_PLT_ACCOUNT_TYPE);
		checkRequired(txtAccountNo, NAM_ACCOUNT_NO, PRM_TXT_ACCOUNT_NO);
		checkRequired(pltDelete, NAM_DELETE, PRM_PLT_DELETE);
		// ^CvmF
		checkCode(txtCoBankCode, NAM_CO_BANK_CODE, PRM_TXT_CO_BANK_CODE);
		//checkCode    (txtBankCode    , NAM_BANK_CODE    , PRM_TXT_BANK_CODE    );
		//checkCode    (txtBranchCode  , NAM_BRANCH_CODE  , PRM_TXT_BRANCH_CODE  );
		//checkCode    (pltAccountType , TNM_ACCOUNT_TYPE , PRM_PLT_ACCOUNT_TYPE );
		//checkCode    (txtAccountNo   , NAM_ACCOUNT_NO   , PRM_TXT_ACCOUNT_NO   );
		//checkRegex   (pltDelete, REG_DELETE, NAM_DELETE , PRM_PLT_DELETE       );
		// 񒷊mF
		checkLength(txtCoBankCode, LEN_CO_BANK_CODE, NAM_CO_BANK_CODE, PRM_TXT_CO_BANK_CODE);
		checkLength(txtBankCode, LEN_BANK_CODE, NAM_BANK_CODE, PRM_TXT_BANK_CODE);
		checkLength(txtBranchCode, LEN_BRANCH_CODE, NAM_BRANCH_CODE, PRM_TXT_BRANCH_CODE);
		//checkLength  (pltAccountType , LEN_ACCOUNT_TYPE , TNM_ACCOUNT_TYPE , PRM_PLT_ACCOUNT_TYPE );
		checkLength(txtAccountNo, LEN_ACCOUNT_NO, NAM_ACCOUNT_NO, PRM_TXT_ACCOUNT_NO);
		// mF
		checkNumeric(txtBankCode, NAM_BANK_CODE, PRM_TXT_BANK_CODE);
		checkNumeric(txtBranchCode, NAM_BRANCH_CODE, PRM_TXT_BRANCH_CODE);
		checkNumeric(txtAccountNo, NAM_ACCOUNT_NO, PRM_TXT_ACCOUNT_NO);
		// ÓmFI
		endValidation();
	}
	
	/**
	 * Z@JSݒ
	 * @param sb
	 */
	protected void setFinanceData(StringBuffer sb) {
		sb.append("</script>");
		sb.append("<script type=\"text/javascript\" src=\"..");
		sb.append(PayrollConst.JS_FINANCE);
		sb.append("\"></script>");
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class<?> cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		// sJSݒ
		setFinanceData(sb);
		
		return sb.toString();
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmCoBankDto dto) {
		dto.setCoBankCode(txtCoBankCode);
		dto.setBankCode(txtBankCode);
		dto.setBranchCode(txtBranchCode);
		dto.setAccountType(pltAccountType);
		dto.setAccountNo(txtAccountNo);
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}
	
	/**
	 * 
	 */
	public void setInitFields() {
		txtCoBankCode = "";
		txtBankCode = "";
		txtBranchCode = "";
		pltAccountType = "";
		txtAccountNo = "";
		pltDelete = "";
		lblBankName = "";
		lblBranchName = "";
	}
	
	// ANZT\bh
	public void setTxtCoBankCode(String txtCoBankCode) {
		this.txtCoBankCode = txtCoBankCode;
	}
	
	public void setTxtBankCode(String txtBankCode) {
		this.txtBankCode = txtBankCode;
	}
	
	public void setTxtBranchCode(String txtBranchCode) {
		this.txtBranchCode = txtBranchCode;
	}
	
	public void setPltAccountType(String pltAccountType) {
		this.pltAccountType = pltAccountType;
	}
	
	public void setTxtAccountNo(String txtAccountNo) {
		this.txtAccountNo = txtAccountNo;
	}
	
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}
	
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	public void setLblBankName(String lblBankName) {
		this.lblBankName = lblBankName;
	}
	
	public void setLblBranchName(String lblBranchName) {
		this.lblBranchName = lblBranchName;
	}
	
	public String[] getEscAryCoBankCode() {
		return aryCoBankCode.clone();
	}
	
	public String[] getEscAryBankCode() {
		return aryBankCode.clone();
	}
	
	public String[] getEscAryBranchCode() {
		return aryBranchCode.clone();
	}
	
	public String[] getEscAryAccountType() {
		return aryAccountType.clone();
	}
	
	public String[] getEscAryAccountNo() {
		return aryAccountNo.clone();
	}
	
	public String[] getEscAryDelete() {
		return aryDelete.clone();
	}
	
	public String getTxtCoBankCode() {
		return txtCoBankCode;
	}
	
	public String getTxtBankCode() {
		return txtBankCode;
	}
	
	public String getTxtBranchCode() {
		return txtBranchCode;
	}
	
	public String getTxtAccountNo() {
		return txtAccountNo;
	}
	
	public String getPltAccountType() {
		return pltAccountType;
	}
	
	public String getPltDelete() {
		return pltDelete;
	}
	
	public String getEscTxtCoBankCode() {
		return escapeHTML(txtCoBankCode);
	}
	
	public String getEscTxtBankCode() {
		return escapeHTML(txtBankCode);
	}
	
	public String getEscTxtBranchCode() {
		return escapeHTML(txtBranchCode);
	}
	
	public String getEscTxtAccountNo() {
		return escapeHTML(txtAccountNo);
	}
	
	public int getMode() {
		return mode;
	}
	
	public void setPltDelete(int pltDelete) {
		this.pltDelete = String.valueOf(pltDelete);
	}
	
	public void setTxtBankName(String txtBankName) {
		this.txtBankName = txtBankName;
	}
	
	public void setTxtBranchName(String txtBranchName) {
		this.txtBranchName = txtBranchName;
	}
	
	public String[] getEscAryBankName() {
		return aryBankName.clone();
	}
	
	public String[] getEscAryBranchName() {
		return aryBranchName.clone();
	}
	
	public String getTxtBankName() {
		return txtBankName;
	}
	
	public String getTxtBranchName() {
		return txtBranchName;
	}
	
	public String getEscTxtBankName() {
		return escapeHTML(txtBankName);
	}
	
	public String getEscTxtBranchName() {
		return escapeHTML(txtBranchName);
	}
	
	public String getEscLblBankName() {
		return escapeHTML(lblBankName);
	}
	
	public String getEscLblBranchName() {
		return escapeHTML(lblBranchName);
	}
	
}
