package jp.mosp.payroll.payment.action;

import java.util.Date;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.PtCurrentDao;
import jp.mosp.payroll.dto.PtCurrentDto;
import jp.mosp.payroll.payment.vo.EndCalcVo;

/**
 * ^vZIʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li><li>
 * {@link #CMD_EXECUTE}
 * </li></ul>
 */
public class EndCalcAction extends PayrollAction {
	
	/**
	 * ʕ\R}hB<br><br>
	 * ^vZ̔N擾A\B<br>
	 * ^vZ̔NȂꍇ́AxB<br>
	 */
	public static final String	CMD_SHOW	= "P1210";
	
	/**
	 * sR}hB<br><br>
	 * \ꂽvZNɑ΂āAvZIԂɂB<br>
	 */
	public static final String	CMD_EXECUTE	= "P1215";
	

	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public EndCalcAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new EndCalcVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else if (cmd.equals(CMD_EXECUTE)) {
			// s
			execute();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br>
	 * @throws Exception 
	 */
	@Override
	public void show() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		EndCalcVo vo = (EndCalcVo)getVo();
		// vZ擾
		Date current = getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT);
		// vZmF
		if (current == null) {
			// ʃ[hݒ
			vo.setMode(1);
			// xbZ[Wݒ
			vo.addErrMessage(MospUtility.getMessage(msg, "WP1210", ""));
			// OX[
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		// VOtB[hݒ
		vo.setCalcDate(current);
		// ʃ[hݒ
		vo.setMode(0);
	}
	
	/**
	 * ^vZIsB<br>
	 * @throws Exception 
	 */
	private void execute() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		EndCalcVo vo = (EndCalcVo)getVo();
		// Ώ۔N擾
		Date targetMonth = vo.getCalcDate();
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		// ΏۊmF
		PtCurrentDto dto = dao.findForUpdate(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT, targetMonth);
		// DTOύX
		dto.setCurrentStatus(PayrollConst.CURRENT_END);
		// XV
		dao.update(dto);
		// R~bg
		commit();
		// ʃ[hݒ
		vo.setMode(2);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
	}
	
}
