package jp.mosp.payroll.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

/**
 * ^wb_
 * @author koike
 *
 */
public class PhPaymentDto extends BaseDto {
	
	private static final long	serialVersionUID	= 5167119611329975677L;
	
	private String				kCode;
	private Date				calcMonth;
	private Date				payDate;
	private String				slipCode;
	private int					allowanceTotal;							// xz
	private int					deductionTotal;
	private int					paymentTotal;
	private int					taxation;									// ېŎxz
	private int					socInsTotal;								// Љیv
	private int					dependent;
	private int					incomeTax;
	private int					adjustedTax;
	private int					insureMoney;
	private int					insureInKind;
	private int					insureFixed;
	private int					insureUnemploy;
	private int					bonusBase;
	

	/**
	 * Ŋz擾B
	 * @return Ŋz
	 */
	public int getAdjustedTax() {
		return adjustedTax;
	}
	
	/**
	 * Ŋzݒ肷B
	 * @param adjustedTax ݒ肷钲Ŋz
	 */
	public void setAdjustedTax(int adjustedTax) {
		this.adjustedTax = adjustedTax;
	}
	
	/**
	 * xz擾B
	 * @return xz
	 */
	public int getAllowanceTotal() {
		return allowanceTotal;
	}
	
	/**
	 * xzݒ肷B
	 * @param allowanceTotal ݒ肷鑍xz
	 */
	public void setAllowanceTotal(int allowanceTotal) {
		this.allowanceTotal = allowanceTotal;
	}
	
	/**
	 * vZN擾B
	 * @return vZN
	 */
	public Date getCalcMonth() {
		return getDateField(calcMonth);
	}
	
	/**
	 * vZNݒ肷B
	 * @param calcMonth ݒ肷vZN
	 */
	public void setCalcMonth(Date calcMonth) {
		this.calcMonth = getDateField(calcMonth);
	}
	
	/**
	 * Tz擾B
	 * @return Tz
	 */
	public int getDeductionTotal() {
		return deductionTotal;
	}
	
	/**
	 * Tzݒ肷B
	 * @param deductionTotal ݒ肷鑍Tz
	 */
	public void setDeductionTotal(int deductionTotal) {
		this.deductionTotal = deductionTotal;
	}
	
	/**
	 * }{̐擾B
	 * @return }{̐
	 */
	public int getDependent() {
		return dependent;
	}
	
	/**
	 * }{̐ݒ肷B
	 * @param dependent ݒ肷}{̐
	 */
	public void setDependent(int dependent) {
		this.dependent = dependent;
	}
	
	/**
	 * Ŋz擾B
	 * @return Ŋz
	 */
	public int getIncomeTax() {
		return incomeTax;
	}
	
	/**
	 * Ŋzݒ肷B
	 * @param incomeTax ݒ肷鏊Ŋz
	 */
	public void setIncomeTax(int incomeTax) {
		this.incomeTax = incomeTax;
	}
	
	/**
	 * ЈR[h擾B
	 * @return ЈR[h
	 */
	public String getKCode() {
		return kCode;
	}
	
	/**
	 * ЈR[hݒ肷B
	 * @param kCode ݒ肷ЈR[h
	 */
	public void setKCode(String kCode) {
		this.kCode = kCode;
	}
	
	/**
	 * x擾B
	 * @return x
	 */
	public Date getPayDate() {
		return getDateField(payDate);
	}
	
	/**
	 * xݒ肷B
	 * @param payDate ݒ肷x
	 */
	public void setPayDate(Date payDate) {
		this.payDate = getDateField(payDate);
	}
	
	/**
	 * xz擾B
	 * @return xz
	 */
	public int getPaymentTotal() {
		return paymentTotal;
	}
	
	/**
	 * xzݒ肷B
	 * @param paymentTotal ݒ肷鍷xz
	 */
	public void setPaymentTotal(int paymentTotal) {
		this.paymentTotal = paymentTotal;
	}
	
	/**
	 * Љی擾B
	 * @return Љی
	 */
	public int getSocInsTotal() {
		return socInsTotal;
	}
	
	/**
	 * Љیݒ肷B
	 * @param socInsTotal ݒ肷Љی
	 */
	public void setSocInsTotal(int socInsTotal) {
		this.socInsTotal = socInsTotal;
	}
	
	/**
	 * ېőΏۊz擾B(ېŎxzƉېőΏۊz̏ꍇ)
	 * @return ېőΏۊz
	 */
	public int getTaxation() {
		return taxation;
	}
	
	/**
	 * ېőΏۊzݒ肷B
	 * @param taxation ݒ肷ېőΏۊz
	 */
	public void setTaxation(int taxation) {
		this.taxation = taxation;
	}
	
	/**
	 * `[R[h擾B
	 * @return `[R[h
	 */
	public String getSlipCode() {
		return slipCode;
	}
	
	/**
	 * `[R[hݒ肷B
	 * @param slipCode ݒ肷`[R[h
	 */
	public void setSlipCode(String slipCode) {
		this.slipCode = slipCode;
	}
	
	/**
	 * ЉیΏیŒ擾B
	 * @return ЉیΏیŒ
	 */
	public int getInsureFixed() {
		return insureFixed;
	}
	
	/**
	 * ЉیΏیŒݒ肷B
	 * @param insureFixed ݒ肷ЉیΏیŒ
	 */
	public void setInsureFixed(int insureFixed) {
		this.insureFixed = insureFixed;
	}
	
	/**
	 * ЉیΏی擾B
	 * @return ЉیΏی
	 */
	public int getInsureInKind() {
		return insureInKind;
	}
	
	/**
	 * ЉیΏیݒ肷B
	 * @param insureInKind ݒ肷ЉیΏی
	 */
	public void setInsureInKind(int insureInKind) {
		this.insureInKind = insureInKind;
	}
	
	/**
	 * ЉیΏۋK擾B
	 * @return ЉیΏۋK
	 */
	public int getInsureMoney() {
		return insureMoney;
	}
	
	/**
	 * ЉیΏۋKݒ肷B
	 * @param insureMoney ݒ肷ЉیΏۋK
	 */
	public void setInsureMoney(int insureMoney) {
		this.insureMoney = insureMoney;
	}
	
	/**
	 * ٗpیΏۊz擾B
	 * @return ٗpیΏۊz
	 */
	public int getInsureUnemploy() {
		return insureUnemploy;
	}
	
	/**
	 * ٗpیΏۊzݒ肷B
	 * @param insureUnemploy ݒ肷ٗpیΏۊz
	 */
	public void setInsureUnemploy(int insureUnemploy) {
		this.insureUnemploy = insureUnemploy;
	}
	
	/**
	 * ܗ^vZΏۊz擾B
	 * @return ܗ^vZΏۊz
	 */
	public int getBonusBase() {
		return bonusBase;
	}
	
	/**
	 * ܗ^vZΏۊzݒ肷B
	 * @param bonusBase ݒ肷ܗ^vZΏۊz
	 */
	public void setBonusBase(int bonusBase) {
		this.bonusBase = bonusBase;
	}
	
	/**
	 * ېŊz擾
	 * @return ېŊz
	 */
	public int getTaxExempt() {
		int taxExempt;
		if (allowanceTotal > 0 && allowanceTotal > taxation) {
			// xz-ېŎxz
			taxExempt = allowanceTotal - taxation;
		} else {
			taxExempt = 0;
		}
		// xz-Љیv-ېőΏۊz
		//int taxExempt = allowanceTotal- socInsTotal  - amountToTaxation;
		// xz0ېőΏۊz0ȂېŊz0B
		//if (allowanceTotal == 0 && amountToTaxation == 0) {
		//	taxExempt = 0;
		//}
		
		/*
		if (taxExempt < 0) {
			taxExempt = 0;
		}
		*/
		return taxExempt;
	}
	
	/**
	 * ېőΏۊz擾B
	 * @return ېőΏۊz
	 */
	public int getAmountToTaxation() {
		int amountToTaxation;
		if (taxation > 0 && taxation > socInsTotal) {
			// ېŋz - Љیv
			amountToTaxation = taxation - socInsTotal;
		} else {
			amountToTaxation = 0;
		}
		return amountToTaxation;
	}
	
}
