package jp.mosp.payroll.dto;

import jp.mosp.common.common.BaseDto;

public class CdAdjustmentDto extends BaseDto {
	
	private static final long	serialVersionUID	= -7044767143429998535L;
	
	// tB[h
	private String				kCode;											// ЈR[h
	private int					adjustYear;									// N
	private String				adjustStatus;									// NvZ
	private int					generalLifeIns;								// ʂ̐ی
	private int					privatePension;								// lNی
	private int					lifeInsDeduction;								// یTz
	private int					earthquakeIns;									// nkی
	private int					longTermDamageIns;								// Qی
	private int					damageInsDeduction;							// QیTz
	private int					socialInsDeduction;							// ЉیTz
	private int					mutualAidDeduction;							// K͊Ƌϓ|Tz
	private int					spouseSumIncome;								// z҂̖{N̍vžϊz
	private int					spouseSpDeduction;								// zғʍTz
	private int					houseLoanDeduction;							// ZؓʍTz
	private int					allowanceAdjustment;							// xz
	private int					taxFreeAdjustment;								// ېŒz
	private int					socInsAdjustment;								// Љیz
	private int					taxIncAdjustment;								// Œz
	private String				withholdSlipNotes;								// 򒥎[Ev
	private int					paymentAllowance;								// ^A蓖z
	private int					paymentIncomeTax;								// ^A蓖Ŋz
	private int					bonusAllowance;								// ܗ^z
	private int					bonusIncomeTax;								// ܗ^Ŋz
	private int					midwayAdjustIncome;							// rAz
	private int					midwayAdjustTax;								// rAŊz
	private int					afterDeductIncome;								// ^T̋^̋z
	private int					payInsDeduction;								// Љی^̍T
	private int					dependentsDeduction;							// zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	private int					calcTaxedIncome;								// ېŋ^z
	private int					calcIncomeTax;									// ZoNŊz
	private int					adjustedIncomeTax;								// NNŊz
	private int					deductedIncomeTax;								// N藦TzŊz
	private int					finalIncomeTax;								// NŊz
	private String				deadRetirement;								// SސE
	private String				selfDisaster;									// ЊQ
	private String				foreigner;										// Ol
																				
	
	/**
	 * RXgN^
	 */
	public CdAdjustmentDto() {
		super();
	}
	
	// ANZT\bh
	public String getKCode() {
		return kCode;
	} // ЈR[h
	
	public int getAdjustYear() {
		return adjustYear;
	} // N
	
	public String getAdjustStatus() {
		return adjustStatus;
	} // NvZ
	
	public int getGeneralLifeIns() {
		return generalLifeIns;
	} // ʂ̐ی
	
	public int getPrivatePension() {
		return privatePension;
	} // lNی
	
	public int getLifeInsDeduction() {
		return lifeInsDeduction;
	} // یTz
	
	public int getEarthquakeIns() {
		return earthquakeIns;
	} // nkی
	
	public int getLongTermDamageIns() {
		return longTermDamageIns;
	} // Qی
	
	public int getDamageInsDeduction() {
		return damageInsDeduction;
	} // QیTz
	
	public int getSocialInsDeduction() {
		return socialInsDeduction;
	} // ЉیTz
	
	public int getMutualAidDeduction() {
		return mutualAidDeduction;
	} // K͊Ƌϓ|Tz
	
	public int getSpouseSumIncome() {
		return spouseSumIncome;
	} // z҂̖{N̍vžϊz
	
	public int getSpouseSpDeduction() {
		return spouseSpDeduction;
	} // zғʍTz
	
	public int getHouseLoanDeduction() {
		return houseLoanDeduction;
	} // ZؓʍTz
	
	public int getAllowanceAdjustment() {
		return allowanceAdjustment;
	} // xz
	
	public int getTaxFreeAdjustment() {
		return taxFreeAdjustment;
	} // ېŒz
	
	public int getSocInsAdjustment() {
		return socInsAdjustment;
	} // Љیz
	
	public int getTaxIncAdjustment() {
		return taxIncAdjustment;
	} // Œz
	
	public String getWithholdSlipNotes() {
		return withholdSlipNotes;
	} // 򒥎[Ev
	
	public int getPaymentAllowance() {
		return paymentAllowance;
	} // ^A蓖z
	
	public int getPaymentIncomeTax() {
		return paymentIncomeTax;
	} // ^A蓖Ŋz
	
	public int getBonusAllowance() {
		return bonusAllowance;
	} // ܗ^z
	
	public int getBonusIncomeTax() {
		return bonusIncomeTax;
	} // ܗ^Ŋz
	
	public int getMidwayAdjustIncome() {
		return midwayAdjustIncome;
	} // rAz
	
	public int getMidwayAdjustTax() {
		return midwayAdjustTax;
	} // rAŊz
	
	public int getAfterDeductIncome() {
		return afterDeductIncome;
	} // ^T̋^̋z
	
	public int getPayInsDeduction() {
		return payInsDeduction;
	} // Љی^̍T
	
	public int getDependentsDeduction() {
		return dependentsDeduction;
	} // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	
	public int getCalcTaxedIncome() {
		return calcTaxedIncome;
	} // ېŋ^z
	
	public int getCalcIncomeTax() {
		return calcIncomeTax;
	} // ZoNŊz
	
	public int getAdjustedIncomeTax() {
		return adjustedIncomeTax;
	} // NNŊz
	
	public int getDeductedIncomeTax() {
		return deductedIncomeTax;
	} // N藦TzŊz
	
	public int getFinalIncomeTax() {
		return finalIncomeTax;
	} // NŊz
	
	public String getDeadRetirement() {
		return deadRetirement;
	} // SސE
	
	public String getSelfDisaster() {
		return selfDisaster;
	} // ЊQ
	
	public String getForeigner() {
		return foreigner;
	} // Ol
	
	public void setKCode(String kCode) {
		this.kCode = kCode;
	} // ЈR[h
	
	public void setAdjustYear(int adjustYear) {
		this.adjustYear = adjustYear;
	} // N
	
	public void setAdjustStatus(String adjustStatus) {
		this.adjustStatus = adjustStatus;
	} // NvZ
	
	public void setGeneralLifeIns(int generalLifeIns) {
		this.generalLifeIns = generalLifeIns;
	} // ʂ̐ی
	
	public void setPrivatePension(int privatePension) {
		this.privatePension = privatePension;
	} // lNی
	
	public void setLifeInsDeduction(int lifeInsDeduction) {
		this.lifeInsDeduction = lifeInsDeduction;
	} // یTz
	
	public void setEarthquakeIns(int earthquakeIns) {
		this.earthquakeIns = earthquakeIns;
	} // nkی
	
	public void setLongTermDamageIns(int longTermDamageIns) {
		this.longTermDamageIns = longTermDamageIns;
	} // Qی
	
	public void setDamageInsDeduction(int damageInsDeduction) {
		this.damageInsDeduction = damageInsDeduction;
	} // QیTz
	
	public void setSocialInsDeduction(int socialInsDeduction) {
		this.socialInsDeduction = socialInsDeduction;
	} // ЉیTz
	
	public void setMutualAidDeduction(int mutualAidDeduction) {
		this.mutualAidDeduction = mutualAidDeduction;
	} // K͊Ƌϓ|Tz
	
	public void setSpouseSumIncome(int spouseSumIncome) {
		this.spouseSumIncome = spouseSumIncome;
	} // z҂̖{N̍vžϊz
	
	public void setSpouseSpDeduction(int spouseSpDeduction) {
		this.spouseSpDeduction = spouseSpDeduction;
	} // zғʍTz
	
	public void setHouseLoanDeduction(int houseLoanDeduction) {
		this.houseLoanDeduction = houseLoanDeduction;
	} // ZؓʍTz
	
	public void setAllowanceAdjustment(int allowanceAdjustment) {
		this.allowanceAdjustment = allowanceAdjustment;
	} // xz
	
	public void setTaxFreeAdjustment(int taxFreeAdjustment) {
		this.taxFreeAdjustment = taxFreeAdjustment;
	} // ېŒz
	
	public void setSocInsAdjustment(int socInsAdjustment) {
		this.socInsAdjustment = socInsAdjustment;
	} // Љیz
	
	public void setTaxIncAdjustment(int taxIncAdjustment) {
		this.taxIncAdjustment = taxIncAdjustment;
	} // Œz
	
	public void setWithholdSlipNotes(String withholdSlipNotes) {
		this.withholdSlipNotes = withholdSlipNotes;
	} // 򒥎[Ev
	
	public void setPaymentAllowance(int paymentAllowance) {
		this.paymentAllowance = paymentAllowance;
	} // ^A蓖z
	
	public void setPaymentIncomeTax(int paymentIncomeTax) {
		this.paymentIncomeTax = paymentIncomeTax;
	} // ^A蓖Ŋz
	
	public void setBonusAllowance(int bonusAllowance) {
		this.bonusAllowance = bonusAllowance;
	} // ܗ^z
	
	public void setBonusIncomeTax(int bonusIncomeTax) {
		this.bonusIncomeTax = bonusIncomeTax;
	} // ܗ^Ŋz
	
	public void setMidwayAdjustIncome(int midwayAdjustIncome) {
		this.midwayAdjustIncome = midwayAdjustIncome;
	} // rAz
	
	public void setMidwayAdjustTax(int midwayAdjustTax) {
		this.midwayAdjustTax = midwayAdjustTax;
	} // rAŊz
	
	public void setAfterDeductIncome(int afterDeductIncome) {
		this.afterDeductIncome = afterDeductIncome;
	} // ^T̋^̋z
	
	public void setPayInsDeduction(int payInsDeduction) {
		this.payInsDeduction = payInsDeduction;
	} // Љی^̍T
	
	public void setDependentsDeduction(int dependentsDeduction) {
		this.dependentsDeduction = dependentsDeduction;
	} // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	
	public void setCalcTaxedIncome(int calcTaxedIncome) {
		this.calcTaxedIncome = calcTaxedIncome;
	} // ېŋ^z
	
	public void setCalcIncomeTax(int calcIncomeTax) {
		this.calcIncomeTax = calcIncomeTax;
	} // ZoNŊz
	
	public void setAdjustedIncomeTax(int adjustedIncomeTax) {
		this.adjustedIncomeTax = adjustedIncomeTax;
	} // NNŊz
	
	public void setDeductedIncomeTax(int deductedIncomeTax) {
		this.deductedIncomeTax = deductedIncomeTax;
	} // N藦TzŊz
	
	public void setFinalIncomeTax(int finalIncomeTax) {
		this.finalIncomeTax = finalIncomeTax;
	} // NŊz
	
	public void setDeadRetirement(String deadRetirement) {
		this.deadRetirement = deadRetirement;
	} // SސE
	
	public void setSelfDisaster(String selfDisaster) {
		this.selfDisaster = selfDisaster;
	} // ЊQ
	
	public void setForeigner(String foreigner) {
		this.foreigner = foreigner;
	} // Ol
	
	/**
	 * Ŋz擾
	 * @return Ŋz
	 */
	public int getTaxGap() {
		return finalIncomeTax - paymentIncomeTax - bonusIncomeTax - midwayAdjustTax;
	}
	
	/**
	 * Tvz擾
	 * @return Tvz
	 */
	public int getIncomeDeductSum() {
		return lifeInsDeduction + damageInsDeduction + socialInsDeduction + mutualAidDeduction + spouseSpDeduction
				+ payInsDeduction + dependentsDeduction;
	}
	
	/**
	 * ōvz擾
	 * @return ōvz
	 */
	public int getIncomeTaxSum() {
		return paymentIncomeTax + bonusIncomeTax + midwayAdjustTax;
	}
	
	/**
	 * ېŏvz擾
	 * @return ېŏvz
	 */
	public int getTaxedPaymentSum() {
		return paymentAllowance + bonusAllowance + midwayAdjustIncome;
	}
	
}
