package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.Date;

import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.ResideTransferFBDataDto;

/**
 * @author koike
 *
 */
public class ResideTransferDao extends PayrollDao {
	
	// 
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE				= PdPayDeductionDao.COL_KCODE;
	
	/**
	 * vZN
	 */
	public static final String	COL_CALC_DATE			= PdPayDeductionDao.COL_CALC_DATE;
	
	/**
	 * ׃R[h
	 */
	public static final String	COL_DETAIL_CODE			= PdPayDeductionDao.COL_DETAIL_CODE;
	
	/**
	 * ЈR[h
	 */
	public static final String	COL_RES_K_CODE			= CmResidenceTaxDao.COL_K_CODE;
	
	/**
	 * Zōv
	 */
	public static final String	COL_SUM_RESIDENCE_TAX	= "SUM(" + "PAY." + PdPayDeductionDao.COL_AMOUNT + ")";
	
	/**
	 * ZŌ
	 */
	public static final String	COL_COUNT_RESIDENCE_TAX	= "COUNT(" + "PAY." + PdPayDeductionDao.COL_AMOUNT + ")";
	
	/**
	 * ׃R[h Z
	 */
	public static final String	COL_DETAIL_CODE_PD007	= "PD007";
	

	/**
	 * RXgN^
	 */
	public ResideTransferDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "";
		UPDATE_USER = "";
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return ResideTransferFBDataDto ZFBR[h
	 * @throws SQLException SQLOꍇ
	 */
	private ResideTransferFBDataDto mapping() throws SQLException {
		ResideTransferFBDataDto dto = new ResideTransferFBDataDto();
		// v
		dto.setTotalCount(rs.getInt(COL_COUNT_RESIDENCE_TAX));
		// vŊz
		dto.setTotalTax(rs.getInt(COL_SUM_RESIDENCE_TAX));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ɂf[^擾
	 * @param cityCode sR[h
	 * @param calcDate vZN
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public ResideTransferFBDataDto findForFirmBanking(String cityCode, Date calcDate) throws SQLException,
			IllegalAccessException {
		index = 1;
		CmResidenceTaxDao cmResidenceTaxDao = new CmResidenceTaxDao();
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_SUM_RESIDENCE_TAX);
		sb.append(", ");
		sb.append(COL_COUNT_RESIDENCE_TAX);
		sb.append(" FROM ");
		sb.append(PdPayDeductionDao.TABLE + " PAY");
		sb.append(" , ");
		sb.append(cmResidenceTaxDao.getHistoryTableForFB());
		sb.append(" RES ");
		sb.append(" WHERE ");
		sb.append("PAY." + COL_CALC_DATE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append("PAY." + COL_DETAIL_CODE);
		sb.append(" = ");
		sb.append("'" + COL_DETAIL_CODE_PD007 + "'");
		sb.append(" AND ");
		sb.append("PAY.");
		sb.append(COL_K_CODE);
		sb.append(" =  ");
		sb.append("RES.");
		sb.append(COL_RES_K_CODE);
		
		try {
			prepareStatement(sb.toString());
			setParam(index++, calcDate);
			setParam(index++, cityCode);
			setParam(index++, calcDate);
			executeQuery();
			ResideTransferFBDataDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
}
