/**
 * 
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.MospConst;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;

/**
 * @author koike
 *
 */
public class KdSubstituteHolidayDao extends jp.mosp.kintai.payroll.dao.KdSubstituteHolidayDao {
	
	/**
	 * ʎ擾(DTOList)B
	 * @return ʃXg
	 * @throws SQLException 	SQLOꍇ
	 */
	@SuppressWarnings("unused")
	private List<KdSubstituteHolidayDto> mappingAll() throws SQLException {
		List<KdSubstituteHolidayDto> all = new ArrayList<KdSubstituteHolidayDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)B
	 * @return KD_SUBSTITUTE_HOLIDAYR[h
	 * @throws SQLException 	SQLOꍇ
	 */
	private KdSubstituteHolidayDto mapping() throws SQLException {
		KdSubstituteHolidayDto dto = new KdSubstituteHolidayDto();
		dto.setSubstituteId(rs.getLong(COL_SUBSTITUTE_ID));
		dto.setKCode(rs.getString(COL_K_CODE));
		dto.setOccurYear(rs.getInt(COL_OCCUR_YEAR));
		dto.setOccurMonth(rs.getInt(COL_OCCUR_MONTH));
		dto.setCloseDate(rs.getDate(COL_CLOSE_DATE));
		dto.setLimitStartDate(rs.getDate(COL_LIMIT_START_DATE));
		dto.setLimitEndDate(rs.getDate(COL_LIMIT_END_DATE));
		dto.setAttitudeStatus(rs.getString(COL_ATTITUDE_STATUS));
		dto.setPaymentAcquireTime(rs.getInt(COL_PAYMENT_ACQUIRE_TIME));
		dto.setPaymentAcquireHoliday(rs.getInt(COL_PAYMENT_ACQUIRE_HOLIDAY));
		dto.setPaymentQuitTime(rs.getInt(COL_PAYMENT_QUIT_TIME));
		dto.setUseHolidayTime(rs.getInt(COL_USE_HOLIDAY_TIME));
		dto.setAcquisitionStatus(rs.getString(COL_ACQUISITION_STATUS));
		dto.setLiquidationOverTime(rs.getInt(COL_LIQUIDATION_OVER_TIME));
		dto.setLiquidationWeekHoliday(rs.getInt(COL_LIQUIDATION_WEEK_HOLIDAY));
		dto.setDecisionStatus(rs.getString(COL_DECISION_STATUS));
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * L[ɂf[^擾B
	 * @param kCode 
	 * @param year 
	 * @param month 
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public KdSubstituteHolidayDto findForCondition(String kCode, int year, int month, String status)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE);
			sb.append(" = ?");
			sb.append(" AND ");
			sb.append(COL_OCCUR_YEAR);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_OCCUR_MONTH);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_DECISION_STATUS);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, year);
			setParam(index++, month);
			setParam(index++, status);
			executeQuery();
			
			KdSubstituteHolidayDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
}
