package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CmBankDto;

public class CmBankDao extends PayrollDao {
	
	public static final String	TABLE			= "CM_BANK";	// s}X^
	//public static final String TABLE2 = "CM_BRANCH"; // xX}X^
	public static final String	KEY_1			= "BANK_CODE";	// sR[h
																
	public static final String	COL_BANK_CODE	= "BANK_CODE";	//sR[h
	public static final String	COL_BANK_NAME	= "BANK_NAME";	//s
	public static final String	COL_BANK_KANA	= "BANK_KANA";	//stKi
																
	
	/**
	 * RXgN^
	 */
	public CmBankDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CmBankDto> mappingAll() throws SQLException {
		List<CmBankDto> all = new ArrayList<CmBankDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmBankDto CM_BANKR[h
	 * @throws SQLException
	 */
	private CmBankDto mapping() throws SQLException {
		CmBankDto dto = new CmBankDto();
		dto.setBankCode(rs.getString(COL_BANK_CODE)); // sR[h
		dto.setBankName(rs.getString(COL_BANK_NAME)); // s
		dto.setBankKana(rs.getString(COL_BANK_KANA)); // stKi
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * L[ɂf[^̎擾B<br>
	 * @param bankCode sR[h
	 * @return Ɉvs}X^̃R[h(v郌R[hꍇNULL)
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public CmBankDto findForKey(String bankCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, bankCode);
			executeQuery();
			CmBankDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param bankCode sR[h(L[)
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmBankDto findForUpdate(String bankCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, bankCode);
			executeQuery();
			CmBankDto cmBankDto = null;
			if (rs.next()) {
				cmBankDto = mapping();
			}
			return cmBankDto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmBankDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmBankDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmBankDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmBankDto dto, boolean needLog) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getBankCode());
			executeUpdate(needLog);
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}(Abv[h)
	 * @param aryCsvDate }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 */
	/*	public int insertUpload(
				String[] aryHeaderNo,
				String[] aryCsvData,
				String   bankCode,
				Date     calcDate
		) throws SQLException {
			try {
				Date date = new Date();
				index = 1;
				StringBuffer sb = new StringBuffer();
				sb.append("INSERT INTO ");
				sb.append(TABLE);
				sb.append(" ( ");
				sb.append(COL_BANK_CODE);
				sb.append(", ");
				sb.append(COL_BANK_NAME);
				sb.append(", ");
				sb.append(COL_BANK_KANA);
				sb.append(", ");
				if (!INSERT_DATE.equals("")) {
					sb.append(INSERT_DATE + ", ");
				}
				if (!INSERT_USER.equals("")) {
					sb.append(INSERT_USER + ", ");
				}
				if (!UPDATE_DATE.equals("")) {
					sb.append(UPDATE_DATE + ", ");
				}
				if (!UPDATE_USER.equals("")) {
					sb.append(UPDATE_USER + " ");
				}
				sb.append(" ) VALUES ( ");
				//sb.append("?, ");
				sb.append(insertRow(aryCsvData));
				sb.append("?, ");
				if (!INSERT_DATE.equals("")) {
					sb.append("?, ");
				}
				if (!INSERT_USER.equals("")) {
					sb.append("?, ");
				}
				if (!UPDATE_DATE.equals("")) {
					sb.append("?, ");
				}
				if (!UPDATE_USER.equals("")) {
					sb.append("?  ");
				}
				sb.append(" ) ");
				prepareStatement(sb.toString());
				setParam(index++, bankCode);
				for (int i = 0; i < aryCsvData.length; i++) {
					setParam(index++, aryCsvData[i]);
				}
				//setParam(index++, calcDate);
				if (!INSERT_DATE.equals("")) {
					setParam(index++, date);
				}
				if (!INSERT_USER.equals("")) {
					setParam(index++, userId);
				}
				if (!UPDATE_DATE.equals("")) {
					setParam(index++, date);
				}
				if (!UPDATE_USER.equals("")) {
					setParam(index++, userId);
				}
				executeUpdate();
				return cnt;
			} catch (SQLException e) {
				throw e;
			} finally {
				releaseResultSet();
				releasePreparedStatement();
			}
		}
		
		*//**
		* IĴSQL쐬
		* @param aryHeaderNo
		* @param isInsert
		* @return
		*/
	/*
	public String createCol(
		String[] aryHeaderNo,
		boolean isInsert
	) {
		index = 1;
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < aryHeaderNo.length; i++) {
			sb.append(getColumn(Integer.parseInt(aryHeaderNo[i])));
			if (!isInsert) {
				sb.append(" = ? ");
			}
			sb.append(UnicConst.STR_CSV_SEPARATOR);
		}
		return sb.toString();
	}
	
	*//**
		* o^p[^
		* @param aryCsvData
		* @return
		*/
	/*
	public String insertRow(
		String[] aryCsvData
	) {
		index = 1;
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < aryCsvData.length; i++) {
			sb.append(" ? ");
			sb.append(UnicConst.STR_CSV_SEPARATOR);
		}
		return sb.toString();
	
	}
	
	*//**
		* f[^XV(Abv[h)
		* @param dto XVΏDTO
		* @return int XV()
		* @throws SQLException
		*/
	/*
	public int updateUpload(
		String[] aryHeaderNo,
		String[] aryCsvData,
		String   bankCode,
		Date     calcDate
	) throws SQLException {
	try {
		Date date = new Date();
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("UPDATE ");
		sb.append(TABLE);
		sb.append(" SET ");
		sb.append(createCol(aryHeaderNo,false));
		sb.append(COL_BANK_CODE);
		sb.append("= ?");
		sb.append(", ");
		sb.append(COL_BANK_NAME);
		sb.append(" = ?");
		sb.append(", ");
		sb.append(COL_BANK_KANA);
		sb.append("= ?");
		sb.append(", ");
		if (!UPDATE_DATE.equals("")) {
			sb.append(UPDATE_DATE + " = ?, ");
		}
		if (!UPDATE_USER.equals("")) {
			sb.append(UPDATE_USER + " = ? ");
		}
		sb.append(" WHERE ");
		sb.append(COL_BANK_CODE);
		sb.append(" = ? ");
		prepareStatement(sb.toString());
		setParam(index++, bankCode);
		for (int i = 0; i < aryCsvData.length; i++) {
			setParam(index++, aryCsvData[i]);
		}
		if (!UPDATE_DATE.equals("")) {
			setParam(index++, date);
		}
		if (!UPDATE_USER.equals("")) {
			setParam(index++, userId);
		}
		setParam(index++, bankCode);
		//setParam(index++, calcDate);
		executeUpdate();
		return cnt;
	} catch (SQLException e) {
		throw e;
	} finally {
		releaseResultSet();
		releasePreparedStatement();
	}
	}*/

	/**
	 * sR[hɂzf[^擾
	 * @return CmBranchDto (DTO)
	 * @throws SQLException
	 */
	public List<CmBankDto> findForEmployeeList() throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT " + " * " + " FROM " + TABLE + " left join ");
			sb.append("CM_BRANCH ");
			sb.append("on" + " ");
			sb.append(TABLE + "." + COL_BANK_CODE + " = ");
			sb.append("CM_BRANCH" + "." + COL_BANK_CODE);
			prepareStatement(sb.toString());
			executeQuery();
			List<CmBankDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param bankCode @@ @	sR[h
	 * @param bankKana			sJi
	 * @param branchCode @@  xXR[h
	 * @param branchKana @@  xXJi
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public List<CmBankDto> findForCondition(String bankCode, String bankKana, String branchCode, String branchKana)
			throws SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append("* ");
		sb.append("FROM ");
		sb.append("CM_BANK ");
		sb.append("left join ");
		sb.append("CM_BRANCH ");
		sb.append(" on ");
		sb.append("CM_BANK." + COL_BANK_CODE + " = ");
		sb.append("CM_BRANCH " + ".");
		sb.append(COL_BANK_CODE);
		if (bankCode != null && !bankCode.equals("") || bankKana != null && !bankKana.equals("") || branchCode != null
				&& !branchCode.equals("") || branchKana != null && !branchKana.equals("")) {
			sb.append(" WHERE ");
		}
		if (bankCode != null && !bankCode.equals("")) {
			sb.append("CM_BANK." + COL_BANK_CODE + " like ? ");
			if (bankKana != null && !bankKana.equals("") || branchCode != null && !branchCode.equals("")
					|| branchKana != null && !branchKana.equals("")) {
				sb.append(" AND ");
			}
		}
		if (bankKana != null && !bankKana.equals("")) {
			sb.append("CM_BANK.BANK_KANA" + " like ? ");
			if (branchCode != null && !branchCode.equals("") || branchKana != null && !branchKana.equals("")) {
				sb.append(" AND ");
			}
		}
		if (branchCode != null && !branchCode.equals("")) {
			sb.append("CM_BRANCH" + "." + "BRANCH_CODE" + " like ? ");
			if (branchKana != null && !branchKana.equals("")) {
				sb.append(" AND ");
			}
		}
		if (branchKana != null && !branchKana.equals("")) {
			sb.append("CM_BRANCH" + "." + "BRANCH_KANA" + " like ? ");
		}
		try {
			prepareStatement(sb.toString());
			if (bankCode != null && !bankCode.equals("")) {
				setParam(index++, bankCode + "%");
			}
			if (bankKana != null && !bankKana.equals("")) {
				setParam(index++, "%" + bankKana + "%");
			}
			if (branchCode != null && !branchCode.equals("")) {
				setParam(index++, "%" + branchCode + "%");
			}
			if (branchKana != null && !branchKana.equals("")) {
				setParam(index++, "%" + branchKana + "%");
			}
			executeQuery();
			List<CmBankDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * J擾
	 * @param idx
	 * @return J
	 */
	/*private String getColumn(int idx) {
		switch (idx) {
		case 1  : return COL_BANK_CODE  ;// sR[h
		case 2  : return COL_BANK_NAME  ;// s
		case 3  : return COL_BANK_KANA  ;// stKi
		default:
			return "";
		}
		
	}*/

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CmBankDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getBankCode()); // sR[h
		setParam(index++, dto.getBankName()); // s
		setParam(index++, dto.getBankKana()); // stKi
		setCommonParams(isInsert);
	}
	
}
