package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CashKindListDto;

/**
 * @author koike
 *
 */
public class CashKindListDao extends PayrollDao {
	
	//
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE				= PhPaymentDao.COL_KCODE;
	/**
	 * vZN
	 */
	public static final String	COL_CALC_DATE			= PhPaymentDao.COL_CALC_MONTH;
	/**
	 * ^x
	 */
	public static final String	COL_PAYDAY				= PhPaymentDao.COL_PAY_DATE;
	/**
	 * Ј
	 */
	public static final String	COL_K_NAME				= MKihonPayrollDao.COL_SIMEI;
	/**
	 * ׃R[h
	 */
	public static final String	COL_DETAIL_CODE			= DetailMoneyDao.COL_DETAIL_CODE;
	/**
	 * ׋z
	 */
	public static final String	COL_AMOUNT				= DetailMoneyDao.COL_AMOUNT;
	/**
	 * ׃R[h
	 */
	public static final String	COL_DETAIL_CODE_PS013	= "PS013";
	

	/**
	 * RXgN^
	 */
	public CashKindListDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "";
		UPDATE_USER = "";
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<CashKindListDto> mappingAll() throws SQLException {
		List<CashKindListDto> all = new ArrayList<CashKindListDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return  CashKindListDto zR[h
	 * @throws SQLException SQLOꍇ
	 */
	private CashKindListDto mapping() throws SQLException {
		CashKindListDto dto = new CashKindListDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setCalcDate(rs.getDate(COL_CALC_DATE)); // vZN
		dto.setPayday(rs.getDate(COL_PAYDAY)); // ^x
		dto.setKName(rs.getString(COL_K_NAME)); // Ј
		dto.setCashAmount(rs.getInt(COL_AMOUNT)); // xz
		return dto;
	}
	
	/**
	 * ɂ錻zf[^擾
	 * @param calcDate Ώ۔N
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 */
	public List<CashKindListDto> findForCondition(Date calcDate) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			setCashKindPayment(sb);
			prepareStatement(sb.toString());
			setDateParam(index++, calcDate);
			sb.append(" ");
			sb.append(getOrderBy());
			sb.append(COL_K_CODE);
			//s
			executeQuery();
			List<CashKindListDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂ錻zf[^擾(^)
	 * @param sb SQLobt@
	 */
	private void setCashKindPayment(StringBuffer sb) {
		sb.append("SELECT ");
		sb.append(" PHPAY.");
		sb.append(COL_K_CODE);
		sb.append(", ");
		sb.append(" PHPAY.");
		sb.append(COL_CALC_DATE);
		sb.append(", ");
		sb.append(" PHPAY.");
		sb.append(COL_PAYDAY);
		sb.append(", ");
		sb.append(" MKIHON.");
		sb.append(COL_K_NAME);
		sb.append(", ");
		sb.append(" PDSUM.");
		sb.append(COL_AMOUNT);
		
		sb.append(" FROM ");
		sb.append(PhPaymentDao.TABLE + " PHPAY ");
		sb.append(", ");
		sb.append(MKihonPayrollDao.TABLE + " MKIHON ");
		sb.append(", ");
		sb.append("PD_PAY_SUM" + " PDSUM ");
		
		sb.append(" WHERE ");
		sb.append(" PHPAY.");
		sb.append(COL_K_CODE);
		sb.append(" = ");
		sb.append(" MKIHON.");
		sb.append(COL_K_CODE);
		sb.append(" AND ");
		sb.append(" PHPAY.");
		sb.append(COL_K_CODE);
		sb.append(" = ");
		sb.append(" PDSUM.");
		sb.append(COL_K_CODE);
		sb.append(" AND ");
		sb.append(" PHPAY.");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(" PHPAY.");
		sb.append(COL_CALC_DATE);
		sb.append(" = ");
		sb.append(" PDSUM.");
		sb.append("CALC_DATE");
		sb.append(" AND ");
		sb.append(" PDSUM.");
		sb.append(COL_DETAIL_CODE);
		sb.append(" = ");
		sb.append("'" + COL_DETAIL_CODE_PS013 + "'");
		sb.append(" AND ");
		sb.append(" PDSUM.");
		sb.append(COL_AMOUNT);
		sb.append(" <> ");
		sb.append(PayrollConst.AMOUNT_ZERO);
	}
	
}
