package jp.mosp.payroll.common.vo;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dto.CtRetireDetailDto;

public class RetireDetailCardVo extends MosPVo {
	
	private static final long	serialVersionUID		= 3281945937471826907L;
	
	// URLACSS
	private static final String	RETURN_URL				= "/jsp/payroll/common/retireDetailCard.jsp";
	private static final String	EXTRA_JS				= "/pub/payroll/common/js/retireDetailCard.js";
	private static final String	EXTRA_CSS				= "/pub/payroll/common/css/retireDetailCard.css";
	
	// ʃTu^Cg
	public final String			SUB_TITLE				= PayrollConst.TTL_RETIRE_DETAIL;
	
	public static final String	PRM_TXT_CITY_CODE		= "txtCityCode";									// sR[h
	public static final String	PRM_LBL_DETAIL_MONTH	= "lblDetailMonth";								// ސEהN
	public static final String	PRM_PLT_CITY_CHANGES	= "pltCityChanges";								// ٓL
	public static final String	PRM_TXT_RETIRE_COUNT	= "txtRetireCount";								// ސEl
	public static final String	PRM_TXT_CITY_PAY_AMOUNT	= "txtCityPayAmount";								// xz
	public static final String	PRM_TXT_CITY_TAX		= "txtCityTax";									// s
	public static final String	PRM_TXT_PREFECTURE_TAX	= "txtPrefectureTax";								// {
																											
	public static final String	PRM_HID_DETAIL_MONTH	= "hidDetailMonth";								// ސEהN
																											
	public static final String	PRM_PLT_SPECIFY_YEAR	= "pltSpecifyYear";								// wN(N)
	public static final String	PRM_PLT_SPECIFY_MONTH	= "pltSpecifyMonth";								// wN()
	public static final String	PRM_PLT_SPECIFY_DAY		= "pltSpecifyDay";									// wN()
																											
	// tB[h
	private String				txtCityCode;
	private String				lblDetailMonth;
	private String				pltCityChanges;
	private String				txtRetireCount;
	private String				txtCityPayAmount;
	private String				txtCityTax;
	private String				txtPrefectureTax;
	
	private String				hidDetailMonth;
	
	private String				pltSpecifyYear;
	private String				pltSpecifyMonth;
	private String				pltSpecifyDay;
	
	// tB[hyѐ
	public static final String	NAM_CITY_CODE			= PayrollConst.NAM_CITY_CODE;
	public static final String	NAM_DETAIL_MONTH		= PayrollConst.NAM_DETAIL_MONTH;
	public static final String	NAM_CITY_CHANGES		= PayrollConst.NAM_CITY_CHANGES;
	public static final String	NAM_RETIRE_COUNT		= PayrollConst.NAM_RETIRE_COUNT;
	public static final String	NAM_CITY_PAY_AMOUNT		= PayrollConst.NAM_CITY_PAY_AMOUNT;
	public static final String	NAM_CITY_TAX			= PayrollConst.NAM_CITY_TAX;
	public static final String	NAM_PREFECTURE_TAX		= PayrollConst.NAM_PREFECTURE_TAX;
	
	public static final int		LEN_CITY_CODE			= PayrollConst.LEN_CITY_CODE;
	public static final int		LEN_RETIRE_COUNT		= PayrollConst.LEN_RETIRE_COUNT;
	public static final int		LEN_CITY_PAY_AMOUNT		= PayrollConst.LEN_CITY_PAY_AMOUNT;
	public static final int		LEN_CITY_TAX			= PayrollConst.LEN_CITY_TAX;
	public static final int		LEN_PREFECTURE_TAX		= PayrollConst.LEN_PREFECTURE_TAX;
	
	// v_EXg
	public String[][]			aryPltCityChanges;
	// ݒe[u
	public List<MosPConfDto>	listConf;
	public String[][]			aryEra;
	

	// p[^
	
	/**
	 * RXgN^
	 */
	public RetireDetailCardVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
	}
	
	/**
	 * p[^ݒ
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		txtCityCode = request.getParameter(PRM_TXT_CITY_CODE);
		lblDetailMonth = request.getParameter(PRM_LBL_DETAIL_MONTH);
		hidDetailMonth = request.getParameter(PRM_HID_DETAIL_MONTH);
		pltCityChanges = request.getParameter(PRM_PLT_CITY_CHANGES);
		txtRetireCount = request.getParameter(PRM_TXT_RETIRE_COUNT);
		txtCityPayAmount = request.getParameter(PRM_TXT_CITY_PAY_AMOUNT);
		txtCityTax = request.getParameter(PRM_TXT_CITY_TAX);
		txtPrefectureTax = request.getParameter(PRM_TXT_PREFECTURE_TAX);
		
		pltSpecifyYear = request.getParameter(PRM_PLT_SPECIFY_YEAR);
		pltSpecifyMonth = request.getParameter(PRM_PLT_SPECIFY_MONTH);
		pltSpecifyDay = request.getParameter(PRM_PLT_SPECIFY_DAY);
		
	}
	
	/**
	 * tB[hݒ
	 * @param ctRetireDetailDto Xg
	 */
	public void setFields(CtRetireDetailDto ctRetireDetailDto) {
		txtCityCode = ctRetireDetailDto.getCityCode();
		lblDetailMonth = String.valueOf(ctRetireDetailDto.getDetailMonth());
		pltCityChanges = ctRetireDetailDto.getCityChanges();
		txtRetireCount = String.valueOf(ctRetireDetailDto.getRetireCount());
		txtCityPayAmount = String.valueOf(ctRetireDetailDto.getCityPayAmount());
		txtCityTax = String.valueOf(ctRetireDetailDto.getCityTax());
		txtPrefectureTax = String.valueOf(ctRetireDetailDto.getPrefectureTax());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CtRetireDetailDto dto) {
		dto.setCityCode(txtCityCode);
		dto.setCityChanges(pltCityChanges);
		dto.setRetireCount(getIntParam(txtRetireCount));
		dto.setCityPayAmount(getLongParam(txtCityPayAmount));
		dto.setCityTax(getIntParam(txtCityTax));
		dto.setPrefectureTax(getIntParam(txtPrefectureTax));
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		checkRequired(txtCityCode, NAM_CITY_CODE, PRM_TXT_CITY_CODE);
		if (pltCityChanges.equals(PayrollConst.NAM_CITY_CHANGES)) {
			checkRequired(txtRetireCount, NAM_RETIRE_COUNT, PRM_TXT_RETIRE_COUNT);
			checkRequired(txtCityPayAmount, NAM_CITY_PAY_AMOUNT, PRM_TXT_CITY_PAY_AMOUNT);
			checkRequired(txtCityTax, NAM_CITY_TAX, PRM_TXT_CITY_TAX);
			checkRequired(txtPrefectureTax, NAM_PREFECTURE_TAX, PRM_TXT_PREFECTURE_TAX);
		}
		// ÓmFI
		endValidation();
	}
	
	/**
	 * tݒ
	 * @param targetMonth
	 * @throws MospException
	 */
	public void setJpDetailMonth(Date targetMonth) throws MospException {
		String[] strDate = getJpImperialCal(listConf, targetMonth);
		String wareki = getCodeName(strDate[0], aryEra);
		lblDetailMonth = wareki + " " + strDate[1] + PayrollConst.NAM_YEAR + strDate[2] + PayrollConst.NAM_MONTH;
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}
	
	// ANZT\bh
	public String getTxtCityCode() {
		return txtCityCode;
	}
	
	public String getLblDetailMonth() {
		return lblDetailMonth;
	}
	
	public String getHidDetailMonth() {
		return hidDetailMonth;
	}
	
	public String getPltCityChanges() {
		return pltCityChanges;
	}
	
	public String getTxtRetireCount() {
		return txtRetireCount;
	}
	
	public String getTxtCityPayAmount() {
		return txtCityPayAmount;
	}
	
	public String getTxtCityTax() {
		return txtCityTax;
	}
	
	public String getTxtPrefectureTax() {
		return txtPrefectureTax;
	}
	
	public String getPltSpecifyYear() {
		return pltSpecifyYear;
	}
	
	public String getPltSpecifyMonth() {
		return pltSpecifyMonth;
	}
	
	public String getPltSpecifyDay() {
		return pltSpecifyDay;
	}
	
	public String getEscTxtCityCode() {
		return escapeHTML(txtCityCode);
	}
	
	public String getEscLblDetailMonth() {
		return escapeHTML(lblDetailMonth);
	}
	
	public String getEscHidDetailMonth() {
		return escapeHTML(hidDetailMonth);
	}
	
	public String getEscPltCityChanges() {
		return escapeHTML(pltCityChanges);
	}
	
	public String getEscTxtRetireCount() {
		return escapeHTML(txtRetireCount);
	}
	
	public String getEscTxtCityPayAmount() {
		return escapeHTML(txtCityPayAmount);
	}
	
	public String getEscTxtCityTax() {
		return escapeHTML(txtCityTax);
	}
	
	public String getEscTxtPrefectureTax() {
		return escapeHTML(txtPrefectureTax);
	}
	
	public void setTxtCityCode(String txtCityCode) {
		this.txtCityCode = txtCityCode;
	}
	
	public void setLblDetailMonth(String lblDetailMonth) {
		this.lblDetailMonth = lblDetailMonth;
	}
	
	public void setHidDetailMonth(String hidDetailMonth) {
		this.hidDetailMonth = hidDetailMonth;
	}
	
	public void setPltCityChanges(String pltCityChanges) {
		this.pltCityChanges = pltCityChanges;
	}
	
	public void setTxtRetireCount(String txtRetireCount) {
		this.txtRetireCount = txtRetireCount;
	}
	
	public void setTxtCityPayAmount(String txtCityPayAmount) {
		this.txtCityPayAmount = txtCityPayAmount;
	}
	
	public void setTxtCityTax(String txtCityTax) {
		this.txtCityTax = txtCityTax;
	}
	
	public void setTxtPrefectureTax(String txtPrefectureTax) {
		this.txtPrefectureTax = txtPrefectureTax;
	}
	
	public void setPltSpecifyYear(String pltSpecifyYear) {
		this.pltSpecifyYear = pltSpecifyYear;
	}
	
	public void setPltSpecifyMonth(String pltSpecifyMonth) {
		this.pltSpecifyMonth = pltSpecifyMonth;
	}
	
	public void setPltSpecifyDay(String pltSpecifyDay) {
		this.pltSpecifyDay = pltSpecifyDay;
	}
	
}
