package jp.mosp.payroll.common.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.dto.MImportDto;

public class ImportMasterListVo extends PayrollVo {
	
	private static final long	serialVersionUID	= -3093345238424415014L;
	
	// 萔
	public static final int		SEARCH_OFF			= 0;
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	public static final String	PRM_TXT_I_CODE		= "txtICode";
	public static final String	PRM_TXT_I_NAME		= "txtIName";
	public static final String	PRM_PLT_I_TABLE		= "pltITable";
	
	// tB[h
	private String[]			aryImportCmd;
	private String[]			aryICode;
	private String[]			aryIName;
	private String[]			aryITable;
	private String				txtICode;
	private String				txtIName;
	private String				pltITable;
	
	// v_EXg
	public String[][]			aryPltITable;
	
	// \[gL[
	public final String			KEY_I_CODE			= "keyICode";
	public final String			KEY_I_NAME			= "keyIName";
	public final String			KEY_I_TABLE			= "keyITable";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public ImportMasterListVo() {
		super();
		txtICode = "";
		txtIName = "";
		pltITable = "";
		aryImportCmd = new String[0];
		aryICode = new String[0];
		aryIName = new String[0];
		aryITable = new String[0];
		setFormerKey(KEY_I_CODE);
	}
	
	/**
	 * Tu^Cgݒ肷B
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_PAYMENT") + getName("P_IMPORT");
		addAryMenu("P1001", getName("P_PAYMENT") + getName("P_CALCULATE") + getName("C_MENU") + getName("C_TO"));
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtICode = request.getParameter(PRM_TXT_I_CODE);
		txtIName = request.getParameter(PRM_TXT_I_NAME);
		pltITable = request.getParameter(PRM_PLT_I_TABLE);
	}
	
	/**
	 * tB[hݒ
	 * @param listImport C|[gXg
	 */
	public void setFields(List listImport) {
		// Xg̐ݒ
		list = listImport;
		// f[^̎擾
		count = listImport.size();
		// z̏
		aryImportCmd = new String[count];
		aryICode = new String[count];
		aryIName = new String[count];
		aryITable = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listImport.iterator();
		while (it.hasNext()) {
			MImportDto dto = (MImportDto)it.next();
			if (dto.getITable().equals(PayrollConst.CODE_IMPORT_TABLE_PI_PAYMENT)) {
				aryImportCmd[i] = "P9040"; /* ^f[^C|[g */
			} else if (dto.getITable().equals(PayrollConst.CODE_IMPORT_TABLE_M_SYUKKINBO)) {
				aryImportCmd[i] = "P9050"; /* ΑӃf[^C|[g */
			} else if (dto.getITable().equals(PayrollConst.CODE_IMPORT_TABLCT_TIMECARD)) {
				aryImportCmd[i] = "P9060"; /* ^CJ[hf[^C|[g */
			}
			aryICode[i] = escapeHTML(dto.getICode());
			aryIName[i] = escapeHTML(dto.getIName());
			aryITable[i] = escapeHTML(getCodeName(dto.getITable(), aryPltITable));
			i++;
		}
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}
	
	// ANZT\bh
	public String[] getAryImportCmd() {
		return aryImportCmd.clone();
	}
	
	public String[] getEscAryICode() {
		return aryICode.clone();
	}
	
	public String[] getEscAryIName() {
		return aryIName.clone();
	}
	
	public String[] getEscAryITable() {
		return aryITable.clone();
	}
	
	public String getTxtICode() {
		return txtICode;
	}
	
	public String getTxtIName() {
		return txtIName;
	}
	
	public String getPltITable() {
		return pltITable;
	}
	
	public String getEscTxtICode() {
		return escapeHTML(txtICode);
	}
	
	public String getEscTxtIName() {
		return escapeHTML(txtIName);
	}
	
	public String getEscPltITable() {
		return escapeHTML(pltITable);
	}
	
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	public int getSearchmode() {
		return searchmode;
	}
	
}
