/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dto.MExportPaymentDto;

public class ExportMasterCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 1449101746145275687L;
	
	// URLACSS
	private static final String	RETURN_URL			= "/jsp/payroll/common/exportMasterCard.jsp";
	private static final String	EXTRA_JS			= "/pub/payroll/common/js/exportMasterCard.js";
	private static final String	EXTRA_CSS			= "/pub/payroll/common/css/exportMasterCard.css";
	
	// ʃTu^Cg
	public final String			SUB_TITLE			= CommonConst.TTL_EXPORT_MASTER_MAINT;
	
	// 萔
	public static final int		MODE_INSERT			= 0;
	public static final int		MODE_UPDATE			= 1;
	public static final int		MODE_SYSTEM			= 2;
	
	// p[^
	public static final String	PRM_TXT_E_NAME		= "txtEName";
	public static final String	PRM_HID_E_FILE		= "hidEFile";
	public static final String	PRM_LBL_E_FILE		= "lblEFile";
	public static final String	PRM_PLT_SELECTED	= "pltSelected";
	
	// tB[h
	public String[]				pltSelected;
	
	// v_EXg
	public String[][]			aryPltKintaiDataItem;
	public String[][]			aryPltSelectDataItem;
	public String[][]			aryTargetTable;
	
	// tB[hyѐ
	public static final String	NAM_NAME			= CommonConst.NAM_REGIST + CommonConst.NAM_COMMON_MEISYO;
	public static final String	NAM_FILE			= PayrollConst.NAM_TYPE;
	public static final String	NAM_PLT_SELECTED	= CommonConst.NAM_HUMAN_DATA_SELECT;
	
	public static final int		LEN_NAME			= 10;
	public static final int		LEN_FILE			= 20;
	
	// [h(0FVKo^A1FXVA2F폜)
	private int					mode;
	
	// tB[h
	private String				txtEName;
	private String				hidEFile;
	private String				lblEFile;
	

	/**
	 * RXgN^
	 */
	public ExportMasterCardVo() {
		super();
		mode = 0;
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		txtEName = request.getParameter(PRM_TXT_E_NAME);
		hidEFile = request.getParameter(PRM_HID_E_FILE);
		pltSelected = request.getParameterValues(PRM_PLT_SELECTED);
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MExportPaymentDto dto, int i) {
		dto.setEName(txtEName);
		dto.setEFile(hidEFile);
		dto.setELine(i);
		dto.setEFname(pltSelected[i]);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtEName, NAM_NAME, PRM_TXT_E_NAME);
		// 񒷊mF
		checkLength(txtEName, LEN_NAME, NAM_NAME, PRM_TXT_E_NAME);
		// ÓmFI
		endValidation();
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	public String getTxtEName() {
		return txtEName;
	}
	
	public String getHidEFile() {
		return hidEFile;
	}
	
	public String getEscTxtEName() {
		return escapeHTML(txtEName);
	}
	
	public String getEscLblEFile() {
		return escapeHTML(lblEFile);
	}
	
	public String[] getPltSelected() {
		return pltSelected == null ? null : pltSelected.clone();
	}
	
	public String getPltSelected(int i) {
		return pltSelected[i];
	}
	
	public void setTxtEName(String ename) {
		txtEName = ename;
	}
	
	public void setHidEFile(String efile) {
		hidEFile = efile;
	}
	
	public void setLblEFile(String efile) {
		lblEFile = efile;
	}
	
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	public int getMode() {
		return mode;
	}
	
}
