package jp.mosp.payroll.common.vo;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.dto.CmIncomeTaxDto;
import jp.mosp.payroll.dto.CmMidwayEnterDto;

public class AdjustmentCardVo extends MosPVo {
	
	private static final long	serialVersionUID				= 1833548315728482756L;
	
	// URLACSS
	private static final String	RETURN_URL						= "/jsp/payroll/common/adjustmentCard.jsp";
	private static final String	EXTRA_JS						= "/pub/payroll/common/js/adjustmentCard.js";
	private static final String	EXTRA_CSS						= "/pub/payroll/common/css/adjustmentCard.css";
	
	// ʃTu^Cg
	public final String			SUB_TITLE						= PayrollConst.TTL_ADJUSTMENT_CARD;
	
	// p[^
	public static final String	PRM_TXT_CHANGE_K_CODE			= "txtChangeKCode";
	public static final String	PRM_HID_ADJUST_YEAR				= "hidAdjustYear";
	public static final String	PRM_HID_K_CODE					= "hidKCode";
	public static final String	PRM_HID_FAMILY_INFO				= "hidFamilyInfo";
	
	public static final String	PRM_TXT_GENERAL_LIFE_INS		= "txtGeneralLifeIns";
	public static final String	PRM_TXT_PRIVATE_PENSION			= "txtPrivatePension";
	public static final String	PRM_TXT_LIFE_INS_DEDUCTION		= "txtLifeInsDeduction";
	public static final String	PRM_TXT_EARTHQUAKE_INS			= "txtEarthquakeIns";
	public static final String	PRM_TXT_LONG_TERM_DAMAGE_INS	= "txtLongTermDamageIns";
	public static final String	PRM_TXT_DAMAGE_INS_DEDUCTION	= "txtDamageInsDeduction";
	public static final String	PRM_TXT_SOCIAL_INS_DEDUCTION	= "txtSocialInsDeduction";
	public static final String	PRM_TXT_MUTUAL_AID_DEDUCTION	= "txtMutualAidDeduction";
	public static final String	PRM_TXT_SPOUSE_SUM_INCOME		= "txtSpouseSumIncome";
	public static final String	PRM_TXT_SPOUSE_SP_DEDUCTION		= "txtSpouseSpDeduction";
	public static final String	PRM_TXT_HOUSE_LOAN_DEDUCTION	= "txtHouseLoanDeduction";
	public static final String	PRM_TXT_ALLOWANCE_ADJUSTMENT	= "txtAllowanceAdjustment";
	public static final String	PRM_TXT_TAX_FREE_ADJUSTMENT		= "txtTaxFreeAdjustment";
	public static final String	PRM_TXT_SOC_INS_ADJUSTMENT		= "txtSocInsAdjustment";
	public static final String	PRM_TXT_TAX_INC_ADJUSTMENT		= "txtTaxIncAdjustment";
	public static final String	PRM_TXT_WITHHOLD_SLIP_NOTES		= "txtWithholdSlipNotes";
	
	public static final String	PRM_CKB_DEAD_RETIREMENT			= "ckbDeadRetirement";
	public static final String	PRM_CKB_SELF_DISASTER			= "ckbSelfDisaster";
	public static final String	PRM_CKB_FOREIGNER				= "ckbForeigner";
	
	// tB[h
	private String				txtChangeKCode;
	private int					hidAdjustYear;
	private String				hidKCode;
	private String				lblKName;
	private String				lblStationCode;
	private String				lblStationName;
	private String				lblPositionCode;
	private String				lblPositionName;
	private String				lblEntranceDate;
	private String				lblAdjustStatus;
	
	private int					txtGeneralLifeIns;
	private int					txtPrivatePension;
	private int					txtLifeInsDeduction;
	private int					txtEarthquakeIns;
	private int					txtLongTermDamageIns;
	private int					txtDamageInsDeduction;
	private int					txtSocialInsDeduction;
	private int					txtMutualAidDeduction;
	private int					txtSpouseSumIncome;
	private int					txtSpouseSpDeduction;
	private int					txtHouseLoanDeduction;
	private int					txtAllowanceAdjustment;
	private int					txtTaxFreeAdjustment;
	private int					txtSocInsAdjustment;
	private int					txtTaxIncAdjustment;
	private String				txtWithholdSlipNotes;
	
	private String				ckbDeadRetirement;																// SސE
	private String				ckbSelfDisaster;																// ЊQ
	private String				ckbForeigner;																	// Ol
																												
	private String				lblIncomeTaxType;
	private String				lblAdjustmentType;
	private String				lblSelfWidowType;
	private String				lblSelfHandicapType;
	private String				lblSelfStudentType;
	private String				lblSpouseIntendType;
	private String				lblGeneralDependent;
	private String				lblSpecificDependent;
	private String				lblElderlyDependent;
	private String				lblLiveWithEldRel;
	private String				lblLiveWithHandiGe;
	private String				lblLiveWithHandiSp;
	private String				lblLiveWithHandiEl;
	private String				lblLiveWithHandiEr;
	private String				lblGeneralHandicap;
	private String				lblSpecificHandicap;
	
	private String				lblMidwayType;
	private String				lblFormerIncome;
	private String				lblFormerInsurance;
	private String				lblFormerTax;
	
	private String				hidFamilyInfo;
	
	// ̎擾pz
	public String[][]			aryStation;
	public String[][]			aryPosition;
	public String[][]			aryEra;
	public String[][]			aryRelation;
	
	// ݒe[u
	public List<MosPConfDto>	listConf;
	
	// tB[hyѐ
	public static final String	NAM_K_CODE						= PayrollConst.NAM_M_KIHON_KCODE;
	public static final int		LEN_K_CODE						= PayrollConst.LEN_K_CODE;
	public static final int		LEN_MONEY_AMOUNT				= PayrollConst.LEN_MONEY_AMOUNT;
	public static final int		LEN_WITHHOLD_NOTES				= PayrollConst.LEN_WITHHOLD_NOTES;
	
	public static final String	NAM_GENERAL_LIFE_INS			= PayrollConst.NAM_GENERAL_LIFE_INS;
	public static final String	NAM_PRIVATE_PENSION				= PayrollConst.NAM_PRIVATE_PENSION;
	public static final String	NAM_LIFE_INS_DEDUCTION			= PayrollConst.NAM_LIFE_INS_DEDUCTION;
	public static final String	NAM_EARTHQUAKE_INS				= PayrollConst.NAM_EARTHQUAKE_INS;
	public static final String	NAM_LONG_TERM_DAMAGE_INS		= PayrollConst.NAM_LONG_TERM_DAMAGE_INS;
	public static final String	NAM_DAMAGE_INS_DEDUCTION		= PayrollConst.NAM_DAMAGE_INS_DEDUCTION;
	public static final String	NAM_SOCIAL_INS_DEDUCTION		= PayrollConst.NAM_SOCIAL_INS_DEDUCTION;
	public static final String	NAM_MUTUAL_AID_DEDUCTION		= PayrollConst.NAM_MUTUAL_AID_DEDUCTION;
	public static final String	NAM_SPOUSE_SUM_INCOME			= PayrollConst.NAM_SPOUSE_SUM_INCOME;
	public static final String	NAM_SPOUSE_SP_DEDUCTION			= PayrollConst.NAM_SPOUSE_SP_DEDUCTION;
	public static final String	NAM_HOUSE_LOAN_DEDUCTION		= PayrollConst.NAM_HOUSE_LOAN_DEDUCTION;
	public static final String	NAM_ALLOWANCE_ADJUSTMENT		= PayrollConst.NAM_ALLOWANCE_ADJUSTMENT;
	public static final String	NAM_TAX_FREE_ADJUSTMENT			= PayrollConst.NAM_TAX_FREE_ADJUSTMENT;
	public static final String	NAM_SOC_INS_ADJUSTMENT			= PayrollConst.NAM_SOC_INS_ADJUSTMENT;
	public static final String	NAM_TAX_INC_ADJUSTMENT			= PayrollConst.NAM_TAX_INC_ADJUSTMENT;
	public static final String	NAM_WITHHOLD_SLIP_NOTES			= PayrollConst.NAM_WITHHOLD_SLIP_NOTES;
	

	/**
	 * RXgN^
	 */
	public AdjustmentCardVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		txtChangeKCode = request.getParameter(PRM_TXT_CHANGE_K_CODE);
		hidAdjustYear = getIntParam(request.getParameter(PRM_HID_ADJUST_YEAR));
		hidKCode = request.getParameter(PRM_HID_K_CODE);
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParamsAll(HttpServletRequest request) {
		setParams(request);
		txtGeneralLifeIns = getIntParam(request.getParameter(PRM_TXT_GENERAL_LIFE_INS));
		txtPrivatePension = getIntParam(request.getParameter(PRM_TXT_PRIVATE_PENSION));
		txtLifeInsDeduction = getIntParam(request.getParameter(PRM_TXT_LIFE_INS_DEDUCTION));
		txtEarthquakeIns = getIntParam(request.getParameter(PRM_TXT_EARTHQUAKE_INS));
		txtLongTermDamageIns = getIntParam(request.getParameter(PRM_TXT_LONG_TERM_DAMAGE_INS));
		txtDamageInsDeduction = getIntParam(request.getParameter(PRM_TXT_DAMAGE_INS_DEDUCTION));
		txtSocialInsDeduction = getIntParam(request.getParameter(PRM_TXT_SOCIAL_INS_DEDUCTION));
		txtMutualAidDeduction = getIntParam(request.getParameter(PRM_TXT_MUTUAL_AID_DEDUCTION));
		txtSpouseSumIncome = getIntParam(request.getParameter(PRM_TXT_SPOUSE_SUM_INCOME));
		txtSpouseSpDeduction = getIntParam(request.getParameter(PRM_TXT_SPOUSE_SP_DEDUCTION));
		txtHouseLoanDeduction = getIntParam(request.getParameter(PRM_TXT_HOUSE_LOAN_DEDUCTION));
		txtAllowanceAdjustment = getIntParam(request.getParameter(PRM_TXT_ALLOWANCE_ADJUSTMENT));
		txtTaxFreeAdjustment = getIntParam(request.getParameter(PRM_TXT_TAX_FREE_ADJUSTMENT));
		txtSocInsAdjustment = getIntParam(request.getParameter(PRM_TXT_SOC_INS_ADJUSTMENT));
		txtTaxIncAdjustment = getIntParam(request.getParameter(PRM_TXT_TAX_INC_ADJUSTMENT));
		txtWithholdSlipNotes = request.getParameter(PRM_TXT_WITHHOLD_SLIP_NOTES);
		ckbDeadRetirement = getCheckBoxParam(request.getParameter(PRM_CKB_DEAD_RETIREMENT)); // SސE
		ckbSelfDisaster = getCheckBoxParam(request.getParameter(PRM_CKB_SELF_DISASTER)); // ЊQ
		ckbForeigner = getCheckBoxParam(request.getParameter(PRM_CKB_FOREIGNER)); // Ol
	}
	
	/**
	 * tB[hݒ
	 * @param dto tB[h擾ΏDTO
	 */
	public void setFields(CdAdjustmentDto dto) {
		if (dto == null) {
			lblAdjustStatus = PayrollConst.ADJU_STATUS_NON_NAME;
			txtWithholdSlipNotes = hidFamilyInfo;
			return;
		}
		// f[^̐ݒ
		lblAdjustStatus = getCodeName(dto.getAdjustStatus(), PayrollConst.getAdjuStatusArray());
		txtGeneralLifeIns = dto.getGeneralLifeIns();
		txtPrivatePension = dto.getPrivatePension();
		txtLifeInsDeduction = dto.getLifeInsDeduction();
		txtEarthquakeIns = dto.getEarthquakeIns();
		txtLongTermDamageIns = dto.getLongTermDamageIns();
		txtDamageInsDeduction = dto.getDamageInsDeduction();
		txtSocialInsDeduction = dto.getSocialInsDeduction();
		txtMutualAidDeduction = dto.getMutualAidDeduction();
		txtSpouseSumIncome = dto.getSpouseSumIncome();
		txtSpouseSpDeduction = dto.getSpouseSpDeduction();
		txtHouseLoanDeduction = dto.getHouseLoanDeduction();
		txtAllowanceAdjustment = dto.getAllowanceAdjustment();
		txtTaxFreeAdjustment = dto.getTaxFreeAdjustment();
		txtSocInsAdjustment = dto.getSocInsAdjustment();
		txtTaxIncAdjustment = dto.getTaxIncAdjustment();
		txtWithholdSlipNotes = dto.getWithholdSlipNotes();
		ckbDeadRetirement = dto.getDeadRetirement();
		ckbSelfDisaster = dto.getSelfDisaster();
		ckbForeigner = dto.getForeigner();
	}
	
	/**
	 * tB[hݒ
	 * @param mKihonDto        tB[h擾ΏDTO
	 * @param cmIncomeTaxDto   tB[h擾ΏDTO
	 * @param cmMidwayEnterDto tB[h擾ΏDTO
	 * @param listFamily       tB[h擾ΏۃXg
	 * @throws MospException 
	 */
	public void setFields(MKihonDto mKihonDto, CmIncomeTaxDto cmIncomeTaxDto, CmMidwayEnterDto cmMidwayEnterDto
//			List<CmFamilyDto> listFamily
	) throws MospException {
		// f[^̐ݒ
		if (mKihonDto != null) {
			txtChangeKCode = mKihonDto.getKCode();
			hidKCode = mKihonDto.getKCode();
			lblKName = mKihonDto.getSimei();
			lblStationCode = mKihonDto.getSCode();
			lblStationName = getCodeName(lblStationCode, aryStation);
			lblPositionCode = mKihonDto.getYCode();
			lblPositionName = getCodeName(lblPositionCode, aryPosition);
			lblEntranceDate = getDateString(listConf, aryEra, DateUtil.convIntegerDateToDate(mKihonDto.getNyDate()));
		}
		if (cmIncomeTaxDto != null) {
			lblIncomeTaxType = getCodeName(cmIncomeTaxDto.getIncomeTaxType(), LegalConst.INCOME_TAX_ARRAY);
			lblAdjustmentType = getCodeName(cmIncomeTaxDto.getAdjustmentType(), LegalConst.ADJUSTMENT_ARRAY);
			lblSelfWidowType = getCodeName(cmIncomeTaxDto.getSelfWidowType(), LegalConst.WIDOW_ARRAY);
			lblSelfHandicapType = getCodeName(cmIncomeTaxDto.getSelfHandicapType(), LegalConst.HANDICAP_ARRAY);
			lblSelfStudentType = getCodeName(cmIncomeTaxDto.getSelfStudentType(), LegalConst.STUDENT_ARRAY);
			lblSpouseIntendType = getCodeName(cmIncomeTaxDto.getSpouseIntendType(), LegalConst.SPOUSE_INTEND_ARRAY);
			lblGeneralDependent = cmIncomeTaxDto.getGeneralDependent() + PayrollConst.NAM_COMMON_CNT1;
			lblSpecificDependent = cmIncomeTaxDto.getSpecificDependent() + PayrollConst.NAM_COMMON_CNT1;
			lblElderlyDependent = cmIncomeTaxDto.getElderlyDependent() + PayrollConst.NAM_COMMON_CNT1;
			lblLiveWithEldRel = cmIncomeTaxDto.getLiveWithEldRel() + PayrollConst.NAM_COMMON_CNT1;
			lblLiveWithHandiGe = cmIncomeTaxDto.getLiveWithHandiGe() + PayrollConst.NAM_COMMON_CNT1;
			lblLiveWithHandiSp = cmIncomeTaxDto.getLiveWithHandiSp() + PayrollConst.NAM_COMMON_CNT1;
			lblLiveWithHandiEl = cmIncomeTaxDto.getLiveWithHandiEl() + PayrollConst.NAM_COMMON_CNT1;
			lblLiveWithHandiEr = cmIncomeTaxDto.getLiveWithHandiEr() + PayrollConst.NAM_COMMON_CNT1;
			lblGeneralHandicap = cmIncomeTaxDto.getGeneralHandicap() + PayrollConst.NAM_COMMON_CNT1;
			lblSpecificHandicap = cmIncomeTaxDto.getSpecificHandicap() + PayrollConst.NAM_COMMON_CNT1;
		}
		if (cmMidwayEnterDto != null) {
			lblMidwayType = getCodeName(cmMidwayEnterDto.getMidwayType(), LegalConst.MIDWAY_ENTER_ARRAY);
			lblFormerIncome = insertComma(String.valueOf(cmMidwayEnterDto.getFormerIncome()))
					+ PayrollConst.NAM_COMMON_YEN;
			lblFormerInsurance = insertComma(String.valueOf(cmMidwayEnterDto.getFormerInsurance()))
					+ PayrollConst.NAM_COMMON_YEN;
			lblFormerTax = insertComma(String.valueOf(cmMidwayEnterDto.getFormerTax())) + PayrollConst.NAM_COMMON_YEN;
		}
		
		/*
				if (listFamily != null) {
					StringBuffer sb = new StringBuffer();
					for (Iterator<CmFamilyDto> it = listFamily.iterator(); it.hasNext();) {
						CmFamilyDto cmFamilyDto = it.next();
						String familyName = cmFamilyDto.getFamilyName();
						String lastName = "";
						if (mKihonDto != null) {
							lastName = mKihonDto.getKName().split(PayrollConst.STR_BLANK)[0] + PayrollConst.STR_BLANK;
						}
						familyName = familyName.replaceFirst(lastName, "");
						sb.append(getCodeName(cmFamilyDto.getFamilyRelation(), aryRelation));
						sb.append(PayrollConst.STR_TITLE_SEPARATOR);
						sb.append(familyName);
						sb.append(PayrollConst.STR_BLANK + PayrollConst.STR_BLANK);
					}
					hidFamilyInfo = sb.toString();
				}
		*/

	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// ÓmFI
		endValidation();
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto        ݒΏDTO
	 * @param kCode      ݒЈR[h
	 * @param adjustYear ݒ蒲N
	 */
	public void setDtoFields(CdAdjustmentDto dto, String kCode, int adjustYear) {
		dto.setKCode(kCode); // ЈR[h
		dto.setAdjustYear(adjustYear); // N
		dto.setAdjustStatus(PayrollConst.ADJU_STATUS_CRE); // NvZ
		dto.setGeneralLifeIns(txtGeneralLifeIns); // ʂ̐ی
		dto.setPrivatePension(txtPrivatePension); // lNی
		dto.setLifeInsDeduction(txtLifeInsDeduction); // یTz
		dto.setEarthquakeIns(txtEarthquakeIns); // nkی
		dto.setLongTermDamageIns(txtLongTermDamageIns); // Qی
		dto.setDamageInsDeduction(txtDamageInsDeduction); // QیTz
		dto.setSocialInsDeduction(txtSocialInsDeduction); // ЉیTz
		dto.setMutualAidDeduction(txtMutualAidDeduction); // K͊Ƌϓ|Tz
		dto.setSpouseSumIncome(txtSpouseSumIncome); // z҂̖{N̍vžϊz
		dto.setSpouseSpDeduction(txtSpouseSpDeduction); // zғʍTz
		dto.setHouseLoanDeduction(txtHouseLoanDeduction); // ZؓʍTz
		dto.setAllowanceAdjustment(txtAllowanceAdjustment); // xz
		dto.setTaxFreeAdjustment(txtTaxFreeAdjustment); // ېŒz
		dto.setSocInsAdjustment(txtSocInsAdjustment); // Љیz
		dto.setTaxIncAdjustment(txtTaxIncAdjustment); // Œz
		dto.setWithholdSlipNotes(txtWithholdSlipNotes); // 򒥎[Ev
		dto.setPaymentAllowance(0); // ^A蓖z
		dto.setPaymentIncomeTax(0); // ^A蓖Ŋz
		dto.setBonusAllowance(0); // ܗ^z
		dto.setBonusIncomeTax(0); // ܗ^Ŋz
		dto.setMidwayAdjustIncome(0); // rAz
		dto.setMidwayAdjustTax(0); // rAŊz
		dto.setAfterDeductIncome(0); // ^T̋^̋z
		dto.setPayInsDeduction(0); // Љی^̍T
		dto.setDependentsDeduction(0); // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
		dto.setCalcTaxedIncome(0); // ېŋ^z
		dto.setCalcIncomeTax(0); // ZoNŊz
		dto.setAdjustedIncomeTax(0); // NNŊz
		dto.setDeductedIncomeTax(0); // N藦TzŊz
		dto.setFinalIncomeTax(0); // NŊz
		dto.setDeadRetirement(ckbDeadRetirement);
		dto.setSelfDisaster(ckbSelfDisaster);
		dto.setForeigner(ckbForeigner);
		
	}
	
	/**
	 * tB[h
	 */
	public void initAllFields() {
		txtChangeKCode = "";
		hidAdjustYear = 0;
		hidKCode = "";
		initFields();
	}
	
	/**
	 * tB[h
	 */
	public void initFields() {
		lblKName = "";
		lblStationCode = "";
		lblStationName = "";
		lblPositionCode = "";
		lblPositionName = "";
		lblEntranceDate = "";
		lblAdjustStatus = "";
		
		txtGeneralLifeIns = 0;
		txtPrivatePension = 0;
		txtLifeInsDeduction = 0;
		txtEarthquakeIns = 0;
		txtLongTermDamageIns = 0;
		txtDamageInsDeduction = 0;
		txtSocialInsDeduction = 0;
		txtMutualAidDeduction = 0;
		txtSpouseSumIncome = 0;
		txtSpouseSpDeduction = 0;
		txtHouseLoanDeduction = 0;
		txtAllowanceAdjustment = 0;
		txtTaxFreeAdjustment = 0;
		txtSocInsAdjustment = 0;
		txtTaxIncAdjustment = 0;
		txtWithholdSlipNotes = "";
		ckbDeadRetirement = String.valueOf(PayrollConst.CHECKBOX_OFF);
		ckbSelfDisaster = String.valueOf(PayrollConst.CHECKBOX_OFF);
		ckbForeigner = String.valueOf(PayrollConst.CHECKBOX_OFF);
		
		lblIncomeTaxType = "";
		lblAdjustmentType = "";
		lblSelfWidowType = "";
		lblSelfHandicapType = "";
		lblSelfStudentType = "";
		lblSpouseIntendType = "";
		lblGeneralDependent = "";
		lblSpecificDependent = "";
		lblElderlyDependent = "";
		lblLiveWithEldRel = "";
		lblLiveWithHandiGe = "";
		lblLiveWithHandiSp = "";
		lblLiveWithHandiEl = "";
		lblLiveWithHandiEr = "";
		lblGeneralHandicap = "";
		lblSpecificHandicap = "";
		
		lblMidwayType = "";
		lblFormerIncome = "";
		lblFormerInsurance = "";
		lblFormerTax = "";
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}
	
	/**
	 * J}}
	 * @param strTarget
	 * @return
	 */
	public String insertComma(String strTarget) {
		String destStr = "";
		if (strTarget == null) {
			return "";
		}
		if (strTarget.equals("")) {
			return "";
		}
		destStr = strTarget.replaceAll("(?m)(?<=\\d)(?=(?:\\d{3})+$)", ",");
		return destStr;
	}
	
	// ANZT\bh
	public String getTxtChangeKCode() {
		return txtChangeKCode;
	}
	
	public int getHidAdjustYear() {
		return hidAdjustYear;
	}
	
	public String getHidKCode() {
		return hidKCode;
	}
	
	public String getEscTxtChangeKCode() {
		return escapeHTML(txtChangeKCode);
	}
	
	public String getEscHidKCode() {
		return escapeHTML(hidKCode);
	}
	
	@Override
	public String getEscLblKName() {
		return escapeHTML(lblKName);
	}
	
	public String getEscLblStationCode() {
		return escapeHTML(lblStationCode);
	}
	
	public String getEscLblStationName() {
		return escapeHTML(lblStationName);
	}
	
	public String getEscLblPositionCode() {
		return escapeHTML(lblPositionCode);
	}
	
	public String getEscLblPositionName() {
		return escapeHTML(lblPositionName);
	}
	
	public String getEsclblEntranceDate() {
		return escapeHTML(lblEntranceDate);
	}
	
	public String getEscLblAdjustStatus() {
		return escapeHTML(lblAdjustStatus);
	}
	
	public void setTxtChangeKCode(String txtChangeKCode) {
		this.txtChangeKCode = txtChangeKCode;
	}
	
	public void setHidAdjustYear(int hidAdjustYear) {
		this.hidAdjustYear = hidAdjustYear;
	}
	
	public int getTxtGeneralLifeIns() {
		return txtGeneralLifeIns;
	}
	
	public int getTxtPrivatePension() {
		return txtPrivatePension;
	}
	
	public int getTxtLifeInsDeduction() {
		return txtLifeInsDeduction;
	}
	
	public int getTxtEarthquakeIns() {
		return txtEarthquakeIns;
	}
	
	public int getTxtLongTermDamageIns() {
		return txtLongTermDamageIns;
	}
	
	public int getTxtDamageInsDeduction() {
		return txtDamageInsDeduction;
	}
	
	public int getTxtSocialInsDeduction() {
		return txtSocialInsDeduction;
	}
	
	public int getTxtMutualAidDeduction() {
		return txtMutualAidDeduction;
	}
	
	public int getTxtSpouseSumIncome() {
		return txtSpouseSumIncome;
	}
	
	public int getTxtSpouseSpDeduction() {
		return txtSpouseSpDeduction;
	}
	
	public int getTxtHouseLoanDeduction() {
		return txtHouseLoanDeduction;
	}
	
	public int getTxtAllowanceAdjustment() {
		return txtAllowanceAdjustment;
	}
	
	public int getTxtTaxFreeAdjustment() {
		return txtTaxFreeAdjustment;
	}
	
	public int getTxtSocInsAdjustment() {
		return txtSocInsAdjustment;
	}
	
	public int getTxtTaxIncAdjustment() {
		return txtTaxIncAdjustment;
	}
	
	public String getTxtWithholdSlipNotes() {
		return escapeHTML(txtWithholdSlipNotes);
	}
	
	public String getCkbDeadRetirement() {
		return getCheckBoxChecked(ckbDeadRetirement);
	}
	
	public String getCkbSelfDisaster() {
		return getCheckBoxChecked(ckbSelfDisaster);
	}
	
	public String getCkbForeigner() {
		return getCheckBoxChecked(ckbForeigner);
	}
	
	public String getEscCkbDeadRetirement() {
		return getCheckBoxChecked(escapeHTML(ckbDeadRetirement));
	}
	
	public String getEscCkbSelfDisaster() {
		return getCheckBoxChecked(escapeHTML(ckbSelfDisaster));
	}
	
	public String getEscCkbForeigner() {
		return getCheckBoxChecked(escapeHTML(ckbForeigner));
	}
	
	public void setTxtGeneralLifeIns(int txtGeneralLifeIns) {
		this.txtGeneralLifeIns = txtGeneralLifeIns;
	}
	
	public void setTxtPrivatePension(int txtPrivatePension) {
		this.txtPrivatePension = txtPrivatePension;
	}
	
	public void setTxtLifeInsDeduction(int txtLifeInsDeduction) {
		this.txtLifeInsDeduction = txtLifeInsDeduction;
	}
	
	public void setTxtEarthquakeIns(int txtEarthquakeIns) {
		this.txtEarthquakeIns = txtEarthquakeIns;
	}
	
	public void setTxtLongTermDamageIns(int txtLongTermDamageIns) {
		this.txtLongTermDamageIns = txtLongTermDamageIns;
	}
	
	public void setTxtDamageInsDeduction(int txtDamageInsDeduction) {
		this.txtDamageInsDeduction = txtDamageInsDeduction;
	}
	
	public void setTxtSocialInsDeduction(int txtSocialInsDeduction) {
		this.txtSocialInsDeduction = txtSocialInsDeduction;
	}
	
	public void setTxtMutualAidDeduction(int txtMutualAidDeduction) {
		this.txtMutualAidDeduction = txtMutualAidDeduction;
	}
	
	public void setTxtSpouseSumIncome(int txtSpouseSumIncome) {
		this.txtSpouseSumIncome = txtSpouseSumIncome;
	}
	
	public void setTxtSpouseSpDeduction(int txtSpouseSpDeduction) {
		this.txtSpouseSpDeduction = txtSpouseSpDeduction;
	}
	
	public void setTxtHouseLoanDeduction(int txtHouseLoanDeduction) {
		this.txtHouseLoanDeduction = txtHouseLoanDeduction;
	}
	
	public void setTxtAllowanceAdjustment(int txtAllowanceAdjustment) {
		this.txtAllowanceAdjustment = txtAllowanceAdjustment;
	}
	
	public void setTxtTaxFreeAdjustment(int txtTaxFreeAdjustment) {
		this.txtTaxFreeAdjustment = txtTaxFreeAdjustment;
	}
	
	public void setTxtSocInsAdjustment(int txtSocInsAdjustment) {
		this.txtSocInsAdjustment = txtSocInsAdjustment;
	}
	
	public void setTxtTaxIncAdjustment(int txtTaxIncAdjustment) {
		this.txtTaxIncAdjustment = txtTaxIncAdjustment;
	}
	
	public void setTxtWithholdSlipNotes(String txtWithholdSlipNotes) {
		this.txtWithholdSlipNotes = txtWithholdSlipNotes;
	}
	
	public void setCkbDeadRetirement(String ckbDeadRetirement) {
		this.ckbDeadRetirement = ckbDeadRetirement;
	}
	
	public void setCkbSelfDisaster(String ckbSelfDisaster) {
		this.ckbSelfDisaster = ckbSelfDisaster;
	}
	
	public void setCkbForeigner(String ckbForeigner) {
		this.ckbForeigner = ckbForeigner;
	}
	
	public String getEscLblIncomeTaxType() {
		return escapeHTML(lblIncomeTaxType);
	}
	
	public String getEscLblAdjustmentType() {
		return escapeHTML(lblAdjustmentType);
	}
	
	public String getEscLblSelfWidowType() {
		return escapeHTML(lblSelfWidowType);
	}
	
	public String getEscLblSelfHandicapType() {
		return escapeHTML(lblSelfHandicapType);
	}
	
	public String getEscLblSelfStudentType() {
		return escapeHTML(lblSelfStudentType);
	}
	
	public String getEscLblSpouseIntendType() {
		return escapeHTML(lblSpouseIntendType);
	}
	
	public String getEscLblGeneralDependent() {
		return escapeHTML(lblGeneralDependent);
	}
	
	public String getEscLblSpecificDependent() {
		return escapeHTML(lblSpecificDependent);
	}
	
	public String getEscLblElderlyDependent() {
		return escapeHTML(lblElderlyDependent);
	}
	
	public String getEscLblLiveWithEldRel() {
		return escapeHTML(lblLiveWithEldRel);
	}
	
	public String getEscLblLiveWithHandiGe() {
		return escapeHTML(lblLiveWithHandiGe);
	}
	
	public String getEscLblLiveWithHandiSp() {
		return escapeHTML(lblLiveWithHandiSp);
	}
	
	public String getEscLblLiveWithHandiEl() {
		return escapeHTML(lblLiveWithHandiEl);
	}
	
	public String getEscLblLiveWithHandiEr() {
		return escapeHTML(lblLiveWithHandiEr);
	}
	
	public String getEscLblGeneralHandicap() {
		return escapeHTML(lblGeneralHandicap);
	}
	
	public String getEscLblSpecificHandicap() {
		return escapeHTML(lblSpecificHandicap);
	}
	
	public String getEscLblMidwayType() {
		return escapeHTML(lblMidwayType);
	}
	
	public String getEscLblFormerIncome() {
		return escapeHTML(lblFormerIncome);
	}
	
	public String getEscLblFormerInsurance() {
		return escapeHTML(lblFormerInsurance);
	}
	
	public String getEscLblFormerTax() {
		return escapeHTML(lblFormerTax);
	}
	
	public String getEscHidFamilyInfo() {
		return escapeHTML(hidFamilyInfo);
	}
}
