package jp.mosp.payroll.common.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.ImportMasterCardVo;
import jp.mosp.payroll.dao.MImportDao;
import jp.mosp.payroll.dao.MImportFieldDao;
import jp.mosp.payroll.dao.PmDetailPaDao;
import jp.mosp.payroll.dao.PmDetailPbDao;
import jp.mosp.payroll.dao.PmDetailPdDao;
import jp.mosp.payroll.dao.PmDetailPsDao;
import jp.mosp.payroll.dao.PmDetailPtDao;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.DetailPaDto;
import jp.mosp.payroll.dto.DetailPbDto;
import jp.mosp.payroll.dto.DetailPdDto;
import jp.mosp.payroll.dto.DetailTimeDto;
import jp.mosp.payroll.dto.MImportDto;
import jp.mosp.payroll.dto.MImportFieldDto;

public class ImportMasterCardAction extends MosPAction {
	
	// R}h
	private static final String	CMD_IMPORT_MASTER_CARD_SHOW		= "P9030";	// \(ǉ)
	private static final String	CMD_IMPORT_MASTER_CARD_SELECT	= "P9031";	// \(I)
	private static final String	CMD_IMPORT_MASTER_CARD_INSERT	= "P9032";	// o^
	private static final String	CMD_IMPORT_MASTER_CARD_UPDATE	= "P9033";	// XV
	private static final String	CMD_IMPORT_MASTER_CARD_DELETE	= "P9034";	// 폜
																			
	public List<DetailPaDto>	detailPaDto_lst;
	public List<DetailPbDto>	detailPbDto_lst;
	public List<DetailPdDto>	detailPdDto_lst;
	public List<DetailMoneyDto>	detailPsDto_lst;
	public List<DetailTimeDto>	detailPtDto_lst;
	

	/**
	 * RXgN^
	 */
	public ImportMasterCardAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new ImportMasterCardVo();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// VO擾yѐݒ
		prepareVo();
		// R}h̏
		if (cmd.equals(CMD_IMPORT_MASTER_CARD_SHOW)) {
			show();
		} else if (cmd.equals(CMD_IMPORT_MASTER_CARD_SELECT)) {
			select();
		} else if (cmd.equals(CMD_IMPORT_MASTER_CARD_INSERT)) {
			insert();
		} else if (cmd.equals(CMD_IMPORT_MASTER_CARD_UPDATE)) {
			update();
		} else if (cmd.equals(CMD_IMPORT_MASTER_CARD_DELETE)) {
			delete();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	public void show() throws SQLException, IllegalAccessException, NoSuchFieldException {
		setPulldown(key1);
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		vo.setAryHidIField(getImportFieldCodeArray(key1));
		vo.setAryLblIField(getImportFieldNameArray(key1));
		vo.setAryPltIOrder(getImportFieldOrderArray(key1));
		vo.setTxtICode("");
		vo.setTxtIName("");
		vo.setHidITable(key1);
		vo.setLblITable(StringUtil.getCodeName(key1, vo.aryPltTable));
		vo.setMode(ImportMasterCardVo.MODE_INSERT);
	}
	
	@Override
	public void select() throws Exception {
		// DAȌ
		MImportDao dao = new MImportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		MImportFieldDao mImportFieldDao = new MImportFieldDao();
		mImportFieldDao.initDao(cfg, cmd, aspUser, user, conn);
		MImportDto dto = dao.findForKey(key1);
		chkExist(dto);
		setPulldown(dto.getITable());
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		vo.setAryHidIField(getImportFieldCodeArray(dto.getITable()));
		vo.setAryLblIField(getImportFieldNameArray(dto.getITable()));
		vo.setAryPltIOrder(getImportFieldOrderArray(dto.getITable()));
		// VOɏZbg
		vo.setFields(dto);
		vo.setFields(mImportFieldDao.findForCondition(dto.getICode()));
		vo.setMode(ImportMasterCardVo.MODE_UPDATE);
		//ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, dto);
	}
	
	@Override
	public void insert() throws Exception {
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		vo.setParams(request);
		// p[^[̑ÓmF
		vo.validate();
		// DAȌ
		MImportDao dao = new MImportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(dao.findForKey(vo.getTxtICode()), vo);
		// DTȌ
		MImportDto dto = new MImportDto();
		vo.setDtoFields(dto);
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		dto = dao.findForKey(dto.getICode());
		chkInsert(dto);
		// C|[gtB[h̑}
		insertImportField();
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ImportMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, dto);
	}
	
	@Override
	public void update() throws Exception {
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		vo.setParams(request);
		//p[^[̑ÓmF
		vo.validate();
		// DAȌ
		MImportDao dao = new MImportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO̎擾
		MImportDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MImportDto ? (MImportDto)obj : null;
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getTxtICode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MImportDto retDto = dao.findForKey(dto.getICode());
		chkUpdate(retDto);
		// C|[gtB[h̑}
		insertImportField();
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ImportMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, retDto);
	}
	
	private void delete() throws Exception {
		// DAȌ
		MImportDao dao = new MImportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO̎擾
		MImportDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MImportDto ? (MImportDto)obj : null;
		// f[^̍XV
		dao.delete(dto);
		// C|[gtB[h̍폜
		deleteImportField(dto.getICode());
		// R~bg
		commit();
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		// [hݒ
		vo.setMode(ImportMasterCardVo.MODE_INSERT);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, dto);
	}
	
	private void insertImportField() throws Exception {
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		// 폜
		deleteImportField(vo.getTxtICode());
		// DAȌ
		MImportFieldDao dao = new MImportFieldDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTȌ
		MImportFieldDto dto = new MImportFieldDto();
		String[] importFieldOrder = vo.getAryPltIOrder();
		for (int i = 0; i < importFieldOrder.length; i++) {
			if (!importFieldOrder[i].equals("")) {
				vo.setDtoFields(dto, i);
				// f[^̑}
				dao.insert(dto);
				// DTO̍Ď擾
				dto = dao.findForKey(dto.getICode(), dto.getIField());
				chkInsert(dto);
			}
		}
	}
	
	private void deleteImportField(String icode) throws Exception {
		// DAȌ
		MImportFieldDao dao = new MImportFieldDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̍XV
		dao.delete(icode, dao.findForCondition(icode).size());
	}
	
	private void setPulldown(String table) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		vo.aryPltTable = getImportTableArray();
		vo.aryPltOrder = StringUtil.getCountArray(1, getImportFieldCodeArray(table).length, 1);
	}
	
	/**
	 * C|[gtB[hR[h擾
	 * @param table C|[ge[u
	 * @return C|[gtB[hR[hpz
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private String[] getImportFieldCodeArray(String table) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		String[] aryImportFieldCode = new String[0];
		int tmoCount = 0;
		ArrayList<String> addList = new ArrayList<String>();
		if (table.equals(PayrollConst.CODE_IMPORT_TABLE_PI_PAYMENT)) {
			
			// DAȌ
			PmDetailPaDao pmDetailPaDao = new PmDetailPaDao(cfg, cmd, aspUser, user, conn);
			PmDetailPbDao pmDetailPbDao = new PmDetailPbDao(cfg, cmd, aspUser, user, conn);
			PmDetailPdDao pmDetailPdDao = new PmDetailPdDao(cfg, cmd, aspUser, user, conn);
			PmDetailPsDao pmDetailPsDao = new PmDetailPsDao(cfg, cmd, aspUser, user, conn);
			PmDetailPtDao pmDetailPtDao = new PmDetailPtDao(cfg, cmd, aspUser, user, conn);
			detailPaDto_lst = pmDetailPaDao.findNotDelete();
			detailPbDto_lst = pmDetailPbDao.findNotDelete();
			detailPdDto_lst = pmDetailPdDao.findNotDelete();
			detailPsDto_lst = pmDetailPsDao.findNotDelete();
			detailPtDto_lst = pmDetailPtDao.findNotDelete();
			
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KCODE);
			addList.add(PayrollConst.DTL_SNEN);
			addList.add(PayrollConst.DTL_STUKI);
			addList.add(PayrollConst.DTL_SHI);
			
			for (DetailPaDto dto : detailPaDto_lst) {
				if (dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD) {
					addList.add(dto.getDetailCode());
				}
			}
			
			for (DetailPbDto dto : detailPbDto_lst) {
				if (dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD) {
					addList.add(dto.getDetailCode());
				}
			}
			
			for (DetailPdDto dto : detailPdDto_lst) {
				if (dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD) {
					addList.add(dto.getDetailCode());
				}
			}
			
			for (DetailMoneyDto dto : detailPsDto_lst) {
				if (dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD) {
					addList.add(dto.getDetailCode());
				}
			}
			
			for (DetailTimeDto dto : detailPtDto_lst) {
				if (dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD) {
					addList.add(dto.getDetailCode());
					if (dto.getDetailCode().equals(PayrollConst.DTL_WARIMASI1)) {
						tmoCount = 1;
					}
				}
			}
			
			if (tmoCount == 0) {
				addList.add(PayrollConst.DTL_WARIMASI1);
			}
			aryImportFieldCode = paiLieToArrayList(addList);
			
		} else if (table.equals(PayrollConst.CODE_IMPORT_TABLE_M_SYUKKINBO)) {
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KCODE);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_HIZUKE);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_SYJIKOKU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KINMU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_SHANKYUKB);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KYUSYUKB);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_TIRIYUU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_TICOMENT);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_TISYOUMEI);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_TIJIKAN);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_TAJIKOKU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KINMUJI);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KYUKEIJI);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_THANKYUKB);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_SORIYUU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_SOCOMENT);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_SOSYOUMEI);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_SOJIKAN);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_ZAJIKAN);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KSJIKAN);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_SNJIKAN);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_SYOKJI);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_CYOKU1);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_CYOKU2);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_CYOKU3);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_HOKA1);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_HOKA2);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_HOKA3);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_HOKA4);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_HOKA5);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KKRIYUU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_DAIKYUJYU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KKCOMENT);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KKSYOUMEI);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KKJIKAN);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_NIJIKYU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_NZAJIKAN);
			aryImportFieldCode = paiLieToArrayList(addList);
		} else if (table.equals(PayrollConst.CODE_IMPORT_TABLCT_TIMECARD)) {
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KCODE);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_HIZUKE);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_SYJIKOKU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_TAJIKOKU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KINMU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KKRIYUU);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_SHANKYUKB);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_THANKYUKB);
			addList.add(PayrollConst.CODE_IMPORT_FIELD_KYUSYUKB);
//			add_list.add( PayrollConst.CODE_IMPORT_FIELD_NIJIKYU );
//			add_list.add( PayrollConst.CODE_IMPORT_FIELD_NZAJIKAN );
			aryImportFieldCode = paiLieToArrayList(addList);
		}
		return aryImportFieldCode;
	}
	
	/**
	 * C|[gtB[h̎擾
	 * @param table C|[ge[u
	 * @return C|[gtB[h̗pz
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private String[] getImportFieldNameArray(String table) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		String[] aryImportFieldName = new String[0];
		ArrayList<String> addList = new ArrayList<String>();
		
		if (table.equals(PayrollConst.CODE_IMPORT_TABLE_PI_PAYMENT)) {
			// DAȌ
			PmDetailPaDao pmDetailPaDao = new PmDetailPaDao(cfg, cmd, aspUser, user, conn);
			PmDetailPbDao pmDetailPbDao = new PmDetailPbDao(cfg, cmd, aspUser, user, conn);
			PmDetailPdDao pmDetailPdDao = new PmDetailPdDao(cfg, cmd, aspUser, user, conn);
			PmDetailPsDao pmDetailPsDao = new PmDetailPsDao(cfg, cmd, aspUser, user, conn);
			PmDetailPtDao pmDetailPtDao = new PmDetailPtDao(cfg, cmd, aspUser, user, conn);
			
			detailPaDto_lst = pmDetailPaDao.findNotDelete();
			detailPbDto_lst = pmDetailPbDao.findNotDelete();
			detailPdDto_lst = pmDetailPdDao.findNotDelete();
			detailPsDto_lst = pmDetailPsDao.findNotDelete();
			detailPtDto_lst = pmDetailPtDao.findNotDelete();
			
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KCODE);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_DTL_SNEN);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_DTL_STUKI);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_DTL_DTL_SHI);
			
			for (DetailPaDto dto : detailPaDto_lst) {
				if (dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD) {
					addList.add(dto.getDetailName());
				}
			}
			
			for (DetailPbDto dto : detailPbDto_lst) {
				if (dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD) {
					addList.add(dto.getDetailName());
				}
			}
			
			for (DetailPdDto dto : detailPdDto_lst) {
				if (dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD) {
					addList.add(dto.getDetailName());
				}
			}
			
			for (DetailMoneyDto dto : detailPsDto_lst) {
				if (dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD) {
					addList.add(dto.getDetailName());
				}
			}
			
			for (DetailTimeDto dto : detailPtDto_lst) {
				if (dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD) {
					addList.add(dto.getDetailName());
				}
			}
			addList.add(PayrollConst.NAM_IMPORT_FIELD_NZAJIKAN);
			aryImportFieldName = paiLieToArrayList(addList);
			
		} else if (table.equals(PayrollConst.CODE_IMPORT_TABLE_M_SYUKKINBO)) {
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KCODE);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_HIZUKE);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_SYJIKOKU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KINMU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_SHANKYUKB);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KYUSYUKB);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_TIRIYUU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_TICOMENT);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_TISYOUMEI);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_TIJIKAN);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_TAJIKOKU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KINMUJI);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KYUKEIJI);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_THANKYUKB);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_SORIYUU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_SOCOMENT);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_SOSYOUMEI);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_SOJIKAN);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_ZAJIKAN);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KSJIKAN);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_SNJIKAN);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_SYOKJI);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_CYOKU1);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_CYOKU2);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_CYOKU3);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_HOKA1);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_HOKA2);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_HOKA3);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_HOKA4);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_HOKA5);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KKRIYUU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_DAIKYUJYU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KKCOMENT);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KKSYOUMEI);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KKJIKAN);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_NIJIKYU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_NZAJIKAN);
			
			aryImportFieldName = paiLieToArrayList(addList);
		} else if (table.equals(PayrollConst.CODE_IMPORT_TABLCT_TIMECARD)) {
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KCODE);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_HIZUKE);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_SYJIKOKU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_TAJIKOKU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KINMU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KKRIYUU);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_SHANKYUKB);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_THANKYUKB);
			addList.add(PayrollConst.NAM_IMPORT_FIELD_KYUSYUKB);
//			add_list.add( PayrollConst.NAM_IMPORT_FIELD_NIJIKYU );
//			add_list.add( PayrollConst.NAM_IMPORT_FIELD_NZAJIKAN );
			aryImportFieldName = paiLieToArrayList(addList);
		}
		return aryImportFieldName;
	}
	
	private String[] getImportFieldOrderArray(String table) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		return new String[getImportFieldCodeArray(table).length];
	}
	
	/**
	 * C|[ge[uv_E擾
	 * @return C|[ge[uv_Epz
	 */
	protected String[][] getImportTableArray() {
		String[][] aryImportTable = new String[3][2];
		aryImportTable[0][0] = PayrollConst.CODE_IMPORT_TABLE_PI_PAYMENT;
		aryImportTable[0][1] = PayrollConst.NAM_IMPORT_TABLE_PI_PAYMENT;
		aryImportTable[1][0] = PayrollConst.CODE_IMPORT_TABLE_M_SYUKKINBO;
		aryImportTable[1][1] = PayrollConst.NAM_IMPORT_TABLE_M_SYUKKINBO;
		aryImportTable[2][0] = PayrollConst.CODE_IMPORT_TABLCT_TIMECARD;
		aryImportTable[2][1] = PayrollConst.NAM_IMPORT_TABLCT_TIMECARD;
		return aryImportTable;
	}
	
	/**
	* StringListStringzɕϊ
	* @param List Xg
	* @return String̔z
	*/
	public static String[] paiLieToArrayList(List<String> list) {
		String[] strs = list.toArray(new String[]{});
		return strs;
	}
	
}
