/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.action;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.VoInterface;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.dao.MKihonDao;
import jp.mosp.payroll.base.Bonus;
import jp.mosp.payroll.base.Payment;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.dao.BonusListDao;
import jp.mosp.payroll.bonus.dao.PdBonAllowanceDao;
import jp.mosp.payroll.bonus.dao.PdBonDeductionDao;
import jp.mosp.payroll.bonus.dao.PdBonSumDao;
import jp.mosp.payroll.bonus.dao.PhBounsDao;
import jp.mosp.payroll.bonus.dao.PmDetailBaDao;
import jp.mosp.payroll.bonus.dao.PmDetailBdDao;
import jp.mosp.payroll.bonus.dao.PmDetailBsDao;
import jp.mosp.payroll.bonus.dto.BonusListDto;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.bonus.dto.PmDetailBaDto;
import jp.mosp.payroll.bonus.dto.PmDetailBdDto;
import jp.mosp.payroll.bonus.dto.PmDetailBsDto;
import jp.mosp.payroll.common.vo.ExportCardVo;
import jp.mosp.payroll.dao.MExportPaymentDao;
import jp.mosp.payroll.dao.PaymentListDao;
import jp.mosp.payroll.dao.PhPaymentDao;
import jp.mosp.payroll.dao.PmDetailPaDao;
import jp.mosp.payroll.dao.PmDetailPbDao;
import jp.mosp.payroll.dao.PmDetailPdDao;
import jp.mosp.payroll.dao.PmDetailPsDao;
import jp.mosp.payroll.dao.PmDetailPtDao;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.DetailPaDto;
import jp.mosp.payroll.dto.DetailPbDto;
import jp.mosp.payroll.dto.DetailPdDto;
import jp.mosp.payroll.dto.DetailTimeDto;
import jp.mosp.payroll.dto.MExportPaymentDto;
import jp.mosp.payroll.dto.PaymentListDto;
import jp.mosp.payroll.payment.vo.PaymentReportVo;

public class ExportCardAction extends PayrollAction {
	
	// R}h
	private static final String	CMD_EXPORT_SHOW	= "P9003";
	private static final String	CMD_EXPORT_DATA	= "P9006";
	

	// tB[h
	
	/**
	 * RXgN^
	 */
	public ExportCardAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new PaymentReportVo();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// vZǗmF
		confirmCalculateAuth();
		// VO̎擾
		ExportCardVo vo = getInitVo();
		init(vo);
		// R}h̏
		if (cmd.equals(CMD_EXPORT_SHOW)) {
			// \
			show(vo);
		} else if (cmd.equals(CMD_EXPORT_DATA)) {
			// GNX|[g
			export(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	protected ExportCardVo getInitVo() {
		return new ExportCardVo();
	}
	
	protected PaymentReportVo getPayReportVo() {
		return new PaymentReportVo();
	}
	
	/**
	 * 
	 * @param vo	ΏVO
	 */
	protected void init(ExportCardVo vo) {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// v_EXg
		Date date = DateUtil.getSystemDate();
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(date), 4, 1);
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltDay = StringUtil.getDayArray();
	}
	
	/**
	 * \
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void show(ExportCardVo vo) throws Exception {
		Date date = DateUtil.getSystemDate();
		vo.setPltYear(String.valueOf(MospUtility.getYear(date)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(date)));
		vo.setPltDay(String.valueOf(MospUtility.getDay(date)));
		// 
		session.removeAttribute(MospConst.ATT_DTO);
		searchExportCard(vo);
		vo.setPageButton();
		sortList(vo);
	}
	
	/**
	 * GNX|[g
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void export(ExportCardVo vo) throws Exception {
		// p[^擾
		vo.setParams(request);
		// VOɏZbg
		// Export
		vo.setTxtEName(key1);
		// Ώۃt@CID
		vo.setTxtEFile(key2);
		// o
		String fileNameType = "";
		if (key2.equals(PayrollConst.NAM_DATA_M_PAYROLL)) {
			fileNameType = PayrollConst.NAM_FILE_PAYROLL;
		} else {
			fileNameType = PayrollConst.NAM_FILE_BONUS;
		}
		StringBuffer fileName = new StringBuffer();
		fileName.append(vo.getPltYear());
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(vo.getPltMonth());
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(fileNameType);
		fileName.append(CommonConst.FILE_COMMON_CSV);
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// Iڎ擾
		MExportPaymentDao mExportDao = new MExportPaymentDao();
		mExportDao.initDao(cfg, cmd, aspUser, user, conn);
		List<MExportPaymentDto> listSelected = mExportDao.findForCondition(vo.getTxtEName(), vo.getTxtEFile());
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName.toString());
		request.setAttribute(MospConst.ATT_FILE_OBJECT, makeHumanData(listSelected, vo.getTxtEFile(), vo.getPltYear(),
				vo.getPltMonth(), vo.getPltDay(), vo));
		// V[PX𔭍sȂB
		setNeedProcSeq(false);
	}
	
	/**
	 * ^쐬
	 * @param vo ΏVO
	 * @return ^񕶎
	 * @throws Exception 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws Exception
	 */
	protected StringBuffer makeHumanData(List<MExportPaymentDto> listSelected, String txtEFile, String pltYear,
			String pltMonth, String pltDay, VoInterface vo) throws Exception {
		// [쐬
		StringBuffer sb = new StringBuffer();
		// wb_[ݒ
		sb.append(appendHeader(listSelected));
		// f[^ǋL
		if (key2.equals(PayrollConst.NAM_DATA_M_PAYROLL)) {
			sb.append(appendData(listSelected, txtEFile, pltYear, pltMonth, vo));
		} else {
			sb.append(appendDataBonus(listSelected, txtEFile, pltYear, pltMonth, pltDay, vo));
		}
		return sb;
	}
	
	/**
	 * wb_[ݒ
	 * @param listSelected		ΏۑI}X^
	 * @param sb				Ώۃf[^
	 * @return
	 * <p>
	 * I}X^̃wb_[
	 * <p>
	 * @throws Exception
	 */
	private StringBuffer appendHeader(List<MExportPaymentDto> listSelected) throws Exception {
		StringBuffer sb = new StringBuffer();
		// wb_[ݒ
		for (int i = 0; i < listSelected.size(); i++) {
			MExportPaymentDto exportDto = listSelected.get(i);
			// wb_[ݒ
			sb.append(getCsvData(getEFnameItem(exportDto.getEFname(), 3)));
			// Zp[^ݒ
			if (i == listSelected.size() - 1) {
				sb.append(CommonConst.STR_CSV_NEW_LINE);
			} else {
				sb.append(CommonConst.STR_CSV_SEPARATOR);
			}
		}
		return sb;
	}
	
	/**
	 * f[^擾(^)
	 * @param listSelected 
	 * @param txtEFile		Ώۃe[u
	 * @param pltYear		Ώ۔N
	 * @param pltMonth		Ώی
	 * @param vo 
	 * @return
	 * <p>
	 * ɂe[uf[^
	 * </p>
	 * @throws Exception
	 */
	protected StringBuffer appendData(List<MExportPaymentDto> listSelected, String txtEFile, String pltYear,
			String pltMonth, VoInterface vo) throws Exception {
		StringBuffer sb = new StringBuffer();
		PaymentReportVo paymentReportVo = getPayReportVo();
		paymentReportVo.setPltYear(Integer.valueOf(pltYear));
		paymentReportVo.setPltMonth(Integer.valueOf(pltMonth));
		//Ώ۔N擾
		Date targetMonth = getDate(paymentReportVo.getPltYear(), paymentReportVo.getPltMonth(),
				PayrollConst.TIME_DEFAULT_DAY);
		// DAO
		PaymentListDao dao = new PaymentListDao(cfg, cmd, aspUser, user, conn);
		//
		List<PaymentListDto> list = dao.findForPayment(targetMonth);
		//^񍀖ڌ
		PmDetailPaDao daoPa = new PmDetailPaDao(cfg, cmd, aspUser, user, conn);
		List<DetailPaDto> listdtoPa = daoPa.findAll();
		PmDetailPbDao daoPb = new PmDetailPbDao(cfg, cmd, aspUser, user, conn);
		List<DetailPbDto> listdtoPb = daoPb.findAll();
		PmDetailPdDao daoPd = new PmDetailPdDao(cfg, cmd, aspUser, user, conn);
		List<DetailPdDto> listdtoPd = daoPd.findAll();
		PmDetailPsDao daoPs = new PmDetailPsDao(cfg, cmd, aspUser, user, conn);
		List<DetailMoneyDto> listdtoPs = daoPs.findAll();
		PmDetailPtDao daoPt = new PmDetailPtDao(cfg, cmd, aspUser, user, conn);
		List<DetailTimeDto> listdtoPt = daoPt.findAll();
		sb.append(appendData(list, listdtoPa, listdtoPb, listdtoPd, listdtoPs, listdtoPt, listSelected, targetMonth));
		return sb;
	}
	
	/**
	 * f[^擾(ܗ^)
	 * @param txtEFile		Ώۃe[u
	 * @param pltYear		Ώ۔N
	 * @param pltMonth		Ώی
	 * @param pltDay		Ώۓ
	 * @return
	 * <p>
	 * ɂe[uf[^
	 * </p>
	 * @throws Exception
	 */
	protected StringBuffer appendDataBonus(List<MExportPaymentDto> listSelected, String txtEFile, String pltYear,
			String pltMonth, String pltDay, VoInterface vo) throws Exception {
		StringBuffer sb = new StringBuffer();
		PaymentReportVo paymentReportVo = getPayReportVo();
		paymentReportVo.setPltYear(Integer.valueOf(pltYear));
		paymentReportVo.setPltMonth(Integer.valueOf(pltMonth));
		paymentReportVo.setPltDay(Integer.valueOf(pltDay));
		//Ώ۔N擾
		Date targetMonth = getDate(paymentReportVo.getPltYear(), paymentReportVo.getPltMonth(), paymentReportVo
			.getPltDay());
		//DAO
		BonusListDao dao = new BonusListDao(cfg, cmd, aspUser, user, conn);
		//
		List<BonusListDto> list = dao.findForPayment(targetMonth);
		//ܗ^񍀖ڌ
		PmDetailBaDao daoBa = new PmDetailBaDao(cfg, cmd, aspUser, user, conn);
		List<PmDetailBaDto> listdtoBa = daoBa.findAll();
		PmDetailBdDao daoBd = new PmDetailBdDao(cfg, cmd, aspUser, user, conn);
		List<PmDetailBdDto> listdtoBd = daoBd.findAll();
		PmDetailBsDao daoBs = new PmDetailBsDao(cfg, cmd, aspUser, user, conn);
		List<PmDetailBsDto> listdtoBs = daoBs.findAll();
		sb.append(appendDataBonus(list, listdtoBa, listdtoBd, listdtoBs, listSelected, targetMonth));
		return sb;
	}
	
	/**
	 * f[^ݒ
	 * @param list 
	 * @param listdtoPa 
	 * @param listdtoPb 
	 * @param listdtoPd 
	 * @param listdtoPs 
	 * @param listdtoPt 
	 * @param sb
	 * @param rs
	 * @param listSelected
	 * @param targetMonth 
	 * @return
	 * @throws Exception
	 */
	protected StringBuffer appendData(List<PaymentListDto> list, List<DetailPaDto> listdtoPa,
			List<DetailPbDto> listdtoPb, List<DetailPdDto> listdtoPd, List<DetailMoneyDto> listdtoPs,
			List<DetailTimeDto> listdtoPt, List<MExportPaymentDto> listSelected, Date targetMonth) throws Exception {
		StringBuffer sb = new StringBuffer();
		
		for (PaymentListDto dto : list) {
			Payment payment = getPayment(dto.getKCode(), targetMonth);
			
			for (int i = 0; i < listSelected.size(); i++) {
				
				MExportPaymentDto exportDto = listSelected.get(i);
				if (getEFnameItem(exportDto.getEFname(), 2).equals(PhPaymentDao.COL_KCODE)) {
					sb.append(getCsvData(dto.getKCode())); // ЈR[h
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(MKihonDao.COL_SIMEI)) {
					sb.append(getCsvData(dto.getSimei())); // 
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(MKihonDao.COL_JCODE)) {
					sb.append(getCsvData(dto.getJCode())); // ƏR[h
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(MKihonDao.COL_SCODE)) {
					sb.append(getCsvData(dto.getSCode())); // R[h
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(MKihonDao.COL_YCODE)) {
					sb.append(getCsvData(dto.getYCode())); // ER[h
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(PhPaymentDao.COL_CALC_MONTH)) {
					sb.append(getCsvData(payment.getCalcMonthStr())); // vZN
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(PhPaymentDao.COL_PAY_DATE)) {
					sb.append(getCsvData(payment.getPayDate())); // x
					sb.append(appendConma(i, listSelected));
					continue;
				}
				for (int j = 0; j < listdtoPt.size(); j++) {
					DetailTimeDto dtoTime = listdtoPt.get(j);
					if (getEFnameItem(exportDto.getEFname(), 3).equals(dtoTime.getDetailName())) {
						sb.append(getCsvData(payment.getTimeAmount(listdtoPt.get(j).getDetailCode())));
						break;
					} else {
						continue;
					}
					
				}
				
				for (int j = 0; j < listdtoPa.size(); j++) {
					DetailPaDto dtoPa = listdtoPa.get(j);
					if (getEFnameItem(exportDto.getEFname(), 3).equals(dtoPa.getDetailName())) {
						sb.append(getCsvData(payment.getAllowanceAmount(listdtoPa.get(j).getDetailCode())));
						break;
					} else {
						continue;
					}
					
				}
				
				for (int j = 0; j < listdtoPb.size(); j++) {
					DetailPbDto dtoPb = listdtoPb.get(j);
					if (getEFnameItem(exportDto.getEFname(), 3).equals(dtoPb.getDetailName())) {
						sb.append(getCsvData(payment.getBreakdownAmount(listdtoPb.get(j).getDetailCode())));
						break;
					} else {
						continue;
					}
					
				}
				
				for (int j = 0; j < listdtoPd.size(); j++) {
					DetailPdDto dtoPd = listdtoPd.get(j);
					if (getEFnameItem(exportDto.getEFname(), 3).equals(dtoPd.getDetailName())) {
						sb.append(getCsvData(payment.getDeductionAmount(listdtoPd.get(j).getDetailCode())));
						break;
					} else {
						continue;
					}
					
				}
				
				for (int j = 0; j < listdtoPs.size(); j++) {
					DetailMoneyDto dtoPs = listdtoPs.get(j);
					if (getEFnameItem(exportDto.getEFname(), 3).equals(dtoPs.getDetailName())) {
						sb.append(getCsvData(payment.getSumAmount(listdtoPs.get(j).getDetailCode())));
						break;
					} else {
						continue;
					}
					
				}
				sb.append(appendConma(i, listSelected));
				
			}
			
		}
		return sb;
	}
	
	/**
	 * f[^ݒ(ܗ^)
	 * @param list 
	 * @param listdtoBa 
	 * @param listdtoBd 
	 * @param listdtoBs 
	 * @param sb
	 * @param rs
	 * @param listSelected
	 * @param targetMonth 
	 * @return
	 * @throws Exception
	 */
	protected StringBuffer appendDataBonus(List<BonusListDto> list, List<PmDetailBaDto> listdtoBa,
			List<PmDetailBdDto> listdtoBd, List<PmDetailBsDto> listdtoBs, List<MExportPaymentDto> listSelected,
			Date targetMonth) throws Exception {
		StringBuffer sb = new StringBuffer();
		for (BonusListDto dto : list) {
			Bonus bouns = getBouns(dto.getKCode(), targetMonth);
			
			for (int i = 0; i < listSelected.size(); i++) {
				
				MExportPaymentDto exportDto = listSelected.get(i);
				if (getEFnameItem(exportDto.getEFname(), 2).equals(PhPaymentDao.COL_KCODE)) {
					sb.append(getCsvData(dto.getKCode())); // ЈR[h
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(MKihonDao.COL_SIMEI)) {
					sb.append(getCsvData(dto.getSimei())); // 
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(MKihonDao.COL_JCODE)) {
					sb.append(getCsvData(dto.getJCode())); // ƏR[h
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(MKihonDao.COL_SCODE)) {
					sb.append(getCsvData(dto.getSCode())); // R[h
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(MKihonDao.COL_YCODE)) {
					sb.append(getCsvData(dto.getYCode())); // ER[h
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(PhPaymentDao.COL_CALC_MONTH)) {
					sb.append(getCsvData(bouns.getCalcMonthStr())); // vZN
					sb.append(appendConma(i, listSelected));
					continue;
				}
				if (getEFnameItem(exportDto.getEFname(), 2).equals(PhPaymentDao.COL_PAY_DATE)) {
					sb.append(getCsvData(bouns.getPayDate())); // x
					sb.append(appendConma(i, listSelected));
					continue;
				}
				for (int j = 0; j < listdtoBa.size(); j++) {
					PmDetailBaDto dtoBa = listdtoBa.get(j);
					if (getEFnameItem(exportDto.getEFname(), 3).equals(dtoBa.getDetailName())) {
						sb.append(getCsvData(bouns.getAllowanceAmount(listdtoBa.get(j).getDetailCode())));
						break;
					} else {
						continue;
					}
					
				}
				
				for (int j = 0; j < listdtoBd.size(); j++) {
					PmDetailBdDto dtoBd = listdtoBd.get(j);
					if (getEFnameItem(exportDto.getEFname(), 3).equals(dtoBd.getDetailName())) {
						sb.append(getCsvData(bouns.getDeductionAmount(listdtoBd.get(j).getDetailCode())));
						break;
					} else {
						continue;
					}
					
				}
				
				for (int j = 0; j < listdtoBs.size(); j++) {
					PmDetailBsDto dtoBs = listdtoBs.get(j);
					if (getEFnameItem(exportDto.getEFname(), 3).equals(dtoBs.getDetailName())) {
						sb.append(getCsvData(bouns.getSumAmount(listdtoBs.get(j).getDetailCode())));
						break;
					} else {
						continue;
					}
					
				}
				sb.append(appendConma(i, listSelected));
			}
		}
		return sb;
	}
	
	/**
	 * ^`[CX^X擾Aݒ肷B<br><br>
	 * kCodeAcalcDateL[Ƃċ^擾A{@link #payment}Ɋi[B
	 * @param kCode     ЈR[h
	 * @param calcMonth vZN
	 * @return ^`[
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected Bonus getBouns(String kCode, Date calcMonth) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		PhBounsDto header = new PhBounsDao(cfg, cmd, aspUser, user, conn).findForKey(kCode, calcMonth);
		if (header == null) {
			return null;
		}
		return new Bonus(header, new PmDetailBaDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()),
				new PmDetailBdDao(cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()), new PmDetailBsDao(
						cfg, cmd, aspUser, user, conn).findForSlip(header.getSlipCode()), new PdBonAllowanceDao(cfg,
						cmd, aspUser, user, conn).find(kCode, calcMonth), new PdBonDeductionDao(cfg, cmd, aspUser,
						user, conn).find(kCode, calcMonth), new PdBonSumDao(cfg, cmd, aspUser, user, conn).find(kCode,
						calcMonth)

		);
	}
	
	/**
	 * f[^ǋL
	 * @param sb
	 * @param rs
	 * @param listSelected
	 * @return
	 * @throws Exception
	 */
	protected StringBuffer appendConma(int i, List<MExportPaymentDto> listSelected) throws Exception {
		StringBuffer sb = new StringBuffer();
		if (i == listSelected.size() - 1) {
			sb.append(PayrollConst.STR_CSV_NEW_LINE);
		} else {
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
		}
		return sb;
	}
	
	/**
	 * Xg
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	protected void searchExportCard(ExportCardVo vo) throws Exception {
		//DBRlNV擾
		getConnection();
		MExportPaymentDao dao = new MExportPaymentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		//Ώۃt@CID(ʃ{^̐)
		vo.setTxtEFile(key1);
		if (!key1.equals(PayrollConst.FB_OUTPUT_DETAIL_BONUS)) {
			//^Eܗ^܂ߎ擾
			vo.setFields(dao.findForCondition());
		} else {
			//ܗ^݂̂擾
			vo.setFields(dao.findForConditionBonus());
		}
		
		//ΏۂȂꍇ̃bZ[Wݒ
		if (vo.getEscAryEName().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	protected void sortList(ExportCardVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}
	
	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	protected Comparator<Object> getComparator(String key, ExportCardVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_E_NAME)) {
			comp = new CompExportName();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ̂ɂrNX
	 */
	protected static class CompExportName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -5375772027347639889L;
		

		public int compare(Object obj1, Object obj2) {
			MExportPaymentDto dto1 = (MExportPaymentDto)obj1;
			MExportPaymentDto dto2 = (MExportPaymentDto)obj2;
			return dto1.getEName().compareTo(dto2.getEName());
		}
	}
	
}
