package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.PtSupportDto;

public class PtSupportDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE				= "UT_SUPPORT";
	public static final String	KEY_1				= "K_CODE";		// ЈR[h
	public static final String	KEY_2				= "STATION_CODE";	// x揊R[h
	public static final String	KEY_3				= "START_DATE";	// xJn
																		
	// 
	public static final String	COL_K_CODE			= "K_CODE";		// ЈR[h
	public static final String	COL_STATION_CODE	= "STATION_CODE";	// x揊R[h
	public static final String	COL_START_DATE		= "START_DATE";	// xJn
	public static final String	COL_END_DATE		= "END_DATE";		// xI
																		
	public static final String	ALS_BELONG_STATION	= "BELONG_STATION"; // R[h
																		
	
	/**
	 * RXgN^
	 */
	public PtSupportDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @param needExtraInfo AЈv(trueFvAfalseF)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PtSupportDto> mappingAll(boolean needExtraInfo) throws SQLException {
		List<PtSupportDto> all = new ArrayList<PtSupportDto>();
		while (rs.next()) {
			PtSupportDto dto = mapping();
			if (needExtraInfo) {
				dto.setBelongStation(rs.getString(ALS_BELONG_STATION));
				dto.setKName(rs.getString(PmBasisDao.COL_K_NAME));
			}
			all.add(dto);
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PtSupportDto UtSupportR[h
	 * @throws SQLException
	 */
	private PtSupportDto mapping() throws SQLException {
		PtSupportDto dto = new PtSupportDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setStationCode(rs.getString(COL_STATION_CODE)); // x揊R[h
		dto.setStartDate(rs.getDate(COL_START_DATE)); // xJn
		dto.setEndDate(rs.getDate(COL_END_DATE)); // xI
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PtSupportDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PtSupportDto> all = mappingAll(false);
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode       ЈR[h(L[)
	 * @param stationCode x揊R[h(L[)
	 * @param startDate   xJn(L[)
	 * @return PtSupportDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PtSupportDto findForKey(String kCode, String stationCode, Date startDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, stationCode);
			setParam(index++, startDate);
			executeQuery();
			PtSupportDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode       ЈR[h(L[)
	 * @param stationCode x揊R[h(L[)
	 * @param startDate   xJn(L[)
	 * @return PtSupportDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PtSupportDto findForUpdate(String kCode, String stationCode, Date startDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			setParam(index++, stationCode);
			setParam(index++, startDate);
			executeQuery();
			PtSupportDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param belongStation R[h
	 * @param kCode         ЈR[h
	 * @param kName         Ј
	 * @param stationCode   x揊R[h
	 * @param startDate     xJn
	 * @param endDate       xI
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public List<PtSupportDto> findForCondition(String belongStation, String kCode, String kName, String stationCode,
			Date startDate, Date endDate) throws SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append("S." + COL_K_CODE + ", ");
		sb.append("S." + COL_START_DATE + ", ");
		sb.append("S." + COL_END_DATE + ", ");
		sb.append("S." + COL_STATION_CODE + ", ");
		sb.append("B." + PmBasisDao.COL_K_NAME + ", ");
		sb.append("B." + PmBasisDao.COL_STATION_CODE + " AS " + ALS_BELONG_STATION + ", ");
		sb.append("S." + INSERT_DATE + " AS " + INSERT_DATE + ", ");
		sb.append("S." + INSERT_USER + " AS " + INSERT_USER + ", ");
		sb.append("S." + UPDATE_DATE + " AS " + UPDATE_DATE + ", ");
		sb.append("S." + UPDATE_USER + " AS " + UPDATE_USER + " ");
		sb.append("FROM ");
		sb.append(TABLE + " S,");
		sb.append(PmBasisDao.TABLE + " B ");
		sb.append("WHERE ");
		sb.append("S." + COL_K_CODE + " = B." + PmBasisDao.COL_K_CODE + " ");
		sb.append("AND ");
		sb.append("S." + COL_K_CODE + " LIKE ? ");
		sb.append("AND ");
		if (stationCode != null && !stationCode.equals("")) {
			sb.append("S." + COL_STATION_CODE + " = ? ");
			sb.append("AND ");
		}
		sb.append("S." + COL_START_DATE + " >= ? ");
		sb.append("AND ");
		sb.append("S." + COL_END_DATE + " <= ? ");
		sb.append("AND ");
		sb.append("B." + PmBasisDao.COL_K_NAME + " LIKE ? ");
		sb.append("AND ");
		sb.append("(");
		sb.append("B." + PmBasisDao.COL_STATION_CODE + " IN(");
		sb.append(PmStationDao.getStationQuery());
		sb.append(") ");
		sb.append("OR ");
		sb.append("S." + COL_STATION_CODE + " = ? ");
		sb.append(") ");
		try {
			prepareStatement(sb.toString());
			setParam(index++, kCode + "%");
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			setParam(index++, startDate);
			setParam(index++, endDate);
			setParam(index++, "%" + kName + "%");
			setParam(index++, belongStation);
			setParam(index++, belongStation);
			executeQuery();
			List<PtSupportDto> list = mappingAll(true);
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(ԏd`FbNp)
	 * @param kCode     ЈR[h
	 * @param startDate xJn
	 * @param endDate   xI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public List<PtSupportDto> findForTermDuplicate(String kCode, Date startDate, Date endDate) throws SQLException,
			NoSuchFieldException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_START_DATE + " <= ? ");
		sb.append("AND ");
		sb.append(COL_END_DATE + " >= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, endDate);
			setParam(index++, startDate);
			executeQuery();
			List<PtSupportDto> list = mappingAll(false);
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(Ζf[^p)
	 * @param kCode       ЈR[h
	 * @param stationCode ЈR[h
	 * @param startDate   xJn
	 * @param endDate     xI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public List<PtSupportDto> findForStation(String kCode, String stationCode, Date startDate, Date endDate)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_STATION_CODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_START_DATE + " <= ? ");
		sb.append("AND ");
		sb.append(COL_END_DATE + " >= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, stationCode);
			setParam(index++, endDate);
			setParam(index++, startDate);
			executeQuery();
			List<PtSupportDto> list = mappingAll(false);
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(x`FbNp)
	 * @param kCode     ЈR[h
	 * @param date      x
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public PtSupportDto findForEmployee(String kCode, Date date) throws SQLException, NoSuchFieldException,
			IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_START_DATE + " <= ? ");
		sb.append("AND ");
		sb.append(COL_END_DATE + " >= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, date);
			setParam(index++, date);
			executeQuery();
			PtSupportDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PtSupportDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PtSupportDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getStationCode());
			setParam(index++, dto.getStartDate());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PtSupportDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getStationCode());
			setParam(index++, dto.getStartDate());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PtSupportDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); // ЈR[h
		setParam(index++, dto.getStationCode()); // x揊R[h
		setParam(index++, dto.getStartDate()); // xJn
		setParam(index++, dto.getEndDate()); // xI
		setCommonParams(isInsert);
	}
	
	/**
	 * xЈR[h擾SQL
	 * @return xЈR[h擾SQL
	 */
	public static final String getSupportQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_K_CODE + " ");
		sb.append("FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_STATION_CODE + " IN (");
		sb.append(PmStationDao.getStationQuery());
		sb.append(") AND ");
		sb.append(COL_START_DATE + " <= ? ");
		sb.append("AND ");
		sb.append(COL_END_DATE + " >= ? ");
		return sb.toString();
	}
	
	/**
	 * xЈR[h擾SQL
	 * @return xЈR[h擾SQL
	 */
	public static final String getTermSupportQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_K_CODE + " ");
		sb.append("FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_STATION_CODE + " IN (");
		sb.append(PmStationDao.getStationQuery());
		sb.append(") AND ((");
		sb.append(COL_START_DATE + " >= ? ");
		sb.append("AND ");
		sb.append(COL_START_DATE + " <= ? ");
		sb.append(") OR ( ");
		sb.append(COL_END_DATE + " >= ? ");
		sb.append("AND ");
		sb.append(COL_END_DATE + " <= ? ");
		sb.append(")) ");
		return sb.toString();
	}
	
}
