package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.PmPositionDto;

public class PmPositionDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE				= "UM_POSITION";
	public static final String	KEY_1				= "POSITION_CODE";		// EʃR[h
																			
	// 
	public static final String	COL_POSITION_CODE	= "POSITION_CODE";		// EʃR[h
	public static final String	COL_POSITION_NAME	= "POSITION_NAME";		// Eʖ
	public static final String	COL_GRADE			= "GRADE";				// 
	public static final String	COL_NOTCH			= "NOTCH";				// 
	public static final String	COL_BASIC_SALARY	= "BASIC_SALARY";		// {
	public static final String	COL_EMPLOYMENT_TYPE	= "EMPLOYMENT_TYPE";	// ٗp敪
	public static final String	COL_DEFAULT_AUTH	= "DEFAULT_AUTH";		// ftHgvOp
	public static final String	COL_DEFAULT_LEVEL	= "DEFAULT_LEVEL";		// ftHgf[^Qƃx
	public static final String	COL_DELETE_FLAG		= "DELETE_FLAG";		// 폜tO
																			
	
	/**
	 * RXgN^
	 */
	public PmPositionDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PmPositionDto> mappingAll() throws SQLException {
		List<PmPositionDto> all = new ArrayList<PmPositionDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PmPositionDto UM_POSITIONR[h
	 * @throws SQLException
	 */
	private PmPositionDto mapping() throws SQLException {
		PmPositionDto dto = new PmPositionDto();
		dto.setPositionCode(rs.getString(COL_POSITION_CODE)); // EʃR[h
		dto.setPositionName(rs.getString(COL_POSITION_NAME)); // Eʖ
		dto.setGrade(rs.getInt(COL_GRADE)); // 
		dto.setNotch(rs.getInt(COL_NOTCH)); // 
		dto.setBasicSalary(rs.getInt(COL_BASIC_SALARY)); // {
		dto.setEmploymentType(rs.getString(COL_EMPLOYMENT_TYPE)); // ٗp敪
		dto.setDefaultAuth(rs.getString(COL_DEFAULT_AUTH)); // ftHgvOp
		dto.setDefaultLevel(rs.getInt(COL_DEFAULT_LEVEL)); // ftHgf[^Qƃx
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG)); // 폜tO
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmPositionDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PmPositionDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Lf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmPositionDto> findAvailable() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<PmPositionDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param positionCode EʃR[h(L[)
	 * @return PmPositionDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmPositionDto findForKey(String positionCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, positionCode);
			executeQuery();
			PmPositionDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param positionCode EʃR[h(L[)
	 * @return PmPositionDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmPositionDto findForUpdate(String positionCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, positionCode);
			executeQuery();
			PmPositionDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param positionCode EʃR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmPositionDto> findForCondition(String positionCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_POSITION_CODE);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, positionCode);
			executeQuery();
			List<PmPositionDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param positionCode R[h
	 * @param positionName 
	 * @param deleteFlag   폜tO
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmPositionDto> findForCondition(String positionCode, String positionName, String deleteFlag)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_POSITION_CODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_POSITION_NAME);
		sb.append(" LIKE ?  ");
		if (!deleteFlag.equals("")) {
			sb.append(" AND  ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ?  ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, positionCode + "%");
			setParam(index++, "%" + positionName + "%");
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			List<PmPositionDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PmPositionDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PmPositionDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getPositionCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PmPositionDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getPositionCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PmPositionDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getPositionCode()); // EʃR[h
		setParam(index++, dto.getPositionName()); // Eʖ
		setParam(index++, dto.getGrade()); // 
		setParam(index++, dto.getNotch()); // 
		setParam(index++, dto.getBasicSalary()); // {
		setParam(index++, dto.getEmploymentType()); // ٗp敪
		setParam(index++, dto.getDefaultAuth()); // ftHgvOp
		setParam(index++, dto.getDefaultLevel()); // ftHgf[^Qƃx
		setParam(index++, dto.getDeleteFlag()); // 폜tO
		setCommonParams(isInsert);
	}
	
	/**
	 * f[^xEʃR[hoSQL擾
	 * @return f[^xEʃR[hoSQL
	 */
	public static String getQueryForLowerLevel() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT " + COL_POSITION_CODE + " ");
		sb.append("FROM " + TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_DEFAULT_LEVEL + " < ? ");
		return sb.toString();
	}
	
}
