package jp.mosp.payroll.base;

import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.express.ExpressUtility;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;
import jp.mosp.mospcommon.system.AgreementBaseInfo;
import jp.mosp.payroll.dao.KdSubstituteHolidayDao;
import jp.mosp.payroll.dto.DetailDto;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.DetailTimeDto;

/**
 * ^vZ֘A`[̌ƂȂNXB<br><br>
 */
public abstract class PayrollSlip extends PayrollAction {
	
	/**
	 * ׏擾B
	 * @param list
	 * @param detailCode ׃R[h
	 * @return גl
	 */
	protected DetailDto getDetailDto(List<?> list, String detailCode) {
		for (Object name : list) {
			DetailDto dto = (DetailDto)name;
			if (dto.getDetailCode().equals(detailCode)) {
				return dto;
			}
		}
		return null;
	}
	
	/**
	 * ׃Xgݒ肷B
	 * @param listDetail
	 * @param aryDetail ݒΏۖהz
	 */
	protected void setDetails(List<?> listDetail, String[][] aryDetail) {
		for (Object name : listDetail) {
			DetailDto dto = (DetailDto)name;
			for (String[] element : aryDetail) {
				if (dto.getDetailCode().equals(element[0])) {
					setDetailAmount(dto, Float.parseFloat(element[2]));
					break;
				}
			}
		}
	}
	
	/**
	 * גl擾B
	 * @param list 擾ΏۃXg
	 * @param detailCode 擾Ώۖ׃R[h
	 * @return גl
	 */
	protected float getDetailAmount(List<?> list, String detailCode) {
		for (Object name : list) {
			DetailDto dto = (DetailDto)name;
			if (dto.getDetailCode().equals(detailCode)) {
				if (dto instanceof DetailTimeDto) {
					DetailTimeDto detailTimeDto = (DetailTimeDto)dto;
					return detailTimeDto.getAmount();
				}
				if (dto instanceof DetailMoneyDto) {
					DetailMoneyDto detailMoneyDto = (DetailMoneyDto)dto;
					return detailMoneyDto.getAmount();
				}
			}
		}
		return 0;
	}
	
	/**
	 * הz擾B
	 * @param list 擾ΏۃXg
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	protected String[][] getAryDetail(List<?> list, boolean checkDisplayType) {
		String[][] aryDetail = new String[list.size()][3];
		for (int i = 0; i < list.size(); i++) {
			DetailDto dto = (DetailDto)list.get(i);
			aryDetail[i][0] = dto.getDetailCode();
			aryDetail[i][1] = dto.getDetailAbbr();
			aryDetail[i][2] = "0";
			if (dto instanceof DetailTimeDto) {
				aryDetail[i][2] = String.valueOf(((DetailTimeDto)dto).getAmount());
			}
			if (dto instanceof DetailMoneyDto) {
				aryDetail[i][2] = String.valueOf(((DetailMoneyDto)dto).getAmount());
			}
			if (checkDisplayType && dto.getDisplayType() == PayrollConst.DETAIL_DISP_NONE) {
				if (String.valueOf(aryDetail[i][2]).equals("0")) {
					aryDetail[i][1] = "";
					aryDetail[i][2] = "";
				}
			}
		}
		return aryDetail;
	}
	
	/**
	 * גlݒ肷B
	 * @param list ׏
	 * @param listAmount גlXg
	 */
	protected void setDetailsAmount(List<?> list, List<?> listAmount) {
		for (Object name : list) {
			DetailDto dto = (DetailDto)name;
			for (Object name2 : listAmount) {
				DetailDto dtoAmount = (DetailDto)name2;
				if (dto.getDetailCode().equals(dtoAmount.getDetailCode())) {
					if (dtoAmount instanceof DetailTimeDto) {
						setDetailAmount(dto, ((DetailTimeDto)dtoAmount).getAmount());
						break;
					}
					if (dtoAmount instanceof DetailMoneyDto) {
						setDetailAmount(dto, ((DetailMoneyDto)dtoAmount).getAmount());
						break;
					}
				}
			}
		}
	}
	
	/**
	 * גlvZB
	 * @param listDetail ׃Xg
	 * @param mapParams  p[^Map
	 * @param kCode ЈR[h
	 * @param targetDate ^vZΏ۔N
	 * @throws MospException MosPOꍇ
	 * @throws ClassNotFoundException NXȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	protected void calcDetails(List<?> listDetail, Map<String, String> mapParams, String kCode, Date targetDate)
			throws MospException, SQLException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
		for (Object name : listDetail) {
			DetailDto dto = (DetailDto)name;
			// c[x蓖ŕ22N41ȍ~̏ꍇ
			if (dto.getDetailCode().equals(PayrollConst.DTL_EACH_ALLOWANCE)
					&& MosPCodePart.afterLegalReformDate(targetDate)) {
				setDetailAmount(dto, (float)calcOverTimeLateNightWorkHoliday(mapParams, kCode, targetDate));
			} else {
				setDetailAmount(dto, calcExpr(dto.getExpression(), mapParams));
			}
		}
		
	}
	
	/**
	 * גlݒ肷B
	 * @param detailDto ݒΏۖDTO
	 * @param amount    ݒl
	 */
	protected void setDetailAmount(DetailDto detailDto, float amount) {
		if (detailDto instanceof DetailTimeDto) {
			DetailTimeDto dto = (DetailTimeDto)detailDto;
			dto.setAmount(amount);
			return;
		}
		if (detailDto instanceof DetailMoneyDto) {
			DetailMoneyDto dto = (DetailMoneyDto)detailDto;
			dto.setAmount((int)amount);
			return;
		}
	}
	
	/**
	 * ׂB
	 * @param list     Ώۖ׃Xg
	 * @param kCode    tЈR[h
	 * @param calcDate tvZN
	 */
	protected void initDetails(List<?> list, String kCode, Date calcDate) {
		for (Object name : list) {
			initDetail((DetailDto)name, kCode, calcDate);
		}
	}
	
	/**
	 * ׂB
	 * @param dto ݒΏۖDTO
	 * @param kCode    tЈR[h
	 * @param calcDate tvZN
	 */
	private void initDetail(DetailDto dto, String kCode, Date calcDate) {
		dto.setKCode(kCode);
		dto.setCalcDate(calcDate);
		if (dto instanceof DetailTimeDto) {
			((DetailTimeDto)dto).setAmount(0F);
			return;
		}
		if (dto instanceof DetailMoneyDto) {
			((DetailMoneyDto)dto).setAmount(0);
			return;
		}
	}
	
	/**
	 * vZvZB<br>
	 * @param expression vZ
	 * @param mapParams  p[^
	 * @return vZl
	 * @throws MospException MosPOꍇ
	 */
	protected float calcExpr(String expression, Map<String, String> mapParams) throws MospException {
		return ExpressUtility.calculate(expression, mapParams, new HashMap<String, String[][]>());
	}
	
	/**
	 * c[x蓖̌vZB<br>
	 * @param mapParams  p[^
	 * @param kCode ЈR[h
	 * @param targetMonth Ώ۔N
	 * @return vZl
	 * @throws MospException MosPOꍇ
	 * @throws ClassNotFoundException  NXȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	protected double calcOverTimeLateNightWorkHoliday(Map<String, String> mapParams, String kCode, Date targetMonth)
			throws MospException, SQLException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
		// Jg̎擾
		AgreementBaseInfo agreement = part().laborAgreement().getUserLaborAgreement(kCode, targetMonth);
		// cƑ̌vZ + [̌vZ+ xǒvZ
		return overTime(mapParams, kCode, targetMonth, agreement) + lateNight(mapParams)
				+ workHoliday(mapParams, kCode, targetMonth, agreement);
	}
	
	/**
	 * cƎԂ̌vZ
	 * @param mapParams p[^
	 * @param kCode ЈR[h
	 * @param targetDate ^vZΏ۔N
	 * @param agreement Jg
	 * @return cƎԂ̍vl 0.0
	 * @throws MospException MosPOꍇ
	 * @throws ClassNotFoundException NXȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	protected double overTime(Map<String, String> mapParams, String kCode, Date targetDate, AgreementBaseInfo agreement)
			throws MospException, SQLException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
		if (mapParams.size() != 0) {
			// ԊO
			double weekDayOvreTime = 0;
			// xԊO
			double weekHolidayOvreTime = 0;
			// w莞ԊO
			double limitTerm = 0;
			// 60ԒߕԊǑvZ
			double monthlyWeekOvreTime = 0;
			// 1ŇxԊO
			double limitYearOverTime = 0;
			// ֋x
			KdSubstituteHolidayDao kdSubstituteHolidayDao = new KdSubstituteHolidayDao();
			kdSubstituteHolidayDao.initDao(cfg, cmd, aspUser, user, conn);
			// Ϗ = m̃f[^擾
			KdSubstituteHolidayDto kdSubDaoFixed = new KdSubstituteHolidayDto();
			kdSubDaoFixed = kdSubstituteHolidayDao.findForCondition(kCode, MospUtility.getYear(targetDate), MospUtility
				.getMonth(targetDate), "fixed");
			// Ϗ = ς̃f[^擾
			// ^vZΏ۔N2Õf[^擾
			KdSubstituteHolidayDto kdSubDaoPayment = new KdSubstituteHolidayDto();
			kdSubDaoPayment = kdSubstituteHolidayDao.findForCondition(kCode, MospUtility.getYear(targetDate),
					MospUtility.getMonth(targetDate) - 2, "payment");
			// ԊǑvZ
			weekDayOvreTime = calcOverTime(agreement, checkParam(mapParams.get(PayrollConst.DTL_WEEK_DAY_OVRE_TIME)),
					checkParam(mapParams.get(PayrollConst.DTL_OVER_TIME_ALLOWANCE)));
			// xԊǑvZ
			weekHolidayOvreTime = calcOverTime(agreement, checkParam(mapParams
				.get(PayrollConst.DTL_WEEK_HOLIDAY_OVRE_TIME)), checkParam(mapParams
				.get(PayrollConst.DTL_OVER_TIME_ALLOWANCE)));
			// 60ԒߎԊǑvZ Ϗ󋵁imj
			monthlyWeekOvreTime = calcMon60HoursFixed(agreement, mapParams, kdSubDaoFixed);
			// 60ԒߎԊǑvZ Ϗ󋵁iρj
			monthlyWeekOvreTime += calcMon60HoursPayment(agreement, mapParams, kdSubDaoPayment);
			/* vZ */
			// SĂ̍vԂ
			return weekDayOvreTime + weekHolidayOvreTime + limitTerm + monthlyWeekOvreTime + limitYearOverTime;
		}
		return 0;
		
	}
	
	/**
	 * [鎞Ԃ̌vZ
	 * @param mapParams p[^
	 * @return cƎԂ̍vl
	 * @throws MospException MosPOꍇ
	 */
	protected double lateNight(Map<String, String> mapParams) throws MospException {
		if (mapParams.size() > 0) {
			return checkParam(mapParams.get(PayrollConst.DTL_LATE_NIGHT_ALLOWANCE))
					* (checkParam(mapParams.get(PayrollConst.DTL_SNJIKAN)) / 60);
		}
		return 0;
	}
	
	/**
	 * xoԂ̌vZ
	 * @param mapParams p[^
	 * @param kCode ЈR[h
	 * @param targetDate ^vZΏ۔N
	 * @param agreement Jg
	 * @return xo㎞Ԃ̍vl
	 * @throws MospException MosPOꍇ
	 * @throws ClassNotFoundException NXȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	protected double workHoliday(Map<String, String> mapParams, String kCode, Date targetDate,
			AgreementBaseInfo agreement) throws MospException, SQLException, IllegalAccessException,
			NoSuchFieldException, ClassNotFoundException {
		if (mapParams.size() > 0) {
			return checkParam(mapParams.get(PayrollConst.DTL_WOKR_HOLIDAY_ALLOWANCE1))
					* (agreement.getOfficialHolidayRate() * 0.01)
					* (checkParam(mapParams.get(PayrollConst.DTL_KSJIKAN)) / 60);
		}
		return 0;
	}
	
	/**
	 * tiYYYY/MM/01^j
	 * @param yyyy N
	 * @param mm 
	 * @return YYYY/MM/01
	 * @throws MospException MosPOꍇ
	 */
	protected Date aworkHoliday(String yyyy, String mm) throws MospException {
		return MospUtility.getDate(yyyy + "/" + mm + "/" + "01");
	}
	
	/**
	 * p[^̒g`FbN
	 * @param payrollConst p[^
	 * @return p[^Ɋ֘AlA0.0 
	 */
	protected Double checkParam(String payrollConst) {
		if (payrollConst == null) {
			return 0.0;
		} else {
			return Double.valueOf(payrollConst);
		}
	}
	
	/**
	 * cƎ
	 * @param overtime cƎԁiPʁj
	 * @param price cƒP
	 * @param agreement Jg
	 * @return cƂ̑
	 */
	protected Double calcOverTime(AgreementBaseInfo agreement, Double overtime, Double price) {
		return price * (agreement.getOverTimeRate() * 0.01) * (overtime / 60);
	}
	
	/**
	 * 60ԒߎԊǑvZ Ϗ󋵁imj
	 * @param agreement Jg
	 * @param mapParams p[^
	 * @param kdSubDaoFixed Ϗ󋵁imj
	 * @return 60ԒߎԊȎ
	 */
	protected Double calcMon60HoursFixed(AgreementBaseInfo agreement, Map<String, String> mapParams,
			KdSubstituteHolidayDto kdSubDaoFixed) {
		//  Ϗ󋵁imj݂Ȃ
		if (kdSubDaoFixed != null) {
			// ֋x()
			double alteVacaWeek = kdSubDaoFixed.getPaymentAcquireTime() / substituteHolidayPremOverTime(agreement);
			// ֋x(x)
			double alteVacaGiven = kdSubDaoFixed.getPaymentAcquireHoliday() / substituteHolidayPremWeek(agreement);
			// ֋xɎ()
			double alteVacaTimeWeek = checkParam(mapParams.get(PayrollConst.DTL_MONTHLY_OVRE_TIME)) - alteVacaWeek;
			// ֋xɎ(x)
			double alteVacaTimeGiven = checkParam(mapParams.get(PayrollConst.DTL_MONTHLY_WEEK_HOLIDAY)) - alteVacaGiven;
			// vZ 
			return ((alteVacaTimeWeek + alteVacaTimeGiven) / 60) * (agreement.getSubQuitRate() * 0.01)
					* checkParam(mapParams.get(PayrollConst.DTL_OVER_TIME_ALLOWANCE));
		} else {
			return 0.0;
		}
	}
	
	/**
	 * 60ԒߎԊǑvZ Ϗ󋵁iρj
	 * @param agreement Jg
	 * @param mapParams p[^
	 * @param kdSubDaoPayment Ϗ󋵁iρj
	 * @return 60ԒߎԊȎ
	 */
	protected Double calcMon60HoursPayment(AgreementBaseInfo agreement, Map<String, String> mapParams,
			KdSubstituteHolidayDto kdSubDaoPayment) {
		//  Ϗ󋵁iρj݂Ȃ
		if (kdSubDaoPayment != null) {
			// ֋x()
			double substituteHolidayOverTime = kdSubDaoPayment.getLiquidationOverTime()
					/ substituteHolidayPremOverTime(agreement);
			// ֋x(x)
			double substituteHolidayOverTimeWeek = kdSubDaoPayment.getLiquidationWeekHoliday()
					/ substituteHolidayPremWeek(agreement);
			// vZ 
			return checkParam(mapParams.get(PayrollConst.DTL_OVER_TIME_ALLOWANCE))
					* (agreement.getSubQuitRate() * 0.01)
					* ((substituteHolidayOverTime + substituteHolidayOverTimeWeek) / 60);
		} else {
			return 0.0;
		}
	}
	
	/**
	 * ֋xɊ()
	 * @param agreement Jg
	 * @return ֋xɊ() 
	 */
	protected Double substituteHolidayPremOverTime(AgreementBaseInfo agreement) {
		return (agreement.getSubQuitRate() - agreement.getSubAcquireRate()) * 0.01;
		
	}
	
	/**
	 * ֋xɊ(x)
	 * @param agreement Jg
	 * @return ֋xɊ(x)
	 */
	protected Double substituteHolidayPremWeek(AgreementBaseInfo agreement) {
		return (agreement.getSubQuitRate() - agreement.getSubAcquireHolidayRate()) * 0.01;
		
	}
}
