package jp.mosp.payroll.base;

import java.math.BigDecimal;
import java.util.Date;

import jp.mosp.common.common.MospUtility;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.payroll.dto.CmSocInsuranceDto;

public abstract class AttendanceTotalAction extends PayrollAction {
	
	// tB[h
	protected String			kCode;
	protected int				year;
	protected int				month;
	protected Date				targetMonth;
	protected Date				startDate;
	protected Date				endDate;
	
	protected MKihonDto			mKihonDto;
	protected CmSocInsuranceDto	cmSocInsuranceDto;
	
	protected String[][]		aryPosition;
	
	double						minority25	= 0.25;
	double						minority50	= 0.50;
	double						minority75	= 0.75;
	
	float						minority25f	= 0.25F;
	float						minority50f	= 0.50F;
	float						minority75f	= 0.75F;
	

	/**
	 * Ώ۔NݒB<br>
	 * @param targetMonth ݒΏ
	 * @throws Exception 
	 */
	protected void setTargetMonth(Date targetMonth) throws Exception {
		this.targetMonth = targetMonth;
		year = MospUtility.getYear(targetMonth);
		month = MospUtility.getMonth(targetMonth);
		startDate = getStartDate(targetMonth);
		endDate = getEndDate(targetMonth);
	}
	
	/**
	 * ۂߏsB<br>
	 * Ԃ15PʂŐ؂グB<br>
	 * @param value Ώےl()
	 */
	protected float roundTime(float value) {
		// Ԃ𐮐Ə_ɕ
		int integer = (int)round(value, 0, BigDecimal.ROUND_DOWN);
		float decimal = value - integer;
		// _؂グ
		float roundup = 0F;
		if (decimal == 0) {
			roundup = 0F;
		} else if (decimal <= minority25) {
			roundup = minority25f;
		} else if (decimal <= minority50) {
			roundup = minority50f;
		} else if (decimal <= minority75) {
			roundup = minority75f;
		} else {
			roundup = 1;
		}
		// +_؂グ
		return integer + roundup;
	}
	
	/**
	 * ۂߏ(ľܓ)
	 * @param value Ώےl
	 * @param scale Ώۈʒu(_ȉF0Ő)
	 * @param mode  @
	 */
	protected double round(double value, int scale, int mode) {
		BigDecimal bd;
		if (scale >= 0) {
			bd = new BigDecimal(value);
			return bd.setScale(scale, mode).doubleValue();
		}
		int minusScale = scale * -1;
		double dividing = 1;
		for (int i = 0; i < minusScale; i++) {
			dividing *= 10;
		}
		bd = new BigDecimal(value / dividing);
		return bd.setScale(0, mode).doubleValue() * dividing;
	}
	
}
