/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.mospcommon.system.dao.CmLimitStandardDao;
import jp.mosp.mospcommon.system.dto.CmLimitStandardDto;
import jp.mosp.mospcommon.system.vo.LimitStandardMasterListVo;

/**
 * @author nakamura
 *
 */
public class LimitStandardMasterListAction extends MosPAction {
	
	// R}h
	private static final String	CMD_LIMIT_STANDARD_MASTER_LIST_SHOW			= "S2540";
	private static final String	CMD_LIMIT_STANDARD_MASTER_LIST_SEARCH		= "S2541";
	private static final String	CMD_LIMIT_STANDARD_MASTER_LIST_RE_SEARCH	= "S2542";
	private static final String	CMD_LIMIT_STANDARD_MASTER_LIST_SORT			= "S2543";
	

	/**
	 * RXgN^[
	 */
	public LimitStandardMasterListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_LIMIT_STANDARD_MASTER_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_LIMIT_STANDARD_MASTER_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_LIMIT_STANDARD_MASTER_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_LIMIT_STANDARD_MASTER_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
		
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new LimitStandardMasterListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
	}
	
	@Override
	protected void show() throws Exception {
		LimitStandardMasterListVo vo = (LimitStandardMasterListVo)getVo();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		// lɃZbg	
		vo.setSearchmode(LimitStandardMasterListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		LimitStandardMasterListVo vo = (LimitStandardMasterListVo)getVo();
		vo.setParams(request);
		searchLimitStandardList();
		vo.setFormerKey(vo.KEY_LCODE);
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(LimitStandardMasterListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		LimitStandardMasterListVo vo = (LimitStandardMasterListVo)getVo();
		if (vo.getSearchmode() == LimitStandardMasterListVo.SEARCH_ON) {
			removeSessionDto();
			searchLimitStandardList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * xXg
	 * @throws Exception 	Oꍇ
	 */
	private void searchLimitStandardList() throws Exception {
		LimitStandardMasterListVo vo = (LimitStandardMasterListVo)getVo();
		// DAȌ
		CmLimitStandardDao dao = new CmLimitStandardDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForCondition(vo.getTxtLCode(), vo.getTxtLName(), vo.getPltDeleteFlag()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryLCode().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		LimitStandardMasterListVo vo = (LimitStandardMasterListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		LimitStandardMasterListVo vo = (LimitStandardMasterListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		LimitStandardMasterListVo vo = (LimitStandardMasterListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_LCODE)) {
			comp = new CompLCode();
		} else if (key.equals(vo.KEY_LNAME)) {
			comp = new CompLName();
		} else if (key.equals(vo.KEY_DELETE)) {
			comp = new CompDelete();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * xR[hɂrNX
	 */
	protected static class CompLCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -877635291706121128L;
		

		public int compare(Object obj1, Object obj2) {
			CmLimitStandardDto dto1 = (CmLimitStandardDto)obj1;
			CmLimitStandardDto dto2 = (CmLimitStandardDto)obj2;
			return dto1.getLimitCode().compareTo(dto2.getLimitCode());
		}
	}
	
	/**
	 * x̂ɂrNX
	 */
	protected static class CompLName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -877635291706121128L;
		

		public int compare(Object obj1, Object obj2) {
			CmLimitStandardDto dto1 = (CmLimitStandardDto)obj1;
			CmLimitStandardDto dto2 = (CmLimitStandardDto)obj2;
			return dto1.getLimitName().compareTo(dto2.getLimitName());
		}
	}
	
	/**
	 * 폜tOɂrNX
	 */
	protected static class CompDelete implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -877635291706121128L;
		

		public int compare(Object obj1, Object obj2) {
			CmLimitStandardDto dto1 = (CmLimitStandardDto)obj1;
			CmLimitStandardDto dto2 = (CmLimitStandardDto)obj2;
			return Integer.valueOf(dto1.getDeleteFlag()).compareTo(Integer.valueOf(dto2.getDeleteFlag()));
		}
	}
	
}
