/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.schedule.vo.MosPScheduleVo;

/**
 * @author yoshida
 *
 */
public class ScheduleInputCardVo extends MosPScheduleVo {
	
	private static final long	serialVersionUID			= 7506588503963452011L;
	
	/*						
	 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
	 */
	// p[^
	/**
	 * pltScheduleDay
	 */
	public static final String	PRM_PLT_SCHEDULE_DAY		= "pltScheduleDay";
	/**
	 * pltRotationCode
	 */
	public static final String	PRM_PLT_ROTATION_CODE		= "pltRotationCode";
	/**
	 * pltRotationDays
	 */
	public static final String	PRM_PLT_ROTATION_DAYS		= "pltRotationDays";
	/**
	 * pltWorkTypeCode
	 */
	public static final String	PRM_PLT_WORK_TYPE_CODE		= "pltWorkTypeCode";
	/**
	 * ckbSelectWorkType
	 */
	public static final String	PRM_CKB_SELECT_WORK_TYPE	= "ckbSelectWorkType";
	/**
	 * ckbSelectPeriod
	 */
	public static final String	PRM_CKB_SELECT_PERIOD		= "ckbSelectPeriod";
	
	/*						
	 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
	 */
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_SCHEDULE_START;
	/**
	 * 
	 */
	public String				NAM_ROTATION_TYPE;
	/**
	 * 
	 */
	public String				NAM_ROTATION_DAYS;
	
	// tB[h
	private String				pltScheduleDay;
	private String				pltRotationCode;
	private String				pltRotationDays;
	
	private String				pltWorkTypeCode;
	private String				ckbSelectWorkType;
	private String				ckbSelectPeriod;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltScheduleYear;
	/**
	 * 
	 */
	public String[][]			aryPltScheduleMonth;
	/**
	 * 
	 */
	public String[][]			aryPltScheduleDay;
	/**
	 * 
	 */
	public String[][]			aryPltRotation;
	/**
	 * 
	 */
	public String[][]			aryPltDays;
	
	/**
	 * 
	 */
	public String[][]			aryPltWorkType;
	

	/**
	 * RXgN^
	 */
	public ScheduleInputCardVo() {
		super();
		setViewPath(getClassName());
		initFields();
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_SCHEDULE_INPUT;
		aryMenu = new String[][]{ { CMD_MENU_INPUT, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuSchedule() };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_SCHEDULE_START = CommonConst.NAM_TARGET_MONTH;
		NAM_ROTATION_TYPE = CommonConst.NAM_WORKING_TYPE;
		NAM_ROTATION_DAYS = CommonConst.NAM_NUMBER_OF_DAYS;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		pltScheduleDay = request.getParameter(PRM_PLT_SCHEDULE_DAY);
		pltRotationCode = request.getParameter(PRM_PLT_ROTATION_CODE);
		pltRotationDays = request.getParameter(PRM_PLT_ROTATION_DAYS);
		pltWorkTypeCode = request.getParameter(PRM_PLT_WORK_TYPE_CODE);
		ckbSelectWorkType = getCheckBoxParam(request.getParameter(PRM_CKB_SELECT_WORK_TYPE));
		ckbSelectPeriod = getCheckBoxParam(request.getParameter(PRM_CKB_SELECT_PERIOD));
	}
	
	/**
	 * tB[h
	 */
	public void initFields() {
		pltScheduleDay = "";
		pltRotationCode = "";
		pltRotationDays = "";
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		if (ckbSelectPeriod.equals(CommonConst.NAM_DEFAULT_FLAG_ON)) {
			checkDate(getIntParam(getPltYear()), getIntParam(getPltMonth()), getIntParam(pltScheduleDay),
					NAM_SCHEDULE_START, PRM_PLT_SCHEDULE_DAY);
		}
		// ÓmFI
		endValidation();
	}
	
	// ANZT\bh
	public String[][] getAryPltRotation() {
		return aryPltRotation.clone();
	}
	
	public String getPltRotationCode() {
		return pltRotationCode;
	}
	
	public String getPltRotationDays() {
		return pltRotationDays;
	}
	
	public String getPltScheduleDay() {
		return pltScheduleDay;
	}
	
	public void setPltRotationCode(String pltRotationCode) {
		this.pltRotationCode = pltRotationCode;
	}
	
	public void setPltRotationDays(String pltRotationDays) {
		this.pltRotationDays = pltRotationDays;
	}
	
	public void setPltScheduleDay(String pltScheduleDay) {
		this.pltScheduleDay = pltScheduleDay;
	}
	
	public String getCkbSelectWorkType() {
		return ckbSelectWorkType;
	}
	
	public String getEscCkbSelectWorkType() {
		return getCheckBoxChecked(ckbSelectWorkType);
	}
	
	public void setCkbSelectWorkType(String ckbSelectWorkType) {
		this.ckbSelectWorkType = ckbSelectWorkType;
	}
	
	public String getCkbSelectPeriod() {
		return ckbSelectPeriod;
	}
	
	public String getEscCkbSelectPeriod() {
		return getCheckBoxChecked(ckbSelectPeriod);
	}
	
	public void setCkbSelectPeriod(String ckbSelectPeriod) {
		this.ckbSelectPeriod = ckbSelectPeriod;
	}
	
	public String getPltWorkTypeCode() {
		return pltWorkTypeCode;
	}
	
	public void setPltWorkTypeCode(String pltWorkTypeCode) {
		this.pltWorkTypeCode = pltWorkTypeCode;
	}
	
}
