/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.part.KintaiCompilePart;
import jp.mosp.kintai.common.part.SubstituteHolidayPart;
import jp.mosp.kintai.payroll.dao.KdSubstituteHolidayDao;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;
import jp.mosp.kintai.payroll.dto.KdWorkDto;
import jp.mosp.kintai.payroll.vo.PreparatoryOperationCardVo;

/**
 * @author matsusita
 *
 */
public class PreparatoryOperationCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_OPERATION_CARD_SHOW		= "P1320";
	private static final String	CMD_OPERATION_CARD_REGIST	= "P1321";
	

	/**
	 * RXgN^
	 */
	public PreparatoryOperationCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_OPERATION_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_OPERATION_CARD_REGIST)) {
			// Jn
			regist();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new PreparatoryOperationCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// PAYROLLmF
		confirmPayrollAuth();
		PreparatoryOperationCardVo vo = (PreparatoryOperationCardVo)getVo();
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), 0, 1);
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltDay = StringUtil.getDayArray();
	}
	
	@Override
	protected void show() throws Exception {
		PreparatoryOperationCardVo vo = (PreparatoryOperationCardVo)getVo();
		// lݒ
		Date calcMonth = getCalcMonth();
		// N
		vo.setHidOccurYear(String.valueOf(MospUtility.getYear(calcMonth)));
		// 
		vo.setHidOccurMonth(String.valueOf(MospUtility.getMonth(calcMonth)));
		Date endDate = getEndDate(calcMonth);
		// WvJn
		vo.setLblStartDate(DateUtil.convDateFormatted(getStartDate(calcMonth)));
		// WvI
		vo.setLblEndDate(DateUtil.convDateFormatted(endDate));
		Date nextWeek = DateUtil.addWeek(endDate, 1);
		// ؓ
		vo.setPltCloseYear(String.valueOf(MospUtility.getYear(nextWeek)));
		vo.setPltCloseMonth(String.valueOf(MospUtility.getMonth(nextWeek)));
		vo.setPltCloseDay(String.valueOf(MospUtility.getDay(nextWeek)));
		// Jn
		vo.setHidLimitStartDate(DateUtil.convDateFormatted(DateUtil.addDay(endDate, 1)));
		// L
		int addMonth = 0;
		if (part().subHoliday().isPeriodOneMonth()) {
			addMonth = 1;
		} else if (part().subHoliday().isPeriodTwoMonths()) {
			addMonth = 2;
		}
		// I
		vo.setHidLimitEndDate(DateUtil.convDateFormatted(getEndDate(DateUtil.addMonth(calcMonth, addMonth))));
	}
	
	private void regist() throws Exception {
		PreparatoryOperationCardVo vo = (PreparatoryOperationCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// ΏۋΖWvXg
		List<KdWorkDto> list = part().compile().getKdWorkList(vo.getHidOccurYear(), vo.getHidOccurMonth());
		// D攻f
		boolean isPriorityWeekDay = part().subHoliday().isPriorityWeekDay();
		// L
		int addMonth = 0;
		if (part().subHoliday().isPeriodOneMonth()) {
			addMonth = 1;
		} else if (part().subHoliday().isPeriodTwoMonths()) {
			addMonth = 2;
		}
		Date paymentMonth = DateUtil.addMonth(DateUtil.getYearMonth(vo.getHidOccurYear(), vo.getHidOccurMonth()),
				-addMonth);
		// ϏΏۊJn
		Date limitStart = DateUtil.addDay(getEndDate(paymentMonth), 1);
		// ϏΏۊI
		Date limitEnd = getEndDate(DateUtil.addMonth(paymentMonth, addMonth));
		// e[ubN̏
		prepareTableLock();
		// Ώۃe[u̒ǉ
		addTargetTable(KdSubstituteHolidayDao.TABLE, true);
		// e[ubN
		lockTables();
		// 
		int initNumber = issue(list);
		// Ϗ
		int paymentNumber = liquidation(limitStart, limitEnd, isPriorityWeekDay);
		// R~bg
		commit();
		// e[ubN
		unLockTables();
		// bZ[Wݒ
		StringBuffer sb = new StringBuffer();
		sb.append("");
		sb.append(initNumber);
		sb.append("");
		sb.append("A");
		sb.append("Ϗ");
		sb.append(paymentNumber);
		sb.append("");
		sb.append("XV");
		setMessage(getMessage(CommonConst.MSG_DONE, sb.toString()));
	}
	
	/**
	 * 
	 * @param list ΏۋΑӏWvXg
	 * @return o^
	 * @throws Exception 	Oꍇ
	 */
	private int issue(List<KdWorkDto> list) throws Exception {
		PreparatoryOperationCardVo vo = (PreparatoryOperationCardVo)getVo();
		int occurYear = NumberUtil.getIntParam(vo.getHidOccurYear());
		int occurMonth = NumberUtil.getIntParam(vo.getHidOccurMonth());
		Date closeDate = DateUtil.getDate(vo.getPltCloseYear(), vo.getPltCloseMonth(), vo.getPltCloseDay());
		Date limitStartDate = DateUtil.convStringDateToDate(vo.getHidLimitStartDate());
		Date limitEndDate = DateUtil.convStringDateToDate(vo.getHidLimitEndDate());
		// DAȌ
		KdSubstituteHolidayDao dao = part().subHoliday().getKdSubstituteHolidayDao();
		// ől擾
		String max = dao.findForMax();
		if (StringUtil.isNull(max)) {
			max = "-1";
		}
		long maxId = Long.parseLong(max);
		// o^
		int initNumber = 0;
		for (KdWorkDto workDto : list) {
			if (KintaiCompilePart.getOver60HourOverTime(workDto) > 0) {
				// DTȌ
				KdSubstituteHolidayDto dto = SubstituteHolidayPart.createInitalDto(workDto.getKCode(), occurYear,
						occurMonth, closeDate, limitStartDate, limitEndDate);
				// N̏
				KdSubstituteHolidayDto currentDto = part().subHoliday().getOccurSubstituteInfo(dto.getKCode(),
						dto.getOccurYear(), dto.getOccurMonth());
				boolean insertFlag = false;
				if (VariousUtil.isNull(currentDto)) {
					// ȂꍇB
					insertFlag = true;
				} else if (SubstituteHolidayPart.isAttitudeInit(currentDto)) {
					// Ԃ̏ꍇ
					currentDto.setDeleteFlag(MospConst.DELETE_FLAG_ON);
					// rmF
					chkExclusive(currentDto, dao.findForUpdate(currentDto.getSubstituteId()));
					// f[^̍XV
					dao.update(currentDto);
					// DTO̍Ď擾
					chkUpdate(dao.findForKey(currentDto.getSubstituteId()));
					insertFlag = true;
				}
				if (insertFlag) {
					maxId++;
					dto.setSubstituteId(maxId);
					// d`FbN
					chkDuplicate(dao.findForKey(dto.getSubstituteId()));
					// f[^̑}
					dao.insert(dto);
					// DTO̍Ď擾
					chkInsert(dao.findForKey(dto.getSubstituteId()));
					initNumber++;
				}
			}
		}
		return initNumber;
	}
	
	/**
	 * Ϗ
	 * @param limitStart ΏۊJn
	 * @param limitEnd ΏۏI
	 * @param isPriorityWeekDay D攻f
	 * @return XV
	 * @throws Exception 	Oꍇ
	 */
	private int liquidation(Date limitStart, Date limitEnd, boolean isPriorityWeekDay) throws Exception {
		// XV
		int paymentNumber = 0;
		// DAȌ
		KdSubstituteHolidayDao dao = part().subHoliday().getKdSubstituteHolidayDao();
		List<KdSubstituteHolidayDto> list = dao.findForCondition(limitStart, limitEnd,
				CommonConst.CODE_DECISION_STATUS_FIXED);
		for (KdSubstituteHolidayDto dto : list) {
			int acquireTime = dto.getPaymentAcquireTime();
			int acquireHoliday = dto.getPaymentAcquireHoliday();
			int useHolidayTime = dto.getUseHolidayTime();
			int liquidationOver = 0;
			int liquidationWeek = 0;
			if (isPriorityWeekDay) {
				// D̏ꍇ
				liquidationOver = acquireTime - useHolidayTime;
				liquidationWeek = acquireHoliday;
				if (acquireTime - useHolidayTime < 0) {
					liquidationOver = 0;
					liquidationWeek = acquireHoliday + acquireTime - useHolidayTime;
				}
			} else {
				// xD̏ꍇ
				liquidationOver = acquireTime;
				liquidationWeek = acquireHoliday - useHolidayTime;
				if (acquireHoliday - useHolidayTime < 0) {
					liquidationOver = acquireTime + acquireHoliday - useHolidayTime;
					liquidationWeek = 0;
				}
			}
			dto.setLiquidationOverTime(liquidationOver);
			dto.setLiquidationWeekHoliday(liquidationWeek);
			dto.setAcquisitionStatus(CommonConst.CODE_ACQUISITION_STATUS_FINISH);
			dto.setDecisionStatus(CommonConst.CODE_DECISION_STATUS_PAYMENT);
			// rmF
			chkExclusive(dto, dao.findForUpdate(dto.getSubstituteId()));
			// f[^̍XV
			dao.update(dto);
			// DTO̍Ď擾
			chkUpdate(dao.findForKey(dto.getSubstituteId()));
			paymentNumber++;
		}
		return paymentNumber;
	}
	
}
