/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.sql.Connection;
import java.util.Properties;

import jp.mosp.common.common.BaseDto;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * Part𗘗pۂɕKvȏDTO
 * @author yoshida
 *	@version	0.0.1
 */
public class PartInfo extends BaseDto {
	
	private static final long		serialVersionUID	= -6077546544100981837L;
	
	private Properties				cfg;
	private String					cmd;
	private CmAspUserDto			aspUser;
	private CmUserDto				user;
	
	private transient Connection	conn;
	

	/**
	 * RXgN^
	 */
	private PartInfo() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param cfg	MosPAvP[Vݒ(/WEB-INF/mosp.properties)B
	 * @param cmd	NGXgꂽCommandB
	 * @param aspUser	OCASP[U[B
	 * @param user	OC[U[B
	 * @param conn 	DBRlNVB
	 */
	public PartInfo(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		this();
		init(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * 
	 * @param cfg	MosPAvP[Vݒ(/WEB-INF/mosp.properties)B
	 * @param cmd	NGXgꂽCommandB
	 * @param aspUser	OCASP[U[B
	 * @param user	OC[U[B
	 * @param conn 	DBRlNVB
	 */
	private void init(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		this.cfg = cfg;
		this.cmd = cmd;
		this.aspUser = aspUser;
		this.user = user;
		this.conn = conn;
	}
	
	// ANZT\bh
	/**
	 * @return	MosPAvP[Vݒ(/WEB-INF/mosp.properties)B
	 */
	public Properties getCfg() {
		return cfg;
	}
	
	/**
	 * @return	NGXgꂽCommandB
	 */
	public String getCmd() {
		return cmd;
	}
	
	/**
	 * @return	OCASP[U[B
	 */
	public CmAspUserDto getAspUser() {
		return aspUser;
	}
	
	/**
	 * @return	OC[U[B
	 */
	public CmUserDto getUser() {
		return user;
	}
	
	/**
	 * @return 	DBRlNVB
	 */
	public Connection getConn() {
		return conn;
	}
	
}
