package jp.mosp.payroll.report.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.bean.OdsBean;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.InsuranceConfSetVo;
import jp.mosp.payroll.dao.CdSocInsuranceDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.CdSocInsuranceDto;
import jp.mosp.payroll.dto.CmCompanyDto;

/**
 * @author 
 *
 */
public class InsuranceRepAction extends AdjustmentAction {
	
	// R}h
	private static final String	CMD_INSURANCEREP_LIST_ALL	= "P4010";
	private static final String	CMD_INSURANCEREP_LIST_ONE	= "P4011";
	private static final String	CMD_INSURANCEREP_LIST_ALL2	= "P4012";
	
	private int					nowYear						= 0;		// NxvZp
	private String				strTekiyouDate				= "";		// KptiNEj
	private Date				nowDateTmp;							//{t(Date^)
	private String				nowDateJp;								//{t(a)
																		
	private CmCompanyDao		cmCompanyDao;
	private CmCompanyDto		cmCompanyDto;
	
	/**
	 * 
	 */
	public String[][]			aryGender;
	// ݒe[u
	/**
	 * 
	 */
	public List<MosPConfDto>	listConf;
	/**
	 * 
	 */
	public String[][]			aryEra;
	/**
	 * 
	 */
	public String[][]			aryStation;
	

	/**
	 * RXgN^
	 */
	public InsuranceRepAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		InsuranceConfSetVo confVo;
		Date dateTekiyouDate = null; // KptiNEEj
		int intCalcDate = 0;
		int intCalcDates = 0;
		
		// DBRlNV擾
		getConnection();
		// DAO
		prepareDao();
		// z擾
		aryStation = getStationArrayAll();
		aryPosition = getPositionArrayAll();
		aryEra = getCodeArray(PayrollConst.TID_JAPANESE);
		
		//ݒvo̎擾
		confVo = (InsuranceConfSetVo)getStoredVo(PayrollConst.VO_INSURANCECONF_SET); // ZEϏݒVO̎擾
		
		// aݒ擾
		listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		
		nowDateTmp = getSystemDate(); //{t擾
		nowYear = MospUtility.getYear(nowDateTmp); //N擾
		
		//a{t擾
		nowDateJp = getJapaneseDate(nowDateTmp);
		
		//KpiNj擾ݒ
		if (confVo.idButtonSyori.equals(InsuranceConfSetVo.PRM_CKR_SANTEI_KISO)) { //Zbw̏ꍇ
			intCalcDate = (nowYear * 10000) + (PayrollConst.MONTH_TEKIYOU_DEFAULT * 100)
					+ PayrollConst.TIME_DEFAULT_DAY;
			intCalcDates = (nowYear * 100) + PayrollConst.MONTH_TEKIYOU_DEFAULT;
		} else {
			if ((confVo.prmSyoukyuTuki == null) || (confVo.prmSyoukyuTuki.equals("0"))) {
				intCalcDate = (nowYear * 10000) + (PayrollConst.MONTH_TEKIYOU_DEFAULT * 100)
						+ PayrollConst.TIME_DEFAULT_DAY;
				intCalcDates = (nowYear * 100) + PayrollConst.MONTH_TEKIYOU_DEFAULT;
			} else {
				intCalcDate = (nowYear * 10000) + ((Integer.valueOf(confVo.prmSyoukyuTuki) + 3) * 100)
						+ PayrollConst.TIME_DEFAULT_DAY;
				intCalcDates = (nowYear * 100) + (Integer.valueOf(confVo.prmSyoukyuTuki) + 3);
			}
		}
		dateTekiyouDate = DateUtil.convIntegerDateToDate(intCalcDate);
		strTekiyouDate = String.valueOf(intCalcDates);
		
		// Џ擾
		cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		cmCompanyDto = cmCompanyDao.findAll();
		
		if (cmd.equals(CMD_INSURANCEREP_LIST_ALL)) {
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate = getLastDateOfYear(adjustYear);
			CdSocInsuranceDao cdSocInsuranceDao = new CdSocInsuranceDao();
			cdSocInsuranceDao.initDao(cfg, cmd, aspUser, user, conn);
			
			// ^׃f[^쐬
			List<CdSocInsuranceDto> list = cdSocInsuranceDao.findForCondition(dateTekiyouDate);
			// [쐬
			if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
				report(confVo, list);
			} else {
				reportXls(confVo, list);
			}
			
		} else if (cmd.equals(CMD_INSURANCEREP_LIST_ONE)) {
			// VO̎擾
		} else if (cmd.equals(CMD_INSURANCEREP_LIST_ALL2)) {
			// VO̎擾
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * [o͏sB(Excel)<br><br>
	 * @param vo 
	 * @param list 
	 * @throws Exception 
	 */
	private void reportXls(InsuranceConfSetVo vo, List<CdSocInsuranceDto> list) throws Exception {
		
		CdSocInsuranceDto cdSocInsuranceDto;
		
		String tmpTitleSei = "";
		String tmpTitleFuk = "";
		String tmpRepCode = "";
		String tmpWork = "";
		int line;
		int column;
		int sumSheet;
		int sumCnt;
		int tmpDate;
		
		int lkName = 14; // sFЈ
		int ckName = 7; // FЈ
		int lHhealthNo = 14; // sFNیԍ
		int cHhealthNo = 2; // FNیԍ
		int lBerthdayJpCd = 14; // sFR[h
		int cBerthdayJpCd = 15; // FR[h
		int lBerthdayY = 14; // sFaN
		int cBerthdayY = 17; // FaN
		int lBerthdayM = 14; // sFa
		int cBerthdaym = 19; // Fa
		int lBerthdayD = 14; // sFa
		int cBerthdayD = 21; // Fa
		int lGender = 14; // sFʃR[h
		int cGender = 23; // FʃR[h
		int lHealthBefPremium = 14; // sFۏ]Oی
		int cHealthBefPremium = 25; // Fۏ]Oی
		int lPensionBefPremium = 14; // sFN]Oی
		int cPensionBefPremium = 32; // FN]Oی
		
		int lPayBasicMonth1 = 20; // sFxb1()
		int cPayBasicMonth1 = 1; // Fxb1()
		int lPayBasicMonth2 = 18; // sFxb2()
		int cPayBasicMonth2 = 1; // Fxb2()
		int lPayBasicMonth3 = 16; // sFxb3()
		int cPayBasicMonth3 = 1; // Fxb3()
		
		int lPayBasicDay1 = 20; // sFxb1()
		int cPayBasicDay1 = 3; // Fxb1()
		int lPayBasicDay2 = 18; // sFxb2()
		int cPayBasicDay2 = 3; // Fxb2()
		int lPayBasicDay3 = 16; // sFxb3()
		int cPayBasicDay3 = 3; // Fxb3()
		
		int lPayAmount1 = 20; // sFK̊z1
		int cPayAmount1 = 6; // FK̊z1
		int lPayAmount2 = 18; // sFK̊z2
		int cPayAmount2 = 6; // FK̊z2
		int lPayAmount3 = 16; // sFK̊z3
		int cPayAmount3 = 6; // FK̊z3
		
		int lGoodsAmount1 = 20; // sF̊z1
		int cGoodsAmount1 = 12; // F̊z1
		int lGoodsAmount2 = 18; // sF̊z2
		int cGoodsAmount2 = 12; // F̊z2
		int lGoodsAmount3 = 16; // sF̊z3
		int cGoodsAmount3 = 12; // F̊z3
		
		int lRewardTotal1 = 20; // sFVv1
		int cRewardTotal1 = 19; // FVv1
		int lRewardTotal2 = 18; // sFVv2
		int cRewardTotal2 = 19; // FVv2
		int lRewardTotal3 = 16; // sFVv3
		int cRewardTotal3 = 19; // FVv3
		
		int lRewardTotalSum = 16; // sFVz
		int cRewardTotalSum = 25; // FVz
		int lAverageThreeMonths = 18; // sFR
		int cAverageThreeMonths = 25; // FR
		int lHealthDecPremium = 20; // sFیی
		int cHealthDecPremium = 25; // Fیی
		int lExpectedDateY = 16; // sFKpN:N
		int cExpectedDateY = 32; // FKpN:N
		int lExpectedDateM = 16; // sFKpN:
		int cExpectedDateM = 34; // FKpN:
		int lEditAverage = 18; // sFC
		int cEditAverage = 32; // FC
		int lPensionDecPremium = 20; // sFNی
		int cPensionDecPremium = 32; // FNی
		int lRetroactivePayment = 16; // sFkyxz
		int cRetroactivePayment = 39; // Fkyxz
		int lRaiseDownSalaryBasis = 17; // sF~̌z
		int cRaiseDownSalaryBasis = 39; // F~̌z
		int lRaiseDownSalaryDate = 18; // sF~N
		int cRaiseDownSalaryDate = 39; // F~N
		
		// RlNV擾
		getConnection();
		
		if (null == cmCompanyDto) { // Џ񖢎擾
			throw new MospException(MospConst.EX_CM_USER_ILLEGAL);
		}
		
		// wb_[^Cg͏oR[h̎擾
		if (vo.idButtonSyori.equals(InsuranceConfSetVo.PRM_CKR_SANTEI_KISO)) { //uZbvw̏ꍇ
			tmpTitleSei = PayrollConst.TTL_REP_SANTEI_SEI;
			tmpTitleFuk = PayrollConst.TTL_REP_SANTEI_FUKU;
			tmpRepCode = PayrollConst.TTL_REP_CODE_SANTEI;
		} else {
			tmpTitleSei = PayrollConst.TTL_REP_GEPPEN_SEI;
			tmpTitleFuk = PayrollConst.TTL_REP_GEPPEN_FUKU;
			tmpRepCode = PayrollConst.TTL_REP_CODE_GEPPEN;
		}
		
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_GEPPEN_XLS);
		
		// wb_[
		line = 2;
		column = 12;
		poi.prtItem(line, column, tmpTitleSei); // ރ^Cgij
		poi.prtItem(line + 54, column + 2, tmpTitleFuk); // ރ^Cgij
		
		line = 4;
		column = 0;
		poi.prtItem(line, column, tmpRepCode); // ͏oR[h
		
		line = 5;
		column = 6;
		poi.prtItem(line, column, cmCompanyDto.getDisposeNo()); // Əԍij
		poi.prtItem(line + 56, column, cmCompanyDto.getDisposeNo()); // Əԍij
		
		line = 48;
		column = 6;
		poi.prtItem(line, column, PayrollConst.NAM_COMMON_POSTAL + cmCompanyDto.getCompanyPostal()); // ƏX֔ԍij
		poi.prtItem(line + 56, column, PayrollConst.NAM_COMMON_POSTAL + cmCompanyDto.getCompanyPostal()); // ƏX֔ԍij
		
		line = 49;
		column = 6;
		poi.prtItem(line, column, cmCompanyDto.getCompanyAddress()); //Əݒnij
		poi.prtItem(line + 56, column, cmCompanyDto.getCompanyAddress()); //Əݒnij
		
		line = 50;
		column = 6;
		poi.prtItem(line, column, cmCompanyDto.getCompanyName()); //Ə́ij
		poi.prtItem(line + 56, column, cmCompanyDto.getCompanyName()); //Ə́ij
		
		line = 51;
		column = 6;
		poi.prtItem(line, column, cmCompanyDto.getEnterpreneur()); //Ǝ厁ij
		poi.prtItem(line + 56, column, cmCompanyDto.getEnterpreneur()); //Ǝ厁ij
		
		line = 52;
		column = 6;
		poi.prtItem(line, column, cmCompanyDto.getCompanyPhone()); //dbij
		poi.prtItem(line + 56, column, cmCompanyDto.getCompanyPhone()); //dbij
		
		line = 46;
		column = 8;
		poi.prtItem(line, column, nowDateJp); //a{tij	
		poi.prtItem(line + 59, column + 21, nowDateJp); //a{tij
		
		sumCnt = 99;
		sumSheet = 0;
		
		for (int i = 0; i < list.size(); i++) {
			if (sumCnt >= 4) {
				sumSheet++;
//				poi.clnSheet(0, Sum_sheet, String.valueOf(Sum_sheet));  //V[g̕
//				poi.crtSheet(Sum_sheet, String.valueOf(Sum_sheet));     //\[g쐬
				sumCnt = 0;
			}
			
			cdSocInsuranceDto = list.get(i);
			kCode = cdSocInsuranceDto.getKCode();
			mKojinDto = mKojinDao.findForKey(kCode); //l}X^lCX^X擾
			cmSocInsuranceDto = cmSocInsuranceDao.findForEmployee(kCode); //l}X^ЉیCX^X擾		
			if ((null != mKojinDto) && (null != cmSocInsuranceDto)) {
				
				/**** @eЈ̍ڐݒ  ****/
				
				// Nیԍ()
				poi.prtItem(lHhealthNo + (sumCnt * 8), cHhealthNo, cmSocInsuranceDto.getHealthNo() + "\n" + "("
						+ cmSocInsuranceDto.getPensionNo() + ")");
				// Nیԍ()
				poi.prtItem(lHhealthNo + (sumCnt * 8) + 56, cHhealthNo, cmSocInsuranceDto.getHealthNo() + "\n" + "("
						+ cmSocInsuranceDto.getPensionNo() + ")");
				
				poi.prtItem(lkName + (sumCnt * 8), ckName, cdSocInsuranceDto.getKName()); // Ј()
				poi.prtItem(lkName + (sumCnt * 8) + 56, ckName, cdSocInsuranceDto.getKName()); // Ј()
				
				poi.prtItem(lBerthdayJpCd + (sumCnt * 8), cBerthdayJpCd, String.valueOf(getGengouCD(mKojinDto
					.getSeinenbi()))); // R[h()
				poi.prtItem(lBerthdayJpCd + (sumCnt * 8) + 56, cBerthdayJpCd, String.valueOf(getGengouCD(mKojinDto
					.getSeinenbi()))); // R[h()
				
				tmpDate = mKojinDto.getSeinenbi();
				String tmpM = String.valueOf(MospUtility.getMonth(DateUtil.convIntegerDateToDate(tmpDate)));
				String tmpD = String.valueOf(MospUtility.getDay(DateUtil.convIntegerDateToDate(tmpDate)));
				poi.prtItem(lBerthdayY + (sumCnt * 8), cBerthdayY, getWaNen(tmpDate)); // aN()
				poi.prtItem(lBerthdayY + (sumCnt * 8) + 56, cBerthdayY, getWaNen(tmpDate)); // aN()
				poi.prtItem(lBerthdayM + (sumCnt * 8), cBerthdaym, tmpM); // a()
				poi.prtItem(lBerthdayM + (sumCnt * 8) + 56, cBerthdaym, tmpM); // a()
				poi.prtItem(lBerthdayD + (sumCnt * 8), cBerthdayD, tmpD); // a()
				poi.prtItem(lBerthdayD + (sumCnt * 8) + 56, cBerthdayD, tmpD); // a()
				poi.prtItem(lGender + (sumCnt * 8), cGender, mKojinDto.getSeibetu()); // ʃR[h()
				poi.prtItem(lGender + (sumCnt * 8) + 56, cGender, mKojinDto.getSeibetu()); // ʃR[h()
				poi.prtItem(lHealthBefPremium + (sumCnt * 8), cHealthBefPremium, omission1000(cdSocInsuranceDto
					.getHealthBefPremium())); // ۏ]Oی()
				poi.prtItem(lHealthBefPremium + (sumCnt * 8) + 56, cHealthBefPremium, omission1000(cdSocInsuranceDto
					.getHealthBefPremium())); // ۏ]Oی()
				poi.prtItem(lPensionBefPremium + (sumCnt * 8), cPensionBefPremium, omission1000(cdSocInsuranceDto
					.getPensionBefPremium())); // N]Oی()
				poi.prtItem(lPensionBefPremium + (sumCnt * 8) + 56, cPensionBefPremium, omission1000(cdSocInsuranceDto
					.getPensionBefPremium())); // N]Oی()
				poi.prtItem(lPayBasicMonth1 + (sumCnt * 8), cPayBasicMonth1, cdSocInsuranceDto.getPayBasicMonth1()); // xb1:()
				poi
					.prtItem(lPayBasicMonth1 + (sumCnt * 8) + 56, cPayBasicMonth1, cdSocInsuranceDto
						.getPayBasicMonth1()); // xb1:()
				poi.prtItem(lPayBasicMonth2 + (sumCnt * 8), cPayBasicMonth2, cdSocInsuranceDto.getPayBasicMonth2()); // xb2:()
				poi
					.prtItem(lPayBasicMonth2 + (sumCnt * 8) + 56, cPayBasicMonth2, cdSocInsuranceDto
						.getPayBasicMonth2()); // xb2:()
				poi.prtItem(lPayBasicMonth3 + (sumCnt * 8), cPayBasicMonth3, cdSocInsuranceDto.getPayBasicMonth3()); // xb3:()
				poi
					.prtItem(lPayBasicMonth3 + (sumCnt * 8) + 56, cPayBasicMonth3, cdSocInsuranceDto
						.getPayBasicMonth3()); // xb3:()
				poi.prtItem(lPayBasicDay1 + (sumCnt * 8), cPayBasicDay1, cdSocInsuranceDto.getPayBasicDay1()); // xb1:()
				poi.prtItem(lPayBasicDay1 + (sumCnt * 8) + 56, cPayBasicDay1, cdSocInsuranceDto.getPayBasicDay1()); // xb1:()
				poi.prtItem(lPayBasicDay2 + (sumCnt * 8), cPayBasicDay2, cdSocInsuranceDto.getPayBasicDay2()); // xb2:()
				poi.prtItem(lPayBasicDay2 + (sumCnt * 8) + 56, cPayBasicDay2, cdSocInsuranceDto.getPayBasicDay2()); // xb2:()
				poi.prtItem(lPayBasicDay3 + (sumCnt * 8), cPayBasicDay3, cdSocInsuranceDto.getPayBasicDay3()); // xb3:()
				poi.prtItem(lPayBasicDay3 + (sumCnt * 8) + 56, cPayBasicDay3, cdSocInsuranceDto.getPayBasicDay3()); // xb3:()
				poi.prtItem(lPayAmount1 + (sumCnt * 8), cPayAmount1, cdSocInsuranceDto.getPayAmount1()); // K̊z1()
				poi.prtItem(lPayAmount1 + (sumCnt * 8) + 56, cPayAmount1, cdSocInsuranceDto.getPayAmount1()); // K̊z1()
				poi.prtItem(lPayAmount2 + (sumCnt * 8), cPayAmount2, cdSocInsuranceDto.getPayAmount2()); // K̊z2()
				poi.prtItem(lPayAmount2 + (sumCnt * 8) + 56, cPayAmount2, cdSocInsuranceDto.getPayAmount2()); // K̊z2()
				poi.prtItem(lPayAmount3 + (sumCnt * 8), cPayAmount3, cdSocInsuranceDto.getPayAmount3()); // K̊z3()
				poi.prtItem(lPayAmount3 + (sumCnt * 8) + 56, cPayAmount3, cdSocInsuranceDto.getPayAmount3()); // K̊z3()
				poi.prtItem(lGoodsAmount1 + (sumCnt * 8), cGoodsAmount1, cdSocInsuranceDto.getGoodsAmount1()); // ̊z1()
				poi.prtItem(lGoodsAmount1 + (sumCnt * 8) + 56, cGoodsAmount1, cdSocInsuranceDto.getGoodsAmount1()); // ̊z1()
				poi.prtItem(lGoodsAmount2 + (sumCnt * 8), cGoodsAmount2, cdSocInsuranceDto.getGoodsAmount2()); // ̊z2()
				poi.prtItem(lGoodsAmount2 + (sumCnt * 8) + 56, cGoodsAmount2, cdSocInsuranceDto.getGoodsAmount2()); // ̊z2()
				poi.prtItem(lGoodsAmount3 + (sumCnt * 8), cGoodsAmount3, cdSocInsuranceDto.getGoodsAmount3()); // ̊z3()
				poi.prtItem(lGoodsAmount3 + (sumCnt * 8) + 56, cGoodsAmount3, cdSocInsuranceDto.getGoodsAmount3()); // ̊z3()
				poi.prtItem(lRewardTotal1 + (sumCnt * 8), cRewardTotal1, cdSocInsuranceDto.getRewardTotal1()); // Vv1()
				poi.prtItem(lRewardTotal1 + (sumCnt * 8) + 56, cRewardTotal1, cdSocInsuranceDto.getRewardTotal1()); // Vv1()
				poi.prtItem(lRewardTotal2 + (sumCnt * 8), cRewardTotal2, cdSocInsuranceDto.getRewardTotal2()); // Vv2()
				poi.prtItem(lRewardTotal2 + (sumCnt * 8) + 56, cRewardTotal2, cdSocInsuranceDto.getRewardTotal2()); // Vv2()
				poi.prtItem(lRewardTotal3 + (sumCnt * 8), cRewardTotal3, cdSocInsuranceDto.getRewardTotal3()); // Vv3()
				poi.prtItem(lRewardTotal3 + (sumCnt * 8) + 56, cRewardTotal3, cdSocInsuranceDto.getRewardTotal3()); // Vv3()
				poi.prtItem(lRewardTotalSum + (sumCnt * 8), cRewardTotalSum, cdSocInsuranceDto.getRewardTotalSum()); // Vz()
				poi
					.prtItem(lRewardTotalSum + (sumCnt * 8) + 56, cRewardTotalSum, cdSocInsuranceDto
						.getRewardTotalSum()); // Vz()
				poi.prtItem(lAverageThreeMonths + (sumCnt * 8), cAverageThreeMonths, cdSocInsuranceDto
					.getAverageThreeMonths()); // R()
				poi.prtItem(lAverageThreeMonths + (sumCnt * 8) + 56, cAverageThreeMonths, cdSocInsuranceDto
					.getAverageThreeMonths()); // R()
				poi.prtItem(lHealthDecPremium + (sumCnt * 8), cHealthDecPremium, omission1000(cdSocInsuranceDto
					.getHealthDecPremium())); // یی()
				poi.prtItem(lHealthDecPremium + (sumCnt * 8) + 56, cHealthDecPremium, omission1000(cdSocInsuranceDto
					.getHealthDecPremium())); // یی()
				
				tmpDate = DateUtil.convDateToInteger(cdSocInsuranceDto.getExpectedDate());
				poi.prtItem(lExpectedDateY + (sumCnt * 8), cExpectedDateY, getWaNen(tmpDate)); // KpN:N()
				poi.prtItem(lExpectedDateY + (sumCnt * 8) + 56, cExpectedDateY, getWaNen(tmpDate)); // KpN:N()
				poi.prtItem(lExpectedDateM + (sumCnt * 8), cExpectedDateM, MospUtility.getMonth(cdSocInsuranceDto
					.getExpectedDate())); // KpN:()
				poi.prtItem(lExpectedDateM + (sumCnt * 8) + 56, cExpectedDateM, MospUtility.getMonth(cdSocInsuranceDto
					.getExpectedDate())); // KpN:()
				poi.prtItem(lEditAverage + (sumCnt * 8), cEditAverage, cdSocInsuranceDto.getEditAverage()); // C()
				poi.prtItem(lEditAverage + (sumCnt * 8) + 56, cEditAverage, cdSocInsuranceDto.getEditAverage()); // C()
				poi.prtItem(lPensionDecPremium + (sumCnt * 8), cPensionDecPremium, omission1000(cdSocInsuranceDto
					.getPensionDecPremium())); // Nی()
				poi.prtItem(lPensionDecPremium + (sumCnt * 8) + 56, cPensionDecPremium, omission1000(cdSocInsuranceDto
					.getPensionDecPremium())); // Nی()
				poi.prtItem(lRetroactivePayment + (sumCnt * 8), cRetroactivePayment, cdSocInsuranceDto
					.getRetroactivePayment()); // kyxz()
				poi.prtItem(lRetroactivePayment + (sumCnt * 8) + 56, cRetroactivePayment, cdSocInsuranceDto
					.getRetroactivePayment()); // kyxz()
				poi.prtItem(lRaiseDownSalaryBasis + (sumCnt * 8), cRaiseDownSalaryBasis, cdSocInsuranceDto
					.getRaiseDownSalaryBasis()); // ~̌z()
				poi.prtItem(lRaiseDownSalaryBasis + (sumCnt * 8) + 56, cRaiseDownSalaryBasis, cdSocInsuranceDto
					.getRaiseDownSalaryBasis()); // ~̌z()
				
				tmpDate = DateUtil.convDateToInteger(cdSocInsuranceDto.getRaiseDownSalaryDate());
				tmpWork = getWaNen(tmpDate) + "N" + MospUtility.getMonth(cdSocInsuranceDto.getRaiseDownSalaryDate())
						+ "";
				poi.prtItem(lRaiseDownSalaryDate + (sumCnt * 8), cRaiseDownSalaryDate, tmpWork); // ~N()
				poi.prtItem(lRaiseDownSalaryDate + (sumCnt * 8) + 56, cRaiseDownSalaryDate, tmpWork); // ~N()
				
				/**** @eЈ̍ڐݒ  ****/
				
				sumCnt++;
			}
		}
		
		//ev[gV[gO̍폜
//		if(Sum_sheet > 0){
//			poi.rmvSheet(0);
//		}
		// o͓eݒ
		String fileName = strTekiyouDate + PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_INSURANCE_XLS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}
	
	/**
	 * [o͏sB(OpenOffice Calc)<br><br>
	 * @param vo 
	 * @param list 
	 * @throws Exception 
	 */
	private void report(InsuranceConfSetVo vo, List<CdSocInsuranceDto> list) throws Exception {
		CdSocInsuranceDto cdSocInsuranceDto;
		
		String tmpTitleSei = "";
		String tmpTitleFuk = "";
		String tmpRepCode = "";
		String tmpWork = "";
		
		int line;
		int column;
		int sumSheet;
		int sumCnt;
		int tmpDate;
		
		int lkName = 14; // sFЈ
		int ckName = 7; // FЈ
		int lHhealthNo = 14; // sFNیԍ
		int cHhealthNo = 2; // FNیԍ
		int lBerthdayJpCd = 14; // sFR[h
		int cBerthdayJpCd = 15; // FR[h
		int lBerthdayY = 14; // sFaN
		int cBerthdayY = 17; // FaN
		int lBerthdayM = 14; // sFa
		int cBerthdaym = 19; // Fa
		int lBerthdayD = 14; // sFa
		int cBerthdayD = 21; // Fa
		int lGender = 14; // sFʃR[h
		int cGender = 23; // FʃR[h
		int lHealthBefPremium = 14; // sFۏ]Oی
		int cHealthBefPremium = 25; // Fۏ]Oی
		int lPensionBefPremium = 14; // sFN]Oی
		int cPensionBefPremium = 32; // FN]Oی
		
		int lPayBasicMonth1 = 20; // sFxb1()
		int cPayBasicMonth1 = 1; // Fxb1()
		int lPayBasicMonth2 = 18; // sFxb2()
		int cPayBasicMonth2 = 1; // Fxb2()
		int lPayBasicMonth3 = 16; // sFxb3()
		int cPayBasicMonth3 = 1; // Fxb3()
		
		int lPayBasicDay1 = 20; // sFxb1()
		int cPayBasicDay1 = 3; // Fxb1()
		int lPayBasicDay2 = 18; // sFxb2()
		int cPayBsicday2 = 3; // Fxb2()
		int lPayBasicDay3 = 16; // sFxb3()
		int cPayBasicDay3 = 3; // Fxb3()
		
		int lPayAmount1 = 20; // sFK̊z1
		int cPayAmount1 = 6; // FK̊z1
		int lPayAmount2 = 18; // sFK̊z2
		int cPayAmount2 = 6; // FK̊z2
		int lPayAmount3 = 16; // sFK̊z3
		int cPayAmount3 = 6; // FK̊z3
		
		int lGoodsAmount1 = 20; // sF̊z1
		int cGoodsAmount1 = 12; // F̊z1
		int lGoodsAmount2 = 18; // sF̊z2
		int cGoodsAmount2 = 12; // F̊z2
		int lGoodsAmount3 = 16; // sF̊z3
		int cGoodsAmount3 = 12; // F̊z3
		
		int lRewardTotal1 = 20; // sFVv1
		int cRewardTotal1 = 19; // FVv1
		int lRewardTotal2 = 18; // sFVv2
		int cRewardTotal2 = 19; // FVv2
		int lRewardTotal3 = 16; // sFVv3
		int cRewardTotal3 = 19; // FVv3
		
		int lRewardTotalSum = 16; // sFVz
		int cRewardTotalSum = 25; // FVz
		int lAverageThreeMonths = 18; // sFR
		int cAverageThreeMonths = 25; // FR
		int lHealthDecPremium = 20; // sFیی
		int cHealthDecPremium = 25; // Fیی
		int lExpectedDateY = 16; // sFKpN:N
		int cExpectedDateY = 32; // FKpN:N
		int lExpectedDateM = 16; // sFKpN:
		int cExpectedDateM = 34; // FKpN:
		int lEditAverage = 18; // sFC
		int cEditAverage = 32; // FC
		int lPensionDecPremium = 20; // sFNی
		int cPensionDecPremium = 32; // FNی
		int lRetroactivePayment = 16; // sFkyxz
		int cRetroactivePayment = 39; // Fkyxz
		int lRaiseDownSalaryBasis = 17; // sF~̌z
		int cRaiseDownsalaryBasis = 39; // F~̌z
		int lRaisedownSalaryDate = 18; // sF~N
		int cRaiseDownSalaryDate = 39; // F~N
		
		// RlNV擾
		getConnection();
		
		// [쐬
		OdsBean odsBean = new OdsBean(cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_GEPPEN_ODS);
		
		if (null == cmCompanyDto) { // Џ񖢎擾
			throw new MospException(MospConst.EX_CM_USER_ILLEGAL);
		}
		
		// wb_[^Cg͏oR[h̎擾
		if (vo.idButtonSyori.equals(InsuranceConfSetVo.PRM_CKR_SANTEI_KISO)) { //uZbvw̏ꍇ
			tmpTitleSei = PayrollConst.TTL_REP_SANTEI_SEI;
			tmpTitleFuk = PayrollConst.TTL_REP_SANTEI_FUKU;
			tmpRepCode = PayrollConst.TTL_REP_CODE_SANTEI;
		} else {
			tmpTitleSei = PayrollConst.TTL_REP_GEPPEN_SEI;
			tmpTitleFuk = PayrollConst.TTL_REP_GEPPEN_FUKU;
			tmpRepCode = PayrollConst.TTL_REP_CODE_GEPPEN;
		}
		
		// wb_[
		line = 2;
		column = 12;
		odsBean.setValue(column, line, tmpTitleSei); // ރ^Cgij
		odsBean.setValue(column + 2, line + 54, tmpTitleFuk); // ރ^Cgij
		
		line = 4;
		column = 0;
		odsBean.setValue(column, line, tmpRepCode); // ͏oR[h
		
		line = 5;
		column = 6;
		odsBean.setValue(column, line, cmCompanyDto.getDisposeNo()); // Əԍij
		odsBean.setValue(column, line + 56, cmCompanyDto.getDisposeNo()); // Əԍij
		
		line = 48;
		column = 6;
		odsBean.setValue(column, line, PayrollConst.NAM_COMMON_POSTAL + cmCompanyDto.getCompanyPostal()); // ƏX֔ԍij
		odsBean.setValue(column, line + 56, PayrollConst.NAM_COMMON_POSTAL + cmCompanyDto.getCompanyPostal()); // ƏX֔ԍij
		
		line = 49;
		column = 6;
		odsBean.setValue(column, line, cmCompanyDto.getCompanyAddress()); //Əݒnij
		odsBean.setValue(column, line + 56, cmCompanyDto.getCompanyAddress()); //Əݒnij
		
		line = 50;
		column = 6;
		odsBean.setValue(column, line, cmCompanyDto.getCompanyName()); //Ə́ij
		odsBean.setValue(column, line + 56, cmCompanyDto.getCompanyName()); //Ə́ij
		
		line = 51;
		column = 6;
		odsBean.setValue(column, line, cmCompanyDto.getEnterpreneur()); //Ǝ厁ij
		odsBean.setValue(column, line + 56, cmCompanyDto.getEnterpreneur()); //Ǝ厁ij
		
		line = 52;
		column = 6;
		odsBean.setValue(column, line, cmCompanyDto.getCompanyPhone()); //dbij
		odsBean.setValue(column, line + 56, cmCompanyDto.getCompanyPhone()); //dbij
		
		line = 46;
		column = 8;
		odsBean.setValue(column, line, nowDateJp); //a{tij	
		odsBean.setValue(column + 21, line + 59, nowDateJp); //a{tij
		
		sumCnt = 99;
		sumSheet = 0;
		
		for (int i = 0; i < list.size(); i++) {
			if (sumCnt >= 4) {
				sumSheet++;
//				poi.clnSheet(0, Sum_sheet, String.valueOf(Sum_sheet));  //V[g̕
//				poi.crtSheet(Sum_sheet, String.valueOf(Sum_sheet));     //\[g쐬
				sumCnt = 0;
			}
			
			cdSocInsuranceDto = list.get(i);
			kCode = cdSocInsuranceDto.getKCode();
			mKojinDto = mKojinDao.findForKey(kCode); //l}X^lCX^X擾
			cmSocInsuranceDto = cmSocInsuranceDao.findForEmployee(kCode); //l}X^ЉیCX^X擾		
			if ((null != mKojinDto) && (null != cmSocInsuranceDto)) {
				
				/**** @eЈ̍ڐݒ  ****/
				
				odsBean.setValue(cHhealthNo, lHhealthNo + (sumCnt * 8), cmSocInsuranceDto.getHealthNo() + "\n" + "("
						+ cmSocInsuranceDto.getPensionNo() + ")"); // Nیԍ()
				odsBean.setValue(cHhealthNo, lHhealthNo + (sumCnt * 8) + 56, cmSocInsuranceDto.getHealthNo() + "\n"
						+ "(" + cmSocInsuranceDto.getPensionNo() + ")"); // Nیԍ()
				odsBean.setValue(ckName, lkName + (sumCnt * 8), cdSocInsuranceDto.getKName()); // Ј()
				odsBean.setValue(ckName, lkName + (sumCnt * 8) + 56, cdSocInsuranceDto.getKName()); // Ј()
				odsBean.setValue(cBerthdayJpCd, lBerthdayJpCd + (sumCnt * 8), String.valueOf(getGengouCD(mKojinDto
					.getSeinenbi()))); // R[h()
				odsBean.setValue(cBerthdayJpCd, lBerthdayJpCd + (sumCnt * 8) + 56, String.valueOf(getGengouCD(mKojinDto
					.getSeinenbi()))); // R[h()
				
				tmpDate = mKojinDto.getSeinenbi();
				String tmpM = String.valueOf(MospUtility.getMonth(DateUtil.convIntegerDateToDate(tmpDate)));
				String tmpD = String.valueOf(MospUtility.getDay(DateUtil.convIntegerDateToDate(tmpDate)));
				
				odsBean.setValue(cBerthdayY, lBerthdayY + (sumCnt * 8), getWaNen(tmpDate)); // aN()
				odsBean.setValue(cBerthdayY, lBerthdayY + (sumCnt * 8) + 56, getWaNen(tmpDate)); // aN()
				odsBean.setValue(cBerthdaym, lBerthdayM + (sumCnt * 8), tmpM); // a()
				odsBean.setValue(cBerthdaym, lBerthdayM + (sumCnt * 8) + 56, tmpM); // a()
				odsBean.setValue(cBerthdayD, lBerthdayD + (sumCnt * 8), tmpD); // a()
				odsBean.setValue(cBerthdayD, lBerthdayD + (sumCnt * 8) + 56, tmpD); // a()
				odsBean.setValue(cGender, lGender + (sumCnt * 8), mKojinDto.getSeibetu()); // ʃR[h()
				odsBean.setValue(cGender, lGender + (sumCnt * 8) + 56, mKojinDto.getSeibetu()); // ʃR[h()
				odsBean.setValue(cHealthBefPremium, lHealthBefPremium + (sumCnt * 8), omission1000(cdSocInsuranceDto
					.getHealthBefPremium())); // ۏ]Oی()
				odsBean.setValue(cHealthBefPremium, lHealthBefPremium + (sumCnt * 8) + 56,
						omission1000(cdSocInsuranceDto.getHealthBefPremium())); // ۏ]Oی()
				odsBean.setValue(cPensionBefPremium, lPensionBefPremium + (sumCnt * 8), omission1000(cdSocInsuranceDto
					.getPensionBefPremium())); // N]Oی()
				odsBean.setValue(cPensionBefPremium, lPensionBefPremium + (sumCnt * 8) + 56,
						omission1000(cdSocInsuranceDto.getPensionBefPremium())); // N]Oی()
				odsBean
					.setValue(cPayBasicMonth1, lPayBasicMonth1 + (sumCnt * 8), cdSocInsuranceDto.getPayBasicMonth1()); // xb1:()
				odsBean.setValue(cPayBasicMonth1, lPayBasicMonth1 + (sumCnt * 8) + 56, cdSocInsuranceDto
					.getPayBasicMonth1()); // xb1:()
				odsBean
					.setValue(cPayBasicMonth2, lPayBasicMonth2 + (sumCnt * 8), cdSocInsuranceDto.getPayBasicMonth2()); // xb2:()
				odsBean.setValue(cPayBasicMonth2, lPayBasicMonth2 + (sumCnt * 8) + 56, cdSocInsuranceDto
					.getPayBasicMonth2()); // xb2:()
				odsBean
					.setValue(cPayBasicMonth3, lPayBasicMonth3 + (sumCnt * 8), cdSocInsuranceDto.getPayBasicMonth3()); // xb3:()
				odsBean.setValue(cPayBasicMonth3, lPayBasicMonth3 + (sumCnt * 8) + 56, cdSocInsuranceDto
					.getPayBasicMonth3()); // xb3:()
				odsBean.setValue(cPayBasicDay1, lPayBasicDay1 + (sumCnt * 8), cdSocInsuranceDto.getPayBasicDay1()); // xb1:()
				odsBean.setValue(cPayBasicDay1, lPayBasicDay1 + (sumCnt * 8) + 56, cdSocInsuranceDto.getPayBasicDay1()); // xb1:()
				odsBean.setValue(cPayBsicday2, lPayBasicDay2 + (sumCnt * 8), cdSocInsuranceDto.getPayBasicDay2()); // xb2:()
				odsBean.setValue(cPayBsicday2, lPayBasicDay2 + (sumCnt * 8) + 56, cdSocInsuranceDto.getPayBasicDay2()); // xb2:()
				odsBean.setValue(cPayBasicDay3, lPayBasicDay3 + (sumCnt * 8), cdSocInsuranceDto.getPayBasicDay3()); // xb3:()
				odsBean.setValue(cPayBasicDay3, lPayBasicDay3 + (sumCnt * 8) + 56, cdSocInsuranceDto.getPayBasicDay3()); // xb3:()
				odsBean.setValue(cPayAmount1, lPayAmount1 + (sumCnt * 8), cdSocInsuranceDto.getPayAmount1()); // K̊z1()
				odsBean.setValue(cPayAmount1, lPayAmount1 + (sumCnt * 8) + 56, cdSocInsuranceDto.getPayAmount1()); // K̊z1()
				odsBean.setValue(cPayAmount2, lPayAmount2 + (sumCnt * 8), cdSocInsuranceDto.getPayAmount2()); // K̊z2()
				odsBean.setValue(cPayAmount2, lPayAmount2 + (sumCnt * 8) + 56, cdSocInsuranceDto.getPayAmount2()); // K̊z2()
				odsBean.setValue(cPayAmount3, lPayAmount3 + (sumCnt * 8), cdSocInsuranceDto.getPayAmount3()); // K̊z3()
				odsBean.setValue(cPayAmount3, lPayAmount3 + (sumCnt * 8) + 56, cdSocInsuranceDto.getPayAmount3()); // K̊z3()
				odsBean.setValue(cGoodsAmount1, lGoodsAmount1 + (sumCnt * 8), cdSocInsuranceDto.getGoodsAmount1()); // ̊z1()
				odsBean.setValue(cGoodsAmount1, lGoodsAmount1 + (sumCnt * 8) + 56, cdSocInsuranceDto.getGoodsAmount1()); // ̊z1()
				odsBean.setValue(cGoodsAmount2, lGoodsAmount2 + (sumCnt * 8), cdSocInsuranceDto.getGoodsAmount2()); // ̊z2()
				odsBean.setValue(cGoodsAmount2, lGoodsAmount2 + (sumCnt * 8) + 56, cdSocInsuranceDto.getGoodsAmount2()); // ̊z2()
				odsBean.setValue(cGoodsAmount3, lGoodsAmount3 + (sumCnt * 8), cdSocInsuranceDto.getGoodsAmount3()); // ̊z3()
				odsBean.setValue(cGoodsAmount3, lGoodsAmount3 + (sumCnt * 8) + 56, cdSocInsuranceDto.getGoodsAmount3()); // ̊z3()
				odsBean.setValue(cRewardTotal1, lRewardTotal1 + (sumCnt * 8), cdSocInsuranceDto.getRewardTotal1()); // Vv1()
				odsBean.setValue(cRewardTotal1, lRewardTotal1 + (sumCnt * 8) + 56, cdSocInsuranceDto.getRewardTotal1()); // Vv1()
				odsBean.setValue(cRewardTotal2, lRewardTotal2 + (sumCnt * 8), cdSocInsuranceDto.getRewardTotal2()); // Vv2()
				odsBean.setValue(cRewardTotal2, lRewardTotal2 + (sumCnt * 8) + 56, cdSocInsuranceDto.getRewardTotal2()); // Vv2()
				odsBean.setValue(cRewardTotal3, lRewardTotal3 + (sumCnt * 8), cdSocInsuranceDto.getRewardTotal3()); // Vv3()
				odsBean.setValue(cRewardTotal3, lRewardTotal3 + (sumCnt * 8) + 56, cdSocInsuranceDto.getRewardTotal3()); // Vv3()
				odsBean
					.setValue(cRewardTotalSum, lRewardTotalSum + (sumCnt * 8), cdSocInsuranceDto.getRewardTotalSum()); // Vz()
				odsBean.setValue(cRewardTotalSum, lRewardTotalSum + (sumCnt * 8) + 56, cdSocInsuranceDto
					.getRewardTotalSum()); // Vz()
				odsBean.setValue(cAverageThreeMonths, lAverageThreeMonths + (sumCnt * 8), cdSocInsuranceDto
					.getAverageThreeMonths()); // R()
				odsBean.setValue(cAverageThreeMonths, lAverageThreeMonths + (sumCnt * 8) + 56, cdSocInsuranceDto
					.getAverageThreeMonths()); // R()
				odsBean.setValue(cHealthDecPremium, lHealthDecPremium + (sumCnt * 8), omission1000(cdSocInsuranceDto
					.getHealthDecPremium())); // یی()
				odsBean.setValue(cHealthDecPremium, lHealthDecPremium + (sumCnt * 8) + 56,
						omission1000(cdSocInsuranceDto.getHealthDecPremium())); // یی()
				
				tmpDate = DateUtil.convDateToInteger(cdSocInsuranceDto.getExpectedDate());
				odsBean.setValue(cExpectedDateY, lExpectedDateY + (sumCnt * 8), getWaNen(tmpDate)); // KpN:N()
				odsBean.setValue(cExpectedDateY, lExpectedDateY + (sumCnt * 8) + 56, getWaNen(tmpDate)); // KpN:N()
				odsBean.setValue(cExpectedDateM, lExpectedDateM + (sumCnt * 8), MospUtility.getMonth(cdSocInsuranceDto
					.getExpectedDate())); // KpN:()
				odsBean.setValue(cExpectedDateM, lExpectedDateM + (sumCnt * 8) + 56, MospUtility
					.getMonth(cdSocInsuranceDto.getExpectedDate())); // KpN:()
				odsBean.setValue(cEditAverage, lEditAverage + (sumCnt * 8), cdSocInsuranceDto.getEditAverage()); // C()
				odsBean.setValue(cEditAverage, lEditAverage + (sumCnt * 8) + 56, cdSocInsuranceDto.getEditAverage()); // C()
				odsBean.setValue(cPensionDecPremium, lPensionDecPremium + (sumCnt * 8), omission1000(cdSocInsuranceDto
					.getPensionDecPremium())); // Nی()
				odsBean.setValue(cPensionDecPremium, lPensionDecPremium + (sumCnt * 8) + 56,
						omission1000(cdSocInsuranceDto.getPensionDecPremium())); // Nی()
				odsBean.setValue(cRetroactivePayment, lRetroactivePayment + (sumCnt * 8), cdSocInsuranceDto
					.getRetroactivePayment()); // kyxz()
				odsBean.setValue(cRetroactivePayment, lRetroactivePayment + (sumCnt * 8) + 56, cdSocInsuranceDto
					.getRetroactivePayment()); // kyxz()
				odsBean.setValue(cRaiseDownsalaryBasis, lRaiseDownSalaryBasis + (sumCnt * 8), cdSocInsuranceDto
					.getRaiseDownSalaryBasis()); // ~̌z()
				odsBean.setValue(cRaiseDownsalaryBasis, lRaiseDownSalaryBasis + (sumCnt * 8) + 56, cdSocInsuranceDto
					.getRaiseDownSalaryBasis()); // ~̌z()
				
				tmpDate = DateUtil.convDateToInteger(cdSocInsuranceDto.getRaiseDownSalaryDate());
				tmpWork = getWaNen(tmpDate) + "N" + MospUtility.getMonth(cdSocInsuranceDto.getRaiseDownSalaryDate())
						+ "";
				odsBean.setValue(cRaiseDownSalaryDate, lRaisedownSalaryDate + (sumCnt * 8), tmpWork); // ~N()
				odsBean.setValue(cRaiseDownSalaryDate, lRaisedownSalaryDate + (sumCnt * 8) + 56, tmpWork); // ~N()
				
				/**** @eЈ̍ڐݒ  ****/
				
				sumCnt++;
			}
		}
		
		// o͓eݒ
		String fileName = strTekiyouDate + PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_INSURANCE_ODS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, odsBean.getSpreadSheet());
	}
	
	/**
	 * R[h擾B<br><br>
	 * @param intDate 擾ΏۂINT
	 * @return R[h
	 */
	private int getGengouCD(int intDate) {
		int outCode = 0;
		//猳R[h擾
		if (intDate >= 19890108) {
			outCode = 7;
		} else if ((intDate < 19890108) & (intDate >= 19261225)) {
			outCode = 5;
		} else if ((intDate < 19261225) & (intDate >= 19121110)) {
			outCode = 3;
		} else if ((intDate < 19121110) & (intDate >= 18680908)) {
			outCode = 1;
		}
		return outCode;
	}
	
	/**
	 * aN擾B<br><br>
	 * @param intDate 擾ΏۂINTN
	 * @return ߊz͕sz
	 */
	private String getWaNen(int intDate) {
		String tmpCode = "";
		int tmpInt = 0;
		//猳R[h擾
		if (intDate >= 19890108) {
			tmpCode = String.valueOf(intDate - 19880000);
		} else if ((intDate < 19890108) & (intDate >= 19261225)) {
			tmpCode = String.valueOf(intDate - 19250000);
		} else if ((intDate < 19261225) & (intDate >= 19121110)) {
			tmpCode = String.valueOf(intDate - 19110000);
		} else if ((intDate < 19121110) & (intDate >= 18680908)) {
			tmpCode = String.valueOf(intDate - 18670000);
		}
		tmpInt = tmpCode.length();
		if (tmpInt > 4) {
			return tmpCode.substring(0, tmpInt - 4);
		}
		return "0";
	}
	
	/**
	 * z~PʂɂB(~ȉ؎̂)<br><br>
	 * @param intPay 擾ΏۂINTz
	 * @return ~Pʂ̋z
	 */
	private int omission1000(int intPay) {
		int sumTmp = 0;
		if (1000 <= intPay) {
			sumTmp = intPay / 1000;
		}
		return sumTmp;
	}
	
}
