package jp.mosp.payroll.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

/**
 * @author koike
 *
 */
public class ResidenceTaxDto extends BaseDto {
	
	private static final long	serialVersionUID	= 1958389383485471274L;
	//tB[h
	/**
	 * ЈR[h
	 */
	protected String			kCode				= "";
	/**
	 * vZN
	 */
	protected Date				calcDate;
	/**
	 * ^x
	 */
	protected Date				payday;
	/**
	 * vZXe[^X
	 */
	protected String			calcStatus			= "";
	/**
	 * Ј
	 */
	protected String			kName				= "";
	/**
	 * Z
	 */
	protected int				residenceTax		= 0;
	/**
	 * sR[h
	 */
	protected String			cityCode			= "";
	/**
	 * s
	 */
	protected String			cityName			= "";
	/**
	 * [tsR[h
	 */
	protected String			paymentCityCode		= "";
	

	/**
	 * RXgN^
	 */
	public ResidenceTaxDto() {
		super();
	}
	
	//ANZT\bh
	public String getKCode() {
		return kCode;
	} // ЈR[h
	
	public Date getCalcDate() {
		return getDateField(calcDate);
	} // vZN
	
	public Date getPayday() {
		return getDateField(payday);
	} // ^x
	
	public String getCalcStatus() {
		return calcStatus;
	} // vZXe[^X
	
	public String getKName() {
		return kName;
	} // Ј
	
	public int getResidenceTax() {
		return residenceTax;
	} // Z
	
	public String getCityCode() {
		return cityCode;
	} // sR[h
	
	public String getCityName() {
		return cityName;
	} // s
	
	public String getPaymentCityCode() {
		return paymentCityCode;
	} // [tsR[h
	
	public void setKCode(String kCode) {
		this.kCode = kCode;
	} // ЈR[h
	
	public void setCalcDate(Date calcDate) {
		this.calcDate = getDateField(calcDate);
	} // vZN
	
	public void setPayday(Date payday) {
		this.payday = getDateField(payday);
	} // ^x
	
	public void setCalcStatus(String calcStatus) {
		this.calcStatus = calcStatus;
	} // vZXe[^X
	
	public void setKName(String kName) {
		this.kName = kName;
	} // Ј
	
	public void setResidenceTax(int residenceTax) {
		this.residenceTax = residenceTax;
	} // Z
	
	public void setCityCode(String cityCode) {
		this.cityCode = cityCode;
	} // sR[h
	
	public void setCityName(String cityName) {
		this.cityName = cityName;
	} // s
	
	public void setPaymentCityCode(String paymentCityCode) {
		this.paymentCityCode = paymentCityCode;
	} // [tsR[h
	
}
