package jp.mosp.payroll.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.payroll.dto.DetailTimeDto;

public class PdPayTimeDao extends DetailTimeDao {
	
	/**
	 *  e[uB<br>
	 */
	public static final String	TABLE	= "PD_PAY_TIME";
	

	/**
	 * {@link DetailTimeDao#DetailTimeDao(Properties, String, CmAspUserDto, CmUserDto, Connection)}
	 * sB<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public PdPayTimeDao(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		super(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * ʂDTOƂĎ擾B<br>
	 * @return R[h(DTO)
	 * @throws SQLException
	 */
	private DetailTimeDto mapping() throws SQLException {
		DetailTimeDto dto = new DetailTimeDto();
		dto.setKCode(rs.getString(COL_KCODE));
		dto.setCalcDate(rs.getDate(COL_CALC_DATE));
		dto.setDetailCode(rs.getString(COL_DETAIL_CODE));
		dto.setAmount(rs.getFloat(COL_AMOUNT));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ɂf[^擾B(ЈR[hAvZNA׃R[h)<br>
	 * @param kCode     ЈR[h
	 * @param calcDate vZN
	 * @param detailCode 
	 * @return (DTOList)
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public DetailTimeDto findDetailCode(String kCode, Date calcDate, String detailCode) throws SQLException,
			NoSuchFieldException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_CALC_DATE + " = ? ");
		sb.append("AND ");
		sb.append(COL_DETAIL_CODE + " = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setDateParam(index++, calcDate);
			setParam(index++, detailCode);
			executeQuery();
			DetailTimeDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
}
