package jp.mosp.payroll.common.vo;

import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.FileUploadUtility;
import jp.mosp.payroll.dto.DetailTimeDto;

import org.apache.commons.fileupload.FileItem;

public class PayrollImportCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 1L;
	
	// URLACSS
	private static final String	RETURN_URL			= "/jsp/payroll/common/payrollImportCard.jsp";
	private static final String	EXTRA_JS			= "/pub/payroll/common/js/payrollImportCard.js";
	private static final String	EXTRA_CSS			= "/pub/payroll/common/css/payrollImportCard.css";
	
	// p[^[
	public static final String	PRM_FIL_IMPORT_FILE	= "filImportFile";
	
	/**
	 * wb_
	 */
	public String[]				aryImportHeaderItem;
	public String[]				aryImportHeaderCode;
	// tB[h
	private FileItem			filImportFile;
	public String[][]			aryImportData;
	
	private String				selectICode;
	private String				lblHeader;
	
	// Xg
	public String[][]			aryWorkType;
	public String[][]			aryHolidayReason;
	public String[][]			aryLateReason;
	public String[][]			aryLeaveEarlyReason;
	

	/**
	 * RXgN^
	 */
	public PayrollImportCardVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		aryWorkType = new String[0][0];
		aryHolidayReason = new String[0][0];
		aryLateReason = new String[0][0];
		aryLeaveEarlyReason = new String[0][0];
		aryImportData = new String[0][0];
		aryImportHeaderItem = new String[0];
	}
	
	/**
	 * Tu^Cgݒ肷B
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_PAYMENT") + getName("P_IMPORT");
		aryMenu = new String[2][2];
		aryMenu[0][0] = "P1910";
		aryMenu[0][1] = getName("C_MENU") + getName("C_TO");
		aryMenu[1][0] = "P9022";
		aryMenu[1][1] = getName("C_LIST") + getName("C_TO");
	}
	
	/**
	 * p[^ݒ
	 * @param list NGXgXg
	 */
	public void setImportFile(List list) throws Exception {
		filImportFile = FileUploadUtility.getMultipartFile(list, PRM_FIL_IMPORT_FILE);
	}
	
	/**
	 * tB[hݒ
	 * @param importCsvList C|[gXg
	 */
	@Override
	public void setFields(List<?> importCsvList) {
		//Xg̐ݒ
		list = importCsvList;
		//f[^̎擾
		count = importCsvList.size();
		//z̏
		aryImportData = new String[count][14];
		//f[^̐ݒ
		int i = 0;
		Iterator it = importCsvList.iterator();
		while (it.hasNext()) {
			DetailTimeDto dto = (DetailTimeDto)it.next();
			
			aryImportData[i][0] = escapeHTML(dto.getKCode());
			
			StringBuffer sb = new StringBuffer();
			sb.append(CommonConst.SEPARATOR_DATE);
			sb.append(CommonConst.SEPARATOR_DATE);
			i++;
			
		}
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}
	
	// ANZT\bh
	public FileItem getFilImportFile() {
		return filImportFile;
	}
	
	public String[][] getEscAryImportData() {
		return aryImportData.clone();
	}
	
	public String[] getaryImportHeader() {
		return aryImportHeaderItem;
	}
	
	public int getImportHeaderCount() {
		return aryImportHeaderItem.length;
	}
	
	public int getImporDataCount() {
		return aryImportData.length;
	}
	
	public String getSelectICode() {
		return selectICode;
	}
	
	public String getLblHeader() {
		return lblHeader;
	}
	
	public String getEscLblHeader() {
		return escapeHTML(lblHeader);
	}
	
	public void setSelectICode(String selectICode) {
		this.selectICode = selectICode;
	}
	
	public void setLblHeader(String lblHeader) {
		this.lblHeader = lblHeader;
	}
	
}
