package jp.mosp.payroll.common.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.part.MosPMenuPart;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.vo.MosPMenuVo;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.common.part.PayrollMosPMenuPart;

/**
 * @author koike
 *
 */
public class PayrollMenuAction extends PayrollAction {
	
	// R}h萔
	private static final String	CMD_SHOW	= MospConst.CMD_MENU;
	

	/**
	 * RXgN^
	 */
	public PayrollMenuAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VȌ
		prepareVo(false);
		// 
		init();
		// \
		show();
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new MosPMenuVo();
	}
	
	@Override
	protected void init() throws Exception {
		// ZbVێ̏
		initStoredData();
	}
	
	@Override
	protected void show() throws Exception {
		MosPMenuVo vo = (MosPMenuVo)getVo();
		String component = "";
		String title = "";
		// R}h̏
		if (cmd.equals(CMD_SHOW) || cmd.equals(vo.CMD_MENU_INPUT)) {
			component = part().payrollMenu().getEmployeeComponent();
			title = CommonConst.TTL_MENU_INPUT;
		} else if (cmd.equals(vo.CMD_MENU_MAMAGE)) {
			component = part().payrollMenu().getManagerComponent();
			title = CommonConst.TTL_MENU_MANAGE;
		} else if (cmd.equals(vo.CMD_MENU_PAYROLL)) {
			component = part().payrollMenu().getPayrollComponent();
			title = CommonConst.TTL_MENU_PAYROLL;
		} else if (cmd.equals(vo.CMD_MENU_HUMAN)) {
			component = part().payrollMenu().getHumanComponent();
			title = CommonConst.TTL_MENU_HUMAN;
		} else if (cmd.equals(vo.CMD_MENU_SYSTEM2)) {
			component = MosPMenuPart.convAryToComponent(MosPMenuConst.getCmdSystemArray());
			// CSS̐ݒ
			vo.setCommonCss(CommonConst.CSS_ADMIN);
			vo.setMode(MosPMenuVo.MODE_ADMIN);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
		if (StringUtil.isNotNull(title)) {
			vo.setTitle(title);
		}
		user.setCommonCss(vo.getCommonCss());
		vo.setFields(component, StringUtil.combineArray(PayrollMosPMenuPart.getAllCmdArrayList()));
	}
}
