package jp.mosp.payroll.common.action;

import java.util.Date;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.InsuranceConfSetVo;

public class InsuranceConfSetAction extends AdjustmentAction {
	
	/**
	 * ʕ\R}h
	 */
//	public static final String CMD_SHOW	= "P4001";
//	public static final String CMD_SET	= "P4002";
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public InsuranceConfSetAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new InsuranceConfSetVo();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// ZbVێ̏
		initStoredData();
		// DBRlNV擾
		getConnection();
		// VO̎擾
		InsuranceConfSetVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof InsuranceConfSetVo) {
			vo = (InsuranceConfSetVo)obj;
		} else {
			vo = new InsuranceConfSetVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(PayrollConst.VO_INSURANCECONF_SET, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		
		vo.aryEra = getCodeArray(PayrollConst.TID_JAPANESE); // NR[he[u擾  
		vo.listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL); // ae[uݒ擾
		
		Date dateTmp = DateUtil.convIntegerDateToDate((MospUtility.getYear(DateUtil.getSystemDate()) * 10000) + 401);
		vo.setSyoukyuTuki(dateTmp); // i~jNlݒ
		vo.setSyoukyuTukiJp(getJapaneseDate(dateTmp)); // i~jN(a)ݒ
		
		// KpNlݒ
		dateTmp = DateUtil.convIntegerDateToDate((MospUtility.getYear(DateUtil.getSystemDate()) * 10000) + 901);
		vo.setTekiyouNenGetu(dateTmp); // KpN(a)ݒ
		// Jnlݒ
		dateTmp = DateUtil.convIntegerDateToDate((MospUtility.getYear(DateUtil.getSystemDate()) * 10000) + 1001);
		vo.setChousyuKaisiTukiStr(dateTmp); // Jniajݒ
		vo.initFields(); // VOtB[hݒ		
	}
}
