package jp.mosp.payroll.common.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.ImportMasterListVo;
import jp.mosp.payroll.dao.MImportDao;
import jp.mosp.payroll.dto.MImportDto;

public class ImportMasterListAction extends PayrollAction {
	
	// R}h
	private static final String	CMD_IMPORT_MASTER_LIST_SHOW			= "P9020";	// \
	private static final String	CMD_IMPORT_MASTER_LIST_SEARCH		= "P9021";	// 
	private static final String	CMD_IMPORT_MASTER_LIST_RE_SEARCH	= "P9022";	// Č
	private static final String	CMD_IMPORT_MASTER_LIST_SORT			= "P9023";	// \[g
																				
	
	/**
	 * RXgN^
	 */
	public ImportMasterListAction() {
		super();
		setNeedProcSeq(false);
		
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new ImportMasterListVo();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// VO擾yѐݒ
		prepareVo();
		// v_Ee[uݒ
		setPulldown();
		
		// R}h̏
		if (cmd.equals(CMD_IMPORT_MASTER_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_IMPORT_MASTER_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_IMPORT_MASTER_LIST_RE_SEARCH)) {
			// Č
			reSearch();
		} else if (cmd.equals(CMD_IMPORT_MASTER_LIST_SORT)) {
			// \[g
			sort();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * \
	 */
	@Override
	public void show() {
		// VO擾
		ImportMasterListVo vo = (ImportMasterListVo)getVo();
		// lɃZbg
		vo.setSearchmode(ImportMasterListVo.SEARCH_OFF);
	}
	
	/**
	 * 
	 * @throws Exception
	 */
	@Override
	public void search() throws Exception {
		// VO擾
		ImportMasterListVo vo = (ImportMasterListVo)getVo();
		// p[^擾
		vo.setParams(request);
		// 
		searchImportMasterList();
		vo.setFormerKey(vo.KEY_I_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(ImportMasterListVo.SEARCH_ON);
	}
	
	/**
	 * Č
	 * @throws Exception
	 */
	private void reSearch() throws Exception {
		// VO擾
		ImportMasterListVo vo = (ImportMasterListVo)getVo();
		if (vo.getSearchmode() == ImportMasterListVo.SEARCH_ON) {
			session.removeAttribute(MospConst.ATT_DTO);
			searchImportMasterList();
			vo.setPageButton();
			sortList(vo);
		}
	}
	
	/**
	 * \[g
	 * @throws Exception
	 */
	private void sort() throws Exception {
		/* Makeing by y.mikami  */
	}
	
	/**
	 * v_Eݒ
	 */
	private void setPulldown() {
		// VO擾
		ImportMasterListVo vo = (ImportMasterListVo)getVo();
		// v_E̐ݒ
		vo.aryPltITable = getImportTableArray();
	}
	
	/**
	 * C|[ge[uv_E擾
	 * @return C|[ge[uv_Epz
	 */
	protected String[][] getImportTableArray() {
		String[][] aryImportTable = new String[3][2];
		aryImportTable[0][0] = PayrollConst.CODE_IMPORT_TABLE_PI_PAYMENT;
		aryImportTable[0][1] = PayrollConst.NAM_IMPORT_TABLE_PI_PAYMENT;
		aryImportTable[1][0] = PayrollConst.CODE_IMPORT_TABLE_M_SYUKKINBO;
		aryImportTable[1][1] = PayrollConst.NAM_IMPORT_TABLE_M_SYUKKINBO;
		aryImportTable[2][0] = PayrollConst.CODE_IMPORT_TABLCT_TIMECARD;
		aryImportTable[2][1] = PayrollConst.NAM_IMPORT_TABLCT_TIMECARD;
		return aryImportTable;
	}
	
	/**
	 * C|[gXg
	 * @throws Exception
	 */
	private void searchImportMasterList() throws Exception {
		// VO擾
		ImportMasterListVo vo = (ImportMasterListVo)getVo();
		// DAȌ
		MImportDao dao = new MImportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// VOɐݒ
		vo.setFields(dao.findForCondition(vo.getTxtICode(), vo.getTxtIName(), vo.getPltITable()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryICode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(ImportMasterListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}
	
	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException 
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, ImportMasterListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_I_CODE)) {
			comp = new CompICode();
		} else if (key.equals(vo.KEY_I_NAME)) {
			comp = new CompIName();
		} else if (key.equals(vo.KEY_I_TABLE)) {
			comp = new CompITable();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * C|[gR[hɂrNX
	 */
	protected static class CompICode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -4919768827859268739L;
		

		public int compare(Object obj1, Object obj2) {
			MImportDto dto1 = (MImportDto)obj1;
			MImportDto dto2 = (MImportDto)obj2;
			return dto1.getICode().compareTo(dto2.getICode());
		}
	}
	
	/**
	 * C|[ĝɂrNX
	 */
	protected static class CompIName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -5780195486773585945L;
		

		public int compare(Object obj1, Object obj2) {
			MImportDto dto1 = (MImportDto)obj1;
			MImportDto dto2 = (MImportDto)obj2;
			return dto1.getIName().compareTo(dto2.getIName());
		}
	}
	
	/**
	 * C|[ĝɂrNX
	 */
	protected static class CompITable implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 2237491082499752665L;
		

		public int compare(Object obj1, Object obj2) {
			MImportDto dto1 = (MImportDto)obj1;
			MImportDto dto2 = (MImportDto)obj2;
			return dto1.getITable().compareTo(dto2.getITable());
		}
	}
}
