/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.action;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.kintai.common.part.ExportPart;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.dao.PmDetailBaDao;
import jp.mosp.payroll.bonus.dao.PmDetailBdDao;
import jp.mosp.payroll.bonus.dao.PmDetailBsDao;
import jp.mosp.payroll.bonus.dto.PmDetailBaDto;
import jp.mosp.payroll.bonus.dto.PmDetailBdDto;
import jp.mosp.payroll.bonus.dto.PmDetailBsDto;
import jp.mosp.payroll.common.vo.ExportMasterCardVo;
import jp.mosp.payroll.dao.MExportPaymentDao;
import jp.mosp.payroll.dao.PmDetailPaDao;
import jp.mosp.payroll.dao.PmDetailPbDao;
import jp.mosp.payroll.dao.PmDetailPdDao;
import jp.mosp.payroll.dao.PmDetailPsDao;
import jp.mosp.payroll.dao.PmDetailPtDao;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.DetailPaDto;
import jp.mosp.payroll.dto.DetailPbDto;
import jp.mosp.payroll.dto.DetailPdDto;
import jp.mosp.payroll.dto.DetailTimeDto;
import jp.mosp.payroll.dto.MExportPaymentDto;

public class ExportMasterCardAction extends MosPAction {
	
	// R}h
	private static final String	CMD_EXPORT_MASTER_CARD_SHOW			= "P9004";	// \(ǉ)
	private static final String	CMD_EXPORT_MASTER_CARD_SELECT		= "P9007";	// \(I)
	private static final String	CMD_EXPORT_MASTER_CARD_INSERT		= "P9005";	// o^
	private static final String	CMD_EXPORT_MASTER_CARD_UPDATE		= "P9008";	// XV
	private static final String	CMD_EXPORT_MASTER_CARD_DELETE		= "P9009";	// 폜
	private static final String	CMD_EXPORT_MASTER_CARD_BONUS_SHOW	= "P9010";	// ܗ^\iǉj
																				
	//͕ϐ
	private String				eName								= "";
	

	/**
	 * RXgN^
	 */
	public ExportMasterCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// vZǗmF
		confirmCalculateAuth();
		// VO̎擾
		ExportMasterCardVo vo = getInitVo();
		
		init(vo);
		// R}h̏
		if (cmd.equals(CMD_EXPORT_MASTER_CARD_SHOW)) {
			// \(^)
			show(vo);
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			select(vo);
			// l񍀖ڐݒ
			crtDataItem(vo);
			// [hݒ
			vo.setMode(ExportMasterCardVo.MODE_UPDATE);
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_INSERT)) {
			// VKo^(^)
			if (regist(vo)) {
				// l񍀖ڐݒ
				crtDataItem(vo);
			} else {
				if (vo.getHidEFile().equals(PayrollConst.NAM_DATA_M_PAYROLL)) {
					show(vo);
				} else {
					showBonus(vo);
				}
			}
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_UPDATE)) {
			// XV
			regist(vo);
			// l񍀖ڐݒ
			crtDataItem(vo);
			
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_DELETE)) {
			// 폜
			delete(vo);
			// l񍀖ڐݒ
			vo.aryPltKintaiDataItem = new String[0][2];
			vo.aryPltSelectDataItem = new String[0][2];
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_BONUS_SHOW)) {
			//\(ܗ^)
			showBonus(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.action.MosPAction#getInitVo()
	 */
	protected ExportMasterCardVo getInitVo() {
		return new ExportMasterCardVo();
	}
	
	/**
	 * 
	 * @param vo	ΏVO
	 */
	protected void init(ExportMasterCardVo vo) {
		vo.initVo(cfg, msg, nam, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		vo.setParams(request);
		vo.aryTargetTable = getArrayTargetTable();
	}
	
	/**
	 * \(^)
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void show(ExportMasterCardVo vo) throws Exception {
		// VOɏZbg
		vo.setTxtEName(eName);
		if (!key1.equals("")) {
			vo.setHidEFile(key1);
		} else {
			vo.setHidEFile(vo.getHidEFile());
		}
		vo.setLblEFile(vo.getHidEFile());
		//Xgڂ̐
		crtList(vo);
		vo.aryPltSelectDataItem = new String[0][2];
		
	}
	
	/**
	 * \(ܗ^)
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void showBonus(ExportMasterCardVo vo) throws Exception {
		//VOɏZbg
		vo.setTxtEName(eName);
		if (!key1.equals("")) {
			vo.setHidEFile(key1);
		} else {
			vo.setHidEFile(vo.getHidEFile());
		}
		vo.setLblEFile(vo.getHidEFile());
		//Xgڂ̐
		crtListBouns(vo);
		vo.aryPltSelectDataItem = new String[0][2];
		
	}
	
	/**
	 * I(^Eܗ^p)
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void select(ExportMasterCardVo vo) throws Exception {
		// VOɏZbg
		vo.setTxtEName(key1);
		if (key2.equals(PayrollConst.NAM_DATA_M_PAYROLL)) {
			vo.setHidEFile(PayrollConst.NAM_DATA_M_PAYROLL);
			vo.setLblEFile(vo.getHidEFile());
			//Xgڂ̐
			crtList(vo);
		} else {
			vo.setHidEFile(PayrollConst.NAM_DATA_M_BONAS);
			vo.setLblEFile(vo.getHidEFile());
			//Xgڂ̐
			crtListBouns(vo);
		}
		// DAȌ
		MExportPaymentDao dao = new MExportPaymentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		chkExist(dao.findForKey(vo.getTxtEName(), vo.getHidEFile(), 0));
		
	}
	
	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	protected boolean regist(ExportMasterCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MExportPaymentDao dao = new MExportPaymentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		List<MExportPaymentDto> exportlist = dao.findForCondition(vo.getTxtEName(), vo.getHidEFile());
		if (cmd.equals(CMD_EXPORT_MASTER_CARD_INSERT)) {
			if (exportlist.size() > 0) {
				vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_DUPLICATE, ""));
				eName = vo.getTxtEName();
				vo.addErrField("txtEName");
				return false;
			}
		} else if (cmd.equals(CMD_EXPORT_MASTER_CARD_UPDATE)) {
			if (exportlist.size() > 0) {
				dao.delete(vo.getTxtEName(), vo.getHidEFile());
				eName = vo.getTxtEName();
			}
		}
		for (int i = 0; i < vo.getPltSelected().length; i++) {
			MExportPaymentDto dto = new MExportPaymentDto();
			vo.setDtoFields(dto, i);
			dao.insert(dto);
		}
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ExportMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return true;
	}
	
	/**
	 * f[^폜
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void delete(ExportMasterCardVo vo) throws Exception {
		// DAȌ
		MExportPaymentDao dao = new MExportPaymentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̍XV
		dao.delete(vo.getTxtEName(), vo.getHidEFile());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
	}
	
	/**
	 * Iڂ̃Xg쐬
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void crtDataItem(ExportMasterCardVo vo) throws Exception {
		String[][] aryKintaiDataItem;
		if (vo.getHidEFile().equals(PayrollConst.NAM_DATA_M_PAYROLL)) {
			vo.setHidEFile(PayrollConst.NAM_DATA_M_PAYROLL);
		} else {
			vo.setHidEFile(PayrollConst.NAM_DATA_M_BONAS);
		}
		vo.setLblEFile(vo.getHidEFile());
		// DAȌ
		MExportPaymentDao dao = new MExportPaymentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// l񍀖ڐݒ
		List<MExportPaymentDto> mExportList = dao.findForCondition(vo.getTxtEName(), vo.getHidEFile());
		if (vo.getHidEFile().equals(PayrollConst.NAM_DATA_M_PAYROLL)) {
			aryKintaiDataItem = crtList(vo);
		} else {
			aryKintaiDataItem = crtListBouns(vo);
		}
		// ڂ̑I
		vo.aryPltSelectDataItem = new String[mExportList.size()][2];
		int t = 0;
		for (int i = 0; i < mExportList.size(); i++) {
			MExportPaymentDto dto = mExportList.get(i);
			for (int j = 0; j < aryKintaiDataItem.length; j++) {
				if (aryKintaiDataItem[j][0].equals(dto.getEFname())) {
					vo.aryPltSelectDataItem[i][0] = aryKintaiDataItem[j][0];
					vo.aryPltSelectDataItem[i][1] = aryKintaiDataItem[j][1];
					aryKintaiDataItem[j][0] = "";
					t++;
				} else if (!aryKintaiDataItem[j][0].equals("")) {
					vo.aryPltSelectDataItem[i][0] = dto.getEFname();
					vo.aryPltSelectDataItem[i][1] = getEFnameItem(dto.getEFname(), 3);
				}
			}
		}
		String[][] aryPltDataItem = new String[aryKintaiDataItem.length - t][2];
		int n = 0;
		for (int j = 0; j < aryKintaiDataItem.length; j++) {
			if (!aryKintaiDataItem[j][0].equals("")) {
				aryPltDataItem[n][0] = aryKintaiDataItem[j][0];
				aryPltDataItem[n][1] = aryKintaiDataItem[j][1];
				n++;
			}
		}
		vo.aryPltKintaiDataItem = aryPltDataItem;
	}
	
	/**
	 * Ώۃe[u̔z
	 * @return	String[][]	Ώۃe[u̔z
	 */
	protected String[][] getArrayTargetTable() {
		String[][] aryTargetTable = new String[4][2];
		aryTargetTable[0][0] = CommonConst.CODE_TABLE_M_KIHON;
		aryTargetTable[0][1] = CommonConst.NAM_TABLE_M_KIHON;
		aryTargetTable[1][0] = CommonConst.CODE_TABLE_M_KINTAI;
		aryTargetTable[1][1] = CommonConst.NAM_TABLE_M_KINTAI;
		aryTargetTable[2][0] = CommonConst.CODE_TABLE_M_SYUKKINBO;
		aryTargetTable[2][1] = CommonConst.NAM_TABLE_M_SYUKKINBO;
		aryTargetTable[3][0] = CommonConst.CODE_TABLE_M_YUKYU;
		aryTargetTable[3][1] = CommonConst.NAM_TABLE_M_YUKYU;
		return aryTargetTable;
	}
	
	/**
	 * IڃXg̎擾(^)
	 * @param vo 
	 */
	private String[][] crtList(ExportMasterCardVo vo) throws Exception {
		//v_EXg
		String[][] aryPltItem;
		aryPltItem = getKintaiDataItem(vo.getHidEFile());
		//^񍀖ڐݒ
		PmDetailPaDao daoPa = new PmDetailPaDao(cfg, cmd, aspUser, user, conn);
		List<DetailPaDto> listdtoPa = daoPa.findAll();
		PmDetailPbDao daoPb = new PmDetailPbDao(cfg, cmd, aspUser, user, conn);
		List<DetailPbDto> listdtoPb = daoPb.findAll();
		PmDetailPdDao daoPd = new PmDetailPdDao(cfg, cmd, aspUser, user, conn);
		List<DetailPdDto> listdtoPd = daoPd.findAll();
		PmDetailPsDao daoPs = new PmDetailPsDao(cfg, cmd, aspUser, user, conn);
		List<DetailMoneyDto> listdtoPs = daoPs.findAll();
		PmDetailPtDao daoPt = new PmDetailPtDao(cfg, cmd, aspUser, user, conn);
		List<DetailTimeDto> listdtoPt = daoPt.findAll();
		//l̈敪mۗL
		int cnt = listdtoPa.size() + listdtoPb.size() + listdtoPd.size() + listdtoPs.size() + listdtoPt.size()
				+ PayrollConst.HUMAN_CNT;
		int rowCnt = 0;
		//l񍀖ڐݒ
		vo.aryPltKintaiDataItem = new String[cnt][2];
		for (String[] element : aryPltItem) {
			if (getEFnameItem(element[0], 3).equals(PayrollConst.NAM_M_KIHON_KCODE)
					|| getEFnameItem(element[0], 3).equals(PayrollConst.NAM_M_KIHON_SHIME)
					|| getEFnameItem(element[0], 3).equals(PayrollConst.NAM_M_KIHON_JCODE)
					|| getEFnameItem(element[0], 3).equals(PayrollConst.NAM_M_KIHON_SCODE)
					|| getEFnameItem(element[0], 3).equals(PayrollConst.NAM_M_KIHON_YCODE)) {
				
				vo.aryPltKintaiDataItem[rowCnt][0] = element[0];
				vo.aryPltKintaiDataItem[rowCnt][1] = element[1];
				rowCnt++;
			}
		}
		vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
				+ PayrollConst.STR_CSV_SEPARATOR + "CALC_MONTH" + PayrollConst.STR_CSV_SEPARATOR
				+ PayrollConst.NAM_PH_PAYMENT_CALC_MONTH;
		vo.aryPltKintaiDataItem[rowCnt][1] = PayrollConst.NAM_PH_PAYMENT_CALC_MONTH;
		rowCnt++;
		vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
				+ PayrollConst.STR_CSV_SEPARATOR + "PAY_DATE" + PayrollConst.STR_CSV_SEPARATOR
				+ PayrollConst.NAM_PH_PAYMENT_CALC_PAY_DATE;
		vo.aryPltKintaiDataItem[rowCnt][1] = PayrollConst.NAM_PH_PAYMENT_CALC_PAY_DATE;
		rowCnt++;
		
		for (int i = 0; i < listdtoPa.size(); i++) {
			DetailPaDto dto = listdtoPa.get(i);
			vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
					+ PayrollConst.STR_CSV_SEPARATOR + "DETAIL_NAME" + PayrollConst.STR_CSV_SEPARATOR
					+ dto.getDetailName();
			vo.aryPltKintaiDataItem[rowCnt][1] = dto.getDetailName();
			rowCnt++;
		}
		for (int i = 0; i < listdtoPb.size(); i++) {
			DetailPbDto dto = listdtoPb.get(i);
			vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
					+ PayrollConst.STR_CSV_SEPARATOR + "DETAIL_NAME" + PayrollConst.STR_CSV_SEPARATOR
					+ dto.getDetailName();
			vo.aryPltKintaiDataItem[rowCnt][1] = dto.getDetailName();
			rowCnt++;
		}
		for (int i = 0; i < listdtoPd.size(); i++) {
			DetailPdDto dto = listdtoPd.get(i);
			vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
					+ PayrollConst.STR_CSV_SEPARATOR + "DETAIL_NAME" + PayrollConst.STR_CSV_SEPARATOR
					+ dto.getDetailName();
			vo.aryPltKintaiDataItem[rowCnt][1] = dto.getDetailName();
			rowCnt++;
		}
		for (int i = 0; i < listdtoPs.size(); i++) {
			DetailMoneyDto dto = listdtoPs.get(i);
			vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
					+ PayrollConst.STR_CSV_SEPARATOR + "DETAIL_NAME" + PayrollConst.STR_CSV_SEPARATOR
					+ dto.getDetailName();
			vo.aryPltKintaiDataItem[rowCnt][1] = dto.getDetailName();
			rowCnt++;
		}
		for (int i = 0; i < listdtoPt.size(); i++) {
			DetailTimeDto dto = listdtoPt.get(i);
			vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
					+ PayrollConst.STR_CSV_SEPARATOR + "DETAIL_NAME" + PayrollConst.STR_CSV_SEPARATOR
					+ dto.getDetailName();
			vo.aryPltKintaiDataItem[rowCnt][1] = dto.getDetailName();
			rowCnt++;
		}
		
		return vo.aryPltKintaiDataItem;
	}
	
	/**
	 * IڃXg̎擾(ܗ^)
	 * @param vo 
	 */
	private String[][] crtListBouns(ExportMasterCardVo vo) throws Exception {
		//v_EXg
		String[][] aryPltItem;
		aryPltItem = getKintaiDataItem(vo.getHidEFile());
		//ܗ^񍀖ڐݒ
		PmDetailBaDao daoBa = new PmDetailBaDao(cfg, cmd, aspUser, user, conn);
		List<PmDetailBaDto> listdtoBa = daoBa.findAll();
		PmDetailBdDao daoBd = new PmDetailBdDao(cfg, cmd, aspUser, user, conn);
		List<PmDetailBdDto> listdtoBd = daoBd.findAll();
		PmDetailBsDao daoBs = new PmDetailBsDao(cfg, cmd, aspUser, user, conn);
		List<PmDetailBsDto> listdtoBs = daoBs.findAll();
		//l̈敪mۗL
		int cnt = listdtoBa.size() + listdtoBd.size() + listdtoBs.size() + PayrollConst.HUMAN_CNT;
		int rowCnt = 0;
		//l񍀖ڐݒ
		//l񍀖ڐݒ
		vo.aryPltKintaiDataItem = new String[cnt][2];
		for (String[] element : aryPltItem) {
			if (getEFnameItem(element[0], 3).equals(PayrollConst.NAM_M_KIHON_KCODE)
					|| getEFnameItem(element[0], 3).equals(PayrollConst.NAM_M_KIHON_SHIME)
					|| getEFnameItem(element[0], 3).equals(PayrollConst.NAM_M_KIHON_JCODE)
					|| getEFnameItem(element[0], 3).equals(PayrollConst.NAM_M_KIHON_SCODE)
					|| getEFnameItem(element[0], 3).equals(PayrollConst.NAM_M_KIHON_YCODE)) {
				
				vo.aryPltKintaiDataItem[rowCnt][0] = element[0];
				vo.aryPltKintaiDataItem[rowCnt][1] = element[1];
				rowCnt++;
			}
		}
		vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
				+ PayrollConst.STR_CSV_SEPARATOR + "CALC_MONTH" + PayrollConst.STR_CSV_SEPARATOR
				+ PayrollConst.NAM_PH_PAYMENT_CALC_MONTH;
		vo.aryPltKintaiDataItem[rowCnt][1] = PayrollConst.NAM_PH_PAYMENT_CALC_MONTH;
		rowCnt++;
		vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
				+ PayrollConst.STR_CSV_SEPARATOR + "PAY_DATE" + PayrollConst.STR_CSV_SEPARATOR
				+ PayrollConst.NAM_PH_PAYMENT_CALC_PAY_DATE;
		vo.aryPltKintaiDataItem[rowCnt][1] = PayrollConst.NAM_PH_PAYMENT_CALC_PAY_DATE;
		rowCnt++;
		for (int i = 0; i < listdtoBa.size(); i++) {
			PmDetailBaDto dto = listdtoBa.get(i);
			vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
					+ PayrollConst.STR_CSV_SEPARATOR + "DETAIL_NAME" + PayrollConst.STR_CSV_SEPARATOR
					+ dto.getDetailName();
			vo.aryPltKintaiDataItem[rowCnt][1] = dto.getDetailName();
			rowCnt++;
		}
		for (int i = 0; i < listdtoBd.size(); i++) {
			PmDetailBdDto dto = listdtoBd.get(i);
			vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
					+ PayrollConst.STR_CSV_SEPARATOR + "DETAIL_NAME" + PayrollConst.STR_CSV_SEPARATOR
					+ dto.getDetailName();
			vo.aryPltKintaiDataItem[rowCnt][1] = dto.getDetailName();
			rowCnt++;
		}
		for (int i = 0; i < listdtoBs.size(); i++) {
			PmDetailBsDto dto = listdtoBs.get(i);
			vo.aryPltKintaiDataItem[rowCnt][0] = vo.getHidEFile() + PayrollConst.STR_CSV_SEPARATOR + rowCnt
					+ PayrollConst.STR_CSV_SEPARATOR + "DETAIL_NAME" + PayrollConst.STR_CSV_SEPARATOR
					+ dto.getDetailName();
			vo.aryPltKintaiDataItem[rowCnt][1] = dto.getDetailName();
			rowCnt++;
		}
		return vo.aryPltKintaiDataItem;
	}
	
	/**
	 * GNX|[g񍀖ڐݒ
	 * @param strFLID	Ώۃe[uR[h
	 * @return	String[][]	GNX|[g񍀖ڔz
	 * @throws Exception
	 */
	private String[][] getKintaiDataItem(String strFLID) throws Exception {
		return ((ExportPart)getPart(ExportPart.class.getCanonicalName())).getKintaiDataItem(strFLID);
	}
	
}
